/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.pp.PpConfigMainPanel;
import com.aastra.oamp.pp.PpSubscriptionDlg;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PpConfigTaskPanel
extends GuiUtilTaskPanel
implements CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private ConfiguratorTable ppTable = null;
    private CommonDataHandler commonDataHandler = null;
    private PpConfigMainPanel ppMainPanel = null;
    private AastraLinkButton buttonCreatePp = null;
    private AastraLinkButton buttonConfigurePp = null;
    private AastraLinkButton buttonDeletePp = null;
    private AastraLinkButton buttonStartSubscription = null;
    private AastraLinkButton buttonConfigurePpTable = null;
    private AastraLinkButton buttonFilterPpTable = null;
    private AastraLinkButton buttonStartWildcardSubscription = null;
    private AastraLinkButton buttonChangeRelationType = null;
    private PpSubscriptionDlg ppSubscriptionDlg = null;
    private boolean subscriptionModeSet = false;
    private GuiUtilTableFilterDlg ppTableFilterDlg = null;

    public PpConfigTaskPanel(PpConfigMainPanel ppConfigMainPanel, CommonDataHandler commonDataHandler, ConfiguratorTable configuratorTable) {
        this.ppMainPanel = ppConfigMainPanel;
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode, this);
        this.ppTable = configuratorTable;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonCreatePp(), null);
        this.add((Component)this.getButtonConfigurePp(), null);
        this.add((Component)this.getButtonDeletePp(), null);
        this.add((Component)this.getButtonFilterPpTable(), null);
        this.add((Component)this.getButtonStartSubscription(), null);
        this.add((Component)this.getButtonStartWildcardSubscription(), null);
        this.add((Component)this.getButtonConfigurePpTable(), null);
        this.add((Component)this.getButtonChangeRelationType(), null);
    }

    private AastraLinkButton getButtonCreatePp() {
        if (this.buttonCreatePp == null) {
            this.buttonCreatePp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CREATE_20"));
            this.buttonCreatePp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.ppMainPanel.StartPpCreation();
                }
            });
        }
        return this.buttonCreatePp;
    }

    private AastraLinkButton getButtonConfigurePp() {
        if (this.buttonConfigurePp == null) {
            this.buttonConfigurePp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CONFIGURE_20"));
            this.buttonConfigurePp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.ppMainPanel.configurePp();
                }
            });
        }
        return this.buttonConfigurePp;
    }

    private AastraLinkButton getButtonFilterPpTable() {
        if (this.buttonFilterPpTable == null) {
            this.buttonFilterPpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterPpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.getPpTableFilterDlg().setVisible(true);
                    PpConfigTaskPanel.this.ppMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterPpTable;
    }

    private GuiUtilTableFilterDlg getPpTableFilterDlg() {
        if (this.ppTableFilterDlg == null) {
            this.ppTableFilterDlg = new GuiUtilTableFilterDlg(this.ppTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpConfig);
        }
        return this.ppTableFilterDlg;
    }

    private AastraLinkButton getButtonDeletePp() {
        if (this.buttonDeletePp == null) {
            this.buttonDeletePp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_DELETE_20"));
            this.buttonDeletePp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.ppMainPanel.deletePp();
                }
            });
        }
        return this.buttonDeletePp;
    }

    private AastraLinkButton getButtonStartSubscription() {
        if (this.buttonStartSubscription == null) {
            this.buttonStartSubscription = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SUBSCRIPTION_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonStartSubscription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = null;
                    try {
                        dECTSubscriptionMode = (CommonDataHandler.DECTSubscriptionMode)PpConfigTaskPanel.this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode.toString());
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + " failed");
                        return;
                    }
                    if (dECTSubscriptionMode.mode != OmiMessage.DECTSubscriptionModeType.Off) {
                        dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                        dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Off;
                    } else {
                        dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                        dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Configured;
                        dECTSubscriptionMode.timeout = 0;
                    }
                    PpConfigTaskPanel.this.changeSubscriptionMode(dECTSubscriptionMode);
                }
            });
        }
        return this.buttonStartSubscription;
    }

    private AastraLinkButton getButtonStartWildcardSubscription() {
        if (this.buttonStartWildcardSubscription == null) {
            this.buttonStartWildcardSubscription = this.createTaskButtonEnabled(UtilLocale.getString("TXT_WILDCARD_SUBSCRIPTION_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonStartWildcardSubscription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.ppSubscriptionDlg = new PpSubscriptionDlg(PpConfigTaskPanel.this, PpConfigTaskPanel.this.commonDataHandler);
                    PpConfigTaskPanel.this.ppSubscriptionDlg.setVisible(true);
                }
            });
        }
        return this.buttonStartWildcardSubscription;
    }

    private AastraLinkButton getButtonConfigurePpTable() {
        if (this.buttonConfigurePpTable == null) {
            this.buttonConfigurePpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigurePpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(PpConfigTaskPanel.this.ppTable, PpConfigTaskPanel.this.ppMainPanel.getPpTableConfigIdxArray(), UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpConfig);
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonConfigurePpTable;
    }

    private AastraLinkButton getButtonChangeRelationType() {
        if (this.buttonChangeRelationType == null) {
            this.buttonChangeRelationType = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CHANGE_RELATION_TYPE_20"));
            this.buttonChangeRelationType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpConfigTaskPanel.this.ppMainPanel.changeRelationType();
                }
            });
        }
        return this.buttonChangeRelationType;
    }

    public void setTaskButtonCreate(boolean bl) {
        this.buttonCreatePp.setEnabled(bl);
    }

    public void setTaskButtonConfigure(boolean bl) {
        this.buttonConfigurePp.setEnabled(bl);
    }

    public void setTaskButtonChangeRelationType(boolean bl) {
        this.buttonChangeRelationType.setEnabled(bl);
    }

    public void setTaskButtonDelete(boolean bl) {
        this.buttonDeletePp.setEnabled(bl);
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigurePpTable.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterPpTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterPpTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterPpTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterPpTable.setToolTipText(string);
    }

    protected void changeSubscriptionMode(CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode) {
        this.subscriptionModeSet = true;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode);
        this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode, dECTSubscriptionMode);
        this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + ",item=" + commonDataItemEnum.toString() + ",errorCode=" + string3 + ",bad=" + string + ",maxLen=" + string2);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: Unknown errorCode=" + string3);
        }
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode && this.subscriptionModeSet || commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate) {
            if (errorCodes2 != null) {
                String string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string, string2);
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
        }
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode && this.subscriptionModeSet && this.ppSubscriptionDlg != null) {
            if (string != null && string.equals(OmiMessage.attribIds.timeout.name())) {
                this.ppSubscriptionDlg.markErrorComboBoxTimeout();
            }
            this.ppSubscriptionDlg.setVisible(true);
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = null;
        this.subscriptionModeSet = false;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode) {
            try {
                dECTSubscriptionMode = (CommonDataHandler.DECTSubscriptionMode)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode.toString());
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + " failed");
                return;
            }
            switch (dECTSubscriptionMode.mode) {
                case Configured: {
                    this.buttonStartSubscription.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartSubscription.setEnabled(true);
                    this.buttonStartWildcardSubscription.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartWildcardSubscription.setEnabled(false);
                    break;
                }
                case Wildcard: {
                    this.buttonStartWildcardSubscription.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartWildcardSubscription.setEnabled(true);
                    this.buttonStartSubscription.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartSubscription.setEnabled(false);
                    break;
                }
                case Off: {
                    this.buttonStartSubscription.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartSubscription.setEnabled(true);
                    this.buttonStartWildcardSubscription.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.buttonStartWildcardSubscription.setEnabled(true);
                    break;
                }
            }
        }
    }
}

