/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.pp.PpDetailPanel;
import com.aastra.oamp.pp.PpDevConfigMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraTristateCheckbox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PpDevConfigDetailPanel
extends PpDetailPanel {
    private static final long serialVersionUID = 1L;
    private PpDevConfigMainPanel ppDevMainPanel = null;
    private int selectedPpDev = -1;
    private PpDevDataRecord[] ppDevDataRecords = null;

    public PpDevConfigDetailPanel(PpDevConfigMainPanel ppDevConfigMainPanel, UtilErrorComp utilErrorComp) {
        this.ppDevMainPanel = ppDevConfigMainPanel;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
        super.initialize();
        this.headerBar.add(this.labelDevice);
        this.panelTabbed.addTab("DECT", null, this.getTabDECT(), null);
        this.panelButtonBar.add((Component)this.getButtonOK(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    public void setPpDevDetailData(DataRecord[] dataRecordArray) {
        if (dataRecordArray != null) {
            this.ppDevDataRecords = new PpDevDataRecord[dataRecordArray.length];
            for (int i = 0; i < this.ppDevDataRecords.length; ++i) {
                this.ppDevDataRecords[i] = (PpDevDataRecord)dataRecordArray[i].clone();
            }
            if (dataRecordArray.length == 1) {
                this.labelDevice.setText(String.format(" %s #0x%03X", UtilLocale.getString("TXT_PP_DEVICE"), (Integer)this.ppDevDataRecords[0].getField(PpDevDataRecord.IDX_PPN)));
                this.labelDevice.setEnabled(true);
            } else {
                String string = " ";
                for (int i = 0; i < this.ppDevDataRecords.length; ++i) {
                    string = string + String.format("#0x%03X ", (Integer)this.ppDevDataRecords[i].getField(PpDevDataRecord.IDX_PPN));
                    if (i <= 3) continue;
                    string = string + " ...";
                    break;
                }
                this.labelDevice.setText(UtilLocale.getString("TXT_PP_DEVICES") + string);
            }
            Object object = UtilMisc.getRecordsFieldObject(this.ppDevDataRecords, PpDevDataRecord.IDX_REL_TYPE, (Object)OmiMessage.PPRelTypeType.Unbound);
            if (OmiMessage.PPRelTypeType.class == object.getClass() && (OmiMessage.PPRelTypeType)((Object)object) != OmiMessage.PPRelTypeType.Fixed) {
                this.textFieldIPEI.setEnabled(false);
                this.textFieldDECTAuthCode.setEnabled(false);
            } else {
                if (dataRecordArray.length == 1) {
                    this.textFieldIPEI.setEnabled(true);
                } else {
                    this.textFieldIPEI.setEnabled(false);
                }
                this.textFieldDECTAuthCode.setEnabled(true);
            }
            this.textFieldIPEI.setText((String)UtilMisc.getRecordsFieldObject(this.ppDevDataRecords, PpDevDataRecord.IDX_IPEI));
            this.textFieldDECTAuthCode.setText((String)UtilMisc.getRecordsFieldObject(this.ppDevDataRecords, PpDevDataRecord.IDX_AC));
            this.checkBoxEncryption.setState(UtilMisc.getRecordsFieldState(this.ppDevDataRecords, PpDevDataRecord.IDX_ENCRYPT));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.checkBoxSubscribeToPARIOnly.setState(UtilMisc.getRecordsFieldState(this.ppDevDataRecords, PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY));
            }
            this.labelDelSubscription.setVisible(true);
            this.checkBoxDelSubscription.setVisible(true);
            this.checkBoxDelSubscription.setState(AastraTristateCheckbox.NOT_SELECTED);
            Object object2 = UtilMisc.getRecordsFieldObject(this.ppDevDataRecords, PpDevDataRecord.IDX_SUBSCRIBED);
            if (OmiMessage.DECTSubscriptionStateType.class == object2.getClass() && (OmiMessage.DECTSubscriptionStateType)((Object)object2) == OmiMessage.DECTSubscriptionStateType.Yes) {
                this.checkBoxDelSubscription.setEnabled(true);
            } else {
                this.checkBoxDelSubscription.setEnabled(false);
            }
        }
        this.utilChangeHandler.initRootPane(this.getRootPane());
        this.utilChangeHandler.deactivate();
    }

    public DataRecord[] getPpDevDetailData() {
        String string;
        if (this.ppDevDataRecords == null) {
            this.ppDevDataRecords = new PpDevDataRecord[1];
            this.ppDevDataRecords[0] = new PpDevDataRecord();
        }
        if (this.ppDevDataRecords.length == 1 && !(string = this.textFieldIPEI.getText()).isEmpty() && this.textFieldIPEI.isChange()) {
            this.ppDevDataRecords[0].setField(PpDevDataRecord.IDX_IPEI, (Object)string);
        }
        string = null;
        if (this.textFieldDECTAuthCode.isChange()) {
            string = this.textFieldDECTAuthCode.getText();
        }
        for (int i = 0; i < this.ppDevDataRecords.length; ++i) {
            if (string != null) {
                this.ppDevDataRecords[i].setField(PpDevDataRecord.IDX_AC, (Object)string);
            }
            UtilMisc.setRecordFromTristateCheckbox(this.ppDevDataRecords[i], this.checkBoxEncryption, PpDevDataRecord.IDX_ENCRYPT);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                UtilMisc.setRecordFromTristateCheckbox(this.ppDevDataRecords[i], this.checkBoxSubscribeToPARIOnly, PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY);
            }
            if (!this.checkBoxDelSubscription.isSelected()) continue;
            this.ppDevDataRecords[i].setField(PpDevDataRecord.IDX_SUBSCRIBED, (Object)OmiMessage.DECTSubscriptionStateType.No);
        }
        return this.ppDevDataRecords;
    }

    public int getSelectedPpDev() {
        return this.selectedPpDev;
    }

    @Override
    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            super.getButtonOK();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpDevConfigDetailPanel.this.utilChangeHandler.deactivate();
                    PpDevConfigDetailPanel.this.utilErrorComp.clearComponents();
                    PpDevConfigDetailPanel.this.ppDevMainPanel.changePpDev();
                }
            });
        }
        return this.buttonOK;
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpDevConfigDetailPanel.this.utilChangeHandler.deactivate();
                    PpDevConfigDetailPanel.this.ppDevMainPanel.removePpDevDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void requestDefaultFocusInWindow() {
        if (this.textFieldIPEI.isEnabled()) {
            this.textFieldIPEI.requestFocusInWindow();
        } else if (this.textFieldDECTAuthCode.isEnabled()) {
            this.textFieldDECTAuthCode.requestFocusInWindow();
        } else {
            this.checkBoxEncryption.requestFocusInWindow();
        }
    }
}

