/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.pp.PpActivityLogFile;
import com.aastra.oamp.pp.PpDevMonitorDetailPanel;
import com.aastra.oamp.pp.PpDevMonitorTaskPanel;
import com.aastra.oamp.pp.PpMonitorMainPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;

public class PpDevMonitorMainPanel
extends AastraPanel
implements PpDataNotificationInterface,
GuiComponentActivationInterface,
ConfiguratorTableEventInterface,
CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private AastraScrollPane ppDevTablePane = null;
    private PpDevMonitorTaskPanel ppDevTaskPanel = null;
    private GuiUtilConfiguratorTable ppDevTable = null;
    private PpDataHandler ppDataHandler = null;
    private boolean tableActive = false;
    private boolean componentActive = false;
    private OmiMessage.PermissionType[] permissionArray = null;
    private boolean ppDevTableMonitorIdxArrayChecked = false;
    private boolean ppDevTableMonitorIdxArrayDefaultChecked = false;
    private GuiUtilDetailSplitPanel ppDevDetailSplitPane = null;
    private int dividerLocation = 0;
    private PpDevMonitorDetailPanel ppDevDetailPanel = null;
    private int ppnCurrentMonitorPanel = -1;
    private CommonDataHandler commonDataHandler = null;
    private boolean firmwareStateSubscribed = false;
    private OmiManagement omiManagement = null;
    private int[] ppDevTableMonitorIdxArrayDefault = new int[]{PpDevDataRecord.IDX_PPN, PpDevDataRecord.IDX_IPEI, PpDevDataRecord.IDX_HW_TYPE, PpDevDataRecord.IDX_SUBSCRIBED};
    private int[] ppDevTableMonitorIdxArray = new int[]{PpDevDataRecord.IDX_PPN, PpDevDataRecord.IDX_TIME_STAMP, PpDevDataRecord.IDX_IPEI, PpDevDataRecord.IDX_REL_TYPE, PpDevDataRecord.IDX_UID, PpDevDataRecord.IDX_HW_TYPE, PpDevDataRecord.IDX_SUBSCRIBED};

    public PpDevMonitorMainPanel(PpDataHandler ppDataHandler, CommonDataHandler commonDataHandler) {
        this.ppDataHandler = ppDataHandler;
        this.ppDataHandler.registerDevDataNotificationListener(this);
        this.omiManagement = GuiMain.getOmiManagementObject();
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.ppDataHandler.subscribeEventPPDevState();
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.commonDataHandler = commonDataHandler;
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate, this);
        }
        this.permissionArray = this.omiManagement.getOmmPermissions();
        this.initialize();
    }

    public void deregisterNotificationListener() {
        this.ppDataHandler.deregisterDevDataNotificationListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDevDetailSplitPane(), "Center");
        this.add((Component)this.getPpDevTaskPanel(), "East");
    }

    private GuiUtilConfiguratorTable getPpDevTable() {
        if (this.ppDevTable == null) {
            this.ppDevTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDevDatabase(), this.getPpDevTableMonitorIdxArray(), this.getActivePpDevMonitorColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpDevMonitor, 0);
            this.ppDevTable.setIconArray(PpDevDataRecord.IDX_SUBSCRIBED, GuiUtilIcon.getIconArrayErrorErrorActive());
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppDevTable.setIconArray(PpDevDataRecord.IDX_CC_ACTIVE, GuiUtilIcon.getIconArraySpacerActive());
                this.ppDevTable.setIconArray(PpDevDataRecord.IDX_SS_ACTIVE, GuiUtilIcon.getIconArraySpacerActive());
                this.ppDevTable.setIconArray(PpDevDataRecord.IDX_MM_ACTIVE, GuiUtilIcon.getIconArraySpacerActive());
                this.ppDevTable.setIconArray(PpDevDataRecord.IDX_COMS_ACTIVE, GuiUtilIcon.getIconArraySpacerActive());
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                    this.ppDevTable.setIconArray(PpDevDataRecord.IDX_FW_UPDATE_STATE, GuiUtilIcon.getIconArrayFirmwareDownloadStatus());
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.ppDevTable.setIconArray(PpDevDataRecord.IDX_DEF_PROFILE_LOADED, GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.ppDevTable.setColumnFormatString(PpDevDataRecord.IDX_PPN, "0x%03X");
            this.ppDevTable.setColumnFormatString(PpDevDataRecord.IDX_UID, "0x%03X");
            this.ppDevTable.setNegativeIntAsInvalid(PpDevDataRecord.IDX_UID);
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppDevTable.setColumnFormatString(PpDevDataRecord.IDX_RFP, "0x%03X");
                this.ppDevTable.setNegativeIntAsInvalid(PpDevDataRecord.IDX_RFP);
            }
        }
        return this.ppDevTable;
    }

    private int[] getActivePpDevMonitorColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = this.getPpDevTableMonitorIdxArray();
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpDevMonitor);
        if (bitSet != null && !UtilPreferences.isOpenRespAttribsChanged()) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = nArray2[i];
                ++n;
            }
        } else {
            nArray = this.getPpDevTableMonitorIdxArrayDefault();
            bitSet = new BitSet();
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpDevMonitor, bitSet);
        }
        return nArray;
    }

    private int[] getPpDevTableMonitorIdxArrayDefault() {
        int n = 0;
        int n2 = this.ppDevTableMonitorIdxArrayDefault.length;
        if (!this.ppDevTableMonitorIdxArrayDefaultChecked) {
            this.ppDevTableMonitorIdxArrayDefaultChecked = true;
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                ++n;
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                    ++n;
                }
                int[] nArray = Arrays.copyOf(this.ppDevTableMonitorIdxArrayDefault, this.ppDevTableMonitorIdxArrayDefault.length + n);
                this.ppDevTableMonitorIdxArrayDefault = nArray;
                this.ppDevTableMonitorIdxArrayDefault[n2++] = PpDevDataRecord.IDX_ST_SW_VERSION;
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                    this.ppDevTableMonitorIdxArrayDefault[n2++] = PpDevDataRecord.IDX_FW_UPDATE_STATE;
                }
            }
        }
        return this.ppDevTableMonitorIdxArrayDefault;
    }

    public int[] getPpDevTableMonitorIdxArray() {
        int n = 0;
        int n2 = this.ppDevTableMonitorIdxArray.length;
        if (!this.ppDevTableMonitorIdxArrayChecked) {
            this.ppDevTableMonitorIdxArrayChecked = true;
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                n += 8;
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                    ++n;
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                ++n;
            }
            if (n > 0) {
                int[] nArray = Arrays.copyOf(this.ppDevTableMonitorIdxArray, this.ppDevTableMonitorIdxArray.length + n);
                this.ppDevTableMonitorIdxArray = nArray;
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_ST_SW_VERSION;
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
                    this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_FW_UPDATE_STATE;
                }
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_LAST_ACTION_TIME;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_RFP;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_CC_ACTIVE;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_SS_ACTIVE;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_MM_ACTIVE;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_COMS_ACTIVE;
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_ACTIVITIES;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.ppDevTableMonitorIdxArray[n2++] = PpDevDataRecord.IDX_DEF_PROFILE_LOADED;
            }
        }
        return this.ppDevTableMonitorIdxArray;
    }

    private GuiUtilDetailSplitPanel getPpDevDetailSplitPane() {
        if (this.ppDevDetailSplitPane == null) {
            this.ppDevDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDevDetailSplitPane.setTopComponent(this.getPpDevTablePane());
            this.ppDevDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDevDetailSplitPane;
    }

    private AastraScrollPane getPpDevTablePane() {
        if (this.ppDevTablePane == null) {
            this.ppDevTablePane = new AastraScrollPane(this.getPpDevTable());
            this.dividerLocation = this.ppDevDetailSplitPane.getHeight() - 390;
            this.ppDevTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppDevTablePane;
    }

    public void showPpDevDetails() {
        int n = this.ppDevTable.getSelectedRow();
        if (n >= 0) {
            int n2 = this.ppDevTable.convertRowIndexToModel(n);
            PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getDevDatabase().getRecordByIdx(n2);
            if (ppDevDataRecord != null) {
                this.createPpDevDetailPanel(ppDevDataRecord);
            }
        }
    }

    public void createPpDevDetailPanel(PpDevDataRecord ppDevDataRecord) {
        if (this.ppDevDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.ppDevDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP device monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP device monitor detail panel");
            this.ppDevDetailSplitPane.setBottomComponent(this.getPpDevDetailPanel());
        }
        if (ppDevDataRecord != null) {
            Integer n = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
            this.ppnCurrentMonitorPanel = n;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n + "]:");
            UtilPrint.printPpDevDataRecordString(ppDevDataRecord, this);
            this.ppDevDetailPanel.setPpDevDetailData(ppDevDataRecord);
        } else {
            this.ppDevDetailPanel.setPpDevDetailData(null);
        }
        this.ppDevDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDevDetailSplitPane.validate();
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.ppDevTaskPanel.setTaskButtonShowDetails(false);
        }
    }

    public void removePpDevDetailPanel() {
        this.ppnCurrentMonitorPanel = -1;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP device monitor detail panel");
        this.dividerLocation = this.ppDevDetailSplitPane.getDividerLocation();
        this.ppDevDetailSplitPane.setBottomComponent(null);
        if (this.ppDevTable.getSelectedRowCount() == 1 && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.ppDevTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    private void enableTableAccess() {
        this.ppDevTable.setActive(true);
        this.ppDevTaskPanel.setTaskButtonFilter(true);
        this.ppDevTaskPanel.setTaskButtonActivateEventLog(true, null);
        this.ppDevTaskPanel.setTaskButtonConfigureTable(true);
        this.tableActive = true;
    }

    private void disableTableAccess() {
        this.tableActive = false;
        this.ppDevTable.setActive(false);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.ppDevTaskPanel.setTaskButtonShowDetails(false);
        }
        this.ppDevTaskPanel.setTaskButtonFilter(false);
        this.ppDevTaskPanel.setTaskButtonActivateEventLog(false, null);
        this.ppDevTaskPanel.setTaskButtonConfigureTable(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.ppDevTable, this.getPpDevTableMonitorIdxArray(), UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpDevMonitor));
        this.ppDevTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private void checkPpTransactionStart() {
        if ((UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) || UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Locating)) && this.tableActive && this.componentActive && !PpMonitorMainPanel.getPPDevMonitoringState()) {
            PpMonitorMainPanel.setPPDevMonitoringState(true);
            this.ppDataHandler.subscribeEventPPTransaction();
            this.ppDataHandler.updateLastPpDevAction();
            this.ppDataHandler.updateActivePpDev();
        }
    }

    private void checkPpFirmwareStateStart() {
        if (this.tableActive && this.componentActive && !this.firmwareStateSubscribed) {
            this.ppDataHandler.sendFirmwareStateEventSubscription();
            this.ppDataHandler.startGetPPFirmwareUpdateStatusBulk();
            this.firmwareStateSubscribed = true;
        }
    }

    private AastraPanel getPpDevDetailPanel() {
        if (this.ppDevDetailPanel == null) {
            this.ppDevDetailPanel = new PpDevMonitorDetailPanel(this, this.permissionArray);
        }
        return this.ppDevDetailPanel;
    }

    private AastraPanel getPpDevTaskPanel() {
        if (this.ppDevTaskPanel == null) {
            this.ppDevTaskPanel = new PpDevMonitorTaskPanel(this, this.getPpDevTable());
        }
        return this.ppDevTaskPanel;
    }

    private void processTableEvent(DataRecord dataRecord) {
        PpDevDataRecord ppDevDataRecord = (PpDevDataRecord)dataRecord;
        if (ppDevDataRecord != null) {
            Integer n = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
            this.ppDataHandler.sendGetPPFirmwareUpdateStatus(n);
            this.ppDataHandler.sendFirmwareUpdateStateEventSubscription(n);
        }
        if (this.ppDevDetailSplitPane.getBottomComponent() != null) {
            if (ppDevDataRecord != null) {
                this.createPpDevDetailPanel(ppDevDataRecord);
            } else {
                this.removePpDevDetailPanel();
            }
        } else if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            if (this.ppDevTable.getSelectedRowCount() == 1) {
                this.ppDevTaskPanel.setTaskButtonShowDetails(true);
            } else {
                this.ppDevTaskPanel.setTaskButtonShowDetails(false);
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.componentActive = true;
        this.checkPpTransactionStart();
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) {
            this.checkPpFirmwareStateStart();
        }
        this.ppDevTaskPanel.setTaskButtonActivateEventLog(null, PpActivityLogFile.IsLogActive());
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
        this.componentActive = false;
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.checkPpTransactionStart();
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) break;
                this.checkPpFirmwareStateStart();
                break;
            }
            case DATA_CHANGED: {
                PpDevDataRecord ppDevDataRecord;
                if (n != this.ppnCurrentMonitorPanel || (ppDevDataRecord = this.ppDataHandler.getPpDevData(n)) == null) break;
                this.createPpDevDetailPanel(ppDevDataRecord);
                break;
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createPpDevDetailPanel((PpDevDataRecord)dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        switch (commonDataItemEnum) {
            case PPFirmwareUpdate: {
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.havePPFirmwareUpdate)) break;
                CommonDataHandler.PPFirmwareUpdateClass pPFirmwareUpdateClass = null;
                try {
                    pPFirmwareUpdateClass = (CommonDataHandler.PPFirmwareUpdateClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate.toString() + ": " + "enable='" + pPFirmwareUpdateClass.enable + "', source='" + pPFirmwareUpdateClass.name + "'");
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PPFirmwareUpdate.toString() + " failed");
                    return;
                }
                if (pPFirmwareUpdateClass.enable) break;
                this.ppDataHandler.setPPFirmwareUpdateStatusToUnknown();
                break;
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }
}

