/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.pp.PpDetailPanel;
import com.aastra.oamp.pp.PpMonitorMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PpMonitorDetailPanel
extends PpDetailPanel {
    private static final long serialVersionUID = 1L;
    private PpMonitorMainPanel ppMainPanel = null;
    private String dummyPassword = "1234567";
    private AastraPanel tabStatus = null;
    private AastraLabel labelHWType = null;
    private AastraTextField textFieldHWType = null;
    private AastraLabel labelSWVersion = null;
    private AastraTextField textFieldSWVersion = null;
    private AastraLabel labelRegistered = null;
    private AastraLabel labelRegisteredStatus = null;
    private AastraLabel labelRegistrarServerType = null;
    private AastraTextField textFieldRegistrarServerType = null;
    private AastraLabel labelRegistrarServer = null;
    private AastraTextField textFieldRegistrarServer = null;
    private AastraLabel labelRegistrarPort = null;
    private AastraTextField textFieldRegistrarPort = null;
    private AastraPanel tabUserDeviceSync = null;
    private AastraTextField textFieldOmmId = null;
    private AastraTextField textFieldOmmIdAck = null;
    private AastraTextField textFieldRoamingState = null;
    private OmiMessage.PermissionType[] permissionArray = null;

    public PpMonitorDetailPanel(PpMonitorMainPanel ppMonitorMainPanel, OmiMessage.PermissionType[] permissionTypeArray) {
        this.ppMainPanel = ppMonitorMainPanel;
        this.permissionArray = permissionTypeArray;
        this.initialize();
        this.headerBar.add(this.labelDevice);
        this.headerBar.add(this.labelUser);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_STATUS"), null, this.getTabStatus(), null);
        UtilSetPanelEditable.setDisabled(this.tabStatus);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        UtilSetPanelEditable.setDisabled(this.tabGeneral);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
            this.panelTabbed.addTab("SIP", null, this.getTabSIP(), null);
            UtilSetPanelEditable.setDisabled(this.tabSIP);
            this.panelTabbed.addTab(UtilLocale.getString("TXT_INCOMING_CALLS"), null, this.getTabIncomingCall(), null);
            UtilSetPanelEditable.setDisabled(this.tabIncomingCall);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_CONFERENCE"), null, this.getTabConference(), null);
            UtilSetPanelEditable.setDisabled(this.tabConference);
        }
        this.panelTabbed.addTab("DECT", null, this.getTabDECT(), null);
        UtilSetPanelEditable.setDisabled(this.tabDECT);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_MESSAGING"), null, this.getTabMessaging(), null);
        UtilSetPanelEditable.setDisabled(this.tabMessaging);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_LOCATING"), null, this.getTabLocating(), null);
        UtilSetPanelEditable.setDisabled(this.tabLocating);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_ADDITIONAL_SERVICES"), null, this.getTabAdditionalServices(), null);
        UtilSetPanelEditable.setDisabled(this.tabAdditionalServices);
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_USER_MONITORING"), null, this.getTabUserMonitoring(), null);
            UtilSetPanelEditable.setDisabled(this.tabUserMonitoring);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_CONFIGURATION_DATA"), null, this.getTabConfigurationData(true, true), null);
            UtilSetPanelEditable.setDisabled(this.tabConfigurationData);
        }
        if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_DECT_PHONES_SYNCHRONIZATION"), null, this.getTabUserDeviceSync(), null);
            UtilSetPanelEditable.setDisabled(this.tabUserDeviceSync);
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabStatus() {
        int n = 15;
        this.labelHWType = new AastraLabel();
        this.labelHWType.setBounds(30, n, 140, 16);
        this.labelHWType.setText(UtilLocale.getString("TXT_HARDWARE_TYPE"));
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.labelSWVersion = new AastraLabel();
            this.labelSWVersion.setText(UtilLocale.getString("TXT_SOFTWARE_VERSION"));
            this.labelSWVersion.setBounds(30, n += 30, 140, 16);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.labelRegistered = new AastraLabel();
                this.labelRegistered.setText(UtilLocale.getString("TXT_REGISTERED"));
                this.labelRegistered.setBounds(30, n += 30, 140, 16);
                this.labelRegisteredStatus = new AastraLabel();
                this.labelRegisteredStatus.setBounds(180, n, 140, 16);
                this.labelRegistrarServerType = new AastraLabel();
                this.labelRegistrarServerType.setText(UtilLocale.getString("TXT_REGISTRAR_SERVER_TYPE"));
                this.labelRegistrarServerType.setBounds(30, n += 30, 140, 16);
                this.labelRegistrarServer = new AastraLabel();
                this.labelRegistrarServer.setText(UtilLocale.getString("TXT_REGISTRAR_SERVER"));
                this.labelRegistrarServer.setBounds(30, n += 30, 140, 16);
                this.labelRegistrarPort = new AastraLabel();
                this.labelRegistrarPort.setText(UtilLocale.getString("TXT_REGISTRAR_PORT"));
                this.labelRegistrarPort.setBounds(30, n += 30, 140, 16);
            }
        }
        n = 15;
        this.tabStatus = new AastraPanel();
        this.tabStatus.setLayout(null);
        this.tabStatus.add((Component)this.labelHWType, null);
        this.tabStatus.add((Component)this.getTextFieldHWType(n), null);
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.tabStatus.add((Component)this.labelSWVersion, null);
            this.tabStatus.add((Component)this.getTextFieldSWVersion(n += 30), null);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.tabStatus.add((Component)this.labelRegistered, null);
                this.tabStatus.add((Component)this.labelRegisteredStatus, null);
                this.tabStatus.add((Component)this.labelRegistrarServerType, null);
                this.tabStatus.add((Component)this.getTextFieldRegistrarServerType(n += 60), null);
                this.tabStatus.add((Component)this.labelRegistrarServer, null);
                this.tabStatus.add((Component)this.getTextFieldRegistrarServer(n += 30), null);
                this.tabStatus.add((Component)this.labelRegistrarPort, null);
                this.tabStatus.add((Component)this.getTextFieldRegistrarPort(n += 30), null);
            }
        }
        return this.tabStatus;
    }

    private AastraTextField getTextFieldHWType(int n) {
        if (this.textFieldHWType == null) {
            this.textFieldHWType = new AastraTextField();
            this.textFieldHWType.setBounds(180, n, 75, 18);
        }
        return this.textFieldHWType;
    }

    private AastraTextField getTextFieldSWVersion(int n) {
        if (this.textFieldSWVersion == null) {
            this.textFieldSWVersion = new AastraTextField();
            this.textFieldSWVersion.setBounds(180, n, 75, 18);
        }
        return this.textFieldSWVersion;
    }

    private AastraTextField getTextFieldRegistrarServerType(int n) {
        if (this.textFieldRegistrarServerType == null) {
            this.textFieldRegistrarServerType = new AastraTextField();
            this.textFieldRegistrarServerType.setBounds(180, n, 75, 18);
        }
        return this.textFieldRegistrarServerType;
    }

    private AastraTextField getTextFieldRegistrarServer(int n) {
        if (this.textFieldRegistrarServer == null) {
            this.textFieldRegistrarServer = new AastraTextField();
            this.textFieldRegistrarServer.setBounds(180, n, 150, 18);
        }
        return this.textFieldRegistrarServer;
    }

    private AastraTextField getTextFieldRegistrarPort(int n) {
        if (this.textFieldRegistrarPort == null) {
            this.textFieldRegistrarPort = new AastraTextField();
            this.textFieldRegistrarPort.setBounds(180, n, 50, 18);
        }
        return this.textFieldRegistrarPort;
    }

    protected AastraPanel getTabUserDeviceSync() {
        if (this.tabUserDeviceSync == null) {
            this.tabUserDeviceSync = new AastraPanel();
            this.tabUserDeviceSync.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 15, 140, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_OMM_ID"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 50, 140, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_OMM_ID_ACK"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, 85, 140, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_ROAMING_STATE"));
            this.tabUserDeviceSync.add(aastraLabel);
            this.tabUserDeviceSync.add(this.getTextFieldOmmId());
            this.tabUserDeviceSync.add(aastraLabel2);
            this.tabUserDeviceSync.add(this.getTextFieldOmmIdAck());
            this.tabUserDeviceSync.add(aastraLabel3);
            this.tabUserDeviceSync.add(this.getTextFieldRoamingState());
        }
        return this.tabUserDeviceSync;
    }

    private AastraTextField getTextFieldOmmId() {
        if (this.textFieldOmmId == null) {
            this.textFieldOmmId = new AastraTextField();
            this.textFieldOmmId.setBounds(180, 15, 75, 18);
        }
        return this.textFieldOmmId;
    }

    private AastraTextField getTextFieldOmmIdAck() {
        if (this.textFieldOmmIdAck == null) {
            this.textFieldOmmIdAck = new AastraTextField();
            this.textFieldOmmIdAck.setBounds(180, 50, 75, 18);
        }
        return this.textFieldOmmIdAck;
    }

    private AastraTextField getTextFieldRoamingState() {
        if (this.textFieldRoamingState == null) {
            this.textFieldRoamingState = new AastraTextField();
            this.textFieldRoamingState.setBounds(180, 85, 75, 18);
        }
        return this.textFieldRoamingState;
    }

    public void setPpDevDetailData(PpDevDataRecord ppDevDataRecord) {
        if (ppDevDataRecord != null) {
            this.labelDevice.setText(String.format("%s #0x%03X", UtilLocale.getString("TXT_PP_DEVICE"), (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN)));
            this.textFieldHWType.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_HW_TYPE));
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                String string = (String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_SW_VERSION);
                if (string != null && string.length() > 0) {
                    this.textFieldSWVersion.setText(string);
                } else {
                    this.textFieldSWVersion.setText("-");
                }
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO) && this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                if (((Boolean)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REGISTERED)).booleanValue()) {
                    this.labelRegisteredStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelRegisteredStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
                switch ((OmiMessage.RegServerTypeType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_TYPE))) {
                    default: {
                        this.textFieldRegistrarServerType.setText(UtilLocale.getString("TXT_NONE"));
                        this.textFieldRegistrarServer.setText("-");
                        this.textFieldRegistrarPort.setText("-");
                        break;
                    }
                    case Primary: {
                        this.textFieldRegistrarServerType.setText(UtilLocale.getString("TXT_PRIMARY"));
                        this.textFieldRegistrarServer.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR));
                        this.textFieldRegistrarPort.setText(String.valueOf((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_PORT)));
                        break;
                    }
                    case Secondary: {
                        this.textFieldRegistrarServerType.setText(UtilLocale.getString("TXT_SECONDARY"));
                        this.textFieldRegistrarServer.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR));
                        this.textFieldRegistrarPort.setText(String.valueOf((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_PORT)));
                        break;
                    }
                    case Tertiary: {
                        this.textFieldRegistrarServerType.setText(UtilLocale.getString("TXT_TERTIARY"));
                        this.textFieldRegistrarServer.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR));
                        this.textFieldRegistrarPort.setText(String.valueOf((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_PORT)));
                    }
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                if (((Boolean)ppDevDataRecord.getField(PpDevDataRecord.IDX_DEF_PROFILE_LOADED)).booleanValue()) {
                    this.labelDefaultProfileLoadedStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelDefaultProfileLoadedStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
            }
            this.textFieldIPEI.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_IPEI));
            this.textFieldDECTAuthCode.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_AC));
            this.checkBoxEncryption.setSelected((Boolean)ppDevDataRecord.getField(PpDevDataRecord.IDX_ENCRYPT));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.checkBoxSubscribeToPARIOnly.setSelected((Boolean)ppDevDataRecord.getField(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY));
                this.textFieldOmmId.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_OMM_ID));
                this.textFieldOmmIdAck.setText((String)ppDevDataRecord.getField(PpDevDataRecord.IDX_OMM_ID_ACK));
                this.textFieldRoamingState.setText(((OmiMessage.PPDevRoamingStateType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_ROAMING_STATE))).toString());
            }
        } else {
            this.labelDevice.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            this.textFieldHWType.setText("-");
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.textFieldSWVersion.setText("-");
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    this.labelRegisteredStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    this.textFieldRegistrarServerType.setText(UtilLocale.getString("TXT_NONE"));
                    this.textFieldRegistrarServer.setText("-");
                    this.textFieldRegistrarPort.setText("-");
                }
            }
            this.textFieldIPEI.setText("");
            this.textFieldDECTAuthCode.setText("");
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.labelDefaultProfileLoadedStatus.setIcon(null);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.checkBoxSubscribeToPARIOnly.setSelected(false);
                this.textFieldOmmId.setText(null);
                this.textFieldOmmIdAck.setText(null);
                this.textFieldRoamingState.setText(null);
            }
        }
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.getButtonCancel());
            this.getButtonCancel().requestFocusInWindow();
        }
    }

    public void setPpUserDetailData(PpUserDataRecord ppUserDataRecord) {
        if (ppUserDataRecord != null) {
            this.labelUser.setText(String.format(" - %s #0x%03X", UtilLocale.getString("TXT_PP_USER"), (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID)));
            this.textFieldName.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_NAME));
            this.textFieldNumber.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_NUM));
            this.textFieldAdditionalID.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_ADD_ID));
            this.textFieldHierarchy1.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_HIERARCHY1));
            this.textFieldHierarchy2.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_HIERARCHY2));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.textFieldUserName.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_SIP_AUTH_ID));
            }
            this.checkBoxVIP.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_VIP));
            this.checkBoxSIPRegisterCheck.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_SIP_REGISTER_CHECK));
            this.textFieldFixedSIPPort.setText(String.valueOf(ppUserDataRecord.getField(PpUserDataRecord.IDX_FIXED_SIP_PORT)));
            this.textFieldCalculatedSIPPort.setText(String.valueOf(ppUserDataRecord.getField(PpUserDataRecord.IDX_CALCULATED_SIP_PORT)));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.comboBoxAutoAnswer.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_AUTO_ANSWER).toString());
                this.comboBoxMicrophoneMute.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_MICROPHONE_MUTE).toString());
                this.comboBoxWarningTone.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_WARNING_TONE).toString());
                this.comboBoxAllowBargeIn.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_ALLOW_BARGE_IN).toString());
            }
            this.checkBoxSendingMessagesPermission.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_MSG_RIGHT));
            this.checkBoxSendingVcardsPermission.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_SEND_VCARD_RIGHT));
            this.checkBoxReceivingVcardsPermission.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_RECV_VCARD_RIGHT));
            this.checkBoxLocatingPermission.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_LOC_RIGHT));
            this.checkBoxTracking.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_TRACKING_ACTIVE));
            this.checkBoxDECTLocatable.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_LOCATABLE));
            this.textFieldSOSNumber.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_SOS_NUM));
            this.textFieldManDownNumber.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_MAN_DOWN_NUM));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.textFieldVoiceMailNumber.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_VOICEBOX_NUM));
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.checkBoxKeepPersonalDirectory.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_KEEP_LOCAL_PB));
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.checkBoxExternal.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_EXTERNAL));
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.checkBoxAllowVideoStream.setSelected((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM));
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.comboBoxMonitoringMode.setEditable(true);
                this.comboBoxMonitoringMode.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_MONITORING));
                this.comboBoxMonitoringMode.setEditable(false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.comboBoxConferenceServerType.setEditable(true);
                this.comboBoxConferenceServerType.setSelectedItem(ppUserDataRecord.getField(PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE));
                this.comboBoxConferenceServerType.setEditable(false);
                this.textFieldConferenceServerURI.setText((String)ppUserDataRecord.getField(PpUserDataRecord.IDX_CONFERENCE_SERVER_URI));
            }
            String string = null;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                string = (String)ppUserDataRecord.getField(PpUserDataRecord.IDX_PIN);
                if (string != null && string.length() > 0) {
                    this.passwordFieldPIN.setText(this.dummyPassword);
                } else {
                    this.passwordFieldPIN.setText("");
                }
            }
            if ((string = (String)ppUserDataRecord.getField(PpUserDataRecord.IDX_SIP_PW)) != null && string.length() > 0) {
                this.passwordFieldPassword.setText(this.dummyPassword);
                this.passwordFieldPasswordConfirm.setText(this.dummyPassword);
            } else {
                this.passwordFieldPassword.setText("");
                this.passwordFieldPasswordConfirm.setText("");
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                int n = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID);
                this.setPpProfile(n);
                if (((Boolean)ppUserDataRecord.getField(PpUserDataRecord.IDX_CONFIG_DATA_LOADED)).booleanValue()) {
                    this.labelConfigDataLoadedStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                } else {
                    this.labelConfigDataLoadedStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                }
            }
        } else {
            this.labelUser.setText("");
            this.textFieldName.setText("");
            this.textFieldNumber.setText("");
            this.textFieldAdditionalID.setText("");
            this.textFieldHierarchy1.setText("");
            this.textFieldHierarchy2.setText("");
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.passwordFieldPIN.setText("");
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.textFieldUserName.setText("");
            }
            this.passwordFieldPassword.setText("");
            this.checkBoxVIP.setSelected(false);
            this.checkBoxSIPRegisterCheck.setSelected(false);
            this.textFieldFixedSIPPort.setText("0");
            this.textFieldCalculatedSIPPort.setText("");
            this.checkBoxSendingMessagesPermission.setSelected(false);
            this.checkBoxSendingVcardsPermission.setSelected(false);
            this.checkBoxReceivingVcardsPermission.setSelected(false);
            this.checkBoxLocatingPermission.setSelected(false);
            this.checkBoxTracking.setSelected(false);
            this.checkBoxDECTLocatable.setSelected(false);
            this.textFieldSOSNumber.setText("");
            this.textFieldManDownNumber.setText("");
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.textFieldVoiceMailNumber.setText("");
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.checkBoxKeepPersonalDirectory.setSelected(false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.checkBoxExternal.setSelected(false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.checkBoxExternal.setSelected(false);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.comboBoxMonitoringMode.setSelectedIndex(0);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.comboBoxConferenceServerType.setSelectedIndex(0);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.labelConfigDataLoadedStatus.setIcon(null);
                this.setPpProfile(0);
            }
        }
    }

    @Override
    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            super.getButtonCancel();
            this.buttonCancel.setBounds(120, 25, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PpMonitorDetailPanel.this.ppMainPanel != null) {
                        PpMonitorDetailPanel.this.ppMainPanel.removePpDetailPanel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }
}

