/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.pp.PpActivityLogFile;
import com.aastra.oamp.pp.PpMonitorDetailPanel;
import com.aastra.oamp.pp.PpMonitorTaskPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataHandler;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;

public class PpMonitorMainPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static boolean ppDevMonitoringState = false;
    private OmiMessage.PermissionType[] permissionArray = null;
    private GuiUtilDetailSplitPanel ppDetailSplitPane = null;
    private AastraScrollPane ppTablePane = null;
    private PpMonitorDetailPanel ppDetailPanel = null;
    private PpMonitorTaskPanel ppTaskPanel = null;
    private GuiUtilConfiguratorTable ppTable = null;
    private int currentPpn = -1;
    private int currentUid = -1;
    private PpDataHandler ppDataHandler = null;
    private NotificationHandlerClass ppUserHandler = null;
    private NotificationHandlerClass ppDevHandler = null;
    private int dividerLocation = 0;
    private boolean ppTableMonitorIdxArrayChecked = false;
    private boolean ppTableMonitorIdxArrayDefaultChecked = false;
    private boolean tableActive = false;
    private boolean componentActive = false;
    private OmiManagement omiManagement = null;
    private int[] ppTableMonitorIdxArrayDefault = new int[]{PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), PpUserDataRecord.IDX_NUM, PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_FW_VERSION)};
    private int[] ppTableMonitorIdxArray = new int[]{PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_TIME_STAMP), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AC), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_HW_TYPE), PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AUTO_CREATE), PpUserDataRecord.IDX_NAME, PpUserDataRecord.IDX_NUM, PpUserDataRecord.IDX_HIERARCHY1, PpUserDataRecord.IDX_HIERARCHY2, PpUserDataRecord.IDX_ADD_ID, PpUserDataRecord.IDX_SOS_NUM, PpUserDataRecord.IDX_MAN_DOWN_NUM, PpUserDataRecord.IDX_MSG_RIGHT, PpUserDataRecord.IDX_SEND_VCARD_RIGHT, PpUserDataRecord.IDX_RECV_VCARD_RIGHT, PpUserDataRecord.IDX_TRACKING_ACTIVE, PpUserDataRecord.IDX_LOCATABLE, PpUserDataRecord.IDX_LOC_RIGHT, PpUserDataRecord.IDX_VIP, PpUserDataRecord.IDX_SIP_REGISTER_CHECK, PpUserDataRecord.IDX_FIXED_SIP_PORT, PpUserDataRecord.IDX_CALCULATED_SIP_PORT};

    public PpMonitorMainPanel(PpDataHandler ppDataHandler) {
        this.ppDataHandler = ppDataHandler;
        this.ppUserHandler = new NotificationHandlerClass();
        this.ppUserHandler.notificationType = NotificationTypeEnum.USER_NOTIFICATION;
        this.ppDataHandler.registerUserDataNotificationListener(this.ppUserHandler);
        this.ppDevHandler = new NotificationHandlerClass();
        this.ppDevHandler.notificationType = NotificationTypeEnum.DEVICE_NOTIFICATION;
        this.ppDataHandler.registerDevDataNotificationListener(this.ppDevHandler);
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.permissionArray = this.omiManagement.getOmmPermissions();
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.ppDataHandler.subscribeEventPPDevState();
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.ppDataHandler.subscribeEventPPSipState();
            }
        }
        this.initialize();
    }

    public void deregisterNotificationListener() {
        this.ppDataHandler.deregisterUserDataNotificationListener(this.ppUserHandler);
        this.ppDataHandler.deregisterDevDataNotificationListener(this.ppDevHandler);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPpDetailSplitPane(), "Center");
        this.add((Component)this.getPpTaskPanel(), "East");
    }

    private int[] getPpTableMonitorIdxArrayDefault() {
        if (!this.ppTableMonitorIdxArrayDefaultChecked) {
            this.ppTableMonitorIdxArrayDefaultChecked = true;
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                int[] nArray = Arrays.copyOf(this.ppTableMonitorIdxArrayDefault, this.ppTableMonitorIdxArrayDefault.length + 5);
                this.ppTableMonitorIdxArrayDefault = nArray;
                this.ppTableMonitorIdxArrayDefault[this.ppTableMonitorIdxArrayDefault.length - 5] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LAST_ACTION_TIME);
                this.ppTableMonitorIdxArrayDefault[this.ppTableMonitorIdxArrayDefault.length - 4] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP);
                this.ppTableMonitorIdxArrayDefault[this.ppTableMonitorIdxArrayDefault.length - 3] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE);
                this.ppTableMonitorIdxArrayDefault[this.ppTableMonitorIdxArrayDefault.length - 2] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE);
                this.ppTableMonitorIdxArrayDefault[this.ppTableMonitorIdxArrayDefault.length - 1] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ACTIVITIES);
            }
        }
        return this.ppTableMonitorIdxArrayDefault;
    }

    public int[] getPpTableMonitorIdxArray() {
        int n = 0;
        int n2 = this.ppTableMonitorIdxArray.length;
        if (!this.ppTableMonitorIdxArrayChecked) {
            this.ppTableMonitorIdxArrayChecked = true;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                n += 3;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                n += 11;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                n += 8;
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                n = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP) ? (n += 12) : (n += 8);
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                ++n;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                n += 3;
            }
            if (n > 0) {
                int[] nArray = Arrays.copyOf(this.ppTableMonitorIdxArray, this.ppTableMonitorIdxArray.length + n);
                this.ppTableMonitorIdxArray = nArray;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVoiceboxNumber)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_VOICEBOX_NUM;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_UID;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_REL_TYPE;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_KEEP_LOCAL_PB;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveExternalUserData)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_EXTERNAL;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_SIP_AUTH_ID;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_FORWARD_STATE;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_FORWARD_TIME;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_FORWARD_DEST;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_LANG;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_HOLD_RING_BACK_TIME;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_CALL_WAITING_DISABLED;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_AUTO_ANSWER;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_MICROPHONE_MUTE;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_WARNING_TONE;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_ALLOW_BARGE_IN;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_CONFERENCE_SERVER_TYPE;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_OMM_ID);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_OMM_ID_ACK);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ROAMING_STATE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MODIC_TYPE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LOCATION_DATA);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_DECT_IE_FIXED_ID);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIPTION_ID);
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_SW_VERSION);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LAST_ACTION_TIME);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SS_ACTIVE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_COMS_ACTIVE);
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ACTIVITIES);
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED);
                    this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_TYPE);
                    this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR);
                    this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_PORT);
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_MONITORING;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_CONFIG_DATA_PROFILE_ID;
                this.ppTableMonitorIdxArray[n2++] = PpUserDataRecord.IDX_CONFIG_DATA_LOADED;
                this.ppTableMonitorIdxArray[n2++] = PpDataRecord.devDataIdx(PpDevDataRecord.IDX_DEF_PROFILE_LOADED);
            }
        }
        return this.ppTableMonitorIdxArray;
    }

    public void processDevStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device status event: " + ppEventEnum.toString() + ",ppn=" + n + ",rfpId=" + n2);
        if (PpActivityLogFile.IsLogActive()) {
            PpActivityLogFile.writeLog(ppEventEnum, n, n2);
        }
    }

    void processUserDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP user notification: " + dataNotificationEnum.toString() + ",uid=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.checkPpTransactionStart();
                break;
            }
            case DATA_CHANGED: {
                Object object;
                if (this.currentUid != n) break;
                PpUserDataRecord ppUserDataRecord = this.ppDataHandler.getPpUserData(n);
                PpDevDataRecord ppDevDataRecord = null;
                if (ppUserDataRecord != null && (object = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_PPN)) != null) {
                    ppDevDataRecord = this.ppDataHandler.getPpDevData((Integer)object);
                }
                object = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                this.createPpDetailPanel((DataRecord)object);
                break;
            }
        }
    }

    void processDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP device notification: " + dataNotificationEnum.toString() + ",ppn=" + n);
        switch (dataNotificationEnum) {
            case DATA_CHANGED: {
                if (this.currentPpn != n) break;
                PpDevDataRecord ppDevDataRecord = this.ppDataHandler.getPpDevData(n);
                PpUserDataRecord ppUserDataRecord = null;
                if (ppDevDataRecord != null) {
                    Integer n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_UID);
                    OmiMessage.PPRelTypeType pPRelTypeType = (OmiMessage.PPRelTypeType)((Object)ppDevDataRecord.getField(PpDevDataRecord.IDX_REL_TYPE));
                    if (pPRelTypeType == OmiMessage.PPRelTypeType.Unbound) {
                        this.removePpDetailPanel();
                        break;
                    }
                    if (n2 != null) {
                        ppUserDataRecord = this.ppDataHandler.getPpUserData(n2);
                    }
                    PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                    this.createPpDetailPanel(ppDataRecord);
                    break;
                }
                PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
                this.createPpDetailPanel(ppDataRecord);
                break;
            }
        }
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createPpDetailPanel(dataRecord);
            } else {
                this.removePpDetailPanel();
            }
        } else if (this.ppTable.getSelectedRowCount() == 1) {
            this.ppTaskPanel.setTaskButtonShowDetails(true);
        } else {
            this.ppTaskPanel.setTaskButtonShowDetails(false);
        }
    }

    public void showPpDetails() {
        int n = this.ppTable.getSelectedRow();
        if (n >= 0) {
            int n2 = this.ppTable.convertRowIndexToModel(n);
            PpDataRecord ppDataRecord = this.ppDataHandler.getDatabase().getRecordByIdx(n2);
            if (ppDataRecord != null) {
                this.createPpDetailPanel(ppDataRecord);
            }
        }
    }

    private GuiUtilDetailSplitPanel getPpDetailSplitPane() {
        if (this.ppDetailSplitPane == null) {
            this.ppDetailSplitPane = new GuiUtilDetailSplitPanel(390);
            this.ppDetailSplitPane.setTopComponent(this.getPpTablePane());
            this.ppDetailSplitPane.setBottomComponent(null);
        }
        return this.ppDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getPpTable() {
        if (this.ppTable == null) {
            this.ppTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.ppDataHandler.getDatabase(), this.getPpTableMonitorIdxArray(), this.getActivePpMonitorColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpMonitor, 0);
            this.ppTable.setIconArray(PpUserDataRecord.IDX_CALL_WAITING_DISABLED, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_EXTERNAL, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_MSG_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_SEND_VCARD_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_RECV_VCARD_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_ALLOW_VIDEO_STREAM, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_TRACKING_ACTIVE, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_LOCATABLE, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_LOC_RIGHT, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_KEEP_LOCAL_PB, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_VIP, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpUserDataRecord.IDX_SIP_REGISTER_CHECK, GuiUtilIcon.getIconArrayInactiveActive());
            this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ENCRYPT), GuiUtilIcon.getIconArrayErrorActive());
            this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), GuiUtilIcon.getIconArrayErrorErrorActive());
            this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_AUTO_CREATE), GuiUtilIcon.getIconArrayInactiveActive());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUserDeviceSync)) {
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBE_TO_PARI_ONLY), GuiUtilIcon.getIconArrayInactiveActive());
            }
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE), GuiUtilIcon.getIconArraySpacerActive());
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SS_ACTIVE), GuiUtilIcon.getIconArraySpacerActive());
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE), GuiUtilIcon.getIconArraySpacerActive());
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_COMS_ACTIVE), GuiUtilIcon.getIconArraySpacerActive());
                if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSIP)) {
                    this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED), GuiUtilIcon.getIconArrayInactiveActive());
                    this.ppTable.setNegativeIntAsInvalid(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REG_SERVER_PORT));
                }
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveHCM)) {
                this.ppTable.setIconArray(PpUserDataRecord.IDX_CONFIG_DATA_LOADED, GuiUtilIcon.getIconArrayInactiveActive());
                this.ppTable.setIconArray(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_DEF_PROFILE_LOADED), GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.ppTable.setColumnFormatString(PpUserDataRecord.IDX_UID, "0x%03X");
            this.ppTable.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), "0x%03X");
            if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
                this.ppTable.setColumnFormatString(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP), "0x%03X");
                this.ppTable.setNegativeIntAsInvalid(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP));
            }
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_UID, 20);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_REL_TYPE, 35);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_EXTERNAL, 20);
            this.ppTable.setPreferredColumnWidth(PpUserDataRecord.IDX_NUM, 40);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_PPN), 20);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_IPEI), 55);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_CC_ACTIVE), 10);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SS_ACTIVE), 10);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_MM_ACTIVE), 10);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_COMS_ACTIVE), 10);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_ST_REGISTERED), 20);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_SUBSCRIBED), 23);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_RFP), 27);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_LAST_ACTION_TIME), 40);
            this.ppTable.setPreferredColumnWidth(PpDataRecord.devDataIdx(PpDevDataRecord.IDX_FW_VERSION), 25);
            this.ppTable.applyPreferredColumnWidthSettings();
        }
        return this.ppTable;
    }

    private AastraScrollPane getPpTablePane() {
        if (this.ppTablePane == null) {
            this.ppTablePane = new AastraScrollPane(this.getPpTable());
            this.dividerLocation = this.ppDetailSplitPane.getHeight() - 390;
            this.ppTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ppTablePane;
    }

    private void enableTableAccess() {
        this.ppTable.setActive(true);
        this.ppTaskPanel.setTaskButtonConfigureTable(true);
        this.ppTaskPanel.setTaskButtonFilter(true);
        this.ppTaskPanel.setTaskButtonActivateEventLog(true, null);
        this.tableActive = true;
    }

    private void disableTableAccess() {
        this.tableActive = false;
        this.ppTable.setActive(false);
        this.ppTaskPanel.setTaskButtonShowDetails(false);
        this.ppTaskPanel.setTaskButtonConfigureTable(false);
        this.ppTaskPanel.setTaskButtonFilter(false);
        this.ppTaskPanel.setTaskButtonActivateEventLog(false, null);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.ppTable, this.getPpTableMonitorIdxArray(), UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpMonitor));
        this.ppTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getPpDetailPanel() {
        if (this.ppDetailPanel == null) {
            this.ppDetailPanel = new PpMonitorDetailPanel(this, this.permissionArray);
        }
        return this.ppDetailPanel;
    }

    private AastraPanel getPpTaskPanel() {
        if (this.ppTaskPanel == null) {
            this.ppTaskPanel = new PpMonitorTaskPanel(this, this.ppTable);
        }
        return this.ppTaskPanel;
    }

    public void createPpDetailPanel(DataRecord dataRecord) {
        if (this.ppDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP monitor detail panel");
            this.ppDetailSplitPane.setBottomComponent(this.getPpDetailPanel());
            this.ppDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            PpDataRecord ppDataRecord = (PpDataRecord)dataRecord;
            PpUserDataRecord ppUserDataRecord = ppDataRecord.ppUser;
            PpDevDataRecord ppDevDataRecord = ppDataRecord.ppDev;
            Integer n = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP user[" + n + "]:");
            UtilPrint.printPpUserDataRecordString(ppUserDataRecord, this);
            Integer n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP device[" + n2 + "]:");
            UtilPrint.printPpDevDataRecordString(ppDevDataRecord, this);
            this.ppDetailPanel.setPpUserDetailData(ppUserDataRecord);
            this.ppDetailPanel.setPpDevDetailData(ppDevDataRecord);
            this.currentUid = n;
            this.currentPpn = n2;
        } else {
            this.ppDetailPanel.setPpUserDetailData(null);
            this.ppDetailPanel.setPpDevDetailData(null);
        }
        this.ppDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ppDetailSplitPane.validate();
        this.ppTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removePpDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing PP monitor detail panel");
        this.dividerLocation = this.ppDetailSplitPane.getDividerLocation();
        this.ppDetailSplitPane.setBottomComponent(null);
        this.currentUid = -1;
        this.currentPpn = -1;
        if (this.ppTable.getSelectedRowCount() == 1) {
            this.ppTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    private int[] getActivePpMonitorColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = this.getPpTableMonitorIdxArray();
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpMonitor);
        if (bitSet != null && !UtilPreferences.isMonitoringPermissionChanged() && !UtilPreferences.isOpenRespAttribsChanged()) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = nArray2[i];
            }
        } else {
            nArray = this.getPpTableMonitorIdxArrayDefault();
            bitSet = new BitSet();
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpMonitor, bitSet);
        }
        return nArray;
    }

    public static boolean getPPDevMonitoringState() {
        return ppDevMonitoringState;
    }

    public static void setPPDevMonitoringState(boolean bl) {
        ppDevMonitoringState = bl;
    }

    private void checkPpTransactionStart() {
        if ((UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring) || UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Locating)) && this.tableActive && this.componentActive && !PpMonitorMainPanel.getPPDevMonitoringState()) {
            PpMonitorMainPanel.setPPDevMonitoringState(true);
            this.ppDataHandler.subscribeEventPPTransaction();
            this.ppDataHandler.updateLastPpDevAction();
            this.ppDataHandler.updateActivePpDev();
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.componentActive = true;
        this.checkPpTransactionStart();
        this.ppTaskPanel.setTaskButtonActivateEventLog(null, PpActivityLogFile.IsLogActive());
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
        this.componentActive = false;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createPpDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    class NotificationHandlerClass
    implements PpDataNotificationInterface {
        public NotificationTypeEnum notificationType = NotificationTypeEnum.USER_NOTIFICATION;

        NotificationHandlerClass() {
        }

        @Override
        public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
            if (this.notificationType == NotificationTypeEnum.USER_NOTIFICATION) {
                PpMonitorMainPanel.this.processUserDataNotification(n, dataNotificationEnum);
            } else {
                PpMonitorMainPanel.this.processDevDataNotification(n, dataNotificationEnum);
            }
        }

        @Override
        public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        }

        @Override
        public void processStatusEvent(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
            PpMonitorMainPanel.this.processDevStatusEvent(n, n2, ppEventEnum, objectArray);
        }
    }

    private static enum NotificationTypeEnum {
        USER_NOTIFICATION,
        DEVICE_NOTIFICATION;

    }
}

