/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.pp.PpActivityLogFile;
import com.aastra.oamp.pp.PpMonitorMainPanel;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class PpMonitorTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private PpMonitorMainPanel ppMainPanel = null;
    private ConfiguratorTable ppTable = null;
    private AastraLinkButton buttonShowDetails = null;
    private AastraLinkButton buttonConfigurePpTable = null;
    private AastraLinkButton buttonActivatePpEventLog = null;
    private AastraLinkButton buttonFilterPpTable = null;
    private GuiUtilTableFilterDlg ppTableFilterDlg = null;

    public PpMonitorTaskPanel(PpMonitorMainPanel ppMonitorMainPanel, ConfiguratorTable configuratorTable) {
        this.ppMainPanel = ppMonitorMainPanel;
        this.ppTable = configuratorTable;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonShowDetails(), null);
        this.add((Component)this.getButtonFilterPpTable(), null);
        this.add((Component)this.getButtonActivatePpEventLog(), null);
        this.add((Component)this.getButtonConfigurePpTable(), null);
    }

    private AastraLinkButton getButtonShowDetails() {
        if (this.buttonShowDetails == null) {
            this.buttonShowDetails = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_DETAILS_20"));
            this.buttonShowDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpMonitorTaskPanel.this.ppMainPanel.showPpDetails();
                }
            });
        }
        return this.buttonShowDetails;
    }

    private AastraLinkButton getButtonFilterPpTable() {
        if (this.buttonFilterPpTable == null) {
            this.buttonFilterPpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterPpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpMonitorTaskPanel.this.getPpTableFilterDlg().setVisible(true);
                    PpMonitorTaskPanel.this.ppMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterPpTable;
    }

    private GuiUtilTableFilterDlg getPpTableFilterDlg() {
        if (this.ppTableFilterDlg == null) {
            this.ppTableFilterDlg = new GuiUtilTableFilterDlg(this.ppTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesPpMonitor);
        }
        return this.ppTableFilterDlg;
    }

    private AastraLinkButton getButtonActivatePpEventLog() {
        if (this.buttonActivatePpEventLog == null) {
            this.buttonActivatePpEventLog = this.createTaskButtonEnabled(UtilLocale.getString("TXT_LOG_EVENTS_20"), UtilLocale.getString("TXT_LOGGING_PP_DEVICE_ACTIVITY_EVENTS"), PpActivityLogFile.IsLogActive() ? GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall) : GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonActivatePpEventLog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PpActivityLogFile.IsLogActive()) {
                        PpMonitorTaskPanel.this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                        PpActivityLogFile.SetLog(false);
                    } else {
                        PpMonitorTaskPanel.this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                        PpActivityLogFile.SetLog(true);
                        GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_EVENTS_WILL_BE_WRITTEN_TO_*"), UtilFileHandling.getWorkingDirectory() + File.separator + "pp_event.log"));
                    }
                }
            });
        }
        return this.buttonActivatePpEventLog;
    }

    private AastraLinkButton getButtonConfigurePpTable() {
        if (this.buttonConfigurePpTable == null) {
            this.buttonConfigurePpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigurePpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(PpMonitorTaskPanel.this.ppTable, PpMonitorTaskPanel.this.ppMainPanel.getPpTableMonitorIdxArray(), UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectPpMonitor);
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonConfigurePpTable;
    }

    public void setTaskButtonShowDetails(boolean bl) {
        this.buttonShowDetails.setEnabled(bl);
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigurePpTable.setEnabled(bl);
    }

    public void setTaskButtonActivateEventLog(Boolean bl, Boolean bl2) {
        if (bl != null) {
            this.buttonActivatePpEventLog.setEnabled(bl);
        }
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonActivatePpEventLog.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterPpTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterPpTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterPpTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterPpTable.setToolTipText(string);
    }
}

