/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.pp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.pp.PpConfigTaskPanel;
import com.aastra.oamp.pp.PpDevConfigTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PpSubscriptionDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private PpConfigTaskPanel ppConfigTaskPanel = null;
    private PpDevConfigTaskPanel ppDevConfigTaskPanel = null;
    private AastraPanel panelSubscription = null;
    private AastraLabel labelTimeout = null;
    private AastraComboBox comboBoxTimeout = null;
    private AastraButton buttonStart = null;
    private AastraButton buttonStop = null;
    private AastraButton buttonCancel = null;
    private CommonDataHandler commonDataHandler = null;
    private CommonDataHandler.DECTSubscriptionMode dectSubscriptionMode = null;
    private UtilErrorComp utilErrorComp = null;

    public PpSubscriptionDlg(PpConfigTaskPanel ppConfigTaskPanel, CommonDataHandler commonDataHandler) {
        super(GuiMain.getGuiMainObject());
        this.ppConfigTaskPanel = ppConfigTaskPanel;
        this.commonDataHandler = commonDataHandler;
        this.initialize();
    }

    public PpSubscriptionDlg(PpDevConfigTaskPanel ppDevConfigTaskPanel, CommonDataHandler commonDataHandler) {
        super(GuiMain.getGuiMainObject());
        this.ppDevConfigTaskPanel = ppDevConfigTaskPanel;
        this.commonDataHandler = commonDataHandler;
        this.initialize();
    }

    private void initialize() {
        this.setSize(343, 154);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_WILDCARD_SUBSCRIPTION"));
        try {
            this.dectSubscriptionMode = (CommonDataHandler.DECTSubscriptionMode)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + this.dectSubscriptionMode.toString());
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + " failed");
            this.dectSubscriptionMode = null;
        }
        this.setContentPane(this.getPanelSubscription());
        this.utilErrorComp = new UtilErrorComp();
    }

    private AastraPanel getPanelSubscription() {
        if (this.panelSubscription == null) {
            this.labelTimeout = new AastraLabel();
            this.labelTimeout.setBounds(15, 15, 61, 31);
            this.labelTimeout.setText(UtilLocale.getString("TXT_TIMEOUT"));
            this.panelSubscription = new AastraPanel();
            this.panelSubscription.setLayout(null);
            this.panelSubscription.setSize(new Dimension(361, 196));
            this.panelSubscription.add((Component)this.labelTimeout, null);
            this.panelSubscription.add((Component)this.getComboBoxTimeout(), null);
            this.panelSubscription.add((Component)this.getButtonStart(), null);
            this.panelSubscription.add((Component)this.getButtonStop(), null);
            this.panelSubscription.add((Component)this.getButtonCancel(), null);
            this.getRootPane().setDefaultButton(this.getButtonStart());
        }
        return this.panelSubscription;
    }

    private AastraComboBox getComboBoxTimeout() {
        if (this.comboBoxTimeout == null) {
            Object[] objectArray = new String[]{"2 " + UtilLocale.getString("TXT_UNIT_MINUTE"), "10 " + UtilLocale.getString("TXT_UNIT_MINUTE"), "30 " + UtilLocale.getString("TXT_UNIT_MINUTE"), "1 " + UtilLocale.getString("TXT_UNIT_HOUR")};
            this.comboBoxTimeout = new AastraComboBox(objectArray);
            this.comboBoxTimeout.setBounds(90, 15, 70, 20);
            if (this.dectSubscriptionMode != null && this.dectSubscriptionMode.mode == OmiMessage.DECTSubscriptionModeType.Wildcard) {
                this.comboBoxTimeout.setEnabled(false);
            } else {
                this.comboBoxTimeout.setEnabled(true);
            }
        }
        return this.comboBoxTimeout;
    }

    public void markErrorComboBoxTimeout() {
        this.utilErrorComp.markComponent(this.comboBoxTimeout);
    }

    private AastraButton getButtonStart() {
        if (this.buttonStart == null) {
            this.buttonStart = new AastraButton();
            this.buttonStart.setText(UtilLocale.getString("TXT_START"));
            this.buttonStart.setBounds(15, 75, 90, 25);
            if (this.dectSubscriptionMode != null && this.dectSubscriptionMode.mode == OmiMessage.DECTSubscriptionModeType.Wildcard) {
                this.buttonStart.setEnabled(false);
            }
            this.buttonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                    dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Wildcard;
                    int n = PpSubscriptionDlg.this.comboBoxTimeout.getSelectedIndex();
                    switch (n) {
                        default: {
                            dECTSubscriptionMode.timeout = 2;
                            break;
                        }
                        case 1: {
                            dECTSubscriptionMode.timeout = 10;
                            break;
                        }
                        case 2: {
                            dECTSubscriptionMode.timeout = 30;
                            break;
                        }
                        case 3: {
                            dECTSubscriptionMode.timeout = 60;
                        }
                    }
                    if (PpSubscriptionDlg.this.ppConfigTaskPanel != null) {
                        PpSubscriptionDlg.this.ppConfigTaskPanel.changeSubscriptionMode(dECTSubscriptionMode);
                    }
                    if (PpSubscriptionDlg.this.ppDevConfigTaskPanel != null) {
                        PpSubscriptionDlg.this.ppDevConfigTaskPanel.changeSubscriptionMode(dECTSubscriptionMode);
                    }
                    PpSubscriptionDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonStart;
    }

    private AastraButton getButtonStop() {
        if (this.buttonStop == null) {
            this.buttonStop = new AastraButton();
            this.buttonStop.setText(UtilLocale.getString("TXT_STOP"));
            this.buttonStop.setBounds(120, 75, 90, 25);
            if (this.dectSubscriptionMode != null && this.dectSubscriptionMode.mode == OmiMessage.DECTSubscriptionModeType.Off) {
                this.buttonStop.setEnabled(false);
            }
            this.buttonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                    dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Off;
                    if (PpSubscriptionDlg.this.ppConfigTaskPanel != null) {
                        PpSubscriptionDlg.this.ppConfigTaskPanel.changeSubscriptionMode(dECTSubscriptionMode);
                    }
                    if (PpSubscriptionDlg.this.ppDevConfigTaskPanel != null) {
                        PpSubscriptionDlg.this.ppDevConfigTaskPanel.changeSubscriptionMode(dECTSubscriptionMode);
                    }
                    PpSubscriptionDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonStop;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.setBounds(225, 75, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PpSubscriptionDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }
}

