/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.RfpDatabase;
import com.aastra.style.AastraMenuItem;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraPopupMenu;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;

public class DevicePositionPanel
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private static final double MIN_ZOOM = 0.5;
    private static final double MAX_ZOOM = 2.0;
    private static final double ZOOM_STEP = 0.1;
    private static final int DEVICE_RADIUS = 15;
    static final BasicStroke arrowStroke = new BasicStroke(2.0f);
    private DevicePositionRecord showDeviceInfoBox = null;
    private int DragStartX;
    private int DragStartY;
    public int ShiftX = 0;
    public int ShiftY = 0;
    private double zoom = 1.0;
    protected AffineTransform aTransform = new AffineTransform();
    private boolean dragActive = false;
    private boolean deviceSelected = false;
    int noOfSelectedDevices = 0;
    private DevicePositionRecord firstSelectedDevice = null;
    DevicePositionRecord actDevice = null;
    protected boolean positionEditModeActive = false;
    protected BufferedImage img = null;
    private Point drawAreaP1 = new Point();
    private Point drawAreaP2 = new Point();
    DevicePositionIndexClass positionIdx = new DevicePositionIndexClass();
    protected static final int RFP_ATTRIB_POSITION_EDIT_SELECTION = 65536;
    protected AastraPopupMenu popupEdit = new AastraPopupMenu();
    private AastraMenuItem mItemMove = new AastraMenuItem(UtilLocale.getString("TXT_MOVE_SELECTED_RFPS"));
    private AastraMenuItem mItemResetSelection = new AastraMenuItem(UtilLocale.getString("TXT_RESET_SELECTION"));
    Point popupPosition = null;
    protected AffineTransform saveAT = null;

    public DevicePositionPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(627, 336);
        this.setLayout(new BorderLayout());
        this.popupEdit.add(this.mItemMove);
        this.popupEdit.add(this.mItemResetSelection);
        this.mItemMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicePositionPanel.this.noOfSelectedDevices != 0) {
                    DevicePositionRecord devicePositionRecord;
                    int n;
                    Point point = new Point();
                    try {
                        AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                        affineTransform.transform(DevicePositionPanel.this.popupPosition, point);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    int n2 = point.x - ((DevicePositionPanel)DevicePositionPanel.this).firstSelectedDevice.xm;
                    int n3 = point.y - ((DevicePositionPanel)DevicePositionPanel.this).firstSelectedDevice.ym;
                    int n4 = 0;
                    DevicePositionRecord[] devicePositionRecordArray = new DevicePositionRecord[DevicePositionPanel.this.noOfSelectedDevices];
                    for (n = 0; n < DevicePositionPanel.this.positionIdx.noOfRecords; ++n) {
                        devicePositionRecord = DevicePositionPanel.this.positionIdx.arr[n];
                        if (devicePositionRecord == null || (devicePositionRecord.attrib & 0x10000) == 0 || n4 >= DevicePositionPanel.this.noOfSelectedDevices) continue;
                        devicePositionRecordArray[n4++] = devicePositionRecord;
                    }
                    for (n = 0; n < n4; ++n) {
                        devicePositionRecord = devicePositionRecordArray[n];
                        int n5 = devicePositionRecord.xm + n2;
                        int n6 = devicePositionRecord.ym + n3;
                        if (n5 < 0) {
                            n5 = 0;
                        }
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        devicePositionRecord.newCoordinates(n5, n6);
                        devicePositionRecord.attrib &= 0xFFFEFFFF;
                        DevicePositionPanel.this.positionIdx.newCoordinates(devicePositionRecord.deviceType, devicePositionRecord.id);
                        DevicePositionPanel.this.setNewDevicePosition(devicePositionRecord);
                    }
                    DevicePositionPanel.this.noOfSelectedDevices = 0;
                    DevicePositionPanel.this.repaint();
                }
            }
        });
        this.mItemResetSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePositionPanel.this.positionIdx.removeDeviceAttributeBitFromAll(65536);
                DevicePositionPanel.this.noOfSelectedDevices = 0;
                DevicePositionPanel.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!DevicePositionPanel.this.dragActive) {
                    Point point = mouseEvent.getPoint();
                    try {
                        AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                        affineTransform.transform(point, point);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    DevicePositionPanel.this.actDevice = DevicePositionPanel.this.positionIdx.findDevice(point.x, point.y);
                    if (DevicePositionPanel.this.actDevice != null) {
                        if (DevicePositionPanel.this.showDeviceInfoBox != DevicePositionPanel.this.actDevice) {
                            DevicePositionPanel.this.showDeviceInfoBox = DevicePositionPanel.this.actDevice;
                            DevicePositionPanel.this.mouseMovedToDevice(DevicePositionPanel.this.actDevice);
                        }
                    } else if (DevicePositionPanel.this.showDeviceInfoBox != null) {
                        DevicePositionPanel.this.showDeviceInfoBox = null;
                        DevicePositionPanel.this.mouseMovedToDevice(null);
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (DevicePositionPanel.this.dragActive) {
                    Point point = mouseEvent.getPoint();
                    if (DevicePositionPanel.this.deviceSelected) {
                        if (point.x < 0) {
                            point.x = 0;
                        }
                        if (point.y < 0) {
                            point.y = 0;
                        }
                        try {
                            AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                            affineTransform.transform(point, point);
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            noninvertibleTransformException.printStackTrace();
                        }
                        if (point.x >= 0 && point.y >= 0) {
                            DevicePositionPanel.this.actDevice.newCoordinates(point.x, point.y);
                            DevicePositionPanel.this.repaint();
                        }
                    } else {
                        int n = point.x - DevicePositionPanel.this.DragStartX;
                        int n2 = point.y - DevicePositionPanel.this.DragStartY;
                        DevicePositionPanel.this.ShiftX += n;
                        DevicePositionPanel.this.ShiftY += n2;
                        if (DevicePositionPanel.this.ShiftX > 20) {
                            DevicePositionPanel.this.ShiftX = 20;
                        }
                        if (DevicePositionPanel.this.ShiftY > 20) {
                            DevicePositionPanel.this.ShiftY = 20;
                        }
                        DevicePositionPanel.this.DragStartX = point.x;
                        DevicePositionPanel.this.DragStartY = point.y;
                        DevicePositionPanel.this.aTransform.setToIdentity();
                        DevicePositionPanel.this.aTransform.scale(DevicePositionPanel.this.zoom, DevicePositionPanel.this.zoom);
                        DevicePositionPanel.this.aTransform.translate((double)DevicePositionPanel.this.ShiftX * 1.0 / DevicePositionPanel.this.zoom, (double)DevicePositionPanel.this.ShiftY * 1.0 / DevicePositionPanel.this.zoom);
                        DevicePositionPanel.this.repaint();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (DevicePositionPanel.this.deviceSelected) {
                    if (DevicePositionPanel.this.dragActive && DevicePositionPanel.this.actDevice != null) {
                        DevicePositionPanel.this.positionIdx.newCoordinates(DevicePositionPanel.this.actDevice.deviceType, DevicePositionPanel.this.actDevice.id);
                        DevicePositionPanel.this.setNewDevicePosition(DevicePositionPanel.this.actDevice);
                    }
                    DevicePositionPanel.this.deviceSelected = false;
                }
                DevicePositionPanel.this.dragActive = false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getButton();
                Point point = mouseEvent.getPoint();
                if (n == 1) {
                    DevicePositionPanel.this.DragStartX = point.x;
                    DevicePositionPanel.this.DragStartY = point.y;
                    DevicePositionPanel.this.dragActive = true;
                }
                if (DevicePositionPanel.this.positionEditModeActive) {
                    if (n == 1) {
                        try {
                            AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                            affineTransform.transform(point, point);
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            noninvertibleTransformException.printStackTrace();
                        }
                        DevicePositionPanel.this.actDevice = DevicePositionPanel.this.positionIdx.findDevice(point.x, point.y);
                        if (DevicePositionPanel.this.actDevice != null) {
                            DevicePositionPanel.this.deviceSelected = true;
                            if ((DevicePositionPanel.this.actDevice.attrib & 0x10000) == 0) {
                                DevicePositionPanel.this.actDevice.attrib |= 0x10000;
                                ++DevicePositionPanel.this.noOfSelectedDevices;
                                if (DevicePositionPanel.this.noOfSelectedDevices == 1) {
                                    DevicePositionPanel.this.firstSelectedDevice = DevicePositionPanel.this.actDevice;
                                }
                            } else {
                                DevicePositionPanel.this.actDevice.attrib &= 0xFFFEFFFF;
                                if (DevicePositionPanel.this.noOfSelectedDevices > 0) {
                                    --DevicePositionPanel.this.noOfSelectedDevices;
                                }
                            }
                            DevicePositionPanel.this.repaint();
                        } else {
                            DevicePositionPanel.this.deviceSelected = false;
                        }
                    } else if (n == 3) {
                        DevicePositionPanel.this.popupPosition = point;
                        DevicePositionPanel.this.modifyEditMenu();
                        DevicePositionPanel.this.popupEdit.show(mouseEvent.getComponent(), point.x, point.y);
                    }
                } else if (n == 3) {
                    int n2 = point.x;
                    int n3 = point.y;
                    try {
                        AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                        affineTransform.transform(point, point);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        noninvertibleTransformException.printStackTrace();
                    }
                    DevicePositionPanel.this.actDevice = DevicePositionPanel.this.positionIdx.findDevice(point.x, point.y);
                    if (DevicePositionPanel.this.actDevice != null) {
                        DevicePositionPanel.this.handleRightClickOnDevice(DevicePositionPanel.this.actDevice, mouseEvent.getComponent(), n2, n3);
                    }
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Point point = mouseWheelEvent.getPoint();
                int n = mouseWheelEvent.getWheelRotation();
                double d = DevicePositionPanel.this.zoom;
                if (n < 0) {
                    if (DevicePositionPanel.this.zoom > 0.5) {
                        DevicePositionPanel.this.zoom -= 0.1;
                    }
                } else if (n > 0 && DevicePositionPanel.this.zoom < 2.0) {
                    DevicePositionPanel.this.zoom += 0.1;
                }
                if (DevicePositionPanel.this.zoom != d) {
                    Point point2 = new Point();
                    try {
                        AffineTransform affineTransform = DevicePositionPanel.this.aTransform.createInverse();
                        affineTransform.transform(point, point2);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        noninvertibleTransformException.printStackTrace();
                    }
                    double d2 = DevicePositionPanel.this.zoom - d;
                    int n2 = (int)((double)point2.x * d2);
                    int n3 = (int)((double)point2.y * d2);
                    DevicePositionPanel.this.ShiftX -= n2;
                    DevicePositionPanel.this.ShiftY -= n3;
                    if (DevicePositionPanel.this.ShiftX > 0) {
                        DevicePositionPanel.this.ShiftX = 0;
                    }
                    if (DevicePositionPanel.this.ShiftY > 0) {
                        DevicePositionPanel.this.ShiftY = 0;
                    }
                    DevicePositionPanel.this.aTransform.setToIdentity();
                    DevicePositionPanel.this.aTransform.scale(DevicePositionPanel.this.zoom, DevicePositionPanel.this.zoom);
                    DevicePositionPanel.this.aTransform.translate((double)DevicePositionPanel.this.ShiftX * 1.0 / DevicePositionPanel.this.zoom, (double)DevicePositionPanel.this.ShiftY * 1.0 / DevicePositionPanel.this.zoom);
                    DevicePositionPanel.this.repaint();
                }
            }
        });
    }

    protected void handleRightClickOnDevice(DevicePositionRecord devicePositionRecord, Component component, int n, int n2) {
    }

    protected void deviceSelectedByLeftMouseButton(DevicePositionRecord devicePositionRecord) {
    }

    protected void setNewDevicePosition(DevicePositionRecord devicePositionRecord) {
    }

    protected void mouseMovedToDevice(DevicePositionRecord devicePositionRecord) {
    }

    protected void modifyEditMenu() {
        if (this.noOfSelectedDevices == 0) {
            this.mItemResetSelection.setEnabled(false);
            this.mItemMove.setEnabled(false);
        } else {
            this.mItemResetSelection.setEnabled(true);
            this.mItemMove.setEnabled(true);
        }
    }

    public void resetZoomAndShift() {
        this.ShiftX = 0;
        this.ShiftY = 0;
        this.zoom = 1.0;
        this.aTransform.setToIdentity();
        this.repaint();
    }

    protected void paintDevice(Graphics2D graphics2D, int n, DevicePositionRecord devicePositionRecord) {
    }

    private void paintDevices(Graphics2D graphics2D) {
        for (int i = 0; i < this.positionIdx.getNoOfDevices(); ++i) {
            DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceByIndex(i);
            if (devicePositionRecord == null || !this.isPointInDrawingArea(devicePositionRecord.xm, devicePositionRecord.ym)) continue;
            this.paintDevice(graphics2D, (int)this.zoom, devicePositionRecord);
        }
    }

    protected relGraphicData calcCoordinates(relGraphicData relGraphicData2, boolean bl) {
        double d;
        double d2;
        int n = relGraphicData2.x2 - relGraphicData2.x1;
        int n2 = relGraphicData2.y2 - relGraphicData2.y1;
        if (n == 0 && n2 == 0) {
            d2 = 1.0;
            d = 0.0;
        } else {
            double d3 = Math.sqrt(n * n + n2 * n2);
            d2 = (double)n / d3;
            d = (double)n2 / d3;
        }
        relGraphicData2.sx = relGraphicData2.x1 + (int)(17.0 * d2);
        relGraphicData2.sy = relGraphicData2.y1 + (int)(17.0 * d);
        relGraphicData2.ex = relGraphicData2.x2 - (int)(17.0 * d2);
        relGraphicData2.ey = relGraphicData2.y2 - (int)(17.0 * d);
        int n3 = (int)(2.0 * d + 0.5);
        int n4 = (int)(2.0 * d2 + 0.5);
        relGraphicData2.sx += n3;
        relGraphicData2.sy -= n4;
        relGraphicData2.ex += n3;
        relGraphicData2.ey -= n4;
        relGraphicData2.arrowX[0] = relGraphicData2.ex;
        relGraphicData2.arrowY[0] = relGraphicData2.ey;
        relGraphicData2.arrowX[1] = relGraphicData2.arrowX[0] - (int)(13.0 * d2 + 0.5);
        relGraphicData2.arrowY[1] = relGraphicData2.arrowY[0] - (int)(13.0 * d + 0.5);
        relGraphicData2.arrowX[2] = relGraphicData2.arrowX[1] + (int)(7.0 * d + 0.5);
        relGraphicData2.arrowY[2] = relGraphicData2.arrowY[1] - (int)(7.0 * d2 + 0.5);
        return relGraphicData2;
    }

    protected void paintRelationArrow(Graphics2D graphics2D, relGraphicData relGraphicData2) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(arrowStroke);
        graphics2D.setColor(relGraphicData2.col);
        graphics2D.drawLine(relGraphicData2.sx, relGraphicData2.sy, relGraphicData2.ex, relGraphicData2.ey);
        graphics2D.setStroke(stroke);
        graphics2D.fillPolygon(relGraphicData2.arrowX, relGraphicData2.arrowY, 3);
    }

    protected boolean isPointInDrawingArea(int n, int n2) {
        return n >= this.drawAreaP1.x && n <= this.drawAreaP2.x && n2 >= this.drawAreaP1.y && n2 <= this.drawAreaP2.y;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.saveAT = graphics2D.getTransform();
        graphics2D.transform(this.aTransform);
        try {
            AffineTransform affineTransform = this.aTransform.createInverse();
            this.drawAreaP1.x = 0;
            this.drawAreaP1.y = 0;
            affineTransform.transform(this.drawAreaP1, this.drawAreaP1);
            this.drawAreaP2.x = this.getWidth();
            this.drawAreaP2.y = this.getHeight();
            affineTransform.transform(this.drawAreaP2, this.drawAreaP2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.paintBackground(graphics2D);
        this.paint0Cross(graphics2D);
        this.paintDevices(graphics2D);
        this.paintAdditionalElements(graphics2D);
    }

    protected void paintBackground(Graphics2D graphics2D) {
        if (this.img != null) {
            graphics2D.drawImage((Image)this.img, 0, 0, null);
        }
    }

    protected void paintAdditionalElements(Graphics2D graphics2D) {
    }

    public void paint0Cross(Graphics2D graphics2D) {
        graphics2D.drawLine(10, 0, 10, 50);
        graphics2D.drawLine(0, 10, 50, 10);
    }

    protected static String getFileSuffix(String string) {
        String string2 = null;
        if (string != null) {
            string2 = "";
            if (string.lastIndexOf(46) != -1 && (string2 = string.substring(string.lastIndexOf(46))).startsWith(".")) {
                string2 = string2.substring(1);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageDim(String string) {
        Dimension dimension = null;
        String string2 = DevicePositionPanel.getFileSuffix(string);
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string2);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                FileImageInputStream fileImageInputStream = new FileImageInputStream(new File(string));
                imageReader.setInput(fileImageInputStream);
                int n = imageReader.getWidth(imageReader.getMinIndex());
                int n2 = imageReader.getHeight(imageReader.getMinIndex());
                dimension = new Dimension(n, n2);
            }
            catch (IOException iOException) {
            }
            finally {
                imageReader.dispose();
            }
        }
        return dimension;
    }

    public boolean setBackgroundImage(String string) {
        if (string == null) {
            this.img = null;
            return true;
        }
        try {
            this.img = ImageIO.read(new File(string));
            this.repaint();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPositionEditMode(boolean bl) {
        this.positionEditModeActive = bl;
        if (!this.positionEditModeActive) {
            this.positionIdx.removeDeviceAttributeBitFromAll(65536);
            this.noOfSelectedDevices = 0;
            this.firstSelectedDevice = null;
            this.repaint();
        } else {
            this.noOfSelectedDevices = 0;
            this.firstSelectedDevice = null;
        }
    }

    class relGraphicData {
        int x1;
        int y1;
        int x2;
        int y2;
        int sx;
        int sy;
        int ex;
        int ey;
        int[] arrowX = new int[3];
        int[] arrowY = new int[3];
        Color col;

        relGraphicData() {
        }
    }

    class DevicePositionIndexClass {
        private int maxNoOfRfp = RfpDatabase.maxRfp;
        private int maxNoOfBt = 1000;
        DevicePositionRecord[] arr = null;
        int noOfRecords;
        IndexArrayClass[] idxArr = new IndexArrayClass[DeviceType.values().length];

        public DevicePositionIndexClass() {
            this.arr = new DevicePositionRecord[this.maxNoOfRfp + this.maxNoOfBt];
            this.idxArr[DeviceType.RFP.ordinal()] = new IndexArrayClass(this.maxNoOfRfp);
            this.idxArr[DeviceType.BLUETOOTH.ordinal()] = new IndexArrayClass(this.maxNoOfBt);
            this.idxArr[DeviceType.CORNER.ordinal()] = new IndexArrayClass(4);
            this.idxArr[DeviceType.MOVEPOINT.ordinal()] = new IndexArrayClass(1);
            this.clear();
        }

        public DevicePositionIndexClass(int n) {
            this.maxNoOfRfp = n;
            this.maxNoOfBt = 0;
            this.arr = new DevicePositionRecord[this.maxNoOfRfp];
            this.idxArr[DeviceType.RFP.ordinal()] = new IndexArrayClass(this.maxNoOfRfp);
            this.clear();
        }

        public DevicePositionIndexClass(int n, int n2) {
            this.maxNoOfRfp = n;
            this.maxNoOfBt = n2;
            this.maxNoOfBt = 0;
            this.arr = new DevicePositionRecord[this.maxNoOfRfp + n2];
            this.idxArr[DeviceType.RFP.ordinal()] = new IndexArrayClass(this.maxNoOfRfp);
            this.idxArr[DeviceType.BLUETOOTH.ordinal()] = new IndexArrayClass(this.maxNoOfBt);
            this.idxArr[DeviceType.CORNER.ordinal()] = new IndexArrayClass(4);
            this.idxArr[DeviceType.MOVEPOINT.ordinal()] = new IndexArrayClass(1);
            this.clear();
        }

        public int getNoOfDevices() {
            return this.noOfRecords;
        }

        public DevicePositionRecord getDeviceByIndex(int n) {
            if (n >= 0 && n < this.noOfRecords) {
                return this.arr[n];
            }
            return null;
        }

        public DevicePositionRecord getDeviceById(DeviceType deviceType, int n) {
            if (deviceType == null) {
                return null;
            }
            IndexArrayClass indexArrayClass = this.idxArr[deviceType.ordinal()];
            if (n >= 0 && n < indexArrayClass.size && indexArrayClass.idxArr[n] >= 0 && indexArrayClass.idxArr[n] < this.arr.length) {
                return this.arr[indexArrayClass.idxArr[n]];
            }
            return null;
        }

        public void setDeviceAttribute(DeviceType deviceType, int n, int n2) {
            DevicePositionRecord devicePositionRecord = this.getDeviceById(deviceType, n);
            if (devicePositionRecord != null) {
                devicePositionRecord.attrib = n2;
            }
        }

        public void addDeviceAttributeBit(DeviceType deviceType, int n, int n2) {
            DevicePositionRecord devicePositionRecord = this.getDeviceById(deviceType, n);
            if (devicePositionRecord != null) {
                devicePositionRecord.attrib |= n2;
            }
        }

        public void removeDeviceAttributeBit(DeviceType deviceType, int n, int n2) {
            DevicePositionRecord devicePositionRecord = this.getDeviceById(deviceType, n);
            if (devicePositionRecord != null) {
                devicePositionRecord.attrib &= ~n2;
            }
        }

        public void removeDeviceAttributeBitFromAll(int n) {
            for (int i = 0; i < this.noOfRecords; ++i) {
                DevicePositionRecord devicePositionRecord = this.arr[i];
                if (devicePositionRecord == null) continue;
                devicePositionRecord.attrib &= ~n;
            }
        }

        public int getDeviceAttributeById(DeviceType deviceType, int n) {
            DevicePositionRecord devicePositionRecord = this.getDeviceById(deviceType, n);
            if (devicePositionRecord != null) {
                return devicePositionRecord.attrib;
            }
            return 0;
        }

        private int binaryXPositionSearch(int n) {
            int n2 = 0;
            int n3 = this.noOfRecords;
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                DevicePositionRecord devicePositionRecord = this.arr[n4];
                if (devicePositionRecord.compareToDeviceXPosition(n) < 0) {
                    n3 = n4;
                    continue;
                }
                if (devicePositionRecord.compareToDeviceXPosition(n) > 0) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return -n2;
        }

        private int binaryXRangeSearch(int n) {
            int n2 = 0;
            int n3 = this.noOfRecords;
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                DevicePositionRecord devicePositionRecord = this.arr[n4];
                if (devicePositionRecord.compareToDeviceXRange(n) < 0) {
                    n3 = n4;
                    continue;
                }
                if (devicePositionRecord.compareToDeviceXRange(n) > 0) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return -1;
        }

        public DevicePositionRecord addDevice(DeviceType deviceType, int n, int n2, int n3) {
            if (deviceType == null) {
                return null;
            }
            IndexArrayClass indexArrayClass = this.idxArr[deviceType.ordinal()];
            if (indexArrayClass == null) {
                return null;
            }
            if (n >= 0 && n < indexArrayClass.size) {
                if (indexArrayClass.idxArr[n] >= 0 && indexArrayClass.idxArr[n] < indexArrayClass.idxArr.length) {
                    return this.arr[indexArrayClass.idxArr[n]];
                }
            } else {
                return null;
            }
            if (this.noOfRecords == 0) {
                this.arr[0] = new DevicePositionRecord(n, n2, n3, deviceType);
                indexArrayClass.idxArr[n] = 0;
                this.noOfRecords = 1;
                return this.arr[0];
            }
            int n4 = this.binaryXPositionSearch(n2);
            if (n4 < 0) {
                n4 *= -1;
            }
            for (int i = this.noOfRecords; i > n4; --i) {
                this.arr[i] = this.arr[i - 1];
                this.idxArr[this.arr[i].deviceType.ordinal()].idxArr[this.arr[i].id] = i;
            }
            this.arr[n4] = new DevicePositionRecord(n, n2, n3, deviceType);
            indexArrayClass.idxArr[n] = n4;
            ++this.noOfRecords;
            return this.arr[n4];
        }

        public void newCoordinates(DeviceType deviceType, int n) {
            int n2;
            int n3;
            if (deviceType == null) {
                return;
            }
            IndexArrayClass indexArrayClass = this.idxArr[deviceType.ordinal()];
            if (indexArrayClass == null) {
                return;
            }
            if (n < 0 || n >= indexArrayClass.size) {
                return;
            }
            int n4 = n3 = indexArrayClass.idxArr[n];
            DevicePositionRecord devicePositionRecord = this.arr[n3];
            if (devicePositionRecord.xm > this.arr[this.noOfRecords - 1].xm) {
                n4 = this.noOfRecords - 1;
            } else {
                for (n2 = 0; n2 < this.noOfRecords; ++n2) {
                    n4 = n2;
                    if (n2 != n3 && this.arr[n2].xm > devicePositionRecord.xm) break;
                }
                if (n3 < n4) {
                    --n4;
                }
            }
            if (n4 > n3) {
                n2 = n3;
                while (n2 < n4) {
                    DevicePositionRecord devicePositionRecord2;
                    this.arr[n2] = devicePositionRecord2 = this.arr[n2 + 1];
                    this.idxArr[devicePositionRecord2.deviceType.ordinal()].idxArr[devicePositionRecord2.id] = n2++;
                }
                this.arr[n4] = devicePositionRecord;
                this.idxArr[devicePositionRecord.deviceType.ordinal()].idxArr[devicePositionRecord.id] = n4;
            } else if (n4 < n3) {
                n2 = n3;
                while (n2 > n4) {
                    DevicePositionRecord devicePositionRecord3;
                    this.arr[n2] = devicePositionRecord3 = this.arr[n2 - 1];
                    this.idxArr[devicePositionRecord3.deviceType.ordinal()].idxArr[devicePositionRecord3.id] = n2--;
                }
                this.arr[n4] = devicePositionRecord;
                this.idxArr[devicePositionRecord.deviceType.ordinal()].idxArr[devicePositionRecord.id] = n4;
            }
        }

        public void removeDevice(DeviceType deviceType, int n) {
            if (deviceType == null) {
                return;
            }
            IndexArrayClass indexArrayClass = this.idxArr[deviceType.ordinal()];
            if (indexArrayClass == null) {
                return;
            }
            if (n < 0 || n >= indexArrayClass.size) {
                return;
            }
            int n2 = indexArrayClass.idxArr[n];
            if (n2 == -1) {
                return;
            }
            indexArrayClass.idxArr[n] = -1;
            --this.noOfRecords;
            int n3 = n2;
            while (n3 < this.noOfRecords) {
                this.arr[n3] = this.arr[n3 + 1];
                DevicePositionRecord devicePositionRecord = this.arr[n3];
                this.idxArr[devicePositionRecord.deviceType.ordinal()].idxArr[devicePositionRecord.id] = n3++;
            }
        }

        public DevicePositionRecord findDevice(int n, int n2) {
            int n3 = this.binaryXRangeSearch(n);
            if (n3 < 0) {
                return null;
            }
            int n4 = n3;
            boolean bl = true;
            while (bl) {
                if (this.arr[n4].compareToDeviceYRange(n2)) {
                    return this.arr[n4];
                }
                if (--n4 >= 0) {
                    if (this.arr[n4].compareToDeviceXRange(n) == 0) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
            n4 = n3 + 1;
            if (n4 >= this.noOfRecords) {
                return null;
            }
            boolean bl2 = bl = this.arr[n4].compareToDeviceXRange(n) == 0;
            while (bl) {
                if (this.arr[n4].compareToDeviceYRange(n2)) {
                    return this.arr[n4];
                }
                if (++n4 < this.noOfRecords) {
                    if (this.arr[n4].compareToDeviceXRange(n) == 0) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
            return null;
        }

        public void clear() {
            this.noOfRecords = 0;
            for (int i = 0; i < this.idxArr.length; ++i) {
                if (this.idxArr[i] == null) continue;
                this.idxArr[i].clear();
            }
        }
    }

    class IndexArrayClass {
        public int size;
        public int[] idxArr;

        public IndexArrayClass(int n) {
            this.size = n;
            this.idxArr = new int[this.size];
        }

        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.idxArr[i] = -1;
            }
        }
    }

    class DevicePositionRecord {
        public int xm;
        public int ym;
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public int id;
        public int attrib = 0;
        public DeviceType deviceType;
        public int state = 0;

        public DevicePositionRecord(int n, int n2, int n3, DeviceType deviceType) {
            this.id = n;
            this.xm = n2;
            this.ym = n3;
            this.x1 = n2 - 15 - 3;
            this.x2 = n2 + 15 + 3;
            this.y1 = n3 - 15 - 3;
            this.y2 = n3 + 15 + 3;
            this.deviceType = deviceType;
        }

        public void newCoordinates(int n, int n2) {
            this.xm = n;
            this.ym = n2;
            this.x1 = n - 15 - 3;
            this.x2 = n + 15 + 3;
            this.y1 = n2 - 15 - 3;
            this.y2 = n2 + 15 + 3;
        }

        public int compareToDeviceXRange(int n) {
            if (n >= this.x1 && n <= this.x2) {
                return 0;
            }
            if (n < this.x1) {
                return -1;
            }
            return 1;
        }

        public boolean compareToDeviceYRange(int n) {
            return n >= this.y1 && n <= this.y2;
        }

        public int compareToDeviceXPosition(int n) {
            if (n < this.xm) {
                return -1;
            }
            if (n > this.xm) {
                return 1;
            }
            return 0;
        }
    }

    public static enum DeviceType {
        RFP,
        BLUETOOTH,
        CORNER,
        MOVEPOINT;

    }
}

