/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpCaptureHandler;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import java.util.HashMap;

public class RfpCapturePanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
RfpDataNotificationInterface,
RfpCaptureHandler.RfpCaptureDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    private CommonDataHandler commonDataHandler = null;
    private RfpDataHandler rfpDataHandler = null;
    private RfpCaptureHandler rfpCaptureHandler = null;
    private boolean rfpCapture = false;
    private HashMap<Integer, String> mapSeqEthAddr = new HashMap();
    private HashMap<String, Integer> mapEthAddrSeq = new HashMap();
    private AastraScrollPane rfpCaptureTablePane = null;
    private GuiUtilConfiguratorTable rfpCaptureTable = null;
    private RfpCaptureTaskPanel rfpCaptureTaskPanel = null;
    private int[] rfpCaptureTableColumns = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public RfpCapturePanel(CommonDataHandler commonDataHandler, RfpDataHandler rfpDataHandler, RfpCaptureHandler rfpCaptureHandler) {
        this.commonDataHandler = commonDataHandler;
        this.rfpDataHandler = rfpDataHandler;
        this.rfpCaptureHandler = rfpCaptureHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.RFPCapture, this);
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.rfpCaptureHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpCaptureTablePane(), "Center");
        this.add((Component)this.getRfpCaptureTaskPanel(), "East");
    }

    private AastraScrollPane getRfpCaptureTablePane() {
        if (this.rfpCaptureTablePane == null) {
            this.rfpCaptureTablePane = new AastraScrollPane(this.getRfpCaptureTable());
        }
        return this.rfpCaptureTablePane;
    }

    private GuiUtilConfiguratorTable getRfpCaptureTable() {
        if (this.rfpCaptureTable == null) {
            this.rfpCaptureTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpCaptureHandler.getDb(), this.getActiveRfpCaptureTableColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpCapture, true);
            this.rfpCaptureTable.setIconArray(3, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpCaptureTable.setIconArray(5, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpCaptureTable.setIconArray(6, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpCaptureTable.setIconArray(7, GuiUtilIcon.getIconArrayInactiveError());
        }
        return this.rfpCaptureTable;
    }

    private int[] getActiveRfpCaptureTableColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpCapture);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < this.rfpCaptureTableColumns.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = this.rfpCaptureTableColumns[i];
            }
        } else {
            nArray = this.rfpCaptureTableColumns;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            for (int i = 0; i < nArray.length; ++i) {
                bitSet.set(i);
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpCapture, bitSet);
        }
        return nArray;
    }

    private AastraPanel getRfpCaptureTaskPanel() {
        if (this.rfpCaptureTaskPanel == null) {
            this.rfpCaptureTaskPanel = new RfpCaptureTaskPanel();
        }
        return this.rfpCaptureTaskPanel;
    }

    private void toogleRfpCapture() {
        this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.RFPCapture, !this.rfpCapture);
        this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.RFPCapture);
    }

    private void addRfp() {
        int n = this.rfpCaptureTable.getSelectedRowCount();
        if (n > 0) {
            int[] nArray = this.rfpCaptureTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.rfpCaptureTable.convertRowIndexToModel(nArray[i]);
                RfpCaptureHandler.RfpCaptureRecord rfpCaptureRecord = this.rfpCaptureHandler.getCapturedRfpByTableIdx(n2);
                if (rfpCaptureRecord == null) continue;
                this.createRfpDataRecord(rfpCaptureRecord);
            }
        }
    }

    private void addAllRfp() {
        int n = this.rfpCaptureTable.getRowCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = this.rfpCaptureTable.convertRowIndexToModel(i);
                RfpCaptureHandler.RfpCaptureRecord rfpCaptureRecord = this.rfpCaptureHandler.getCapturedRfpByTableIdx(n2);
                if (rfpCaptureRecord == null) continue;
                this.createRfpDataRecord(rfpCaptureRecord);
            }
        }
    }

    private void createRfpDataRecord(RfpCaptureHandler.RfpCaptureRecord rfpCaptureRecord) {
        RfpDataRecord rfpDataRecord = new RfpDataRecord();
        rfpDataRecord.setField(RfpDataRecord.IDX_ETH_ADDR, rfpCaptureRecord.getField(0));
        rfpDataRecord.setField(RfpDataRecord.IDX_IP_ADDR, rfpCaptureRecord.getField(1));
        rfpDataRecord.setField(RfpDataRecord.IDX_HWTYPE, rfpCaptureRecord.getField(2));
        rfpDataRecord.setField(RfpDataRecord.IDX_HAS_WLAN, rfpCaptureRecord.getField(3));
        rfpDataRecord.setField(RfpDataRecord.IDX_RADIO_TYPE, rfpCaptureRecord.getField(4));
        rfpDataRecord.setField(RfpDataRecord.IDX_OUTDOOR_TYPE, rfpCaptureRecord.getField(5));
        rfpDataRecord.setField(RfpDataRecord.IDX_HAS_FREQ_SHIFT, rfpCaptureRecord.getField(6));
        int n = this.rfpDataHandler.sendCreateRfp(rfpDataRecord);
        this.mapSeqEthAddr.put(n, (String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR));
        this.mapEthAddrSeq.put((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR), n);
    }

    private void deleteCaptureList() {
        this.rfpCaptureHandler.sendDeleteRfpCaptureList();
    }

    private void deleteCaptureListElem() {
        int n = this.rfpCaptureTable.getSelectedRowCount();
        if (n > 0) {
            int[] nArray = this.rfpCaptureTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.rfpCaptureTable.convertRowIndexToModel(nArray[i]);
                RfpCaptureHandler.RfpCaptureRecord rfpCaptureRecord = this.rfpCaptureHandler.getCapturedRfpByTableIdx(n2);
                if (rfpCaptureRecord == null) continue;
                this.rfpCaptureHandler.sendDeleteRfpCaptureListElem((String)rfpCaptureRecord.getField(0));
            }
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        switch (commonDataItemEnum) {
            case RFPCapture: {
                try {
                    this.rfpCapture = (Boolean)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.RFPCapture);
                    this.rfpCaptureTaskPanel.setButtonCaptureIcon(this.rfpCapture);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RFPCapture.name() + "=" + this.rfpCapture);
                    break;
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.RFPCapture.name() + " failed");
                    return;
                }
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        RfpDataRecord rfpDataRecord;
        if (dataNotificationEnum == DataNotificationEnum.CREATE_RFP && (rfpDataRecord = this.rfpDataHandler.getRfpData(n)) != null && this.mapEthAddrSeq.containsKey((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR))) {
            int n2 = this.mapEthAddrSeq.get((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR));
            this.mapEthAddrSeq.remove((String)rfpDataRecord.getField(RfpDataRecord.IDX_ETH_ADDR));
            this.mapSeqEthAddr.remove(n2);
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        OmiMessage.errorCodes errorCodes2 = OmiMessage.errorCodes.valueOf(omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name()));
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        Integer n2 = new Integer(omiMessage.getAttribVal(OmiMessage.attribIds.seq.name()));
        if (this.mapSeqEthAddr.containsKey(n2)) {
            String string3 = this.mapSeqEthAddr.get(n2);
            this.mapSeqEthAddr.remove(n2);
            this.mapEthAddrSeq.remove(string3);
            this.rfpCaptureHandler.setConfigState(string3, true);
            String string4 = String.format(UtilLocale.getString("TXT_CONFIGURATION_OF_RFP_MAC_ADDRESS_*_FAILED_REASON:_*"), string3, UtilErrorHandling.getErrorMessage(errorCodes2, string, string2));
            GuiInfoConsole.showError(string4);
        }
    }

    @Override
    public void processRfpCaptureDataNotification(String string, DataNotificationEnum dataNotificationEnum) {
        this.processTableEvent();
    }

    @Override
    public void processRfpCaptureDataErrorNotification(String string, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.rfpCaptureTable.getRowCount() > 0) {
            bl = true;
        }
        if (this.rfpCaptureTable.getSelectedRowCount() > 0) {
            bl2 = true;
        }
        this.rfpCaptureTaskPanel.setTaskButtonAddAllRfp(bl);
        this.rfpCaptureTaskPanel.setTaskButtonAddRfp(bl2);
        this.rfpCaptureTaskPanel.setTaskButtonDeleteCaptureList(bl);
        this.rfpCaptureTaskPanel.setTaskButtonDeleteCaptureListElem(bl2);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
    }

    private final class RfpCaptureTaskPanel
    extends GuiUtilTaskPanel {
        private static final long serialVersionUID = 1L;
        private AastraLinkButton buttonCapture = null;
        private AastraLinkButton buttonAddRfp = null;
        private AastraLinkButton buttonAddAllRfp = null;
        private AastraLinkButton buttonDeleteCaptureList = null;
        private AastraLinkButton buttonDeleteCaptureListElem = null;
        private AastraLinkButton buttonConfigureRfpCaptureTable = null;

        private RfpCaptureTaskPanel() {
            this.initialize();
        }

        private void initialize() {
            this.add((Component)this.getButtonCapture(), null);
            this.add((Component)this.getButtonAddAllRfp(), null);
            this.add((Component)this.getButtonAddRfp(), null);
            this.add((Component)this.getButtonDeleteCaptureList(), null);
            this.add((Component)this.getButtonDeleteCaptureListElem(), null);
            this.add(this.getButtonConfigureRfpCaptureTable());
        }

        private AastraLinkButton getButtonCapture() {
            if (this.buttonCapture == null) {
                this.buttonCapture = this.createTaskButtonEnabled(UtilLocale.getString("TXT_CAPTURING_20"), UtilLocale.getString("TXT_HELP_RFP_CAPTURING"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.buttonCapture.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpCapturePanel.this.toogleRfpCapture();
                    }
                });
            }
            return this.buttonCapture;
        }

        private void setButtonCaptureIcon(boolean bl) {
            if (bl) {
                this.buttonCapture.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonCapture.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }

        private AastraLinkButton getButtonAddAllRfp() {
            if (this.buttonAddAllRfp == null) {
                this.buttonAddAllRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_ADD_ALL_20"), UtilLocale.getString("TXT_HELP_RFP_CAPTURING_ADD_ALL"));
                this.buttonAddAllRfp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpCapturePanel.this.addAllRfp();
                    }
                });
            }
            return this.buttonAddAllRfp;
        }

        private AastraLinkButton getButtonAddRfp() {
            if (this.buttonAddRfp == null) {
                this.buttonAddRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_ADD_SELECTED_20"), UtilLocale.getString("TXT_HELP_RFP_CAPTURING_ADD_SELECTED"));
                this.buttonAddRfp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpCapturePanel.this.addRfp();
                    }
                });
            }
            return this.buttonAddRfp;
        }

        private AastraLinkButton getButtonDeleteCaptureList() {
            if (this.buttonDeleteCaptureList == null) {
                this.buttonDeleteCaptureList = this.createTaskButtonDisabled(UtilLocale.getString("TXT_REMOVE_ALL_20"), UtilLocale.getString("TXT_HELP_RFP_CAPTURING_REMOVE_ALL"));
                this.buttonDeleteCaptureList.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpCapturePanel.this.deleteCaptureList();
                    }
                });
            }
            return this.buttonDeleteCaptureList;
        }

        private AastraLinkButton getButtonDeleteCaptureListElem() {
            if (this.buttonDeleteCaptureListElem == null) {
                this.buttonDeleteCaptureListElem = this.createTaskButtonDisabled(UtilLocale.getString("TXT_REMOVE_SELECTED_20"), UtilLocale.getString("TXT_HELP_RFP_CAPTURING_REMOVE_SELECTED"));
                this.buttonDeleteCaptureListElem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpCapturePanel.this.deleteCaptureListElem();
                    }
                });
            }
            return this.buttonDeleteCaptureListElem;
        }

        private AastraLinkButton getButtonConfigureRfpCaptureTable() {
            if (this.buttonConfigureRfpCaptureTable == null) {
                this.buttonConfigureRfpCaptureTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
                this.buttonConfigureRfpCaptureTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpCapturePanel.this.rfpCaptureTable, RfpCapturePanel.this.rfpCaptureTableColumns, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpCapture);
                        guiUtilTableConfigDlg.setVisible(true);
                    }
                });
            }
            return this.buttonConfigureRfpCaptureTable;
        }

        private void setTaskButtonAddAllRfp(boolean bl) {
            this.buttonAddAllRfp.setEnabled(bl);
        }

        private void setTaskButtonAddRfp(boolean bl) {
            this.buttonAddRfp.setEnabled(bl);
        }

        private void setTaskButtonDeleteCaptureList(boolean bl) {
            this.buttonDeleteCaptureList.setEnabled(bl);
        }

        private void setTaskButtonDeleteCaptureListElem(boolean bl) {
            this.buttonDeleteCaptureListElem.setEnabled(bl);
        }
    }
}

