/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpConfigDetailPanel;
import com.aastra.oamp.rfp.RfpConfigTaskPanel;
import com.aastra.oamp.rfp.RfpTreeView;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;

public class RfpConfigMainPanel
extends AastraPanel
implements RfpDataNotificationInterface,
WLANProfileHandler.WLANProfileDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 285;
    protected static final int ySizeDetailPanelSurcharge = 190;
    protected static final int ySizeDetailPanel = 400;
    public static final String DECT_ON = "DECT_ON";
    private RfpDataHandler rfpDataHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private WLANProfileHandler wlanProfileHandler = null;
    private CommonDataHandler commonDataHandler = null;
    private GuiStatusBar guiStatusBar = null;
    private GuiUtilDetailSplitPanel rfpDetailSplitPane = null;
    private AastraScrollPane rfpTablePane = null;
    private RfpConfigDetailPanel rfpDetailPanel = null;
    private RfpConfigTaskPanel rfpTaskPanel = null;
    private GuiUtilConfiguratorTable rfpTable = null;
    private RfpTreeView rfpTreeView = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> rfpsIdPending = new HashMap();
    private int dividerLocation = 0;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private int cntNotificationsToReceive = 0;
    private int cntRfpsSendBulkTotal = 0;
    private boolean rfpTableConfigIdxArrayChecked = false;
    private boolean activePanel = false;
    private OmiManagement omiManagement = null;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private UtilErrorComp utilErrorComp = null;
    public static int[] rfpTableConfigIdxArrayDefault = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_HWTYPE_TEXT, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_CONNECTED, RfpDataRecord.IDX_GUI_ATTRIB1};
    public static int[] rfpTableConfigIdxArray = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_RPN, RfpDataRecord.IDX_LICENSE_RFP, RfpDataRecord.IDX_HWTYPE_TEXT, RfpDataRecord.IDX_DECT_ON, RfpDataRecord.IDX_PREFERRED_SYNC, RfpDataRecord.IDX_REFLECTIVE_ENV, RfpDataRecord.IDX_SITE, RfpDataRecord.IDX_SITE_TEXT, RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_CONNECTED, RfpDataRecord.IDX_GUI_ATTRIB1, RfpDataRecord.IDX_WLAN_ON, RfpDataRecord.IDX_WLAN_PROFILE, RfpDataRecord.IDX_WLAN_CHANNEL, RfpDataRecord.IDX_WLAN_POWER, RfpDataRecord.IDX_WLAN_ANTENNA_DIV, RfpDataRecord.IDX_WLAN_ANTENNA, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT};

    public RfpConfigMainPanel(RfpDataHandler rfpDataHandler, SiteDataHandler siteDataHandler, WLANProfileHandler wLANProfileHandler, CommonDataHandler commonDataHandler, RfpTreeView rfpTreeView) {
        this.rfpDataHandler = rfpDataHandler;
        this.siteDataHandler = siteDataHandler;
        this.wlanProfileHandler = wLANProfileHandler;
        this.commonDataHandler = commonDataHandler;
        this.rfpTreeView = rfpTreeView;
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.wlanProfileHandler.registerProfileDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        OmiMessage.RFPHwTypeType.UNKNOWN.setStrPreselect(UtilLocale.getString("TXT_AUTO"));
        this.add((Component)this.getRfpDetailSplitPane(), "Center");
        this.add((Component)this.getRfpTaskPanel(), "East");
        this.utilErrorComp = new UtilErrorComp();
    }

    public int[] getRfpTableConfigIdxArray() {
        int n = 0;
        int n2 = rfpTableConfigIdxArray.length;
        if (!this.rfpTableConfigIdxArrayChecked) {
            this.rfpTableConfigIdxArrayChecked = true;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (n > 0) {
                int[] nArray = Arrays.copyOf(rfpTableConfigIdxArray, rfpTableConfigIdxArray.length + n);
                rfpTableConfigIdxArray = nArray;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                RfpConfigMainPanel.rfpTableConfigIdxArray[n2++] = RfpDataRecord.IDX_CONFERENCE_CHANNELS;
            }
        }
        return rfpTableConfigIdxArray;
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    public void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.rfpsIdPending.clear();
    }

    private void updateColumnActive(int n) {
        RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpData(n);
        Boolean bl = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_CONNECTED);
        Boolean bl2 = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_DECT_ON);
        OmiMessage.RFPSyncStateType rFPSyncStateType = (OmiMessage.RFPSyncStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_SYNC_STATE));
        if (bl.booleanValue() && bl2.booleanValue()) {
            switch (rFPSyncStateType) {
                case Inactive: {
                    this.rfpDataHandler.setInternalAttrib(n, RfpDataRecord.IDX_GUI_ATTRIB1, (Object)RfpDataRecord.RfpActiveTypeEnum.RFP_DECT_INACTIVE);
                    break;
                }
                case NotSynced: {
                    this.rfpDataHandler.setInternalAttrib(n, RfpDataRecord.IDX_GUI_ATTRIB1, (Object)RfpDataRecord.RfpActiveTypeEnum.RFP_NOT_SYNCED);
                    break;
                }
                case Searching: {
                    this.rfpDataHandler.setInternalAttrib(n, RfpDataRecord.IDX_GUI_ATTRIB1, (Object)RfpDataRecord.RfpActiveTypeEnum.RFP_SEARCHING);
                    break;
                }
                default: {
                    this.rfpDataHandler.setInternalAttrib(n, RfpDataRecord.IDX_GUI_ATTRIB1, (Object)RfpDataRecord.RfpActiveTypeEnum.RFP_SYNCED);
                    break;
                }
            }
        } else {
            this.rfpDataHandler.setInternalAttrib(n, RfpDataRecord.IDX_GUI_ATTRIB1, (Object)RfpDataRecord.RfpActiveTypeEnum.RFP_DECT_NOT_ACTIVATED);
        }
    }

    private void processTableEvent() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.rfpTable.getSelectedRowCount();
        int[] nArray = this.rfpTable.getSelectedRows();
        if (n > 0) {
            bl = true;
            if (!this.isOmmOrLicenseRfpSelected(nArray)) {
                bl2 = true;
            }
        }
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            if (n > 0) {
                DataRecord[] dataRecordArray = new DataRecord[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
                    dataRecordArray[i] = this.rfpDataHandler.getRfpDataByIdx(n2);
                }
                this.createRfpDetailPanel(dataRecordArray);
            } else {
                this.removeRfpDetailPanel();
            }
            bl = false;
        }
        this.rfpTaskPanel.setTaskButtonConfigure(bl);
        this.rfpTaskPanel.setTaskButtonDelete(bl2);
    }

    public void configureRfp() {
        int n = this.rfpTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.rfpTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
            RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n2);
            dataRecordArray[i] = rfpDataRecord;
        }
        this.createRfpDetailPanel(dataRecordArray);
    }

    private GuiUtilDetailSplitPanel getRfpDetailSplitPane() {
        if (this.rfpDetailSplitPane == null) {
            this.rfpDetailSplitPane = new GuiUtilDetailSplitPanel(400);
            this.rfpDetailSplitPane.setTopComponent(this.getRfpTablePane());
            this.rfpDetailSplitPane.setBottomComponent(null);
        }
        return this.rfpDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getRfpTable() {
        if (this.rfpTable == null) {
            this.rfpTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDataHandler.getDatabase(), this.getRfpTableConfigIdxArray(), this.getActiveRfpConfigColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpConfig);
            this.rfpTable.setIconArray(RfpDataRecord.IDX_DECT_ON, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_LICENSE_RFP, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_PREFERRED_SYNC, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_REFLECTIVE_ENV, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ON, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_CONNECTED, GuiUtilIcon.getIconArrayErrorActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_GUI_ATTRIB1, GuiUtilIcon.getIconArrayInactiveErrorSearchSearchActive());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.rfpTable.setIconArray(RfpDataRecord.IDX_CONFERENCE_CHANNELS, GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.rfpTable.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
            this.rfpTable.setColumnFormatString(RfpDataRecord.IDX_RPN, "0x%03X");
            this.rfpTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_RPN);
            this.rfpTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_RFP_ID, 30);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_HWTYPE_TEXT, 40);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_CONNECTED, 35);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_CLUSTER, 55);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_PAGING_AREA, 50);
            this.rfpTable.setPreferredColumnWidth(RfpDataRecord.IDX_GUI_ATTRIB1, 35);
            this.rfpTable.applyPreferredColumnWidthSettings();
        }
        return this.rfpTable;
    }

    private AastraScrollPane getRfpTablePane() {
        if (this.rfpTablePane == null) {
            this.rfpTablePane = new AastraScrollPane(this.getRfpTable());
            this.dividerLocation = this.rfpDetailSplitPane.getHeight() - 400;
            this.rfpTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.rfpTablePane;
    }

    private void enableTableAccess() {
        this.rfpTable.setActive(true);
        this.rfpTaskPanel.setTaskButtonCreate(true);
        this.rfpTaskPanel.setTaskButtonConfigureTable(true);
        this.rfpTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.rfpTable.setActive(false);
        this.rfpTaskPanel.setTaskButtonCreate(false);
        this.rfpTaskPanel.setTaskButtonConfigure(false);
        this.rfpTaskPanel.setTaskButtonDelete(false);
        this.rfpTaskPanel.setTaskButtonConfigureTable(false);
        this.rfpTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.rfpTable, this.getActiveRfpConfigColumns(), UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpConfig));
        this.rfpTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getRfpDetailPanel(RfpTreeView rfpTreeView) {
        if (this.rfpDetailPanel == null) {
            this.rfpDetailPanel = new RfpConfigDetailPanel(this, this.siteDataHandler, this.commonDataHandler, rfpTreeView, (WLANProfileHandler.WLANProfileDatabase)this.wlanProfileHandler.getWLANProfileDatabase(), this.utilErrorComp);
        }
        return this.rfpDetailPanel;
    }

    private AastraPanel getRfpTaskPanel() {
        if (this.rfpTaskPanel == null) {
            this.rfpTaskPanel = new RfpConfigTaskPanel(this, this.getRfpTable());
        }
        return this.rfpTaskPanel;
    }

    public void startRfpCreation() {
        this.rfpTable.removeRowSelectionAll();
        this.createRfpDetailPanel(null);
    }

    private void createRfpDetailPanel(DataRecord[] dataRecordArray) {
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            this.clearDetailPanelPending();
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
            if (dataRecordArray == null) {
                this.rfpDetailPanel.setDefaultTab();
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP config detail panel");
        } else {
            this.rfpDetailSplitPane.setBottomComponent(this.getRfpDetailPanel(this.rfpTreeView));
            this.rfpDetailPanel.setDefaultTab();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP config detail panel");
        }
        if (dataRecordArray != null) {
            for (int i = 0; i < dataRecordArray.length; ++i) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading RFP[" + (Integer)dataRecordArray[i].getField(RfpDataRecord.IDX_RFP_ID) + "]:");
                UtilPrint.printRfpDataRecordString((RfpDataRecord)dataRecordArray[i], this);
            }
            this.rfpDetailPanel.setRfpDetailData(dataRecordArray);
        } else {
            this.rfpDetailPanel.setRfpDetailData(null);
        }
        this.rfpDetailPanel.requestDefaultFocusInWindow();
        this.rfpDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.rfpDetailSplitPane.validate();
        this.rfpTaskPanel.setTaskButtonConfigure(false);
    }

    public void removeRfpDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing RFP config detail panel");
        this.clearDetailPanelPending();
        this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
        this.rfpDetailSplitPane.setBottomComponent(null);
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.rfpTable.getSelectedRow() >= 0) {
            this.rfpTaskPanel.setTaskButtonConfigure(true);
        } else {
            this.rfpTaskPanel.setTaskButtonConfigure(false);
        }
    }

    public boolean createRfp() {
        DataRecord[] dataRecordArray = this.rfpDetailPanel.getRfpDetailData();
        if (dataRecordArray != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            RfpDataRecord rfpDataRecord = (RfpDataRecord)dataRecordArray[0];
            if (rfpDataRecord != null) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating RFP:");
                UtilPrint.printRfpDataRecordString(rfpDataRecord, this);
                this.rfpDataHandler.sendCreateRfp(rfpDataRecord);
                this.setDetailPanelPending();
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating RFP failed: No RFP data record");
                this.removeRfpDetailPanel();
            }
            return true;
        }
        return false;
    }

    public boolean changeRfp() {
        DataRecord[] dataRecordArray = this.rfpDetailPanel.getRfpDetailData();
        if (dataRecordArray != null) {
            int n;
            this.cntRfpsSendBulkTotal = 0;
            for (n = 0; n < dataRecordArray.length; ++n) {
                if (!((RfpDataRecord)dataRecordArray[n]).getRecordChanged()) continue;
                this.rfpDataHandler.getDatabase().updateTransientFields((RfpDataRecord)dataRecordArray[n]);
                ++this.cntRfpsSendBulkTotal;
                ++this.cntNotificationsToReceive;
                this.rfpsIdPending.put((Integer)dataRecordArray[n].getField(RfpDataRecord.IDX_RFP_ID), false);
            }
            if (this.cntRfpsSendBulkTotal > 0) {
                n = 0;
                RfpDataRecord[] rfpDataRecordArray = new RfpDataRecord[this.cntRfpsSendBulkTotal];
                for (int i = 0; i < dataRecordArray.length; ++i) {
                    if (!((RfpDataRecord)dataRecordArray[i]).getRecordChanged()) continue;
                    rfpDataRecordArray[n++] = (RfpDataRecord)dataRecordArray[i];
                }
                if (this.cntRfpsSendBulkTotal == 1) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing RFP[%d]\n", rfpDataRecordArray[0].getField(RfpDataRecord.IDX_RFP_ID)));
                } else {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d RFPs\n", this.cntRfpsSendBulkTotal));
                }
                this.sendBulkAction = DataHandler.SendBulkActionType.Change;
                this.rfpDataHandler.sendChangeDeleteRfps(this.sendBulkAction, rfpDataRecordArray, this);
                this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
                this.setDetailPanelPending();
                if (this.cntRfpsSendBulkTotal > 1) {
                    this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_RFPS_IN_PROGRESS"), false, true, this);
                    this.guiProgressDlg.setValue(0);
                    this.guiProgressDlg.setVisible(true);
                }
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing RFP(s): OMILIB told us there is nothing to do (all RFP attributes are unchanged)");
                this.removeRfpDetailPanel();
            }
            return true;
        }
        return false;
    }

    public void deleteRfp() {
        String string;
        GuiUtilDialog guiUtilDialog;
        int n = this.rfpTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, string = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) ? UtilLocale.getString("TXT_DELETE_SELECTED_RFPS_?_VIDEO") : UtilLocale.getString("TXT_DELETE_SELECTED_RFPS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.rfpTable.getSelectedRows();
            this.cntRfpsSendBulkTotal = nArray.length;
            this.cntNotificationsToReceive = nArray.length;
            RfpDataRecord[] rfpDataRecordArray = new RfpDataRecord[this.cntRfpsSendBulkTotal];
            for (int i = 0; i < this.cntRfpsSendBulkTotal; ++i) {
                int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
                rfpDataRecordArray[i] = this.rfpDataHandler.getRfpDataByIdx(n2);
                if (this.rfpDetailSplitPane.getBottomComponent() == null) continue;
                int n3 = (Integer)rfpDataRecordArray[i].getField(RfpDataRecord.IDX_RFP_ID);
                if (this.rfpDetailPanel.getSelectedRfp() != n3) continue;
                this.rfpsIdPending.put(n3, false);
                this.setDetailPanelPending();
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.rfpDataHandler.sendChangeDeleteRfps(this.sendBulkAction, rfpDataRecordArray, this);
            if (this.cntRfpsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_RFPS_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    public static void resetDectInfoHierarchy4(RfpDataRecord rfpDataRecord) {
        String string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY4);
        if (string != null && string.compareTo(DECT_ON) == 0) {
            rfpDataRecord.setField(RfpDataRecord.IDX_HIERARCHY4, (Object)"");
            rfpDataRecord.setField(RfpDataRecord.IDX_DECT_ON, (Object)true);
        }
    }

    public static void setDectInfoHierarchy4(RfpDataRecord rfpDataRecord) {
        if (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_DECT_ON)).booleanValue()) {
            rfpDataRecord.setField(RfpDataRecord.IDX_HIERARCHY4, (Object)DECT_ON);
            rfpDataRecord.setField(RfpDataRecord.IDX_DECT_ON, (Object)false);
        }
    }

    public static boolean getDectInfoHierarchy4(RfpDataRecord rfpDataRecord) {
        String string = (String)rfpDataRecord.getField(RfpDataRecord.IDX_HIERARCHY4);
        return string != null && string.compareTo(DECT_ON) == 0;
    }

    private int[] getActiveRfpConfigColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = this.getRfpTableConfigIdxArray();
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpConfig);
        if (bitSet != null && !UtilPreferences.isOpenRespAttribsChanged()) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = nArray2[i];
            }
        } else {
            nArray = rfpTableConfigIdxArrayDefault;
            bitSet = new BitSet();
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpConfig, bitSet);
        }
        return nArray;
    }

    private boolean isOmmOrLicenseRfpSelected(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.rfpTable.convertRowIndexToModel(nArray[i]);
            RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n);
            if (rfpDataRecord == null || !((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_LICENSE_RFP)).booleanValue() && !((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_OMM_RUNNING)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.rfpTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        if (n < 1) {
            return;
        }
        int[] nArray = this.rfpTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.rfpDataHandler.getRfpDataByIdx(n2);
        }
        this.createRfpDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            this.createRfpDetailPanel(dataRecordArray);
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.configureTableFilter();
        this.activePanel = true;
    }

    @Override
    public void componentDeactivated() {
        this.activePanel = false;
    }

    @Override
    public void processWLANProfileDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.rfpDetailPanel != null) {
            this.rfpDetailPanel.updateComboBoxWLANProfile();
        }
    }

    @Override
    public void processWLANProfileErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        if (this.rfpTable.getSelectedRowCount() == 0) {
            this.rfpTaskPanel.setTaskButtonConfigure(false);
            this.rfpTaskPanel.setTaskButtonDelete(false);
        }
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.guiStatusBar.showAppStateResetOverride(GuiStatusBar.AppStateEnum.APP_STATE_OK, "");
                break;
            }
            case NEW_DATA: {
                if (this.detailPanelPending) {
                    this.rfpsIdPending.remove(n);
                    this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                    this.removeRfpDetailPanel();
                    this.rfpDataHandler.sendRfpReq(n, true, true);
                }
                this.updateColumnActive(n);
                break;
            }
            case DATA_RFP_CHANGED_CNF: {
                this.updateColumnActive(n);
                break;
            }
            case DATA_RFP_CHANGED_RESP: {
                if (this.detailPanelPending) {
                    if (this.rfpsIdPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                        --this.cntNotificationsToReceive;
                    }
                    this.rfpsIdPending.remove(n);
                    if (this.rfpsIdPending.isEmpty()) {
                        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                        this.removeRfpDetailPanel();
                        this.cntNotificationsToReceive = 0;
                    }
                }
                this.updateColumnActive(n);
                break;
            }
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.rfpsIdPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.rfpsIdPending.remove(n);
                if (!this.rfpsIdPending.isEmpty()) break;
                this.removeRfpDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP error notification: " + dataNotificationEnum.toString() + ",rfpId=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP error notification: Unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            String string5 = null;
            if (errorCodes2 != null) {
                if (errorCodes2 == OmiMessage.errorCodes.EAreaFull) {
                    if (this.rfpDetailPanel != null) {
                        this.rfpDetailPanel.markErrorComponent(OmiMessage.RFPType.pagingArea.toString());
                    }
                } else {
                    this.rfpDetailPanel.markErrorComponent(string2);
                    string5 = this.rfpDetailPanel.getErrorLabelText(string2);
                }
                string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if (this.rfpsIdPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                if (!this.rfpsIdPending.containsKey(n)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "rfpId=" + n + " does not exist in send map anymore");
                    return;
                }
                this.rfpsIdPending.put(n, true);
                int n2 = 0;
                for (Integer object2 : this.rfpsIdPending.keySet()) {
                    if (!this.rfpsIdPending.get(object2).booleanValue()) continue;
                    ++n2;
                }
                RfpDataRecord[] rfpDataRecordArray = new RfpDataRecord[n2];
                n2 = 0;
                for (Integer n3 : this.rfpsIdPending.keySet()) {
                    if (!this.rfpsIdPending.get(n3).booleanValue()) continue;
                    rfpDataRecordArray[n2] = this.rfpDataHandler.getRfpData(n3);
                    ++n2;
                }
                this.rfpDetailPanel.setRfpDetailData(rfpDataRecordArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (this.activePanel) {
            if (string4 != null) {
                GuiInfoConsole.showError(string4);
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
            }
        }
        if (this.cntNotificationsToReceive == 0) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        }
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntRfpsSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntRfpsSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_RFPS"), n, this.cntRfpsSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.rfpDataHandler.cancelChangeDeleteRfps();
    }
}

