/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Calendar;
import javax.swing.BorderFactory;

public class RfpExportPanel
extends GuiUtilTaskPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
RfpDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private AastraPanel filePanel = null;
    private AastraPanel dataPanel = null;
    private AastraScrollPane tablePanel = null;
    private AastraPanel taskPanel = null;
    private GuiUtilConfiguratorTable rfpTable = null;
    private AastraLinkButton buttonExportAll = null;
    private AastraLinkButton buttonExportSelected = null;
    private AastraLinkButton buttonSelectColumns = null;
    private AastraLinkButton buttonConfigureRfpTable = null;
    private RfpDataHandler rfpDataHandler = null;
    private RfpDatabase rfpDatabase = null;
    private String rfpExportDirName = null;
    private boolean exportAll = false;
    private int[] rfpTableColumns;
    private GuiUtilFileChooser fileChooser = null;
    public static int[] rfpTableExportIdxArrayDefault = new int[]{RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_SITE, RfpDataRecord.IDX_HWTYPE_TEXT};
    public static int[] rfpTableExportIdxArray = new int[]{RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_DECT_ON, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_PREFERRED_SYNC, RfpDataRecord.IDX_REFLECTIVE_ENV, RfpDataRecord.IDX_SITE, RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_WLAN_PROFILE, RfpDataRecord.IDX_WLAN_ANTENNA, RfpDataRecord.IDX_WLAN_CHANNEL, RfpDataRecord.IDX_WLAN_POWER, RfpDataRecord.IDX_WLAN_ON, RfpDataRecord.IDX_HWTYPE_TEXT, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, RfpDataRecord.IDX_CONFERENCE_CHANNELS};

    public RfpExportPanel(RfpDataHandler rfpDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.rfpDatabase = this.rfpDataHandler.getDatabase();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDataPanel(), "Center");
        this.initializeActiveRfpExportSet();
    }

    private AastraPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new AastraPanel();
            this.dataPanel.setLayout(new BorderLayout());
            this.dataPanel.setPreferredSize(new Dimension(500, 300));
            this.dataPanel.add((Component)this.getTablePanel(), "Center");
            this.dataPanel.add((Component)this.getTaskPanel(), "East");
        }
        return this.dataPanel;
    }

    private AastraScrollPane getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new AastraScrollPane(null);
            this.tablePanel.setPreferredSize(new Dimension(400, 300));
            this.tablePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 107, 183)));
            this.tablePanel.setViewportView(this.getRfpTable());
        }
        return this.tablePanel;
    }

    private GuiUtilConfiguratorTable getRfpTable() {
        if (this.rfpTable == null) {
            this.rfpTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDatabase, this.getActiveRfpExportColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpExport, null, true);
            this.setTableFormating();
        }
        return this.rfpTable;
    }

    private void setTableFormating() {
        this.rfpTable.setIconArray(RfpDataRecord.IDX_DECT_ON, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_PREFERRED_SYNC, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_REFLECTIVE_ENV, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ON, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setIconArray(RfpDataRecord.IDX_CONFERENCE_CHANNELS, GuiUtilIcon.getIconArrayInactiveActive());
        this.rfpTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new AastraPanel();
            this.taskPanel.setPreferredSize(new Dimension(185, 0));
            this.taskPanel.setLayout(null);
            this.taskPanel.add(this.getHeaderBarTasks(null));
            this.taskPanel.add((Component)this.getButtonExportAll(), null);
            this.taskPanel.add((Component)this.getButtonExportSelected(), null);
            this.taskPanel.add((Component)this.getButtonSelectColumns(), null);
            this.taskPanel.add((Component)this.getButtonConfigureRfpTable(), null);
        }
        return this.taskPanel;
    }

    private AastraLinkButton getButtonExportAll() {
        if (this.buttonExportAll == null) {
            this.buttonExportAll = new AastraLinkButton();
            this.buttonExportAll.setBounds(5, 45, 175, 20);
            this.buttonExportAll.setText(UtilLocale.getString("TXT_EXPORT_ALL_20"));
            this.buttonExportAll.setToolTipText(UtilLocale.getString("TXT_EXPORT_ALL_RFPS_TO_FILE"));
            this.buttonExportAll.setEnabled(false);
            this.buttonExportAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpExportPanel.this.exportAll = true;
                    RfpExportPanel.this.openFileChooser();
                }
            });
        }
        return this.buttonExportAll;
    }

    private AastraLinkButton getButtonExportSelected() {
        if (this.buttonExportSelected == null) {
            this.buttonExportSelected = new AastraLinkButton();
            this.buttonExportSelected.setBounds(5, 75, 175, 20);
            this.buttonExportSelected.setText(UtilLocale.getString("TXT_EXPORT_SELECTED_20"));
            this.buttonExportSelected.setToolTipText(UtilLocale.getString("TXT_EXPORT_SELECTED_RFPS_TO_FILE"));
            this.buttonExportSelected.setEnabled(false);
            this.buttonExportSelected.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpExportPanel.this.exportAll = false;
                    RfpExportPanel.this.openFileChooser();
                }
            });
        }
        return this.buttonExportSelected;
    }

    private AastraLinkButton getButtonSelectColumns() {
        if (this.buttonSelectColumns == null) {
            this.buttonSelectColumns = new AastraLinkButton();
            this.buttonSelectColumns.setBounds(5, 105, 175, 20);
            this.buttonSelectColumns.setText(UtilLocale.getString("TXT_SELECT_PARAMETERS_20"));
            this.buttonSelectColumns.setToolTipText(UtilLocale.getString("TXT_SELECT_RFP_PARAMETERS_TO_BE_EXPORTED_TO_FILE"));
            this.buttonSelectColumns.setEnabled(true);
            this.buttonSelectColumns.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpDataRecord.getFieldNames(), rfpTableExportIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExportSet, true, UtilLocale.getString("TXT_SELECT_PARAMETERS"));
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonSelectColumns;
    }

    private AastraLinkButton getButtonConfigureRfpTable() {
        if (this.buttonConfigureRfpTable == null) {
            this.buttonConfigureRfpTable = new AastraLinkButton();
            this.buttonConfigureRfpTable.setBounds(5, 135, 175, 20);
            this.buttonConfigureRfpTable.setText(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpExportPanel.this.rfpTable, rfpTableExportIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExport);
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonConfigureRfpTable;
    }

    private GuiUtilFileChooser getFileChooser(AastraPanel aastraPanel) {
        if (this.fileChooser == null) {
            this.fileChooser = new GuiUtilFileChooser(aastraPanel);
        }
        return this.fileChooser;
    }

    private void openFileChooser() {
        File file = this.getFileChooser(this.filePanel).directoryChooser();
        if (file != null) {
            this.rfpExportDirName = file.getAbsolutePath();
            this.writeExportFile();
        } else {
            this.rfpExportDirName = null;
        }
    }

    private void writeExportFile() {
        BufferedWriter bufferedWriter = null;
        String string = this.rfpExportDirName + File.separator + "rfp_export.csv";
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Exporting RFP data to '" + string + "'");
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), Charset.forName("UTF8")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "File '" + string + "' not found");
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_FILE_*_NOT_FOUND"), string));
            return;
        }
        this.rfpTableColumns = this.getActiveRfpExportSet();
        try {
            this.writeHeader(bufferedWriter);
            this.writeData(bufferedWriter);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "RFP data export failed");
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_RFP_EXPORT_TO_FILE_*_FAILED"), string));
            return;
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "RFP data export successful");
        GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_RFPS_EXPORTED_TO_FILE_*_SUCCESSFULLY"), string));
    }

    private void writeHeader(BufferedWriter bufferedWriter) throws IOException {
        int n;
        Calendar calendar = Calendar.getInstance();
        bufferedWriter.write("##################################################\n");
        bufferedWriter.write(String.format("# %s: '%s'\n", UtilLocale.getString("TXT_RFP_DATA_EXPORT_FILE"), "rfp_export.csv"));
        bufferedWriter.write(String.format("# %s: %s  %s: %s\n", UtilLocale.getString("TXT_DATE"), new SimpleDateFormat("dd.MM.yy").format(calendar.getTime()), UtilLocale.getString("TXT_TIME"), new SimpleDateFormat("HH:mm:ss").format(calendar.getTime())));
        bufferedWriter.write("##################################################\n#\n");
        bufferedWriter.write(String.format("# %s:\n#\n", UtilLocale.getString("TXT_EXPORTED_PARAMETERS")));
        for (n = 0; n < this.rfpTableColumns.length; ++n) {
            bufferedWriter.write("# " + RfpDataRecord.getFieldNames()[this.rfpTableColumns[n]] + "\n");
        }
        bufferedWriter.write("#\n##################################################\n\n");
        for (n = 0; n < this.rfpTableColumns.length; ++n) {
            String string = ";";
            if (n == 0) {
                string = "";
            }
            bufferedWriter.write(string + this.csvConversion(RfpDataRecord.getFieldNames()[this.rfpTableColumns[n]]));
        }
        bufferedWriter.newLine();
        if (this.rfpTableColumns.length == rfpTableExportIdxArray.length) {
            bufferedWriter.write("data_sequence");
            bufferedWriter.newLine();
        }
    }

    private void writeData(BufferedWriter bufferedWriter) throws IOException {
        if (this.exportAll) {
            int n = this.rfpTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                RfpDataRecord rfpDataRecord = this.rfpDatabase.getRecordByIdx(i);
                if (rfpDataRecord == null) continue;
                this.writeDataRecord(bufferedWriter, rfpDataRecord);
            }
        } else {
            int[] nArray = this.rfpTable.getSelectedRows();
            int n = this.rfpTable.getSelectedRowCount();
            for (int i = 0; i < n; ++i) {
                int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
                RfpDataRecord rfpDataRecord = this.rfpDatabase.getRecordByIdx(n2);
                if (rfpDataRecord == null) continue;
                this.writeDataRecord(bufferedWriter, rfpDataRecord);
            }
        }
    }

    private void writeDataRecord(BufferedWriter bufferedWriter, RfpDataRecord rfpDataRecord) throws IOException {
        for (int i = 0; i < this.rfpTableColumns.length; ++i) {
            String string = ";";
            if (i == 0) {
                string = "";
            }
            if (this.rfpTableColumns[i] == RfpDataRecord.IDX_PAGING_AREA) {
                int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_PAGING_AREA);
                if (n == -1) {
                    bufferedWriter.write(string + "unassigned");
                    continue;
                }
                bufferedWriter.write(string + n);
                continue;
            }
            if (this.rfpTableColumns[i] == RfpDataRecord.IDX_WLAN_ANTENNA) {
                if (((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ANTENNA_DIV)).booleanValue()) {
                    bufferedWriter.write(string + "0");
                    continue;
                }
                bufferedWriter.write(string + rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ANTENNA));
                continue;
            }
            if (this.rfpTableColumns[i] == RfpDataRecord.IDX_WLAN_CHANNEL) {
                if ((Integer)rfpDataRecord.getField(this.rfpTableColumns[i]) == 0) {
                    bufferedWriter.write(string);
                    continue;
                }
                bufferedWriter.write(string + rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_CHANNEL));
                continue;
            }
            if (this.rfpTableColumns[i] == RfpDataRecord.IDX_HWTYPE_TEXT) {
                String string2 = OmiMessage.RFPHwTypeType.valueOf((String)rfpDataRecord.getField((int)RfpDataRecord.IDX_HWTYPE).toString()).strExport;
                bufferedWriter.write(string + string2);
                continue;
            }
            if (rfpDataRecord.getField(this.rfpTableColumns[i]).getClass().equals(String.class)) {
                bufferedWriter.write(string + this.csvConversion((String)rfpDataRecord.getField(this.rfpTableColumns[i])));
                continue;
            }
            bufferedWriter.write(string + rfpDataRecord.getField(this.rfpTableColumns[i]));
        }
        bufferedWriter.newLine();
    }

    private String csvConversion(String string) {
        String string2 = string;
        boolean bl = false;
        if (string2.contains("\"")) {
            int n = string2.length();
            while ((n = string2.lastIndexOf("\"", n - 1)) != -1) {
                string2 = string2.substring(0, n + 1) + "\"" + string2.substring(n + 1);
            }
            bl = true;
        }
        if (string2.contains(",")) {
            bl = true;
        }
        if (bl) {
            string2 = "\"" + string2 + "\"";
        }
        return string2;
    }

    private void initializeActiveRfpExportSet() {
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExportSet);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < rfpTableExportIdxArray.length; ++i) {
                bitSet.set(i);
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExportSet, bitSet);
        }
    }

    private int[] getActiveRfpExportSet() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExportSet);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpTableExportIdxArray.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = rfpTableExportIdxArray[i];
                ++n;
            }
        }
        return nArray;
    }

    private int[] getActiveRfpExportColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExport);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpTableExportIdxArray.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = rfpTableExportIdxArray[i];
                ++n;
            }
        } else {
            nArray = rfpTableExportIdxArrayDefault;
            bitSet = new BitSet();
            block1: for (int i = 0; i < rfpTableExportIdxArrayDefault.length; ++i) {
                for (int j = 0; j < rfpTableExportIdxArray.length; ++j) {
                    if (rfpTableExportIdxArrayDefault[i] != rfpTableExportIdxArray[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpExport, bitSet);
        }
        return nArray;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        this.processTableEvent();
    }

    private void processTableEvent() {
        if (this.rfpTable.getSelectedRow() != -1) {
            this.buttonExportSelected.setEnabled(true);
        } else {
            this.buttonExportSelected.setEnabled(false);
        }
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        if (this.rfpTable.getRowCount() > 0) {
            this.buttonExportAll.setEnabled(true);
            this.processTableEvent();
        } else {
            this.buttonExportAll.setEnabled(false);
            this.buttonExportSelected.setEnabled(false);
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }
}

