/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextArea;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class RfpImportLogDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel panelLog = null;
    private AastraScrollPane scrollPaneLog = null;
    private AastraTextArea textAreaLog = null;
    private AastraPanel panelButtonBar = null;
    private AastraButton buttonOK = null;
    private String filePath = null;

    public RfpImportLogDlg(String string) {
        super(GuiMain.getGuiMainObject());
        this.filePath = string;
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 600);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(UtilLocale.getString("TXT_LOG_FILE") + " '" + this.filePath + "'");
        this.setContentPane(this.getPanelLog());
    }

    private AastraPanel getPanelLog() {
        if (this.panelLog == null) {
            this.panelLog = new AastraPanel();
            this.panelLog.setLayout(new BorderLayout());
            this.panelLog.add((Component)this.getScrollPaneLog(), "Center");
            this.panelLog.add((Component)this.getPanelButtonBar(), "South");
        }
        return this.panelLog;
    }

    private AastraScrollPane getScrollPaneLog() {
        if (this.scrollPaneLog == null) {
            this.textAreaLog = new AastraTextArea(0, 0);
            this.textAreaLog.setEditable(false);
            this.scrollPaneLog = new AastraScrollPane(this.textAreaLog, 20, 30);
        }
        return this.scrollPaneLog;
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setPreferredSize(new Dimension(0, 65));
            this.panelButtonBar.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.panelButtonBar.add((Component)this.getButtonOK(), gridBagConstraints);
        }
        return this.panelButtonBar;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setPreferredSize(new Dimension(90, 25));
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpImportLogDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    public void setLogtext() {
        String string = this.getLogFileContent();
        if (string != null) {
            this.textAreaLog.setText(string);
            this.textAreaLog.setCaretPosition(0);
        }
    }

    private String getLogFileContent() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath), "UTF-8"));
            int n = 1;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.ensureCapacity(512 * n + 2);
                    ++n;
                    stringBuffer.append(string);
                    stringBuffer.append("\n\r");
                }
            }
            catch (IOException iOException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, RfpImportLogDlg.class, "Reading file '" + this.filePath + "' failed");
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, RfpImportLogDlg.class, "Closing file '" + this.filePath + "' failed");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, RfpImportLogDlg.class, "File '" + this.filePath + "' not found");
        }
        return stringBuffer.toString();
    }
}

