/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.rfp.RfpMonitorDetailPanel;
import com.aastra.oamp.rfp.RfpMonitorTaskPanel;
import com.aastra.oamp.rfp.RfpSyncView;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;

public class RfpMonitorMainPanel
extends AastraPanel
implements RfpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private RfpDataHandler rfpDataHandler = null;
    private SiteDataHandler siteDataHandler = null;
    private GuiUtilDetailSplitPanel rfpDetailSplitPane = null;
    private AastraScrollPane rfpTablePane = null;
    private RfpMonitorDetailPanel rfpDetailPanel = null;
    private RfpMonitorTaskPanel rfpTaskPanel = null;
    private GuiUtilConfiguratorTable rfpTable = null;
    private RfpSyncView syncView = null;
    private GuiNavigationPanel naviBar = null;
    private int currentRfpDetailPanel = -1;
    private int dividerLocation = 0;
    private OmiMessage.PermissionType[] permissionArray = null;
    private boolean rfpTableMonitorIdxArrayChecked = false;
    private OmiManagement omiManagement = null;
    public static int[] rfpTableMonitorIdxArrayDefault = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_DECT_RUNNING, RfpDataRecord.IDX_SYNC_STATE, RfpDataRecord.IDX_CONNECTED};
    public static int[] rfpTableMonitorIdxArray = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_SITE, RfpDataRecord.IDX_SITE_TEXT, RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_RPN, RfpDataRecord.IDX_DECT_ON, RfpDataRecord.IDX_DECT_RUNNING, RfpDataRecord.IDX_SYNC_STATE, RfpDataRecord.IDX_OMM_RUNNING, RfpDataRecord.IDX_LICENSE_RFP, RfpDataRecord.IDX_HWTYPE_TEXT, RfpDataRecord.IDX_RADIO_TYPE, RfpDataRecord.IDX_OUTDOOR_TYPE, RfpDataRecord.IDX_ENCRYPTION_STATE, RfpDataRecord.IDX_ADVANCED_FEATURES_STATE, RfpDataRecord.IDX_HAS_FREQ_SHIFT, RfpDataRecord.IDX_PREFERRED_SYNC, RfpDataRecord.IDX_REFLECTIVE_ENV, RfpDataRecord.IDX_CONNECTED, RfpDataRecord.IDX_BRANDING_MISMATCH, RfpDataRecord.IDX_VERSION_MISMATCH, RfpDataRecord.IDX_STANDBY_OMM_MISMATCH, RfpDataRecord.IDX_SW_VERSION, RfpDataRecord.IDX_NEW_SW_REQUEST, RfpDataRecord.IDX_HAS_WLAN, RfpDataRecord.IDX_WLAN_ON, RfpDataRecord.IDX_WLAN_RUNNING, RfpDataRecord.IDX_WLAN_LINK_NOK, RfpDataRecord.IDX_WLAN_PROFILE, RfpDataRecord.IDX_WLAN_CHANNEL, RfpDataRecord.IDX_WLAN_CHANNEL_USED, RfpDataRecord.IDX_WLAN_POWER, RfpDataRecord.IDX_WLAN_POWER_USED, RfpDataRecord.IDX_WLAN_ANTENNA_DIV, RfpDataRecord.IDX_WLAN_ANTENNA, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT_TYPE_USED};

    public RfpMonitorMainPanel(RfpDataHandler rfpDataHandler, SiteDataHandler siteDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.siteDataHandler = siteDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.permissionArray = this.omiManagement.getOmmPermissions();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpDetailSplitPane(), "Center");
        this.add((Component)this.getRfpMonitorTaskPanel(), "East");
    }

    public int[] getRfpTableMonitorIdxArray() {
        int n = 0;
        int n2 = rfpTableMonitorIdxArray.length;
        if (!this.rfpTableMonitorIdxArrayChecked) {
            this.rfpTableMonitorIdxArrayChecked = true;
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                ++n;
            }
            if (n > 0) {
                int[] nArray = Arrays.copyOf(rfpTableMonitorIdxArray, rfpTableMonitorIdxArray.length + n);
                rfpTableMonitorIdxArray = nArray;
            }
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                RfpMonitorMainPanel.rfpTableMonitorIdxArray[n2++] = RfpDataRecord.IDX_CONFERENCE_CHANNELS;
            }
        }
        return rfpTableMonitorIdxArray;
    }

    public void showRfpDetails() {
        int n;
        RfpDataRecord rfpDataRecord;
        int n2 = this.rfpTable.getSelectedRow();
        if (n2 >= 0 && (rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n = this.rfpTable.convertRowIndexToModel(n2))) != null) {
            this.createRfpDetailPanel(rfpDataRecord);
        }
    }

    private GuiUtilDetailSplitPanel getRfpDetailSplitPane() {
        if (this.rfpDetailSplitPane == null) {
            this.rfpDetailSplitPane = new GuiUtilDetailSplitPanel(400);
            this.rfpDetailSplitPane.setTopComponent(this.getRfpTablePane());
            this.rfpDetailSplitPane.setBottomComponent(null);
        }
        return this.rfpDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getRfpTable() {
        if (this.rfpTable == null) {
            this.rfpTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDataHandler.getDatabase(), this.getRfpTableMonitorIdxArray(), this.getActiveRfpMonitorColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpMonitor);
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.rfpTable.setIconArray(RfpDataRecord.IDX_CONFERENCE_CHANNELS, GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.rfpTable.setIconArray(RfpDataRecord.IDX_DECT_ON, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_OMM_RUNNING, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_HAS_WLAN, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ON, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_OUTDOOR_TYPE, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_ENCRYPTION_STATE, GuiUtilIcon.getIconArray_Inactive_OKInactive_Error_OK());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_ADVANCED_FEATURES_STATE, GuiUtilIcon.getIconArray_Inactive_OKInactive_Error_OK());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_HAS_FREQ_SHIFT, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_PREFERRED_SYNC, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_REFLECTIVE_ENV, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_LICENSE_RFP, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_NEW_SW_REQUEST, GuiUtilIcon.getIconArrayInactiveActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_CONNECTED, GuiUtilIcon.getIconArrayErrorActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_DECT_RUNNING, GuiUtilIcon.getIconArrayErrorActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_RUNNING, GuiUtilIcon.getIconArrayErrorActive());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_WLAN_LINK_NOK, GuiUtilIcon.getIconArrayInactiveWarning());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_BRANDING_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_VERSION_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_STANDBY_OMM_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
            this.rfpTable.setIconArray(RfpDataRecord.IDX_SYNC_STATE, GuiUtilIcon.getIconArrayErrorSearchSearchActive());
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveConference)) {
                this.rfpTable.setIconArray(RfpDataRecord.IDX_CONFERENCE_CHANNELS, GuiUtilIcon.getIconArrayInactiveActive());
            }
            this.rfpTable.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
            this.rfpTable.setColumnFormatString(RfpDataRecord.IDX_RPN, "0x%03X");
            this.rfpTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_RPN);
            this.rfpTable.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
        }
        return this.rfpTable;
    }

    private AastraScrollPane getRfpTablePane() {
        if (this.rfpTablePane == null) {
            this.rfpTablePane = new AastraScrollPane(this.getRfpTable());
            this.dividerLocation = this.rfpDetailSplitPane.getHeight() - 400;
            this.rfpTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.rfpTablePane;
    }

    private void enableTableAccess() {
        this.rfpTable.setActive(true);
        this.rfpTaskPanel.setTaskButtonConfigureTable(true);
        this.rfpTaskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.rfpTable.setActive(false);
        this.rfpTaskPanel.setTaskButtonShowDetails(false);
        this.rfpTaskPanel.setTaskButtonShowSync(false);
        this.rfpTaskPanel.setTaskButtonConfigureTable(false);
        this.rfpTaskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.rfpTable, this.getRfpTableMonitorIdxArray(), UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpMonitor));
        this.rfpTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getRfpMonitorDetailPanel() {
        if (this.rfpDetailPanel == null) {
            this.rfpDetailPanel = new RfpMonitorDetailPanel(this, this.siteDataHandler);
        }
        return this.rfpDetailPanel;
    }

    private AastraPanel getRfpMonitorTaskPanel() {
        if (this.rfpTaskPanel == null) {
            this.rfpTaskPanel = new RfpMonitorTaskPanel(this, this.getRfpTable(), this.permissionArray);
        }
        return this.rfpTaskPanel;
    }

    public void createRfpDetailPanel(DataRecord dataRecord) {
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP monitor detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP monitor detail panel");
            this.rfpDetailSplitPane.setBottomComponent(this.getRfpMonitorDetailPanel());
            this.rfpDetailPanel.setDefaultTab();
        }
        if (dataRecord != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading RFP[" + (Integer)dataRecord.getField(RfpDataRecord.IDX_RFP_ID) + "]:");
            UtilPrint.printRfpDataRecordString((RfpDataRecord)dataRecord, this);
            this.currentRfpDetailPanel = (Integer)dataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            this.rfpDetailPanel.setRfpDetailData((RfpDataRecord)dataRecord);
        } else {
            this.rfpDetailPanel.setRfpDetailData(null);
        }
        this.rfpDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.rfpDetailSplitPane.validate();
        this.rfpTaskPanel.setTaskButtonShowDetails(false);
    }

    public void removeRfpDetailPanel() {
        this.currentRfpDetailPanel = -1;
        this.dividerLocation = this.rfpDetailSplitPane.getDividerLocation();
        this.rfpDetailSplitPane.setBottomComponent(null);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing RFP monitor detail panel");
        if (this.rfpTable.getSelectedRow() >= 0) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
        }
    }

    public void taskBarActionShowSync() {
        int n;
        if (this.syncView != null && (n = this.rfpTable.getSelectedRowCount()) > 0) {
            int[] nArray = this.rfpTable.getSelectedRows();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.rfpTable.convertRowIndexToModel(nArray[i]);
                RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n2);
                nArray2[i] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            }
            this.syncView.getSyncViewPanel().setSelectedRfpArray(nArray2);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.syncView);
            }
        }
    }

    public void setSyncView(RfpSyncView rfpSyncView) {
        this.syncView = rfpSyncView;
    }

    public void setNaviBar(GuiNavigationPanel guiNavigationPanel) {
        this.naviBar = guiNavigationPanel;
    }

    private int[] getActiveRfpMonitorColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = this.getRfpTableMonitorIdxArray();
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpMonitor);
        if (bitSet != null && !UtilPreferences.isOpenRespAttribsChanged()) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = nArray2[i];
                ++n;
            }
        } else {
            nArray = rfpTableMonitorIdxArrayDefault;
            bitSet = new BitSet();
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpMonitor, bitSet);
        }
        return nArray;
    }

    @Override
    public void componentActivated(Component component) {
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                RfpDataRecord rfpDataRecord;
                if (this.rfpTable.getSelectedRow() == -1) {
                    this.rfpTaskPanel.setTaskButtonShowDetails(false);
                    this.rfpTaskPanel.setTaskButtonShowSync(false);
                }
                if (this.currentRfpDetailPanel != n || (rfpDataRecord = this.rfpDataHandler.getRfpData(n)) == null) break;
                this.rfpDetailPanel.setRfpDetailData(rfpDataRecord);
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createRfpDetailPanel(dataRecord);
            } else {
                this.removeRfpDetailPanel();
            }
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        }
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.createRfpDetailPanel(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        int n;
        if (this.rfpDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                this.createRfpDetailPanel(dataRecord);
            } else {
                this.removeRfpDetailPanel();
            }
        }
        if ((n = this.rfpTable.getSelectedRowCount()) == 1) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1) {
                this.rfpTaskPanel.setTaskButtonShowSync(true);
            } else {
                this.rfpTaskPanel.setTaskButtonShowSync(false);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        int n = this.rfpTable.getSelectedRowCount();
        if (n == 1) {
            this.rfpTaskPanel.setTaskButtonShowDetails(true);
            this.rfpTaskPanel.setTaskButtonShowSync(false);
        } else {
            this.rfpTaskPanel.setTaskButtonShowDetails(false);
            if (n > 1) {
                this.rfpTaskPanel.setTaskButtonShowSync(true);
                if (this.rfpDetailSplitPane.getBottomComponent() != null) {
                    this.removeRfpDetailPanel();
                }
            } else {
                this.rfpTaskPanel.setTaskButtonShowSync(false);
            }
        }
    }
}

