/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.rfp.RfpMonitorMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpMonitorTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private RfpMonitorMainPanel rfpMainPanel = null;
    private ConfiguratorTable rfpTable = null;
    private AastraLinkButton buttonShowRfpDetails = null;
    private AastraLinkButton buttonShowSync = null;
    private AastraLinkButton buttonConfigureRfpTable = null;
    private AastraLinkButton buttonFilterRfpTable = null;
    private OmiMessage.PermissionType[] permissionArray = null;
    private GuiUtilTableFilterDlg rfpTableFilterDlg = null;

    public RfpMonitorTaskPanel(RfpMonitorMainPanel rfpMonitorMainPanel, ConfiguratorTable configuratorTable, OmiMessage.PermissionType[] permissionTypeArray) {
        this.rfpMainPanel = rfpMonitorMainPanel;
        this.rfpTable = configuratorTable;
        this.permissionArray = permissionTypeArray;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonShowRfpDetails(), null);
        this.add((Component)this.getButtonConfigureRfpTable(), null);
        this.add((Component)this.getButtonFilterRfpTable(), null);
        this.add((Component)this.getButtonShowSync(), null);
    }

    private AastraLinkButton getButtonShowRfpDetails() {
        if (this.buttonShowRfpDetails == null) {
            this.buttonShowRfpDetails = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_DETAILS_20"));
            this.buttonShowRfpDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpMonitorTaskPanel.this.rfpMainPanel.showRfpDetails();
                }
            });
        }
        return this.buttonShowRfpDetails;
    }

    private AastraLinkButton getButtonFilterRfpTable() {
        if (this.buttonFilterRfpTable == null) {
            this.buttonFilterRfpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpMonitorTaskPanel.this.getRfpTableFilterDlg().setVisible(true);
                    RfpMonitorTaskPanel.this.rfpMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterRfpTable;
    }

    private GuiUtilTableFilterDlg getRfpTableFilterDlg() {
        if (this.rfpTableFilterDlg == null) {
            this.rfpTableFilterDlg = new GuiUtilTableFilterDlg(this.rfpTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpMonitor);
        }
        return this.rfpTableFilterDlg;
    }

    private AastraLinkButton getButtonConfigureRfpTable() {
        if (this.buttonConfigureRfpTable == null) {
            this.buttonConfigureRfpTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpMonitorTaskPanel.this.rfpTable, RfpMonitorMainPanel.rfpTableMonitorIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpMonitor);
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonConfigureRfpTable;
    }

    private AastraLinkButton getButtonShowSync() {
        if (this.buttonShowSync == null) {
            this.buttonShowSync = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_SYNCHRONIZATION_RELATIONS_20"));
            this.buttonShowSync.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpMonitorTaskPanel.this.rfpMainPanel.taskBarActionShowSync();
                }
            });
        }
        return this.buttonShowSync;
    }

    public void setTaskButtonShowDetails(boolean bl) {
        this.buttonShowRfpDetails.setEnabled(bl);
    }

    public void setTaskButtonShowSync(boolean bl) {
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.buttonShowSync.setEnabled(bl);
        }
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigureRfpTable.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterRfpTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterRfpTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterRfpTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterRfpTable.setToolTipText(string);
    }
}

