/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.rfp.DevicePositionPanel;
import com.aastra.oamp.rfp.RfpPlacementTaskPanel;
import com.aastra.oamp.rfp.RfpPlacementViewPanel;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.BitSet;

public class RfpPlacementTablePanel
extends AastraPanel
implements RfpDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface,
BluetoothBeaconHandler.BtBeaconNotificationInterface {
    private static final long serialVersionUID = 1L;
    private RfpDataHandler rfpDataHandler = null;
    private AastraScrollPane tablePane = null;
    private RfpPlacementTaskPanel taskPanel = null;
    private GuiUtilConfiguratorTable table = null;
    private RfpPlacementViewPanel placementView = null;
    private GuiNavigationPanel naviBar = null;
    private OmiMessage.PermissionType[] permissionArray = null;
    private BluetoothBeaconHandler btdHandler = null;
    private PlacementTableEnum tableType = null;
    private UtilPreferences.TableFilterValuesKeyTypeEnum key = null;
    public static int[] rfpTablePlacementIdxArrayDefault = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_POSITIONED};
    public static int[] rfpTablePlacementIdxArray = new int[]{RfpDataRecord.IDX_RFP_ID, RfpDataRecord.IDX_ETH_ADDR, RfpDataRecord.IDX_IP_ADDR, RfpDataRecord.IDX_NAME, RfpDataRecord.IDX_SITE, RfpDataRecord.IDX_SITE_TEXT, RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_CLUSTER, RfpDataRecord.IDX_PAGING_AREA, RfpDataRecord.IDX_RPN, RfpDataRecord.IDX_LICENSE_RFP, RfpDataRecord.IDX_HWTYPE_TEXT, RfpDataRecord.IDX_RADIO_TYPE, RfpDataRecord.IDX_OUTDOOR_TYPE, RfpDataRecord.IDX_PREFERRED_SYNC, RfpDataRecord.IDX_REFLECTIVE_ENV, RfpDataRecord.IDX_CONNECTED, RfpDataRecord.IDX_SW_VERSION, RfpDataRecord.IDX_NEW_SW_REQUEST, RfpDataRecord.IDX_HAS_WLAN, RfpDataRecord.IDX_WLAN_ON, RfpDataRecord.IDX_POSITIONED};
    public static int[] btdTablePlacementIdxArrayDefault = new int[]{0, 1, 3, 2, 4, 5, 6, 12};
    public static int[] btdTablePlacementIdxArray = new int[]{0, 1, 3, 2, 4, 5, 6, 12};

    public RfpPlacementTablePanel(PlacementTableEnum placementTableEnum, Object object) {
        this.tableType = placementTableEnum;
        switch (this.tableType) {
            case PLACEMENT_TABLE_RFP: {
                this.rfpDataHandler = (RfpDataHandler)object;
                this.rfpDataHandler.registerDataNotificationListener(this);
                this.key = UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpPlacement;
                break;
            }
            case PLACEMENT_TABLE_BT: {
                this.btdHandler = (BluetoothBeaconHandler)object;
                this.btdHandler.registerDataNotificationListener(this);
                this.key = UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesBtBeaconPlacement;
            }
        }
        this.permissionArray = GuiMain.getOmiManagementObject().getOmmPermissions();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTablePane(), "Center");
        this.add((Component)this.getRfpMonitorTaskPanel(), "East");
        this.taskPanel.initializeRfpMonitorMainPanelObject(this, this.getTable());
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.table.getSelectedRow() != -1) break;
                this.taskPanel.setTaskButtonShowImage(false);
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    private void updateTaskbar() {
        int n = this.table.getSelectedRowCount();
        this.taskPanel.setTaskButtonShowImage(n >= 1);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = -1;
        switch (this.tableType) {
            case PLACEMENT_TABLE_RFP: {
                n = ((RfpDataRecord)dataRecord).locatingImageId;
                break;
            }
            case PLACEMENT_TABLE_BT: {
                n = ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingImageId;
            }
        }
        if (n != -1) {
            this.placementView.setActiveImage(n);
            if (this.naviBar != null) {
                this.naviBar.activateComponent(this.placementView);
            }
        }
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.updateTaskbar();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        this.updateTaskbar();
    }

    private GuiUtilConfiguratorTable getTable() {
        if (this.table == null) {
            switch (this.tableType) {
                case PLACEMENT_TABLE_RFP: {
                    this.table = new GuiUtilConfiguratorTable((Object)this, (Database)this.rfpDataHandler.getDatabase(), rfpTablePlacementIdxArray, this.getActiveRfpMonitorColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpPlacement);
                    this.table.setIconArray(RfpDataRecord.IDX_DECT_ON, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_OMM_RUNNING, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_HAS_WLAN, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_WLAN_ON, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_WLAN_ANTENNA_DIV, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_WLAN_HIGH_THROUGHPUT, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_OUTDOOR_TYPE, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_HAS_FREQ_SHIFT, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_PREFERRED_SYNC, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_REFLECTIVE_ENV, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_LICENSE_RFP, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_NEW_SW_REQUEST, GuiUtilIcon.getIconArrayInactiveActive());
                    this.table.setIconArray(RfpDataRecord.IDX_CONNECTED, GuiUtilIcon.getIconArrayErrorActive());
                    this.table.setIconArray(RfpDataRecord.IDX_DECT_RUNNING, GuiUtilIcon.getIconArrayErrorActive());
                    this.table.setIconArray(RfpDataRecord.IDX_WLAN_RUNNING, GuiUtilIcon.getIconArrayErrorActive());
                    this.table.setIconArray(RfpDataRecord.IDX_WLAN_LINK_NOK, GuiUtilIcon.getIconArrayInactiveWarning());
                    this.table.setIconArray(RfpDataRecord.IDX_BRANDING_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
                    this.table.setIconArray(RfpDataRecord.IDX_VERSION_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
                    this.table.setIconArray(RfpDataRecord.IDX_STANDBY_OMM_MISMATCH, GuiUtilIcon.getIconArrayInactiveWarning());
                    this.table.setIconArray(RfpDataRecord.IDX_SYNC_STATE, GuiUtilIcon.getIconArrayErrorSearchSearchActive());
                    this.table.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
                    this.table.setColumnFormatString(RfpDataRecord.IDX_RPN, "0x%03X");
                    this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_RPN);
                    this.table.setNegativeIntAsInvalid(RfpDataRecord.IDX_PAGING_AREA);
                    this.table.setIconArray(RfpDataRecord.IDX_POSITIONED, GuiUtilIcon.getIconArrayInactiveActive());
                    break;
                }
                case PLACEMENT_TABLE_BT: {
                    this.table = new GuiUtilConfiguratorTable((Object)this, this.btdHandler.getDb(), btdTablePlacementIdxArray, this.getActiveBtdMonitorColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthBtBeaconPlacement);
                    this.table.setColumnFormatString(2, "0x%03X");
                    this.table.setIconArray(12, GuiUtilIcon.getIconArrayInactiveActive());
                }
            }
        }
        return this.table;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new AastraScrollPane(this.getTable());
        }
        return this.tablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        this.taskPanel.setTaskButtonConfigureTable(true);
        this.taskPanel.setTaskButtonFilter(true);
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.taskPanel.setTaskButtonShowImage(false);
        this.taskPanel.setTaskButtonConfigureTable(false);
        this.taskPanel.setTaskButtonFilter(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.table, this.getActiveRfpMonitorColumns(), UtilPreferences.getTableFilterValues(this.key));
        this.taskPanel.setTaskButtonFilter(bl, null);
    }

    private AastraPanel getRfpMonitorTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new RfpPlacementTaskPanel(this.tableType, this.permissionArray);
        }
        return this.taskPanel;
    }

    public void taskBarActionShowPlacement() {
        if (this.placementView != null) {
            if (!this.placementView.imageLoaded()) {
                return;
            }
            int n = this.placementView.getActImageId();
            int n2 = this.table.getSelectedRowCount();
            if (n2 > 0) {
                int n3;
                boolean bl = false;
                int[] nArray = this.table.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                block16: for (n3 = 0; n3 < nArray.length; ++n3) {
                    Object object;
                    int n4 = this.table.convertRowIndexToModel(nArray[n3]);
                    boolean bl2 = false;
                    DevicePositionPanel.DeviceType deviceType = null;
                    int n5 = -1;
                    RfpDataRecord rfpDataRecord = null;
                    BluetoothBeaconHandler.BtBeaconRec btBeaconRec = null;
                    switch (this.tableType) {
                        case PLACEMENT_TABLE_RFP: {
                            rfpDataRecord = this.rfpDataHandler.getRfpDataByIdx(n4);
                            nArray2[n3] = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                            bl2 = (Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_POSITIONED);
                            deviceType = DevicePositionPanel.DeviceType.RFP;
                            n5 = rfpDataRecord.locatingImageId;
                            break;
                        }
                        case PLACEMENT_TABLE_BT: {
                            btBeaconRec = (BluetoothBeaconHandler.BtBeaconRec)this.btdHandler.getDb().getRecordByIdx(n4);
                            nArray2[n3] = (Integer)btBeaconRec.getField(0);
                            bl2 = (Boolean)btBeaconRec.getField(12);
                            deviceType = DevicePositionPanel.DeviceType.BLUETOOTH;
                            n5 = btBeaconRec.locatingImageId;
                        }
                    }
                    if (!bl2) continue;
                    if (n == n5) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl) {
                        object = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_REASSIGN_RFPS_TO_NEW_IMAGE_?"), true);
                        if (((GuiUtilDialog)object).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionNo) {
                            return;
                        }
                        bl = true;
                    }
                    if ((object = this.placementView.getImageDb().getRecordById(n5)) != null) {
                        ((RfpPlacementViewPanel.PositioningImage)object).removeDevice(nArray2[n3], deviceType);
                    }
                    switch (this.tableType) {
                        case PLACEMENT_TABLE_RFP: {
                            rfpDataRecord.locatingXPos = 0;
                            rfpDataRecord.locatingYPos = 0;
                            continue block16;
                        }
                        case PLACEMENT_TABLE_BT: {
                            btBeaconRec.locatingXPos = 0;
                            btBeaconRec.locatingYPos = 0;
                        }
                    }
                }
                block17: for (n3 = 0; n3 < nArray2.length; ++n3) {
                    switch (this.tableType) {
                        case PLACEMENT_TABLE_RFP: {
                            RfpDataRecord rfpDataRecord = this.rfpDataHandler.getRfpData(nArray2[n3]);
                            rfpDataRecord.setField(RfpDataRecord.IDX_POSITIONED, (Object)true);
                            continue block17;
                        }
                        case PLACEMENT_TABLE_BT: {
                            BluetoothBeaconHandler.BtBeaconRec btBeaconRec = ((BluetoothBeaconHandler.BtBeaconDatabase)this.btdHandler.getDb()).getRecordById(nArray2[n3]);
                            btBeaconRec.positioned = true;
                        }
                    }
                }
                switch (this.tableType) {
                    case PLACEMENT_TABLE_RFP: {
                        this.placementView.setSelectedRfpArray(nArray2);
                        break;
                    }
                    case PLACEMENT_TABLE_BT: {
                        this.placementView.setSelectedBtdArray(nArray2);
                    }
                }
                if (this.naviBar != null) {
                    this.naviBar.activateComponent(this.placementView);
                }
            }
        }
    }

    public void setPlacementView(RfpPlacementViewPanel rfpPlacementViewPanel) {
        this.placementView = rfpPlacementViewPanel;
    }

    public void setNaviBar(GuiNavigationPanel guiNavigationPanel) {
        this.naviBar = guiNavigationPanel;
    }

    private int[] getActiveRfpMonitorColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpPlacement);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpTablePlacementIdxArray.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = rfpTablePlacementIdxArray[i];
                ++n;
            }
        } else {
            nArray = rfpTablePlacementIdxArrayDefault;
            bitSet = new BitSet();
            block1: for (int i = 0; i < rfpTablePlacementIdxArrayDefault.length; ++i) {
                for (int j = 0; j < rfpTablePlacementIdxArray.length; ++j) {
                    if (rfpTablePlacementIdxArrayDefault[i] != rfpTablePlacementIdxArray[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpPlacement, bitSet);
        }
        return nArray;
    }

    private int[] getActiveBtdMonitorColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconPlacement);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < btdTablePlacementIdxArray.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n] = btdTablePlacementIdxArray[i];
                ++n;
            }
        } else {
            nArray = btdTablePlacementIdxArrayDefault;
            bitSet = new BitSet();
            block1: for (int i = 0; i < btdTablePlacementIdxArrayDefault.length; ++i) {
                for (int j = 0; j < btdTablePlacementIdxArray.length; ++j) {
                    if (btdTablePlacementIdxArrayDefault[i] != btdTablePlacementIdxArray[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconPlacement, bitSet);
        }
        return nArray;
    }

    @Override
    public void componentActivated(Component component) {
        this.configureTableFilter();
        this.placementView.triggerProjectFileRead();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void processBtdDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processBtdDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "BTD notification: " + dataNotificationEnum.toString() + ",btdId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.placementView.triggerProjectFileRead();
                break;
            }
            default: {
                if (this.table.getSelectedRow() != -1) break;
                this.taskPanel.setTaskButtonShowImage(false);
            }
        }
    }

    public void taskBarActionConfigureTable() {
        Dialog dialog = null;
        switch (this.tableType) {
            case PLACEMENT_TABLE_RFP: {
                dialog = new GuiUtilTableConfigDlg(this.table, rfpTablePlacementIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpPlacement);
                break;
            }
            case PLACEMENT_TABLE_BT: {
                dialog = new GuiUtilTableConfigDlg(this.table, btdTablePlacementIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectBtBeaconPlacement);
            }
        }
        if (dialog != null) {
            dialog.setVisible(true);
        }
    }

    public static enum PlacementTableEnum {
        PLACEMENT_TABLE_RFP,
        PLACEMENT_TABLE_BT;

    }
}

