/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.rfp.RfpPlacementTablePanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpPlacementTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private RfpPlacementTablePanel.PlacementTableEnum tableType = null;
    private RfpPlacementTablePanel mainPanel = null;
    private ConfiguratorTable table = null;
    private AastraLinkButton buttonShowImage = null;
    private AastraLinkButton buttonConfigureTable = null;
    private AastraLinkButton buttonFilterTable = null;
    private OmiMessage.PermissionType[] permissionArray = null;
    private GuiUtilTableFilterDlg rfpTableFilterDlg = null;

    public RfpPlacementTaskPanel(RfpPlacementTablePanel.PlacementTableEnum placementTableEnum, OmiMessage.PermissionType[] permissionTypeArray) {
        this.tableType = placementTableEnum;
        this.permissionArray = permissionTypeArray;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonConfigureTable(), null);
        this.add((Component)this.getButtonFilterTable(), null);
        this.add((Component)this.getButtonShowImage(), null);
    }

    public void initializeRfpMonitorMainPanelObject(RfpPlacementTablePanel rfpPlacementTablePanel, ConfiguratorTable configuratorTable) {
        if (this.mainPanel == null) {
            this.mainPanel = rfpPlacementTablePanel;
        }
        if (this.table == null) {
            this.table = configuratorTable;
        }
    }

    public AastraLinkButton getButtonFilterTable() {
        if (this.buttonFilterTable == null) {
            this.buttonFilterTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpPlacementTaskPanel.this.getRfpTableFilterDlg().setVisible(true);
                    RfpPlacementTaskPanel.this.mainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterTable;
    }

    private AastraLinkButton getButtonConfigureTable() {
        if (this.buttonConfigureTable == null) {
            this.buttonConfigureTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpPlacementTaskPanel.this.mainPanel.taskBarActionConfigureTable();
                }
            });
        }
        return this.buttonConfigureTable;
    }

    private AastraLinkButton getButtonShowImage() {
        if (this.buttonShowImage == null) {
            this.buttonShowImage = this.createTaskButtonDisabled(UtilLocale.getString("TXT_ASSIGN_TO_ACTIVE_IMAGE_20"));
            this.buttonShowImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpPlacementTaskPanel.this.mainPanel.taskBarActionShowPlacement();
                }
            });
        }
        return this.buttonShowImage;
    }

    public void setTaskButtonShowImage(boolean bl) {
        if (UtilMisc.getPermission(this.permissionArray, OmiMessage.PermissionType.Monitoring)) {
            this.buttonShowImage.setEnabled(bl);
        }
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigureTable.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterTable.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl, String string) {
        if (bl) {
            this.buttonFilterTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
        } else {
            this.buttonFilterTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
        }
        this.buttonFilterTable.setToolTipText(string);
    }

    private GuiUtilTableFilterDlg getRfpTableFilterDlg() {
        if (this.rfpTableFilterDlg == null) {
            UtilPreferences.TableFilterValuesKeyTypeEnum tableFilterValuesKeyTypeEnum = null;
            switch (this.tableType) {
                case PLACEMENT_TABLE_RFP: {
                    tableFilterValuesKeyTypeEnum = UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesRfpPlacement;
                    break;
                }
                case PLACEMENT_TABLE_BT: {
                    tableFilterValuesKeyTypeEnum = UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesBtBeaconPlacement;
                }
            }
            this.rfpTableFilterDlg = new GuiUtilTableFilterDlg(this.table, tableFilterValuesKeyTypeEnum);
        }
        return this.rfpTableFilterDlg;
    }
}

