/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.rfp.DevicePositionPanel;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.BluetoothBeaconHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.style.AastraMenuItem;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class RfpPlacementViewPanel
extends DevicePositionPanel
implements OmiMessageInterface,
GuiComponentActivationInterface,
RfpDataNotificationInterface,
BluetoothBeaconHandler.BtBeaconNotificationInterface {
    public static final int MAX_IMAGE_WIDTH = 3000;
    public static final int MAX_IMAGE_HEIGHT = 3000;
    private static final long serialVersionUID = 1L;
    private static final int RFP_RADIUS = 15;
    private static final Color infoBgColor = new Color(255, 255, 200);
    private static final Color infoTextColor = new Color(0, 100, 0);
    private static final Color btdColor = new Color(112, 219, 255);
    private static final int SYNC_GRAPH_TINY_FONT_SIZE = 12;
    private static final Font infoFontSmall = new Font("Monospaced", 0, 12);
    private static final Color[] rfpStateColors = new Color[]{Color.LIGHT_GRAY, Color.RED, Color.YELLOW, Color.GREEN};
    private static Color rectColor = new Color(0, 0, 255, 80);
    private RfpDatabase rfpDb;
    private RfpDataHandler rfpDataHandler;
    private BluetoothBeaconHandler btdHandler;
    private BluetoothBeaconHandler.BtBeaconDatabase btdDb;
    private CommonDataHandler commonDataHandler = null;
    private GuiStatusBar guiStatusBar = null;
    private boolean componentActive = false;
    private DevicePositionPanel.DevicePositionRecord mouseOverRecord;
    private boolean projectFileRead = false;
    private boolean projectFileReadRequested = false;
    private boolean rfpDbLoaded = false;
    private boolean btdDbLoaded = false;
    private String imageSourceDir = null;
    private String imageOutputDir = null;
    private AastraMenuItem mItemRemove = new AastraMenuItem(UtilLocale.getString("TXT_REMOVE_SELECTED_DEVICES"));
    private AastraMenuItem mItemResetView = new AastraMenuItem(UtilLocale.getString("TXT_RESET_VIEW"));
    private boolean imageScalingMode = false;
    private int scaleSquareSize = 256;
    public static double defaultZoom = 2.0;
    private int[] addRfpList = null;
    private int[] addBtdList = null;
    private ImageDb imageDb = null;
    private PositioningImage actImage = null;
    static Color rotTransparent1 = new Color(255, 0, 0, 80);
    static Color rotTransparent2 = new Color(255, 0, 0, 180);
    private boolean zoomImageFit = true;
    private static int[] rfpToolTipFieldIds = new int[]{RfpDataRecord.IDX_HIERARCHY1, RfpDataRecord.IDX_HIERARCHY2, RfpDataRecord.IDX_HIERARCHY3, RfpDataRecord.IDX_HIERARCHY4};
    private static int[] btToolTipFieldIds = new int[]{1, 4, 5, 6, 7};

    public RfpPlacementViewPanel(RfpDataHandler rfpDataHandler, BluetoothBeaconHandler bluetoothBeaconHandler, CommonDataHandler commonDataHandler) {
        this.rfpDb = rfpDataHandler.getDatabase();
        this.rfpDataHandler = rfpDataHandler;
        this.btdHandler = bluetoothBeaconHandler;
        if (this.btdHandler != null) {
            this.btdDb = (BluetoothBeaconHandler.BtBeaconDatabase)this.btdHandler.getDb();
            this.btdHandler.registerDataNotificationListener(this);
        }
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.commonDataHandler = commonDataHandler;
        this.imageDb = new ImageDb();
        this.initialize();
    }

    private void initialize() {
        this.setSize(627, 336);
        this.setLayout(new BorderLayout());
        this.setPositionEditMode(true);
        this.popupEdit.add(this.mItemRemove);
        this.mItemRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RfpPlacementViewPanel.this.noOfSelectedDevices != 0) {
                    GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageQuestion, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, GuiUtilDialog.GuiUtilDialogModalityEnum.Modal, UtilLocale.getString("TXT_REMOVE_SELECTED_DEVICES_?"), null, null, false);
                    if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                        int n = 0;
                        while (n < RfpPlacementViewPanel.this.positionIdx.noOfRecords) {
                            DevicePositionPanel.DevicePositionRecord devicePositionRecord = RfpPlacementViewPanel.this.positionIdx.arr[n];
                            if (devicePositionRecord != null) {
                                if ((devicePositionRecord.attrib & 0x10000) != 0) {
                                    RfpPlacementViewPanel.this.positionIdx.removeDevice(devicePositionRecord.deviceType, devicePositionRecord.id);
                                    if (RfpPlacementViewPanel.this.actImage != null) {
                                        RfpPlacementViewPanel.this.actImage.removeDevice(devicePositionRecord.id, devicePositionRecord.deviceType);
                                    }
                                    RfpPlacementViewPanel.this.setDeviceRecordToUnassigned(devicePositionRecord.deviceType, devicePositionRecord.id);
                                    continue;
                                }
                                ++n;
                                continue;
                            }
                            ++n;
                        }
                        RfpPlacementViewPanel.this.noOfSelectedDevices = 0;
                        RfpPlacementViewPanel.this.repaint();
                    }
                } else if (RfpPlacementViewPanel.this.actDevice != null) {
                    RfpPlacementViewPanel.this.positionIdx.removeDevice(RfpPlacementViewPanel.this.actDevice.deviceType, RfpPlacementViewPanel.this.actDevice.id);
                    if (RfpPlacementViewPanel.this.actImage != null) {
                        RfpPlacementViewPanel.this.actImage.removeDevice(RfpPlacementViewPanel.this.actDevice.id, RfpPlacementViewPanel.this.actDevice.deviceType);
                    }
                    RfpPlacementViewPanel.this.setDeviceRecordToUnassigned(RfpPlacementViewPanel.this.actDevice.deviceType, RfpPlacementViewPanel.this.actDevice.id);
                    RfpPlacementViewPanel.this.actDevice = null;
                    RfpPlacementViewPanel.this.repaint();
                }
            }
        });
        this.popupEdit.add(this.mItemResetView);
        this.mItemResetView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RfpPlacementViewPanel.this.resetZoomAndShift();
            }
        });
    }

    @Override
    protected void modifyEditMenu() {
        super.modifyEditMenu();
        if (this.noOfSelectedDevices == 0 && this.actDevice == null) {
            this.mItemRemove.setEnabled(false);
        } else {
            this.mItemRemove.setEnabled(true);
        }
    }

    public ImageDb getImageDb() {
        return this.imageDb;
    }

    public void removeImage(int n) {
        PositioningImage positioningImage = this.imageDb.getRecordById(n);
        if (positioningImage != null) {
            if (positioningImage.anzDevices > 0) {
                for (Device device : positioningImage.devList) {
                    if (device == null) continue;
                    this.setDeviceRecordToUnassigned(device.type, device.id);
                }
            }
            if (this.actImage == positioningImage) {
                this.actImage = null;
                this.showActImage();
                this.repaint();
            }
            this.imageDb.deleteImage(n);
        }
    }

    void setDeviceRecordToUnassigned(DevicePositionPanel.DeviceType deviceType, int n) {
        switch (deviceType) {
            case RFP: {
                RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
                if (rfpDataRecord == null) break;
                rfpDataRecord.locatingImageId = -1;
                rfpDataRecord.setField(RfpDataRecord.IDX_POSITIONED, (Object)false);
                rfpDataRecord.locatingXPos = 0;
                rfpDataRecord.locatingYPos = 0;
                break;
            }
            case BLUETOOTH: {
                BluetoothBeaconHandler.BtBeaconRec btBeaconRec;
                if (this.btdDb == null || (btBeaconRec = this.btdDb.getRecordById(n)) == null) break;
                btBeaconRec.locatingImageId = -1;
                btBeaconRec.setField(12, false);
                btBeaconRec.locatingXPos = 0;
                btBeaconRec.locatingYPos = 0;
                break;
            }
        }
    }

    private String makeDataDir() {
        String string = UtilFileHandling.getAppDataDirectory();
        try {
            string = string + File.separator + this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SystemName) + "_";
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemName.toString() + " failed");
            return null;
        }
        try {
            string = string + this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.PARK);
        }
        catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.PARK.toString() + " failed");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return string;
    }

    public void setImageSoureDir(String string) {
        this.imageSourceDir = string;
    }

    public String getImageSoureDir() {
        return this.imageSourceDir;
    }

    public void setImageOutputDir(String string) {
        this.imageOutputDir = string;
    }

    public String getImageOutputDir() {
        return this.imageOutputDir;
    }

    public void exportProject() {
    }

    public void writeProjectFile(String string, boolean bl) {
        Object object;
        Object object2;
        String string2;
        if (!this.projectFileRead) {
            return;
        }
        if (string != null) {
            string2 = string;
        } else {
            string2 = this.makeDataDir();
            if (string2 == null) {
                return;
            }
        }
        OmiMessage omiMessage = new OmiMessage("LocatingPositioningData");
        OmiMessage omiMessage2 = null;
        if (this.imageSourceDir != null) {
            omiMessage.addAttrib("ImageSourceDir", this.imageSourceDir);
        }
        if (this.imageOutputDir != null) {
            omiMessage.addAttrib("ImageOutputDir", this.imageOutputDir);
        }
        omiMessage.addAttrib("DefaultZoom", "" + defaultZoom);
        for (int i = 0; i < this.imageDb.noOfImages; ++i) {
            object2 = (PositioningImage)this.imageDb.getRecordByIdx(i);
            if (object2 == null) continue;
            object = null;
            omiMessage2 = omiMessage2 == null ? omiMessage.addSubElement("Image") : omiMessage2.addElement("Image");
            Dimension dimension = DevicePositionPanel.getImageDim(((PositioningImage)object2).fileName);
            if (bl) {
                omiMessage2.addAttrib("Name", ((PositioningImage)object2).fileName);
            } else {
                String[] stringArray = ((PositioningImage)object2).fileName.split(Pattern.quote(File.separator));
                omiMessage2.addAttrib("Name", stringArray[stringArray.length - 1]);
            }
            omiMessage2.addAttrib("Zoom", String.format("%5.2f", ((PositioningImage)object2).zoomScale));
            omiMessage2.addAttrib("SizeX", dimension.width);
            omiMessage2.addAttrib("SizeY", dimension.height);
            if (((PositioningImage)object2).anzDevices <= 0) continue;
            for (Device device : ((PositioningImage)object2).devList) {
                if (device == null) continue;
                int n = -1;
                int n2 = -1;
                switch (device.type) {
                    case RFP: {
                        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(device.id);
                        if (rfpDataRecord == null) break;
                        n = rfpDataRecord.locatingXPos;
                        n2 = rfpDataRecord.locatingYPos;
                        break;
                    }
                    case BLUETOOTH: {
                        BluetoothBeaconHandler.BtBeaconRec btBeaconRec;
                        if (this.btdDb == null || (btBeaconRec = this.btdDb.getRecordById(device.id)) == null) break;
                        n = btBeaconRec.locatingXPos;
                        n2 = btBeaconRec.locatingYPos;
                        break;
                    }
                }
                if (n == -1) continue;
                object = object == null ? omiMessage2.addSubElement("Device") : ((OmiMessage)object).addElement("Device");
                ((OmiMessage)object).addAttrib("Type", device.type.name());
                ((OmiMessage)object).addAttrib("Id", device.id);
                ((OmiMessage)object).addAttrib("XPos", n);
                ((OmiMessage)object).addAttrib("YPos", n2);
            }
        }
        String string3 = omiMessage.getXmlString();
        object2 = new File(string2 + File.separator + "locating_project.xml");
        if (((File)object2).exists()) {
            object = new File(string2 + File.separator + "locating_project.bak");
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            ((File)object2).renameTo((File)object);
        }
        try {
            object = new BufferedWriter(new FileWriter(string2 + File.separator + "locating_project.xml"));
            ((Writer)object).write(string3);
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Writing " + string2 + File.separator + "locating_project.xml" + " failed");
        }
    }

    public void clearProject() {
        int n = this.imageDb.noOfUsedIds;
        for (int i = 0; i < n; ++i) {
            this.removeImage(i);
        }
        this.imageDb.clearAll();
        this.actImage = null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readProjectFile(String string, String string2) {
        Object object;
        String string3;
        String string4;
        if (string2 == null) {
            string4 = this.makeDataDir();
            if (string4 == null) {
                return;
            }
            string3 = null;
            File file = new File(string4 + File.separator + "locating_project.xml");
            if (file.exists()) {
                string3 = string4 + File.separator + "locating_project.xml";
            } else {
                file = new File(string4 + File.separator + "locating_project.bak");
                if (!file.exists()) return;
                string3 = string4 + File.separator + "locating_project.bak";
            }
        } else {
            string3 = string2;
            string4 = string;
        }
        String string5 = null;
        try {
            object = new BufferedReader(new FileReader(string3));
            string5 = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Reading " + string3 + " failed");
            GuiInfoConsole.showError(UtilLocale.getString("TXT_FILE_ACCESS_FAILED") + " (" + string3 + ")");
            return;
        }
        if (string5 == null) return;
        object = OmiMessage.convertXmlString(string5);
        if (object == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "device placement: reading projectfile failed - XML conversion error");
            GuiInfoConsole.showError(UtilLocale.getString("TXT_FILE_FORMAT_INVALID") + " (" + string3 + ")");
            return;
        }
        if (!((OmiMessage)object).getElemName().equals("LocatingPositioningData")) return;
        this.imageSourceDir = ((OmiMessage)object).getAttribVal("ImageSourceDir");
        this.imageOutputDir = ((OmiMessage)object).getAttribVal("ImageOutputDir");
        String string6 = ((OmiMessage)object).getAttribVal("DefaultZoom");
        if (string6 != null) {
            try {
                defaultZoom = Double.parseDouble(string6.replaceAll(",", "."));
            }
            catch (Exception exception) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "device placement: reading default overview scale value failed");
                defaultZoom = 2.0;
            }
        }
        for (OmiMessage omiMessage = ((OmiMessage)object).getSubElement(); omiMessage != null; omiMessage = omiMessage.getNext()) {
            void var10_12;
            String string7 = omiMessage.getAttribVal("Name");
            if (string2 != null) {
                if (string7.contains(File.separator)) {
                    Object var10_14 = null;
                } else {
                    String string8 = string4 + File.separator + string7;
                }
            }
            if (var10_12 == null) continue;
            File file = new File((String)var10_12);
            if (file.exists()) {
                if (!this.addImage((String)var10_12, false)) continue;
                string6 = omiMessage.getAttribVal("Zoom");
                if (string6 != null) {
                    try {
                        this.actImage.zoomScale = Double.parseDouble(string6.replaceAll(",", "."));
                    }
                    catch (Exception exception) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "device placement: reading overview scale value failed");
                        this.actImage.zoomScale = 2.0;
                    }
                }
                for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    DataRecord dataRecord;
                    String string9 = omiMessage2.getAttribVal("Type");
                    int n = omiMessage2.getAttribValInt("Id");
                    int n2 = omiMessage2.getAttribValInt("XPos");
                    int n3 = omiMessage2.getAttribValInt("YPos");
                    if (string9.equals(DevicePositionPanel.DeviceType.RFP.name())) {
                        dataRecord = this.rfpDb.getRfpByRfpId(n);
                        if (dataRecord == null) continue;
                        ((RfpDataRecord)dataRecord).locatingXPos = n2;
                        ((RfpDataRecord)dataRecord).locatingYPos = n3;
                        ((RfpDataRecord)dataRecord).locatingImageId = this.actImage.id;
                        ((RfpDataRecord)dataRecord).setField(RfpDataRecord.IDX_POSITIONED, true);
                        this.actImage.addDevice(n, DevicePositionPanel.DeviceType.RFP);
                        this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, n, ((RfpDataRecord)dataRecord).locatingXPos, ((RfpDataRecord)dataRecord).locatingYPos);
                        continue;
                    }
                    if (!string9.equals(DevicePositionPanel.DeviceType.BLUETOOTH.name()) || this.btdDb == null || (dataRecord = this.btdDb.getRecordById(n)) == null) continue;
                    ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingXPos = n2;
                    ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingYPos = n3;
                    ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingImageId = this.actImage.id;
                    ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).setField(12, true);
                    this.actImage.addDevice(n, DevicePositionPanel.DeviceType.BLUETOOTH);
                    this.positionIdx.addDevice(DevicePositionPanel.DeviceType.BLUETOOTH, n, ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingXPos, ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingYPos);
                }
                continue;
            }
            GuiInfoConsole.showWarning(String.format(UtilLocale.getString("TXT_FILE_*_NOT_FOUND"), var10_12));
        }
        this.showActImage();
        this.repaint();
    }

    BufferedImage getScaledImage(BufferedImage bufferedImage, double d) {
        while (d > 1.0) {
            int n;
            int n2;
            if (d > 2.0) {
                n2 = bufferedImage.getWidth() / 2;
                n = bufferedImage.getHeight() / 2;
                d /= 2.0;
            } else {
                n2 = (int)(1.0 * (double)bufferedImage.getWidth() / d);
                n = (int)(1.0 * (double)bufferedImage.getHeight() / d);
                d = 1.0;
            }
            BufferedImage bufferedImage2 = new BufferedImage(n2, n, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(bufferedImage, 0, 0, n2, n, null);
            graphics2D.dispose();
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    public boolean generateLocatingImageTiles(int n, String string, int n2, double d) {
        int n3 = 256;
        PositioningImage positioningImage = this.imageDb.getRecordById(n);
        if (positioningImage != null) {
            try {
                int n4;
                int n5;
                File file = new File(positioningImage.fileName);
                BufferedImage bufferedImage = ImageIO.read(file);
                if (d != 1.0) {
                    n5 = (int)((double)bufferedImage.getWidth() * d);
                    n4 = (int)((double)bufferedImage.getHeight() * d);
                    BufferedImage bufferedImage2 = new BufferedImage(n5, n4, 1);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.drawImage(bufferedImage, 0, 0, n5, n4, null);
                    graphics2D.dispose();
                    bufferedImage = bufferedImage2;
                }
                n5 = bufferedImage.getWidth() / n3;
                n4 = bufferedImage.getHeight() / n3;
                if (bufferedImage.getWidth() % n3 != 0) {
                    ++n5;
                }
                if (bufferedImage.getHeight() % n3 != 0) {
                    ++n4;
                }
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        BufferedImage bufferedImage3 = new BufferedImage(n3, n3, 1);
                        Graphics2D graphics2D = bufferedImage3.createGraphics();
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.fillRect(0, 0, n3, n3);
                        graphics2D.drawImage(bufferedImage, -i * n3, -j * n3, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                        String string2 = file.getName();
                        int n6 = string2.lastIndexOf(46);
                        if (n6 > 0) {
                            string2 = string2.substring(0, n6);
                        }
                        File file2 = new File(string + File.separator + string2 + "_" + String.format("%02d", i) + "_" + String.format("%02d", j) + "_" + String.format("%02d", n2) + ".png");
                        ImageIO.write((RenderedImage)bufferedImage3, "png", file2);
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public boolean generateLocatingImages(int n, String string) {
        PositioningImage positioningImage = this.imageDb.getRecordById(n);
        if (positioningImage != null) {
            try {
                if (positioningImage.anzDevices > 0) {
                    BufferedImage bufferedImage = ImageIO.read(new File(positioningImage.fileName));
                    int n2 = 0;
                    int n3 = 0;
                    double d = positioningImage.zoomScale;
                    this.zoomImageFit = false;
                    BufferedImage bufferedImage2 = this.getScaledImage(bufferedImage, d);
                    for (Device device : positioningImage.devList) {
                        Object object;
                        Object object2;
                        if (device == null) continue;
                        int n4 = 0;
                        int n5 = 0;
                        String string2 = null;
                        switch (device.type) {
                            case RFP: {
                                object2 = this.rfpDb.getRfpByRfpId(device.id);
                                if (object2 == null) break;
                                n4 = ((RfpDataRecord)object2).locatingXPos;
                                n5 = ((RfpDataRecord)object2).locatingYPos;
                                string2 = (String)((RfpDataRecord)object2).getField(RfpDataRecord.IDX_ETH_ADDR);
                                break;
                            }
                            case BLUETOOTH: {
                                object = this.btdDb.getRecordById(device.id);
                                if (object == null) break;
                                n4 = ((BluetoothBeaconHandler.BtBeaconRec)object).locatingXPos;
                                n5 = ((BluetoothBeaconHandler.BtBeaconRec)object).locatingYPos;
                                string2 = (String)((BluetoothBeaconHandler.BtBeaconRec)object).getField(RfpDataRecord.IDX_ETH_ADDR);
                                break;
                            }
                        }
                        if (string2 == null) continue;
                        object2 = new BufferedImage(256, 256, 1);
                        object = ((BufferedImage)object2).createGraphics();
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        ((Graphics)object).setColor(Color.WHITE);
                        ((Graphics)object).fillRect(0, 0, 256, 256);
                        if (this.zoomImageFit) {
                            ((Graphics)object).drawImage(bufferedImage2, n2, n3, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
                            ((Graphics)object).setColor(rotTransparent1);
                            ((Graphics)object).fillOval((int)((double)n4 / d - 40.0) + n2, (int)((double)n5 / d - 40.0) + n3, 80, 80);
                            ((Graphics)object).setColor(rotTransparent2);
                            ((Graphics)object).fillOval((int)((double)n4 / d - 10.0) + n2, (int)((double)n5 / d - 10.0) + n3, 20, 20);
                        } else {
                            int n6 = (int)((double)n4 / d);
                            int n7 = (int)((double)n5 / d);
                            int n8 = 128 - n6;
                            int n9 = 128 - n7;
                            n6 = 128;
                            n7 = 128;
                            int n10 = bufferedImage2.getWidth();
                            if (n10 > 256) {
                                if (n8 + n10 < 256) {
                                    n6 += 256 - (n8 + n10);
                                    n8 = 256 - n10;
                                } else if (n8 > 0) {
                                    n6 -= n8;
                                    n8 = 0;
                                }
                            } else {
                                n2 = (256 - n10) / 2;
                                n6 -= n8 - n2;
                                n8 = n2;
                            }
                            int n11 = bufferedImage2.getHeight();
                            if (n11 > 256) {
                                if (n9 + n11 < 256) {
                                    n7 += 256 - (n9 + n11);
                                    n9 = 256 - n11;
                                } else if (n9 > 0) {
                                    n7 -= n9;
                                    n9 = 0;
                                }
                            } else {
                                n3 = (256 - n11) / 2;
                                n7 -= n9 - n3;
                                n9 = n3;
                            }
                            ((Graphics)object).drawImage(bufferedImage2, n8, n9, n10, n11, null);
                            ((Graphics)object).setColor(rotTransparent1);
                            ((Graphics)object).fillOval(n6 - 40, n7 - 40, 80, 80);
                            ((Graphics)object).setColor(rotTransparent2);
                            ((Graphics)object).fillOval(n6 - 10, n7 - 10, 20, 20);
                        }
                        ((Graphics)object).dispose();
                        String string3 = string2.replaceAll(":", "");
                        File file = new File(string + File.separator + string3 + ".png");
                        ImageIO.write((RenderedImage)object2, "png", file);
                        object = ((BufferedImage)object2).createGraphics();
                        ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        ((Graphics)object).setColor(Color.WHITE);
                        ((Graphics)object).fillRect(0, 0, 256, 256);
                        ((Graphics)object).drawImage(bufferedImage, 128 - n4, 128 - n5, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                        file = new File(string + File.separator + string3 + "-zoom.png");
                        ImageIO.write((RenderedImage)object2, "png", file);
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected void handleRightClickOnDevice(DevicePositionPanel.DevicePositionRecord devicePositionRecord, Component component, int n, int n2) {
    }

    @Override
    protected void deviceSelectedByLeftMouseButton(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
    }

    @Override
    protected void setNewDevicePosition(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        switch (devicePositionRecord.deviceType) {
            case RFP: {
                RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id);
                if (rfpDataRecord == null) break;
                rfpDataRecord.locatingXPos = devicePositionRecord.xm;
                rfpDataRecord.locatingYPos = devicePositionRecord.ym;
                rfpDataRecord.locatingImageId = this.actImage.id;
                break;
            }
            case BLUETOOTH: {
                BluetoothBeaconHandler.BtBeaconRec btBeaconRec;
                if (this.btdDb == null || (btBeaconRec = this.btdDb.getRecordById(devicePositionRecord.id)) == null) break;
                btBeaconRec.locatingXPos = devicePositionRecord.xm;
                btBeaconRec.locatingYPos = devicePositionRecord.ym;
                btBeaconRec.locatingImageId = this.actImage.id;
                break;
            }
            case CORNER: {
                DevicePositionPanel.DevicePositionRecord devicePositionRecord2 = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.MOVEPOINT, 0);
                this.scaleSquareSize = (devicePositionRecord.xm - devicePositionRecord2.xm) * 2;
                if (this.scaleSquareSize < 40) {
                    this.scaleSquareSize = 40;
                }
                devicePositionRecord.newCoordinates(devicePositionRecord2.xm + this.scaleSquareSize / 2, devicePositionRecord2.ym - this.scaleSquareSize / 2);
                this.positionIdx.newCoordinates(DevicePositionPanel.DeviceType.CORNER, 0);
                this.repaint();
                break;
            }
            case MOVEPOINT: {
                DevicePositionPanel.DevicePositionRecord devicePositionRecord3 = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.CORNER, 0);
                devicePositionRecord3.newCoordinates(devicePositionRecord.xm + this.scaleSquareSize / 2, devicePositionRecord.ym - this.scaleSquareSize / 2);
                this.positionIdx.newCoordinates(DevicePositionPanel.DeviceType.CORNER, 0);
                this.repaint();
            }
        }
    }

    @Override
    protected void mouseMovedToDevice(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        this.mouseOverRecord = devicePositionRecord;
        this.repaint();
    }

    private void paintInfoBox(Graphics2D graphics2D, int n, int n2, String[] stringArray, int n3) {
        if (n3 <= 0) {
            return;
        }
        if (stringArray == null) {
            return;
        }
        if (n3 > stringArray.length) {
            return;
        }
        if (!this.isPointInDrawingArea(n, n2)) {
            return;
        }
        if (this.saveAT != null) {
            graphics2D.setTransform(this.saveAT);
            Point point = new Point(n, n2);
            this.aTransform.transform(point, point);
            n = point.x;
            n2 = point.y;
        }
        Font font = graphics2D.getFont();
        int n4 = font.getSize() + 2;
        int n5 = n4 + 2 + (n3 - 1) * 12 + 4 + 4;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, 216.0, n5, 10.0, 10.0);
        graphics2D.setColor(infoBgColor);
        graphics2D.fill(double_);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(double_);
        if (stringArray[0] != null) {
            graphics2D.drawString(stringArray[0], n + 10, n2 + n4);
        }
        graphics2D.setFont(infoFontSmall);
        graphics2D.setColor(infoTextColor);
        for (int i = 1; i < n3; ++i) {
            if (stringArray[i] == null) continue;
            graphics2D.drawString(stringArray[i], n + 10, n2 + n4 + 2 + i * 12);
        }
        graphics2D.setFont(font);
    }

    @Override
    public void paintDevice(Graphics2D graphics2D, int n, DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        if (devicePositionRecord != null) {
            int n2 = devicePositionRecord.xm;
            int n3 = devicePositionRecord.ym;
            if (!this.isPointInDrawingArea(n2, n3)) {
                return;
            }
            int n4 = devicePositionRecord.id;
            String string = String.format("%03X", n4);
            int n5 = 30;
            int n6 = 30;
            switch (devicePositionRecord.deviceType) {
                case RFP: {
                    OmiMessage.RFPSyncStateType rFPSyncStateType = OmiMessage.RFPSyncStateType.Synced;
                    Color color = rfpStateColors[rFPSyncStateType.ordinal()];
                    if (n == 4) {
                        graphics2D.setColor(Color.GREEN);
                        graphics2D.fillOval(n2 - n5 / 6, n3 - n6 / 6, n5 / 3, n6 / 3);
                        break;
                    }
                    graphics2D.setColor(color);
                    graphics2D.fillOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    graphics2D.setColor(Color.BLACK);
                    if ((devicePositionRecord.attrib & 0x10000) != 0) {
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setStroke(arrowStroke);
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                        graphics2D.setStroke(stroke);
                    } else {
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    }
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawString(string, n2 - n5 / 2 + n5 / 6, n3 - n6 / 2 + 2 * n6 / 3);
                    break;
                }
                case BLUETOOTH: {
                    graphics2D.setColor(btdColor);
                    graphics2D.fillOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    graphics2D.setColor(Color.BLACK);
                    if ((devicePositionRecord.attrib & 0x10000) != 0) {
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setStroke(arrowStroke);
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                        graphics2D.setStroke(stroke);
                    } else {
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    }
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawString(string, n2 - n5 / 2 + n5 / 6, n3 - n6 / 2 + 2 * n6 / 3);
                    break;
                }
                case CORNER: {
                    graphics2D.setColor(Color.CYAN);
                    graphics2D.fillOval(n2 - 10, n3 - 10, 20, 20);
                    break;
                }
                case MOVEPOINT: {
                    graphics2D.setColor(Color.PINK);
                    graphics2D.fillOval(n2 - 15, n3 - 15, 30, 30);
                }
            }
        }
    }

    @Override
    protected void paintBackground(Graphics2D graphics2D) {
        super.paintBackground(graphics2D);
    }

    @Override
    protected void paintAdditionalElements(Graphics2D graphics2D) {
        String[] stringArray;
        if (this.mouseOverRecord != null) {
            stringArray = null;
            switch (this.mouseOverRecord.deviceType) {
                case RFP: {
                    RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(this.mouseOverRecord.id);
                    if (rfpDataRecord == null) break;
                    stringArray = new String[rfpToolTipFieldIds.length + 1];
                    stringArray[0] = String.format("RFP 0x%03X (%s)", rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), rfpDataRecord.getField(RfpDataRecord.IDX_NAME));
                    int n = 1;
                    for (int i = 0; i < rfpToolTipFieldIds.length; ++i) {
                        stringArray[n] = (String)rfpDataRecord.getField(rfpToolTipFieldIds[i]);
                        if (stringArray[n] == null || stringArray[n].equals("")) continue;
                        ++n;
                    }
                    this.paintInfoBox(graphics2D, this.mouseOverRecord.xm, this.mouseOverRecord.ym, stringArray, n);
                    break;
                }
                case BLUETOOTH: {
                    BluetoothBeaconHandler.BtBeaconRec btBeaconRec = this.btdDb.getRecordById(this.mouseOverRecord.id);
                    if (btBeaconRec == null) break;
                    stringArray = new String[btToolTipFieldIds.length + 1];
                    stringArray[0] = String.format("BT 0x%03X (%s)", btBeaconRec.getField(0), (String)btBeaconRec.getField(3));
                    int n = 1;
                    for (int i = 0; i < btToolTipFieldIds.length; ++i) {
                        stringArray[n] = (String)btBeaconRec.getField(btToolTipFieldIds[i]);
                        if (stringArray[n] == null || stringArray[n].equals("")) continue;
                        ++n;
                    }
                    this.paintInfoBox(graphics2D, this.mouseOverRecord.xm, this.mouseOverRecord.ym, stringArray, n);
                    break;
                }
                case CORNER: {
                    break;
                }
            }
        }
        if (this.imageScalingMode) {
            stringArray = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.MOVEPOINT, 0);
            graphics2D.setColor(rectColor);
            graphics2D.fillRect(stringArray.xm - this.scaleSquareSize / 2, stringArray.ym - this.scaleSquareSize / 2, this.scaleSquareSize, this.scaleSquareSize);
        }
    }

    private void rebuildRfpPositionIndex() {
        DataRecord dataRecord;
        int n;
        if (this.addRfpList != null) {
            for (n = 0; n < this.addRfpList.length; ++n) {
                dataRecord = this.rfpDb.getRfpByRfpId(this.addRfpList[n]);
                this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, this.addRfpList[n], dataRecord.locatingXPos, dataRecord.locatingYPos);
                if (this.actImage == null) continue;
                this.actImage.addDevice(this.addRfpList[n], DevicePositionPanel.DeviceType.RFP);
            }
            this.addRfpList = null;
        }
        if (this.addBtdList != null && this.btdDb != null) {
            for (n = 0; n < this.addBtdList.length; ++n) {
                dataRecord = this.btdDb.getRecordById(this.addBtdList[n]);
                this.positionIdx.addDevice(DevicePositionPanel.DeviceType.BLUETOOTH, this.addBtdList[n], ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingXPos, ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingYPos);
                if (this.actImage == null) continue;
                this.actImage.addDevice(this.addBtdList[n], DevicePositionPanel.DeviceType.BLUETOOTH);
            }
            this.addBtdList = null;
        }
    }

    private void readProjectFileIfDataAvaillable() {
        if (!this.projectFileRead && this.projectFileReadRequested) {
            if (this.btdDb != null) {
                if (this.btdDbLoaded && this.rfpDbLoaded) {
                    this.readProjectFile(null, null);
                    this.projectFileRead = true;
                }
            } else if (this.rfpDbLoaded) {
                this.readProjectFile(null, null);
                this.projectFileRead = true;
            }
        }
    }

    public void triggerProjectFileRead() {
        if (this.btdHandler != null) {
            this.btdHandler.start();
        }
        this.projectFileReadRequested = true;
        if (!this.projectFileRead) {
            this.readProjectFileIfDataAvaillable();
        }
    }

    public void setImageScalingMode(boolean bl) {
        this.imageScalingMode = bl;
    }

    @Override
    public void componentActivated(Component component) {
        if (!this.projectFileRead) {
            this.triggerProjectFileRead();
        } else if (this.addRfpList != null || this.addBtdList != null) {
            this.rebuildRfpPositionIndex();
        }
        if (this.imageScalingMode) {
            if (this.actImage != null) {
                this.positionIdx.clear();
                this.scaleSquareSize = (int)(256.0 * this.actImage.zoomScale);
                int n = this.scaleSquareSize / 2 + 10;
                int n2 = this.scaleSquareSize / 2 + 10;
                this.positionIdx.addDevice(DevicePositionPanel.DeviceType.MOVEPOINT, 0, n, n2);
                this.positionIdx.addDevice(DevicePositionPanel.DeviceType.CORNER, 0, n + this.scaleSquareSize / 2, n2 - this.scaleSquareSize / 2);
            }
        } else if (this.actImage != null) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_INFO, "Image " + this.actImage.id + " - " + this.actImage.fileName);
        }
        this.componentActive = true;
    }

    @Override
    public void componentDeactivated() {
        this.componentActive = false;
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.imageScalingMode) {
            this.positionIdx.clear();
            if (this.actImage != null) {
                this.actImage.zoomScale = 1.0 * (double)this.scaleSquareSize / 256.0;
                this.showActImage();
            }
        }
        this.writeProjectFile(null, true);
        this.setImageScalingMode(false);
    }

    public boolean imageLoaded() {
        return this.actImage != null;
    }

    public int getActImageId() {
        if (this.actImage != null) {
            return this.actImage.id;
        }
        return -1;
    }

    public void setSelectedRfpArray(int[] nArray) {
        if (this.actImage != null) {
            this.addRfpList = nArray;
            if (this.componentActive) {
                this.rebuildRfpPositionIndex();
                this.repaint();
            }
        }
    }

    public void setSelectedBtdArray(int[] nArray) {
        if (this.actImage != null) {
            this.addBtdList = nArray;
            if (this.componentActive) {
                this.rebuildRfpPositionIndex();
                this.repaint();
            }
        }
    }

    public boolean showActImage() {
        if (this.actImage != null) {
            if (this.setBackgroundImage(this.actImage.fileName)) {
                this.positionIdx.clear();
                if (this.actImage.anzDevices > 0) {
                    for (Device device : this.actImage.devList) {
                        DataRecord dataRecord;
                        if (device == null) continue;
                        if (device.type == DevicePositionPanel.DeviceType.RFP) {
                            dataRecord = this.rfpDb.getRfpByRfpId(device.id);
                            if (dataRecord == null) continue;
                            this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, device.id, dataRecord.locatingXPos, dataRecord.locatingYPos);
                            continue;
                        }
                        if (device.type != DevicePositionPanel.DeviceType.BLUETOOTH || this.btdDb == null || (dataRecord = this.btdDb.getRecordById(device.id)) == null) continue;
                        this.positionIdx.addDevice(DevicePositionPanel.DeviceType.BLUETOOTH, device.id, ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingXPos, ((BluetoothBeaconHandler.BtBeaconRec)dataRecord).locatingYPos);
                    }
                }
                return true;
            }
        } else {
            this.setBackgroundImage(null);
            this.positionIdx.clear();
        }
        return false;
    }

    public boolean addImage(String string, boolean bl) {
        Dimension dimension = RfpPlacementViewPanel.getImageDim(string);
        if (dimension == null) {
            return false;
        }
        if (dimension.height > 3000) {
            return false;
        }
        if (dimension.width > 3000) {
            return false;
        }
        this.actImage = this.imageDb.addImage(string);
        if (bl) {
            return this.showActImage();
        }
        return true;
    }

    public void setActiveImage(int n) {
        this.actImage = this.imageDb.getRecordById(n);
        this.showActImage();
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_RFP_CHANGED_CNF: 
            case DATA_RFP_CHANGED_RESP: {
                break;
            }
            case DATA_DELETED: {
                DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.RFP, n);
                if (devicePositionRecord == null) break;
                this.positionIdx.removeDevice(DevicePositionPanel.DeviceType.RFP, n);
                this.repaint();
                break;
            }
            case DATA_BULK_READY: {
                this.rfpDbLoaded = true;
                this.readProjectFileIfDataAvaillable();
                break;
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processBtdDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processBtdDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "BTD notification: " + dataNotificationEnum.toString() + ",btdId=" + n);
        switch (dataNotificationEnum) {
            case DATA_DELETED: {
                DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.BLUETOOTH, n);
                if (devicePositionRecord == null) break;
                this.positionIdx.removeDevice(DevicePositionPanel.DeviceType.BLUETOOTH, n);
                this.repaint();
                break;
            }
            case DATA_BULK_READY: {
                this.btdDbLoaded = true;
                this.readProjectFileIfDataAvaillable();
                break;
            }
        }
    }

    public boolean getProjectFileRead() {
        return this.projectFileRead;
    }

    public static class ImageDb
    extends Database {
        public static final int MAX_IMAGES = 800;
        PositioningImage[] images = new PositioningImage[800];
        int noOfUsedIds = 0;
        int[] imageIdx = new int[800];
        int noOfImages = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfImages) {
                return this.images[this.imageIdx[n]];
            }
            return null;
        }

        public PositioningImage getRecordById(int n) {
            if (n >= 0 && n < 800) {
                return this.images[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfImages;
        }

        @Override
        public void updateIndex() {
            this.noOfImages = 0;
            for (int i = 0; i < this.noOfUsedIds; ++i) {
                if (this.images[i] == null) continue;
                this.imageIdx[this.noOfImages++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public PositioningImage addImage(String string) {
            int n = -1;
            for (int i = 0; i < this.noOfUsedIds; ++i) {
                if (this.images[i] != null) {
                    if (!this.images[i].fileName.equals(string)) continue;
                    return this.images[i];
                }
                n = i;
            }
            if (n == -1) {
                n = this.noOfUsedIds++;
            }
            if (n >= 800) {
                return null;
            }
            this.images[n] = new PositioningImage(string);
            this.images[n].id = n;
            this.updateIndex();
            return this.images[n];
        }

        public void deleteImage(int n) {
            if (n >= 0 && n < 800) {
                this.images[n] = null;
                if (n == this.noOfUsedIds - 1) {
                    --this.noOfUsedIds;
                }
                this.updateIndex();
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfUsedIds; ++i) {
                this.images[i] = null;
            }
            this.noOfImages = 0;
            this.noOfUsedIds = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return PositioningImage.getFieldNames();
        }
    }

    public static class PositioningImage
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int NUMBER_OF_FIELDS = 2;
        public String fileName;
        public int id;
        public int anzDevices = 0;
        public LinkedList<Device> devList = new LinkedList();
        public double zoomScale;
        public int scaleSquareSize = -1;
        private static String[] fieldNames = new String[]{"id", "name"};

        PositioningImage(String string) {
            this.fileName = string;
            this.zoomScale = defaultZoom;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 2) {
                PositioningImage.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.fileName;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            return this;
        }

        void addDevice(int n, DevicePositionPanel.DeviceType deviceType) {
            if (this.anzDevices > 0) {
                for (Device device : this.devList) {
                    if (device == null || device.id != n || device.type != deviceType) continue;
                    return;
                }
            }
            Device device = new Device(n, deviceType);
            ++this.anzDevices;
            this.devList.add(device);
        }

        void removeDevice(int n, DevicePositionPanel.DeviceType deviceType) {
            if (this.anzDevices > 0) {
                for (Device device : this.devList) {
                    if (device == null || device.id != n || device.type != deviceType) continue;
                    this.devList.remove(device);
                    if (this.anzDevices > 0) {
                        --this.anzDevices;
                    }
                    return;
                }
            }
        }

        void removeAllDevices() {
            this.devList.clear();
            this.anzDevices = 0;
        }
    }

    private static class Device {
        int id;
        DevicePositionPanel.DeviceType type;

        Device(int n, DevicePositionPanel.DeviceType deviceType) {
            this.id = n;
            this.type = deviceType;
        }
    }
}

