/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.rfp.DevicePositionPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.style.AastraMenuItem;
import com.aastra.style.AastraPopupMenu;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;

public class RfpSyncViewPanel
extends DevicePositionPanel
implements OmiMessageInterface,
GuiComponentActivationInterface,
RfpDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int RFP_RADIUS = 15;
    private static final int RFP_ATTRIB_SYNC_VIEW_SELECTION = 1;
    private static final int RFP_ATTRIB_SYNC_VIEW_REFERENCED = 2;
    private static final Color infoBgColor = new Color(255, 255, 200);
    private static final Color infoTextColor = new Color(0, 100, 0);
    private static final int SYNC_GRAPH_TINY_FONT_SIZE = 12;
    private static final Font infoFontSmall = new Font("Monospaced", 0, 12);
    private static final Color[] rfpStateColors = new Color[]{Color.LIGHT_GRAY, Color.RED, Color.YELLOW, Color.GREEN};
    private static final Color[] syncRelationColors = new Color[]{Color.RED, Color.ORANGE, Color.ORANGE.brighter(), Color.GREEN, Color.GREEN, Color.GREEN};
    private RfpDatabase rfpDb;
    private RfpDataHandler rfpDataHandler;
    private OmiManagement omiManagement;
    private boolean componentActive = false;
    private DevicePositionPanel.DevicePositionRecord mouseOverRecord;
    private AastraPopupMenu popupAdd = new AastraPopupMenu();
    private AastraMenuItem mItemAdd = new AastraMenuItem(UtilLocale.getString("TXT_ACTIVATE_MONITORING"));
    private boolean showAllRfp = false;
    private int rssiThreshold = 0;
    private static final int MAX_RFP_PER_SYNC_DATA_REQ = 10;
    private int nextSyncDataReqIdx = 0;
    private int nextLastExpectedRfpId = -1;
    private int anzMonitoredRfp = 0;
    private int[] requestedMonitoredRfpList = null;
    private static final int MAX_RELATIONS = 1000;
    private int anzRegisteredRelations = 0;
    private DevicePositionPanel.relGraphicData gd = new DevicePositionPanel.relGraphicData();

    public RfpSyncViewPanel(RfpDataHandler rfpDataHandler) {
        this.rfpDb = rfpDataHandler.getDatabase();
        this.rfpDataHandler = rfpDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.rfpDataHandler.registerSyncMsgListener(this);
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setSize(627, 336);
        this.setLayout(new BorderLayout());
        this.popupAdd.add(this.mItemAdd);
        this.mItemAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RfpSyncViewPanel.this.actDevice != null) {
                    if (RfpSyncViewPanel.this.anzRegisteredRelations < 1000) {
                        RfpDataRecord rfpDataRecord = RfpSyncViewPanel.this.rfpDb.getRfpByRfpId(RfpSyncViewPanel.this.actDevice.id);
                        RfpSyncViewPanel.this.actDevice.attrib |= 1;
                        RfpSyncViewPanel.this.rfpDataHandler.subscribeForSyncRelation(RfpSyncViewPanel.this.actDevice.id);
                        RfpSyncViewPanel.this.sendGetRfpSync(rfpDataRecord);
                    } else {
                        GuiInfoConsole.showInfo(UtilLocale.getString("TXT_SYNCHRONIZATION_VIEW_20") + ": " + UtilLocale.getString("TXT_MAXIMUM_NUMBER_OF_DRAWABLE_RELATIONS_REACHED") + " " + UtilLocale.getString("TXT_CANNOT_MONITOR_FURTHER_RFPS"));
                    }
                }
            }
        });
    }

    @Override
    protected void handleRightClickOnDevice(DevicePositionPanel.DevicePositionRecord devicePositionRecord, Component component, int n, int n2) {
        this.popupAdd.show(component, n, n2);
    }

    @Override
    protected void deviceSelectedByLeftMouseButton(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
    }

    @Override
    protected void setNewDevicePosition(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id);
        rfpDataRecord.setField(RfpDataRecord.IDX_XPOS, (Object)("" + devicePositionRecord.xm));
        rfpDataRecord.setField(RfpDataRecord.IDX_YPOS, (Object)("" + devicePositionRecord.ym));
        this.rfpDataHandler.setRfpPosition(devicePositionRecord.id, devicePositionRecord.xm, devicePositionRecord.ym);
    }

    @Override
    protected void mouseMovedToDevice(DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        this.mouseOverRecord = devicePositionRecord;
        this.repaint();
    }

    private void paintInfoBox(Graphics2D graphics2D, int n, int n2, RfpDataRecord rfpDataRecord, boolean bl) {
        if (!this.isPointInDrawingArea(n, n2)) {
            return;
        }
        if (this.saveAT != null) {
            graphics2D.setTransform(this.saveAT);
            Point point = new Point(n, n2);
            this.aTransform.transform(point, point);
            n = point.x;
            n2 = point.y;
        }
        int n3 = 0;
        if (bl && rfpDataRecord.forwardRels != null) {
            int n4;
            for (n4 = 0; n4 < rfpDataRecord.maxForwardRelNumber; ++n4) {
                if (rfpDataRecord.forwardRels[n4] == null || rfpDataRecord.forwardRels[n4].rssi < this.rssiThreshold) continue;
                ++n3;
            }
            for (n4 = 0; n4 < rfpDataRecord.maxBackwardRelNumber; ++n4) {
                if (rfpDataRecord.backwardRels[n4] == null || rfpDataRecord.backwardRels[n4].rssi < this.rssiThreshold) continue;
                ++n3;
            }
        }
        Font font = graphics2D.getFont();
        int n5 = font.getSize() + 2;
        int n6 = n5 + 2 + n3 * 12 + 4 + 4;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, 216.0, n6, 10.0, 10.0);
        graphics2D.setColor(infoBgColor);
        graphics2D.fill(double_);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(double_);
        String string = String.format("RFP %03X (%s)", rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID), rfpDataRecord.getField(RfpDataRecord.IDX_NAME));
        graphics2D.drawString(string, n + 10, n2 + n5);
        graphics2D.setFont(infoFontSmall);
        graphics2D.setColor(infoTextColor);
        if (bl) {
            int n7;
            n3 = 0;
            if (rfpDataRecord.forwardRels != null) {
                for (n7 = 0; n7 < rfpDataRecord.maxForwardRelNumber; ++n7) {
                    if (rfpDataRecord.forwardRels[n7] == null || rfpDataRecord.forwardRels[n7].rssi < this.rssiThreshold) continue;
                    string = String.format(">> RFP %03X (rssi = %d dBm)", rfpDataRecord.forwardRels[n7].id, rfpDataRecord.forwardRels[n7].rssi - 100);
                    graphics2D.drawString(string, n + 10, n2 + n5 + 2 + (n3 + 1) * 12);
                    ++n3;
                }
            }
            if (rfpDataRecord.backwardRels != null) {
                for (n7 = 0; n7 < rfpDataRecord.maxBackwardRelNumber; ++n7) {
                    if (rfpDataRecord.backwardRels[n7] == null || rfpDataRecord.backwardRels[n7].rssi < this.rssiThreshold) continue;
                    string = String.format("<< RFP %03X (rssi = %d dBm)", rfpDataRecord.backwardRels[n7].id, rfpDataRecord.backwardRels[n7].rssi - 100);
                    graphics2D.drawString(string, n + 10, n2 + n5 + 6 + (n3 + 1) * 12);
                    ++n3;
                }
            }
        }
        graphics2D.setFont(font);
    }

    @Override
    public void paintDevice(Graphics2D graphics2D, int n, DevicePositionPanel.DevicePositionRecord devicePositionRecord) {
        if (devicePositionRecord != null) {
            if (!this.showAllRfp && this.anzMonitoredRfp != 0 && (devicePositionRecord.attrib & 2) == 0 && (devicePositionRecord.attrib & 1) == 0) {
                return;
            }
            int n2 = devicePositionRecord.xm;
            int n3 = devicePositionRecord.ym;
            if (!this.isPointInDrawingArea(n2, n3)) {
                return;
            }
            int n4 = devicePositionRecord.id;
            RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id);
            OmiMessage.RFPSyncStateType rFPSyncStateType = (OmiMessage.RFPSyncStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_SYNC_STATE));
            if (rFPSyncStateType == null) {
                rFPSyncStateType = OmiMessage.RFPSyncStateType.Inactive;
            }
            Color color = rfpStateColors[rFPSyncStateType.ordinal()];
            String string = String.format("%03X", n4);
            int n5 = 30;
            int n6 = 30;
            if (n == 4) {
                graphics2D.setColor(Color.GREEN);
                graphics2D.fillOval(n2 - n5 / 6, n3 - n6 / 6, n5 / 3, n6 / 3);
            } else {
                graphics2D.setColor(color);
                graphics2D.fillOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                if ((devicePositionRecord.attrib & 1) != 0) {
                    graphics2D.setColor(Color.BLUE);
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(arrowStroke);
                    graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    graphics2D.setStroke(stroke);
                    graphics2D.setColor(Color.BLACK);
                } else {
                    graphics2D.setColor(Color.BLACK);
                    if ((devicePositionRecord.attrib & 0x10000) != 0) {
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setStroke(arrowStroke);
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                        graphics2D.setStroke(stroke);
                    } else {
                        graphics2D.drawOval(n2 - n5 / 2, n3 - n6 / 2, n5, n6);
                    }
                }
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, n2 - n5 / 2 + n5 / 6, n3 - n6 / 2 + 2 * n6 / 3);
            }
        }
    }

    private void paintRelation(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4, RfpDataRecord.SyncRelType syncRelType) {
        this.gd.x1 = n;
        this.gd.y1 = n2;
        this.gd.x2 = n3;
        this.gd.y2 = n4;
        int n5 = syncRelType.rssi / 10;
        if (n5 >= syncRelationColors.length) {
            n5 = syncRelationColors.length - 1;
        }
        this.gd.col = syncRelationColors[n5];
        this.gd = this.calcCoordinates(this.gd, bl);
        this.paintRelationArrow(graphics2D, this.gd);
    }

    private int paintForwardRelations(Graphics2D graphics2D, RfpDataRecord rfpDataRecord) {
        int n = 0;
        for (int i = 0; i < rfpDataRecord.maxForwardRelNumber; ++i) {
            if (rfpDataRecord.forwardRels[i] == null || rfpDataRecord.forwardRels[i].rssi < this.rssiThreshold) continue;
            RfpDataRecord.SyncRelType syncRelType = rfpDataRecord.forwardRels[i];
            RfpDataRecord rfpDataRecord2 = this.rfpDb.getRfpByRfpId(syncRelType.id);
            if (rfpDataRecord2 == null) continue;
            this.addReferencedRfp(syncRelType.id);
            int n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_XPOS);
            int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_YPOS);
            int n4 = (Integer)rfpDataRecord2.getField(RfpDataRecord.IDX_XPOS);
            int n5 = (Integer)rfpDataRecord2.getField(RfpDataRecord.IDX_YPOS);
            if (!this.isPointInDrawingArea(n2, n3) || !this.isPointInDrawingArea(n4, n5)) continue;
            ++n;
            this.paintRelation(graphics2D, true, n2, n3, n4, n5, syncRelType);
        }
        return n;
    }

    private void paintRelations(Graphics2D graphics2D) {
        if (this.rssiThreshold != 0) {
            this.positionIdx.removeDeviceAttributeBitFromAll(2);
        }
        for (int i = 0; i < this.positionIdx.getNoOfDevices(); ++i) {
            RfpDataRecord rfpDataRecord;
            DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceByIndex(i);
            if (devicePositionRecord == null || (rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id)) == null) continue;
            if ((devicePositionRecord.attrib & 1) != 0) {
                this.paintForwardRelations(graphics2D, rfpDataRecord);
                continue;
            }
            int n = this.paintForwardRelations(graphics2D, rfpDataRecord);
            if (n == 0) continue;
            devicePositionRecord.attrib |= 2;
        }
    }

    @Override
    protected void paintBackground(Graphics2D graphics2D) {
        super.paintBackground(graphics2D);
        if (!this.positionEditModeActive) {
            this.paintRelations(graphics2D);
        }
    }

    @Override
    protected void paintAdditionalElements(Graphics2D graphics2D) {
        RfpDataRecord rfpDataRecord;
        if (this.mouseOverRecord != null && (rfpDataRecord = this.rfpDb.getRfpByRfpId(this.mouseOverRecord.id)) != null) {
            this.paintInfoBox(graphics2D, this.mouseOverRecord.xm, this.mouseOverRecord.ym, rfpDataRecord, !this.positionEditModeActive);
        }
    }

    private void rebuildRfpPositionIndex() {
        block3: {
            block2: {
                this.positionIdx.clear();
                this.anzMonitoredRfp = 0;
                if (!this.showAllRfp && this.requestedMonitoredRfpList != null) break block2;
                for (int i = 0; i < this.rfpDb.getRecordNumber(); ++i) {
                    RfpDataRecord rfpDataRecord = this.rfpDb.getRecordByIdx(i);
                    int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                    int n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_XPOS);
                    int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_YPOS);
                    this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, n, n2, n3);
                }
                break block3;
            }
            if (this.requestedMonitoredRfpList == null) break block3;
            for (int i = 0; i < this.requestedMonitoredRfpList.length; ++i) {
                RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(this.requestedMonitoredRfpList[i]);
                int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
                int n4 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_XPOS);
                int n5 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_YPOS);
                this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, n, n4, n5);
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        DevicePositionPanel.DevicePositionRecord devicePositionRecord;
        int n;
        String string = "";
        if (component != null) {
            string = "Previous component is " + component.getClass().toString();
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_SYNC_VIEW, this, "Sync view activated: " + string);
        int n2 = 0;
        this.anzMonitoredRfp = 0;
        while (n2 < this.positionIdx.getNoOfDevices()) {
            n = 0;
            devicePositionRecord = this.positionIdx.getDeviceByIndex(n2);
            if (devicePositionRecord != null) {
                RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id);
                if (rfpDataRecord != null) {
                    if ((devicePositionRecord.attrib & 1) == 0) {
                        this.positionIdx.removeDevice(DevicePositionPanel.DeviceType.RFP, devicePositionRecord.id);
                        n = 1;
                    }
                    rfpDataRecord.deleteSyncRels();
                } else {
                    this.positionIdx.removeDevice(DevicePositionPanel.DeviceType.RFP, devicePositionRecord.id);
                    n = 1;
                }
            }
            if (n != 0) continue;
            ++n2;
        }
        if (this.requestedMonitoredRfpList != null) {
            this.rebuildRfpPositionIndex();
            this.sendGetRfpsyncForAllMonitoredRfp();
        } else {
            n = this.positionIdx.getNoOfDevices();
            if (n > 0) {
                this.requestedMonitoredRfpList = new int[this.positionIdx.getNoOfDevices()];
                for (n2 = 0; n2 < this.positionIdx.getNoOfDevices(); ++n2) {
                    devicePositionRecord = this.positionIdx.getDeviceByIndex(n2);
                    if (devicePositionRecord == null) continue;
                    this.requestedMonitoredRfpList[n2] = devicePositionRecord.id;
                }
                this.positionIdx.removeDeviceAttributeBitFromAll(2);
                this.sendGetRfpsyncForAllMonitoredRfp();
            } else {
                this.rebuildRfpPositionIndex();
            }
        }
        this.anzRegisteredRelations = 0;
        this.componentActive = true;
    }

    @Override
    public void componentDeactivated() {
        this.componentActive = false;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_SYNC_VIEW, this, "Sync view deactivated");
        this.sendUnsubscribeForAllMonitoredRfp();
    }

    public void setSelectedRfpArray(int[] nArray) {
        this.requestedMonitoredRfpList = nArray;
        if (this.componentActive) {
            int n = 0;
            for (n = 0; n < this.positionIdx.getNoOfDevices(); ++n) {
                RfpDataRecord rfpDataRecord;
                DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceByIndex(n);
                if (devicePositionRecord == null || (rfpDataRecord = this.rfpDb.getRfpByRfpId(devicePositionRecord.id)) == null) continue;
                if ((devicePositionRecord.attrib & 1) != 0) {
                    this.rfpDataHandler.unsubscribeForSyncRelation(devicePositionRecord.id);
                }
                rfpDataRecord.deleteSyncRels();
            }
            this.rebuildRfpPositionIndex();
            this.sendGetRfpsyncForAllMonitoredRfp();
            this.anzRegisteredRelations = 0;
            this.repaint();
        }
    }

    @Override
    public void setPositionEditMode(boolean bl) {
        super.setPositionEditMode(bl);
        this.positionIdx.removeDeviceAttributeBitFromAll(2);
        this.setSelectedRfpArray(null);
        this.repaint();
    }

    public void setShowAllRfp(boolean bl) {
        this.showAllRfp = bl;
        for (int i = 0; i < this.rfpDb.getRecordNumber(); ++i) {
            RfpDataRecord rfpDataRecord = this.rfpDb.getRecordByIdx(i);
            int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            int n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_XPOS);
            int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_YPOS);
            this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, n, n2, n3);
        }
        this.repaint();
    }

    public void resetMonitoring() {
        this.setSelectedRfpArray(null);
        this.repaint();
    }

    private void sendGetRfpsyncForAllMonitoredRfp() {
        if (this.requestedMonitoredRfpList != null) {
            this.nextSyncDataReqIdx = 0;
            this.nextSyncDataReqIdx = this.sendNextGetRfpSync(this.nextSyncDataReqIdx);
        }
    }

    private void sendUnsubscribeForAllMonitoredRfp() {
        if (this.omiManagement.getOmiLinkState()) {
            for (int i = 0; i < this.positionIdx.getNoOfDevices(); ++i) {
                DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceByIndex(i);
                if (devicePositionRecord == null || (devicePositionRecord.attrib & 1) == 0) continue;
                this.rfpDataHandler.unsubscribeForSyncRelation(devicePositionRecord.id);
            }
        }
    }

    private void sendGetRfpSync(RfpDataRecord rfpDataRecord) {
        int n = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
        this.positionIdx.setDeviceAttribute(DevicePositionPanel.DeviceType.RFP, n, 1);
        OmiMessage.RFPSyncStateType rFPSyncStateType = (OmiMessage.RFPSyncStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_SYNC_STATE));
        if (rFPSyncStateType == OmiMessage.RFPSyncStateType.Synced) {
            this.rfpDataHandler.SendGetRfpSync(n);
        }
    }

    private int sendNextGetRfpSync(int n) {
        this.nextLastExpectedRfpId = -1;
        if (this.requestedMonitoredRfpList == null) {
            return 0;
        }
        int n2 = 10;
        if (n + n2 > this.requestedMonitoredRfpList.length) {
            n2 = this.requestedMonitoredRfpList.length - n;
        }
        if (this.anzRegisteredRelations > 1000 || n2 == 0) {
            if (n2 != 0) {
                GuiInfoConsole.showInfo(UtilLocale.getString("TXT_SYNCHRONIZATION_VIEW_20") + ": " + UtilLocale.getString("TXT_MAXIMUM_NUMBER_OF_DRAWABLE_RELATIONS_REACHED") + " " + String.format(UtilLocale.getString("TXT_*_OF_*_RFP_RELATIONS_RECEIVED"), this.anzMonitoredRfp, this.requestedMonitoredRfpList.length));
            }
            this.requestedMonitoredRfpList = null;
            return 0;
        }
        for (int i = n; i < n + n2; ++i) {
            int n3 = this.requestedMonitoredRfpList[i];
            RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n3);
            if (rfpDataRecord == null) continue;
            this.rfpDataHandler.subscribeForSyncRelation(n3);
            this.sendGetRfpSync(rfpDataRecord);
            this.nextLastExpectedRfpId = n3;
        }
        return n + n2;
    }

    public void refreshRssi() {
        this.sendGetRfpsyncForAllMonitoredRfp();
    }

    public void setRSSIThreshold(int n) {
        this.rssiThreshold = n;
        this.repaint();
    }

    private DevicePositionPanel.DevicePositionRecord addRfp(int n) {
        DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.RFP, n);
        if (devicePositionRecord != null) {
            return devicePositionRecord;
        }
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
        if (rfpDataRecord != null) {
            int n2 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            int n3 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_XPOS);
            int n4 = (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_YPOS);
            return this.positionIdx.addDevice(DevicePositionPanel.DeviceType.RFP, n2, n3, n4);
        }
        return null;
    }

    private DevicePositionPanel.DevicePositionRecord addReferencedRfp(int n) {
        DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.addRfp(n);
        if (devicePositionRecord != null) {
            devicePositionRecord.attrib |= 2;
        }
        return devicePositionRecord;
    }

    private void addToMonitoredList(int n) {
        DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.addRfp(n);
        if (devicePositionRecord != null) {
            devicePositionRecord.attrib |= 1;
        }
        ++this.anzMonitoredRfp;
    }

    private void removeSyncRelations(RfpDataRecord rfpDataRecord) {
        if (rfpDataRecord.backwardRels != null) {
            for (int i = 0; i < rfpDataRecord.maxBackwardRelNumber; ++i) {
                RfpDataRecord rfpDataRecord2;
                if (rfpDataRecord.backwardRels[i] == null || (rfpDataRecord2 = this.rfpDb.getRfpByRfpId(rfpDataRecord.backwardRels[i].id)) == null) continue;
                rfpDataRecord2.removeForwardRel((Integer)rfpDataRecord.getField(RfpDataRecord.IDX_RFP_ID));
            }
        }
        rfpDataRecord.deleteSyncRels();
    }

    private boolean addRelations(boolean bl, OmiMessage omiMessage) {
        int n;
        int n2 = omiMessage.getAttribValInt(OmiMessage.attribIds.id.name());
        int n3 = 0;
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n2);
        if (bl && this.anzRegisteredRelations > (n = rfpDataRecord.deleteSyncRels())) {
            this.anzRegisteredRelations -= n;
        }
        if (this.anzRegisteredRelations > 1000) {
            this.sendNextGetRfpSync(this.nextSyncDataReqIdx);
            return false;
        }
        if (rfpDataRecord != null) {
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                int n4 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.id.name());
                int n5 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.rssi.name());
                int n6 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.offset.name());
                if (n5 == 0) continue;
                if (omiMessage2.id == OmiMessage.elemIds.forward) {
                    rfpDataRecord.addForwardRel(n4, n5, n6);
                    this.addReferencedRfp(n4);
                    ++n3;
                    continue;
                }
                if (omiMessage2.id != OmiMessage.elemIds.backward) continue;
                rfpDataRecord.addBackwardRel(n4, n5, n6);
                this.addReferencedRfp(n4);
                RfpDataRecord rfpDataRecord2 = this.rfpDb.getRfpByRfpId(n4);
                if (rfpDataRecord2 != null) {
                    rfpDataRecord2.addForwardRel(n2, n5, n6);
                }
                ++n3;
            }
            this.addToMonitoredList(n2);
            if (n3 > 0 && this.nextLastExpectedRfpId == -1) {
                this.repaint();
            }
            this.anzRegisteredRelations += n3;
        }
        if (this.nextLastExpectedRfpId == n2) {
            this.nextSyncDataReqIdx = this.sendNextGetRfpSync(this.nextSyncDataReqIdx);
            if (this.nextLastExpectedRfpId == -1) {
                this.repaint();
            }
        } else if (this.anzRegisteredRelations > 1000) {
            this.nextLastExpectedRfpId = -1;
            this.repaint();
        }
        return true;
    }

    private void updateRelations(OmiMessage omiMessage) {
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.id.name());
        int n2 = 0;
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
        if (rfpDataRecord != null) {
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.forward) continue;
                int n3 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.id.name());
                int n4 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.rssi.name());
                int n5 = omiMessage2.getAttribValInt(OmiMessage.SyncOffsetType.offset.name());
                boolean bl = omiMessage2.getAttribValBool(OmiMessage.SyncOffsetType.lost.name());
                RfpDataRecord rfpDataRecord2 = this.rfpDb.getRfpByRfpId(n3);
                if (bl || n4 == 0) {
                    rfpDataRecord.removeForwardRel(n3);
                    if (rfpDataRecord2 != null) {
                        rfpDataRecord2.removeBackwardRel(n);
                    }
                } else {
                    rfpDataRecord.addForwardRel(n3, n4, n5);
                    if (rfpDataRecord2 != null) {
                        rfpDataRecord2.addBackwardRel(n, n4, n5);
                    }
                    this.addReferencedRfp(n);
                    this.addReferencedRfp(n3);
                }
                ++n2;
            }
            if (n2 > 0) {
                this.repaint();
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetRFPSyncResp: {
                if (this.addRelations(true, omiMessage)) break;
                this.rfpDataHandler.unsubscribeForSyncRelation(omiMessage.getAttribValInt(OmiMessage.attribIds.id.name()));
                break;
            }
            case EventRFPSyncRel: {
                this.updateRelations(omiMessage);
                break;
            }
        }
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.componentActive) {
            switch (dataNotificationEnum) {
                case DATA_RFP_CHANGED_CNF: 
                case DATA_RFP_CHANGED_RESP: {
                    RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
                    if (rfpDataRecord == null) break;
                    OmiMessage.RFPSyncStateType rFPSyncStateType = (OmiMessage.RFPSyncStateType)((Object)rfpDataRecord.getField(RfpDataRecord.IDX_SYNC_STATE));
                    if (rFPSyncStateType != OmiMessage.RFPSyncStateType.Synced && rFPSyncStateType != OmiMessage.RFPSyncStateType.Searching) {
                        this.removeSyncRelations(rfpDataRecord);
                    }
                    this.repaint();
                    break;
                }
                case DATA_DELETED: {
                    DevicePositionPanel.DevicePositionRecord devicePositionRecord = this.positionIdx.getDeviceById(DevicePositionPanel.DeviceType.RFP, n);
                    if (devicePositionRecord == null) break;
                    this.positionIdx.removeDevice(DevicePositionPanel.DeviceType.RFP, n);
                    this.repaint();
                    break;
                }
            }
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }
}

