/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.util.UtilSpy;
import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;

public class RfpTreeNode
extends DefaultMutableTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name = null;
    public NodeTypeEnum nodeType = null;
    private int rfpId = -1;

    public RfpTreeNode(NodeTypeEnum nodeTypeEnum) {
        this.name = "";
        this.nodeType = nodeTypeEnum;
    }

    public RfpTreeNode(NodeTypeEnum nodeTypeEnum, String string) {
        super(string);
        this.name = string;
        this.nodeType = nodeTypeEnum;
    }

    public RfpTreeNode createChild(NodeTypeEnum nodeTypeEnum, String string) {
        if (nodeTypeEnum == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Adding child failed: Node type is invalid");
            return null;
        }
        RfpTreeNode rfpTreeNode = new RfpTreeNode(nodeTypeEnum, string);
        int n = this.getChildCount();
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.getChild((int)i).nodeType == NodeTypeEnum.NODE_RFP) continue;
                ++n2;
            }
            if (nodeTypeEnum != NodeTypeEnum.NODE_RFP) {
                if (n2 > 0) {
                    while (n3 < n2) {
                        RfpTreeNode rfpTreeNode2 = this.getChild(n3);
                        if (rfpTreeNode2.name.compareTo(string) <= 0) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                }
            } else if (n - n2 > 0) {
                for (n3 = n2; n3 < n; ++n3) {
                    RfpTreeNode rfpTreeNode3 = this.getChild(n3);
                    if (rfpTreeNode3.name.compareTo(string) <= 0) {
                        continue;
                    }
                    break;
                }
            }
        }
        this.insert(rfpTreeNode, n3);
        return rfpTreeNode;
    }

    public void setRfpId(int n) {
        this.rfpId = n;
    }

    public int getRfpId() {
        return this.rfpId;
    }

    public RfpTreeNode getChild(int n) {
        return (RfpTreeNode)this.getChildAt(n);
    }

    public int getNumberOfChilds() {
        return this.getChildCount();
    }

    @Override
    public String toString() {
        return this.nodeType.typeName + " " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getName(NodeTypeEnum nodeTypeEnum) {
        if (this.nodeType == nodeTypeEnum) {
            return this.getName();
        }
        return null;
    }

    public static enum NodeTypeEnum {
        NODE_ROOT_UNASSIGNED("Unassigned RFPs"),
        NODE_ROOT_PAGING_AREA("Paging areas"),
        NODE_PAGING_AREA("Paging area"),
        NODE_SITE("Site"),
        NODE_BUILDING("Building"),
        NODE_FLOOR("Floor"),
        NODE_ROOM("Room"),
        NODE_RFP("RFP Id");

        public String typeName;

        private NodeTypeEnum(String string2) {
            this.typeName = string2;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }
    }
}

