/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfp;

import com.aastra.oamp.rfp.RfpTree;
import com.aastra.oamp.rfp.RfpTreeNode;
import com.aastra.oamp.rfp.RfpTreeView;
import com.aastra.util.UtilSpy;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreeDropTarget
implements DropTargetListener {
    private final boolean dropAnywhere = true;
    private final int SCROLL_DETECTION_AREA_SIZE = 20;
    private final int SCROLL_STEP = 20;
    DropTarget target;
    private RfpTree tree;
    private boolean pagingAreaTree;
    private RfpTreeView rfpTreeView;
    private int treeWidth = 0;
    private int treeHeight = 0;
    private int viewWidht = 0;
    private int viewHeight = 0;
    private int treePosX = 0;
    private int offsetViewX = 0;
    private int treePosY = 0;
    private int offsetViewY = 0;
    private int scrollDirX = 0;
    private int scrollDirY = 0;
    private int rfpsToMove = 0;

    public TreeDropTarget(RfpTree rfpTree, boolean bl, RfpTreeView rfpTreeView) {
        this.tree = rfpTree;
        this.target = new DropTarget(this.tree, this);
        this.pagingAreaTree = bl;
        this.rfpTreeView = rfpTreeView;
    }

    private TreeNode getNodeForEvent(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        return (TreeNode)treePath.getLastPathComponent();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getNodeForEvent(dropTargetDragEvent);
        int n = defaultMutableTreeNode.getLevel();
        this.tree.setScrollCheck(this.scrollNecessaryCheck());
        this.tree.evaluateScrollStatus(RfpTree.dragAndDropEvent.DRAG_ENTER, null);
        this.dragAcceptReject(dropTargetDragEvent, n);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getNodeForEvent(dropTargetDragEvent);
        int n = defaultMutableTreeNode.getLevel();
        this.treePosX = dropTargetDragEvent.getLocation().x;
        this.treePosY = dropTargetDragEvent.getLocation().y;
        int n2 = this.treePosX + this.offsetViewX;
        int n3 = this.treePosY + this.offsetViewY;
        this.scrollDirX = n2 < 20 ? -1 : (n2 > this.viewWidht - 20 ? 1 : 0);
        this.scrollDirY = n3 < 20 ? -1 : (n3 > this.viewHeight - 20 ? 1 : 0);
        this.dragAcceptReject(dropTargetDragEvent, n);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.tree.evaluateScrollStatus(RfpTree.dragAndDropEvent.DRAG_EXIT, this);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                void nodeTypeEnum;
                if (!transferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                TreePath treePath2 = (TreePath)transferable.getTransferData(dataFlavorArray[i]);
                RfpTreeNode rfpTreeNode = (RfpTreeNode)treePath2.getLastPathComponent();
                boolean bl = ((RfpTreeNode)defaultMutableTreeNode.getRoot()).nodeType == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA;
                int bl2 = defaultMutableTreeNode.getLevel();
                while (nodeTypeEnum > bl) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    --nodeTypeEnum;
                }
                bl = this.checkListDECTRunning(rfpTreeNode);
                RfpTreeNode.NodeTypeEnum nodeTypeEnum2 = ((RfpTreeNode)defaultMutableTreeNode.getRoot()).nodeType;
                if (nodeTypeEnum2 == RfpTreeNode.NodeTypeEnum.NODE_ROOT_PAGING_AREA) {
                    int defaultTreeModel = this.rfpTreeView.checkRfpCnt(bl, this.listRfps(rfpTreeNode), this.listRfps((RfpTreeNode)defaultMutableTreeNode));
                    if (defaultTreeModel == 0) {
                        dropTargetDropEvent.dropComplete(false);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Paging area full - Do not drop any further RFPs");
                        return;
                    }
                    if (defaultTreeModel == -1) {
                        this.addAllRfps((RfpTreeNode)defaultMutableTreeNode, rfpTreeNode);
                    } else {
                        this.addSomeRfps((RfpTreeNode)defaultMutableTreeNode, rfpTreeNode, defaultTreeModel);
                    }
                } else {
                    if (bl && !this.rfpTreeView.createDropWarningDialog(nodeTypeEnum2)) {
                        dropTargetDropEvent.dropComplete(false);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drop cancelled by user");
                        return;
                    }
                    this.addAllRfps((RfpTreeNode)defaultMutableTreeNode, rfpTreeNode);
                }
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
                defaultTreeModel.nodeChanged(defaultMutableTreeNode);
                dropTargetDropEvent.dropComplete(true);
                this.rfpTreeView.refreshBothTrees();
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            dropTargetDropEvent.rejectDrop();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drop rejected (Data flavor not supported)");
        }
    }

    private void dragAcceptReject(DropTargetDragEvent dropTargetDragEvent, int n) {
        if (this.pagingAreaTree && n == 0) {
            this.rfpTreeView.dropTargetDragEnter(false);
            dropTargetDragEvent.rejectDrag();
        } else {
            this.rfpTreeView.dropTargetDragEnter(true);
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    public void scrollView() {
        int n = this.treePosX + this.scrollDirX * 20;
        int n2 = this.treePosY + this.scrollDirY * 20;
        this.treePosX = n <= 0 ? 0 : (n >= this.treeWidth ? this.treeWidth : n);
        this.treePosY = n2 <= 0 ? 0 : (n2 >= this.treeHeight ? this.treeHeight : n2);
        this.tree.scrollRectToVisible(new Rectangle(this.treePosX, this.treePosY, 1, 1));
    }

    private boolean scrollNecessaryCheck() {
        this.treeWidth = this.tree.getWidth();
        this.treeHeight = this.tree.getHeight();
        this.viewWidht = this.tree.getParent().getWidth();
        this.viewHeight = this.tree.getParent().getHeight();
        if (this.treeWidth > this.viewWidht || this.treeHeight > this.viewHeight) {
            String string = this.tree.getParent().toString();
            int n = string.indexOf("lastPaintPosition=java.awt.Point");
            string = string.substring(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken("=");
            stringTokenizer.nextToken("=");
            String string2 = stringTokenizer.nextToken("=,");
            stringTokenizer.nextToken("=");
            String string3 = stringTokenizer.nextToken("=]");
            this.offsetViewX = Integer.parseInt(string2);
            this.offsetViewY = Integer.parseInt(string3);
            return true;
        }
        return false;
    }

    private int listRfps(RfpTreeNode rfpTreeNode) {
        int n = 0;
        LinkedList<Integer> linkedList = this.getRfpFullList(rfpTreeNode);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 == -1) continue;
            ++n;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drag and Drop: rfpId=" + n2);
        }
        return n;
    }

    private boolean checkListDECTRunning(RfpTreeNode rfpTreeNode) {
        LinkedList<Integer> linkedList = this.getRfpFullList(rfpTreeNode);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n == -1 || !this.rfpTreeView.isRfpDECTRunning(n)) continue;
            return true;
        }
        return false;
    }

    private void addAllRfps(RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2) {
        LinkedList<Integer> linkedList = this.getRfpFullList(rfpTreeNode2);
        this.addRfps(linkedList, rfpTreeNode, rfpTreeNode2);
    }

    private void addSomeRfps(RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2, int n) {
        LinkedList<Integer> linkedList = this.getRfpSubList(rfpTreeNode2, n);
        this.addRfps(linkedList, rfpTreeNode, rfpTreeNode2);
    }

    private LinkedList<Integer> getRfpFullList(RfpTreeNode rfpTreeNode) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.getRfpFullListRecursion(linkedList, rfpTreeNode);
        return linkedList;
    }

    private LinkedList<Integer> getRfpSubList(RfpTreeNode rfpTreeNode, int n) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        this.rfpsToMove = n;
        this.getRfpSubListRecursion(linkedList, rfpTreeNode);
        return linkedList;
    }

    private LinkedList<Integer> getRfpFullListRecursion(LinkedList<Integer> linkedList, RfpTreeNode rfpTreeNode) {
        if (rfpTreeNode.nodeType == RfpTreeNode.NodeTypeEnum.NODE_RFP) {
            int n = rfpTreeNode.getRfpId();
            if (n != -1) {
                linkedList.add(n);
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drag and drop: rfpId=-1");
            }
        } else {
            try {
                for (RfpTreeNode rfpTreeNode2 = (RfpTreeNode)rfpTreeNode.getFirstChild(); rfpTreeNode2 != null; rfpTreeNode2 = (RfpTreeNode)rfpTreeNode2.getNextSibling()) {
                    this.getRfpFullListRecursion(linkedList, rfpTreeNode2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return linkedList;
            }
        }
        return linkedList;
    }

    private LinkedList<Integer> getRfpSubListRecursion(LinkedList<Integer> linkedList, RfpTreeNode rfpTreeNode) {
        if (this.rfpsToMove == 0) {
            return linkedList;
        }
        if (rfpTreeNode.nodeType == RfpTreeNode.NodeTypeEnum.NODE_RFP) {
            int n = rfpTreeNode.getRfpId();
            if (n != -1) {
                linkedList.add(n);
                --this.rfpsToMove;
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drag and Drop: RFP ID=-1");
            }
        } else {
            try {
                for (RfpTreeNode rfpTreeNode2 = (RfpTreeNode)rfpTreeNode.getFirstChild(); rfpTreeNode2 != null && this.rfpsToMove > 0; rfpTreeNode2 = (RfpTreeNode)rfpTreeNode2.getNextSibling()) {
                    this.getRfpSubListRecursion(linkedList, rfpTreeNode2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return linkedList;
            }
        }
        return linkedList;
    }

    private void addRfps(LinkedList<Integer> linkedList, RfpTreeNode rfpTreeNode, RfpTreeNode rfpTreeNode2) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            RfpTreeNode.NodeTypeEnum nodeTypeEnum;
            RfpTreeNode.NodeTypeEnum nodeTypeEnum2;
            int n = (Integer)iterator.next();
            RfpTreeNode rfpTreeNode3 = null;
            if (n != -1) {
                rfpTreeNode3 = this.tree.addRfp(rfpTreeNode, n);
            }
            if ((nodeTypeEnum2 = ((RfpTreeNode)rfpTreeNode2.getRoot()).nodeType) != (nodeTypeEnum = ((RfpTreeNode)rfpTreeNode.getRoot()).nodeType)) {
                this.rfpTreeView.removeRfpInSpecialTree(nodeTypeEnum2, n);
            }
            this.rfpTreeView.updateRfpDataRecord(rfpTreeNode, n);
            this.rfpTreeView.expandTree(rfpTreeNode2, rfpTreeNode3);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_RFP_TREE, this, "Drag and drop: RFP ID=" + n);
        }
    }
}

