/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpquality;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.RfpQualityHandler;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;

public class RfpIpQualityPanel
extends AastraPanel
implements GuiComponentActivationInterface,
CommonDataHandler.CommonDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private RfpQualityHandler rfpQualityHandler = null;
    private CommonDataHandler commonDataHandler = null;
    private RfpIpQualityTaskPanel rfpIpQualityTaskPanel = null;
    private GuiUtilConfiguratorTable rfpQualityTable = null;
    private AastraScrollPane rfpQualityTablePane = null;
    private static final int[] rfpQualityIpTableColumns = new int[]{0, 9, 10, 11, 12, 13, 14, 15, 16, 17};

    public RfpIpQualityPanel(RfpQualityHandler rfpQualityHandler, CommonDataHandler commonDataHandler) {
        this.rfpQualityHandler = rfpQualityHandler;
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.Limits, this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpQualityTablePane(), "Center");
        this.add((Component)this.getRfpIpQualityTaskPanel(), "East");
    }

    private AastraScrollPane getRfpQualityTablePane() {
        if (this.rfpQualityTablePane == null) {
            this.rfpQualityTablePane = new AastraScrollPane(this.getRfpQualityTable());
        }
        return this.rfpQualityTablePane;
    }

    private GuiUtilConfiguratorTable getRfpQualityTable() {
        if (this.rfpQualityTable == null) {
            this.rfpQualityTable = new GuiUtilConfiguratorTable(null, this.rfpQualityHandler.getRfpQualityDb(), this.getActiveRfpQualityColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpQualityIp, true);
            this.rfpQualityTable.setColumnFormatString(0, "0x%03X");
        }
        return this.rfpQualityTable;
    }

    private int[] getActiveRfpQualityColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityIp);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpQualityIpTableColumns.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = rfpQualityIpTableColumns[i];
            }
        } else {
            nArray = rfpQualityIpTableColumns;
            bitSet = new BitSet();
            for (int i = 0; i < nArray.length; ++i) {
                bitSet.set(i);
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityIp, bitSet);
        }
        return nArray;
    }

    private RfpIpQualityTaskPanel getRfpIpQualityTaskPanel() {
        if (this.rfpIpQualityTaskPanel == null) {
            this.rfpIpQualityTaskPanel = new RfpIpQualityTaskPanel();
        }
        return this.rfpIpQualityTaskPanel;
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpQualityHandler.startRfpIpQuality();
    }

    @Override
    public void componentDeactivated() {
        this.rfpQualityHandler.stopRfpIpQuality();
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.Limits) {
            try {
                CommonDataHandler.LimitsClass limitsClass = (CommonDataHandler.LimitsClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.Limits);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.toString() + "='" + limitsClass + "'");
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(13, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT1));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(14, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT2));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(15, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT3));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(16, String.format("< %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT4));
                RfpQualityHandler.RfpQualityRecord.setTableHeaderText(17, String.format(">= %d " + UtilLocale.getString("TXT_UNIT_MILLISECOND"), limitsClass.limitRTT4));
                this.rfpQualityTable.tableStructureChange();
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.toString() + " failed");
            }
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    private final class RfpIpQualityTaskPanel
    extends GuiUtilTaskPanel {
        private static final long serialVersionUID = 1L;
        private AastraLinkButton buttonConfigureRfpTable = null;

        private RfpIpQualityTaskPanel() {
            this.initialize();
        }

        private void initialize() {
            this.add(this.getButtonConfigureRfpTable());
        }

        private AastraLinkButton getButtonConfigureRfpTable() {
            if (this.buttonConfigureRfpTable == null) {
                this.buttonConfigureRfpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
                this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpIpQualityPanel.this.rfpQualityTable, rfpQualityIpTableColumns, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityIp);
                        guiUtilTableConfigDlg.setVisible(true);
                    }
                });
            }
            return this.buttonConfigureRfpTable;
        }
    }
}

