/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpquality;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.RfpQualityHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;

public class RfpMediaStreamQualityPanel
extends AastraPanel
implements GuiComponentActivationInterface,
RfpQualityHandler.MediaStreamQualityNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    private RfpQualityHandler rfpQualityHandler = null;
    private RfpMediaStreamQualityTaskPanel rfpQualityTaskPanel = null;
    private GuiUtilConfiguratorTable rfpQualityTable = null;
    private AastraScrollPane rfpQualityTablePanel = null;
    private static final int[] rfpMediaStreamQualityTableColumns = new int[]{0, 1, 2, 5, 3, 7, 8};

    public RfpMediaStreamQualityPanel(RfpQualityHandler rfpQualityHandler) {
        this.rfpQualityHandler = rfpQualityHandler;
        this.rfpQualityHandler.registerMediaStreamQualityNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpQualityTablePanel(), "Center");
        this.add((Component)this.getRfpQualityTaskPanel(), "East");
    }

    private RfpMediaStreamQualityTaskPanel getRfpQualityTaskPanel() {
        if (this.rfpQualityTaskPanel == null) {
            this.rfpQualityTaskPanel = new RfpMediaStreamQualityTaskPanel();
        }
        return this.rfpQualityTaskPanel;
    }

    private GuiUtilConfiguratorTable getRfpQualityTable() {
        if (this.rfpQualityTable == null) {
            this.rfpQualityTable = new GuiUtilConfiguratorTable((Object)this, this.rfpQualityHandler.getRfpQualityDb(), this.getActiveRfpQualityColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpQualityMediaStream, true);
            this.rfpQualityTable.setColumnFormatString(0, "0x%03X");
        }
        return this.rfpQualityTable;
    }

    private int[] getActiveRfpQualityColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityMediaStream);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpMediaStreamQualityTableColumns.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = rfpMediaStreamQualityTableColumns[i];
            }
        } else {
            nArray = rfpMediaStreamQualityTableColumns;
            bitSet = new BitSet();
            for (int i = 0; i < nArray.length; ++i) {
                bitSet.set(i);
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityMediaStream, bitSet);
        }
        return nArray;
    }

    private AastraScrollPane getRfpQualityTablePanel() {
        if (this.rfpQualityTablePanel == null) {
            this.rfpQualityTablePanel = new AastraScrollPane(this.getRfpQualityTable());
        }
        return this.rfpQualityTablePanel;
    }

    protected void clearSelectedRfp() {
        int[] nArray = this.rfpQualityTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.rfpQualityTable.convertRowIndexToModel(nArray[i]);
            RfpQualityHandler.RfpQualityRecord rfpQualityRecord = this.rfpQualityHandler.getRecordByTableIdx(n);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Clearing rfp media stream quality [%03d]", rfpQualityRecord.id));
            this.rfpQualityHandler.sendResetRFPMediaStreamQuality(rfpQualityRecord.id);
        }
    }

    protected void clearAllRfp() {
        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_CLEAR_COUNTERS_OF_ALL_RFPS_?"), true);
        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Clearing rfp media stream quality for all rfps");
            this.rfpQualityHandler.sendResetRFPMediaStreamQuality();
        }
    }

    private void processTableSelectionChanged() {
        this.rfpQualityTaskPanel.setTaskButtonClearSelectedRfp(this.rfpQualityTable.getSelectedRowCount() > 0);
    }

    @Override
    public void processMediaStreamQualityDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP media stream quality notification: " + dataNotificationEnum.toString() + ",id=" + String.valueOf(n));
        if (dataNotificationEnum == DataNotificationEnum.DATA_BULK_READY) {
            this.rfpQualityTaskPanel.setTaskButtonClearAllRfp(this.rfpQualityTable.getRowCount() > 0);
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpQualityHandler.startRfpMediaStreamQuality();
    }

    @Override
    public void componentDeactivated() {
        this.rfpQualityHandler.stopRfpMediaStreamQuality();
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableSelectionChanged();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableSelectionChanged();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
    }

    private final class RfpMediaStreamQualityTaskPanel
    extends GuiUtilTaskPanel {
        private static final long serialVersionUID = 1L;
        private AastraLinkButton buttonClearSelectedRfp = null;
        private AastraLinkButton buttonClearAllRfp = null;
        private AastraLinkButton buttonConfigureRfpTable = null;

        public RfpMediaStreamQualityTaskPanel() {
            this.initialize();
        }

        private void initialize() {
            this.add(this.getButtonClearSelectedRfp());
            this.add(this.getButtonClearAllRfp());
            this.add(this.getButtonConfigureRfpTable());
        }

        private AastraLinkButton getButtonClearSelectedRfp() {
            if (this.buttonClearSelectedRfp == null) {
                this.buttonClearSelectedRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CLEAR_RFP_20"), UtilLocale.getString("TXT_CLEAR_COUNTERS_OF_SELECTED_RFPS"));
                this.buttonClearSelectedRfp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpMediaStreamQualityPanel.this.clearSelectedRfp();
                    }
                });
            }
            return this.buttonClearSelectedRfp;
        }

        private AastraLinkButton getButtonClearAllRfp() {
            if (this.buttonClearAllRfp == null) {
                this.buttonClearAllRfp = this.createTaskButtonDisabled(UtilLocale.getString("TXT_CLEAR_ALL_20"), UtilLocale.getString("TXT_CLEAR_COUNTERS_OF_ALL_RFPS"));
                this.buttonClearAllRfp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpMediaStreamQualityPanel.this.clearAllRfp();
                    }
                });
            }
            return this.buttonClearAllRfp;
        }

        private AastraLinkButton getButtonConfigureRfpTable() {
            if (this.buttonConfigureRfpTable == null) {
                this.buttonConfigureRfpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
                this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpMediaStreamQualityPanel.this.rfpQualityTable, rfpMediaStreamQualityTableColumns, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualityMediaStream);
                        guiUtilTableConfigDlg.setVisible(true);
                    }
                });
            }
            return this.buttonConfigureRfpTable;
        }

        protected void setTaskButtonClearSelectedRfp(boolean bl) {
            this.buttonClearSelectedRfp.setEnabled(bl);
        }

        protected void setTaskButtonClearAllRfp(boolean bl) {
            this.buttonClearAllRfp.setEnabled(bl);
        }
    }
}

