/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpquality;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.RfpQualityHandler;
import com.aastra.style.AastraLinkButton;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;

public class RfpSyncQualityPanel
extends AastraPanel
implements GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private RfpQualityHandler rfpQualityHandler = null;
    private GuiUtilConfiguratorTable rfpQualityTable = null;
    private AastraScrollPane rfpQualityTablePane = null;
    private RfpSyncQualityTaskPanel rfpSyncQualityTaskPanel = null;
    private static final int[] rfpQualitySyncTableColumns = new int[]{0, 19, 18, 20, 21, 22, 23};

    public RfpSyncQualityPanel(RfpQualityHandler rfpQualityHandler) {
        this.rfpQualityHandler = rfpQualityHandler;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpTablePane(), "Center");
        this.add((Component)this.getRfpSyncQualityTaskPanel(), "East");
    }

    private AastraScrollPane getRfpTablePane() {
        if (this.rfpQualityTablePane == null) {
            this.rfpQualityTablePane = new AastraScrollPane(this.getRfpTable());
            this.rfpQualityTable.setIconArray(18, GuiUtilIcon.getIconArrayErrorSearchSearchActive());
            this.rfpQualityTable.setZeroIntAsInvalid(22);
            this.rfpQualityTable.setZeroIntAsInvalid(23);
        }
        return this.rfpQualityTablePane;
    }

    private GuiUtilConfiguratorTable getRfpTable() {
        if (this.rfpQualityTable == null) {
            this.rfpQualityTable = new GuiUtilConfiguratorTable(null, this.rfpQualityHandler.getRfpQualityApplicationDb(), this.getActiveRfpQualityColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthRfpQualitySync, true);
            this.rfpQualityTable.setColumnFormatString(0, "0x%03X");
        }
        return this.rfpQualityTable;
    }

    private int[] getActiveRfpQualityColumns() {
        int n = 0;
        int[] nArray = null;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualitySync);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < rfpQualitySyncTableColumns.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = rfpQualitySyncTableColumns[i];
            }
        } else {
            nArray = rfpQualitySyncTableColumns;
            bitSet = new BitSet();
            for (int i = 0; i < nArray.length; ++i) {
                bitSet.set(i);
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualitySync, bitSet);
        }
        return nArray;
    }

    private RfpSyncQualityTaskPanel getRfpSyncQualityTaskPanel() {
        if (this.rfpSyncQualityTaskPanel == null) {
            this.rfpSyncQualityTaskPanel = new RfpSyncQualityTaskPanel();
        }
        return this.rfpSyncQualityTaskPanel;
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpQualityHandler.startRfpSyncQuality();
    }

    @Override
    public void componentDeactivated() {
        this.rfpQualityHandler.stopRfpSyncQuality();
    }

    private final class RfpSyncQualityTaskPanel
    extends GuiUtilTaskPanel {
        private static final long serialVersionUID = 1L;
        private AastraLinkButton buttonConfigureRfpTable = null;
        private AastraLinkButton buttonModeRfpTable = null;
        private AastraLinkButton buttonUpdateRfpTable = null;

        private RfpSyncQualityTaskPanel() {
            this.initialize();
        }

        private void initialize() {
            this.add(this.getButtonModeRfpTable());
            this.add(this.getButtonUpdateRfpTable());
            this.add(this.getButtonConfigureRfpTable());
            this.setTaskPanelMode();
        }

        private AastraLinkButton getButtonModeRfpTable() {
            if (this.buttonModeRfpTable == null) {
                this.buttonModeRfpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SNAPSHOT_MODE_20"), UtilLocale.getString("TXT_SNAPSHOT_MODE_HELP"));
                this.buttonModeRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = RfpSyncQualityPanel.this.rfpQualityHandler.getSyncTableModeSnapshot();
                        RfpSyncQualityPanel.this.rfpQualityHandler.changeSyncTableModeSnapshot(!bl);
                        RfpSyncQualityTaskPanel.this.setTaskPanelMode();
                    }
                });
            }
            return this.buttonModeRfpTable;
        }

        private AastraLinkButton getButtonUpdateRfpTable() {
            if (this.buttonUpdateRfpTable == null) {
                this.buttonUpdateRfpTable = this.createTaskButton(UtilLocale.getString("TXT_UPDATE_20"), RfpSyncQualityPanel.this.rfpQualityHandler.getSyncTableModeSnapshot());
                this.buttonUpdateRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        RfpSyncQualityPanel.this.rfpQualityHandler.updateRfpQualityApplicationDb();
                    }
                });
            }
            return this.buttonUpdateRfpTable;
        }

        private AastraLinkButton getButtonConfigureRfpTable() {
            if (this.buttonConfigureRfpTable == null) {
                this.buttonConfigureRfpTable = this.createTaskButtonEnabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
                this.buttonConfigureRfpTable.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(RfpSyncQualityPanel.this.rfpQualityTable, rfpQualitySyncTableColumns, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectRfpQualitySync);
                        guiUtilTableConfigDlg.setVisible(true);
                    }
                });
            }
            return this.buttonConfigureRfpTable;
        }

        private void setTaskPanelMode() {
            boolean bl = RfpSyncQualityPanel.this.rfpQualityHandler.getSyncTableModeSnapshot();
            if (bl) {
                this.buttonModeRfpTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.buttonUpdateRfpTable.setEnabled(true);
                this.buttonUpdateRfpTable.setToolTipText(UtilLocale.getString("TXT_UPDATE_RFP_SYNC_QUALITY_TABLE_HELP"));
            } else {
                this.buttonModeRfpTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                this.buttonUpdateRfpTable.setEnabled(false);
                this.buttonUpdateRfpTable.setToolTipText(null);
            }
        }
    }
}

