/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.rfpstatistic.RfpStatisticConfigDatabase;
import com.aastra.oamp.rfpstatistic.RfpStatisticPanel;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.GenericDataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraScrollPane;
import java.awt.Dimension;

public class RfpStatisticConfigPanel
extends AastraScrollPane
implements ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    private RfpStatisticPanel rfpStatisticPanel = null;
    private ConfiguratorTable rfpStatisticConfigTable = null;
    private RfpStatisticConfigDatabase rfpStatisticConfigDb = null;
    private static int currentRfpStatIdElem = -1;
    private static String currentRfpStatGroup = null;
    private static String currentRfpStatName = null;

    public RfpStatisticConfigPanel(RfpStatisticPanel rfpStatisticPanel, RfpStatisticConfigDatabase rfpStatisticConfigDatabase) {
        super(null);
        this.rfpStatisticPanel = rfpStatisticPanel;
        this.rfpStatisticConfigDb = rfpStatisticConfigDatabase;
        this.initialize();
    }

    public static int getCurrentRfpElemId() {
        if (currentRfpStatIdElem != -1) {
            return currentRfpStatIdElem;
        }
        return -1;
    }

    public static String getCurrentRfpStatGroup() {
        if (currentRfpStatGroup != null) {
            return currentRfpStatGroup.toString();
        }
        return null;
    }

    public static String getCurrentRfpStatName() {
        if (currentRfpStatName != null) {
            return currentRfpStatName.toString();
        }
        return null;
    }

    private void initialize() {
        this.setViewportView(this.getRfpStatisticConfigTable());
        this.setPreferredSize(new Dimension(100, 230));
    }

    protected ConfiguratorTable getRfpStatisticConfigTable() {
        if (this.rfpStatisticConfigTable == null) {
            this.rfpStatisticConfigTable = new ConfiguratorTable(this.rfpStatisticConfigDb);
            this.rfpStatisticConfigTable.setSelectionMode(0);
            int[] nArray = new int[]{0, 2, 1, 3};
            this.rfpStatisticConfigTable.setNegativeIntAsInvalid(3);
            this.rfpStatisticConfigTable.setColumnArr(nArray, nArray.length);
            this.rfpStatisticConfigTable.registerEventListener(this);
        }
        return this.rfpStatisticConfigTable;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (dataRecord != null) {
            currentRfpStatIdElem = (Integer)dataRecord.getField(0);
            currentRfpStatGroup = (String)dataRecord.getField(2);
            currentRfpStatName = (String)dataRecord.getField(1);
            this.rfpStatisticPanel.initRfpStatisticDetailPanel();
        } else {
            this.rfpStatisticPanel.removeRfpStatisticDetailPanel();
        }
    }

    protected void updateRfpStatisticConfigDb(boolean bl) {
        if (this.rfpStatisticConfigTable.getSelectedRowCount() > 0) {
            int n = this.rfpStatisticConfigTable.getSelectedRow();
            int n2 = this.rfpStatisticConfigTable.convertRowIndexToModel(n);
            this.rfpStatisticConfigDb.updateIndex();
            n = this.rfpStatisticConfigTable.convertRowIndexToView(n2);
            if (n != -1 && n < this.rfpStatisticConfigTable.getRowCount()) {
                GenericDataRecord genericDataRecord;
                this.rfpStatisticConfigTable.setRowSelectionInterval(n, n);
                if (bl && (genericDataRecord = this.rfpStatisticConfigDb.getRecordByIdx(n2)) != null) {
                    this.processTableEvent(genericDataRecord);
                }
            }
        } else {
            this.rfpStatisticConfigDb.updateIndex();
        }
    }
}

