/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticConfigPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticRecord;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpStatisticDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private RfpStatisticPanel rfpStatisticPanel = null;
    private AastraPanel tabDetail = null;
    private AastraButton buttonResetSingle = null;
    private AastraButton buttonCancel = null;
    private AastraTextField[] textFieldCounter = new AastraTextField[]{null, null, null};
    private AastraLabel[] labelCounter = new AastraLabel[]{null, null, null};

    public RfpStatisticDetailPanel(RfpStatisticPanel rfpStatisticPanel) {
        super(0, 50);
        this.rfpStatisticPanel = rfpStatisticPanel;
        this.initialize();
    }

    public void setStatDetailDataHeader(int n) {
        String string;
        if (this.labelHeaderBar != null) {
            string = String.format("%s #0x%03X", UtilLocale.getString("TXT_RADIO_FIXED_PART"), n);
            this.labelHeaderBar.setText(string);
        }
        if (this.panelTabbed != null && this.panelTabbed.getTabCount() > 0 && this.textFieldCounter != null) {
            string = String.format("%s - %s", RfpStatisticConfigPanel.getCurrentRfpStatGroup(), RfpStatisticConfigPanel.getCurrentRfpStatName());
            this.panelTabbed.setTitleAt(0, string);
            for (int i = 0; i <= 2; ++i) {
                this.textFieldCounter[i].setText("");
            }
        }
    }

    public void setData(RfpStatisticRecord rfpStatisticRecord) {
        int n = RfpStatisticConfigPanel.getCurrentRfpElemId();
        this.textFieldCounter[0].setText(rfpStatisticRecord.getStatValues(0, n));
        this.textFieldCounter[1].setText(rfpStatisticRecord.getStatValues(1, n));
        this.textFieldCounter[2].setText(rfpStatisticRecord.getStatValues(2, n));
    }

    public void clearData() {
        this.textFieldCounter[0].setText("");
        this.textFieldCounter[1].setText("");
        this.textFieldCounter[2].setText("");
    }

    private void initialize() {
        this.panelTabbed.addTab("", null, this.getTabDetail(), null);
        this.panelButtonBar.add((Component)this.getButtonResetSingleCounter(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabDetail() {
        if (this.tabDetail == null) {
            this.tabDetail = new AastraPanel();
            this.tabDetail.setLayout(null);
            for (int i = 0; i < 3; ++i) {
                this.tabDetail.add(this.getLabel(i));
                this.tabDetail.add(this.getTextField(i));
            }
        }
        return this.tabDetail;
    }

    private AastraLabel getLabel(int n) {
        if (this.labelCounter[n] == null) {
            int n2 = 20 + 30 * n;
            String[] stringArray = new String[]{UtilLocale.getString("TXT_TOTAL"), UtilLocale.getString("TXT_CURRENT_WEEK"), UtilLocale.getString("TXT_LAST_WEEK")};
            String string = stringArray[n];
            this.labelCounter[n] = new AastraLabel();
            this.labelCounter[n].setBounds(50, n2, 111, 16);
            this.labelCounter[n].setText(string);
        }
        return this.labelCounter[n];
    }

    private AastraTextField getTextField(int n) {
        if (this.textFieldCounter[n] == null) {
            int n2 = 20 + 30 * n;
            this.textFieldCounter[n] = new AastraTextField();
            this.textFieldCounter[n].setBounds(200, n2, 50, 18);
            this.textFieldCounter[n].setEditable(false);
        }
        return this.textFieldCounter[n];
    }

    private AastraButton getButtonResetSingleCounter() {
        if (this.buttonResetSingle == null) {
            this.buttonResetSingle = new AastraButton();
            this.buttonResetSingle.setBounds(70, 15, 90, 25);
            this.buttonResetSingle.setText(UtilLocale.getString("TXT_CLEAR"));
            this.buttonResetSingle.setToolTipText(UtilLocale.getString("TXT_CLEAR_SELECTED_COUNTER"));
            this.buttonResetSingle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpStatisticDetailPanel.this.rfpStatisticPanel.resetSingleCounterOnCurrentRfp(RfpStatisticConfigPanel.getCurrentRfpElemId());
                }
            });
        }
        return this.buttonResetSingle;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(200, 15, 90, 25);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpStatisticDetailPanel.this.rfpStatisticPanel.removeRfpStatisticDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }
}

