/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.rfpstatistic.RfpStatisticGroupTaskPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticVectorDatabase;
import com.aastra.omilib.DataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraScrollPane;
import java.awt.Dimension;

public class RfpStatisticGroupPanel
extends AastraScrollPane
implements ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    private ConfiguratorTable tableStatGroup = null;
    private RfpStatisticVectorDatabase rfpStatisticVectorDb = null;
    private RfpStatisticGroupTaskPanel rfpStatisticGroupTaskPanel = null;
    private int[] colums = null;
    private int columNb = 0;
    private int selectedRfpInTab = -1;

    public RfpStatisticGroupPanel(RfpStatisticVectorDatabase rfpStatisticVectorDatabase, int[] nArray, int n, RfpStatisticGroupTaskPanel rfpStatisticGroupTaskPanel) {
        super(null);
        this.rfpStatisticVectorDb = rfpStatisticVectorDatabase;
        this.colums = nArray;
        this.columNb = n;
        this.rfpStatisticGroupTaskPanel = rfpStatisticGroupTaskPanel;
        this.initialize();
    }

    public int getSelectedRfpInGroupTab() {
        return this.selectedRfpInTab;
    }

    private void initialize() {
        this.setViewportView(this.getTableStatGroup());
        this.setPreferredSize(new Dimension(100, 200));
    }

    private ConfiguratorTable getTableStatGroup() {
        if (this.tableStatGroup == null) {
            this.tableStatGroup = new ConfiguratorTable(this.rfpStatisticVectorDb);
            this.rfpStatisticVectorDb.registerTable(this.tableStatGroup);
            this.tableStatGroup.setColumnArr(this.colums, this.columNb);
            this.tableStatGroup.setSelectionMode(0);
            this.tableStatGroup.setColumnFormatString(0, "0x%03X");
            this.tableStatGroup.registerEventListener(this);
            this.disableTableAccess();
        }
        return this.tableStatGroup;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.tableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.tableEvent(dataRecord);
    }

    protected void disableTableAccess() {
        this.tableStatGroup.setActive(false);
        this.rfpStatisticGroupTaskPanel.disableAllTaskButtons();
    }

    protected void enableTableAccess() {
        this.tableStatGroup.setActive(true);
        if (this.tableStatGroup.getRowCount() > 0) {
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearAllCntAllRfp(true);
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearGroupCntAllRfp(true);
            this.rfpStatisticGroupTaskPanel.setTaskButtonRefreshAll(true);
        }
    }

    private void tableEvent(DataRecord dataRecord) {
        if (dataRecord != null) {
            this.selectedRfpInTab = (Integer)dataRecord.getField(0);
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearAllCntSelectedRfp(true);
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearGroupCntSelectedRfp(true);
            this.rfpStatisticGroupTaskPanel.setTaskButtonRefreshRfp(true);
        } else {
            this.selectedRfpInTab = -1;
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearAllCntSelectedRfp(false);
            this.rfpStatisticGroupTaskPanel.setTaskButtonClearGroupCntSelectedRfp(false);
            this.rfpStatisticGroupTaskPanel.setTaskButtonRefreshRfp(false);
        }
    }
}

