/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiNavigationPanel;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticConfigDatabase;
import com.aastra.oamp.rfpstatistic.RfpStatisticConfigPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticConfigRecord;
import com.aastra.oamp.rfpstatistic.RfpStatisticDetailPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticRecord;
import com.aastra.oamp.rfpstatistic.RfpStatisticSplitGroupPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticTaskPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticVectorDatabase;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataNotificationInterface;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraSplitPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.tree.DefaultMutableTreeNode;

public class RfpStatisticPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
OmiMessageInterface,
OmiManagementEventInterface,
RfpDataNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RFP_STAT_CONFIG_GROUPS = 10;
    protected static final int MAX_COLUMS_PER_GROUP = 10;
    private static final int MAX_SEQUENCE_NB = 5000;
    private static final int MAX_RFP_STATISTIC_BULK_RECORDS = 20;
    protected static final int xSizeDetailPanelSurcharge = 0;
    protected static final int ySizeDetailPanelSurcharge = 50;
    private static final int ySizeDetailPanel = 260;
    private static final int LAST_BULK_SEND_REQUEST_TYPE = SendRequestType.BULK_RFP_TIME_LAST_WEEK.ordinal();
    private static final int NUMBER_BULK_SEND_REQUEST_TYPES = SendRequestType.BULK_RFP_TIME_LAST_WEEK.ordinal() + 1;
    private int[] bulkReceived = new int[NUMBER_BULK_SEND_REQUEST_TYPES];
    private boolean[] bulkFinished = new boolean[NUMBER_BULK_SEND_REQUEST_TYPES];
    private AastraSplitPane rfpStatMainSplitPanel = null;
    private AastraScrollPane rfpIdTabScrollPanel = null;
    private ConfiguratorTable rfpIdTab = null;
    private GuiUtilDetailSplitPanel rfpStatisticDetailSplitPanel = null;
    private RfpStatisticConfigPanel rfpStatisticConfigPanel = null;
    private RfpStatisticDetailPanel rfpStatisticDetailPanel = null;
    private RfpStatisticTaskPanel rfpStatisticTaskPanel = null;
    private RfpDatabase rfpDb = null;
    private RfpDataHandler rfpDataHandler = null;
    private OmiManagement omiManagement = null;
    private RfpStatisticConfigDatabase rfpStatisticConfigDb = null;
    private RfpStatisticVectorDatabase rfpStatisticVectorDb = null;
    private String[] groups = new String[10];
    private int[] numberOfColums = new int[10];
    private int[][] arrayColums = new int[10][10];
    private int currentRfpId = -1;
    private DefaultMutableTreeNode nodeRfpStat = null;
    private RfpStatisticSplitGroupPanel[] rfpStatisticSplitGroupPanel = new RfpStatisticSplitGroupPanel[10];
    private int cntStatisticGroupPanels = 0;
    private String[] rfpStatConfGroupFieldNames = new String[41];
    private int sendRequestSeqNb = 0;
    private int sendResetSeqNb = 0;
    private SendRequestType[] sendRequest = new SendRequestType[5000];
    private int[] sendResetRfpId = new int[5000];
    private int rcvRfpId = -1;
    private String rcvCounterSet = null;
    private int msgNumElemPerRec = 0;
    private int msgRecordSets = 0;
    private String msgResolution = null;
    private int msgElemId = 0;
    private String msgGroup = null;
    private String msgName = null;
    private int dividerLocation = 0;
    private boolean dataBulkReadyRfp = false;
    private boolean anyRfpStatisticPanelActivated = false;

    public RfpStatisticPanel(RfpDataHandler rfpDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.initialize();
    }

    private void initialize() {
        this.omiManagement.registerManagementEventListener(this);
        this.rfpDataHandler.registerDataNotificationListener(this);
        this.rfpDataHandler.registerRfpStatisticListener(this);
        this.rfpDb = this.rfpDataHandler.getDatabase();
        this.rfpStatisticConfigDb = new RfpStatisticConfigDatabase();
        this.rfpStatisticVectorDb = new RfpStatisticVectorDatabase();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRfpStatMainSplitPanel(), "Center");
        this.add((Component)this.getRfpStatTaskPanel(), "East");
    }

    public int getCurrentRfpId() {
        return this.currentRfpId;
    }

    private AastraSplitPane getRfpStatMainSplitPanel() {
        if (this.rfpStatMainSplitPanel == null) {
            this.rfpStatMainSplitPanel = new AastraSplitPane();
            this.rfpStatMainSplitPanel.setOrientation(1);
            this.rfpStatMainSplitPanel.setLeftComponent(this.getRfpIdTabScrollPanel());
            this.rfpStatMainSplitPanel.setRightComponent(this.getRfpStatDetailSplitPanel());
            this.rfpStatMainSplitPanel.setDividerSize(0);
        }
        return this.rfpStatMainSplitPanel;
    }

    private AastraPanel getRfpStatTaskPanel() {
        if (this.rfpStatisticTaskPanel == null) {
            this.rfpStatisticTaskPanel = new RfpStatisticTaskPanel(this);
        }
        return this.rfpStatisticTaskPanel;
    }

    private GuiUtilDetailSplitPanel getRfpStatDetailSplitPanel() {
        if (this.rfpStatisticDetailSplitPanel == null) {
            this.rfpStatisticDetailSplitPanel = new GuiUtilDetailSplitPanel(260);
            this.rfpStatisticDetailSplitPanel.setTopComponent(null);
            this.rfpStatisticDetailSplitPanel.setBottomComponent(null);
        }
        return this.rfpStatisticDetailSplitPanel;
    }

    private RfpStatisticConfigPanel getRfpStatConfigPanel() {
        if (this.rfpStatisticConfigPanel == null) {
            this.rfpStatisticConfigPanel = new RfpStatisticConfigPanel(this, this.rfpStatisticConfigDb);
            this.dividerLocation = this.rfpStatisticDetailSplitPanel.getHeight() - 260;
            this.rfpStatisticConfigPanel.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.rfpStatisticConfigPanel;
    }

    private void createRfpStatisticDetailPanel() {
        if (this.rfpStatisticDetailSplitPanel.getBottomComponent() == null) {
            this.rfpStatisticDetailSplitPanel.setBottomComponent(this.getRfpStatisticDetailPanel());
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP statistic detail panel");
        } else {
            this.dividerLocation = this.rfpStatisticDetailSplitPanel.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP statistic detail panel");
        }
        this.rfpStatisticDetailPanel.setStatDetailDataHeader(this.currentRfpId);
        RfpStatisticRecord rfpStatisticRecord = this.rfpStatisticVectorDb.getRecordByRfpId(this.currentRfpId);
        if (rfpStatisticRecord != null) {
            this.rfpStatisticDetailPanel.setData(rfpStatisticRecord);
        }
        this.rfpStatisticDetailSplitPanel.setDividerLocation(this.dividerLocation);
        this.rfpStatisticDetailSplitPanel.validate();
    }

    public void removeRfpStatisticDetailPanel() {
        this.dividerLocation = this.rfpStatisticDetailSplitPanel.getDividerLocation();
        this.rfpStatisticDetailSplitPanel.setBottomComponent(null);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing RFP statistic detail panel");
    }

    private RfpStatisticDetailPanel getRfpStatisticDetailPanel() {
        if (this.rfpStatisticDetailPanel == null) {
            this.rfpStatisticDetailPanel = new RfpStatisticDetailPanel(this);
        }
        return this.rfpStatisticDetailPanel;
    }

    private AastraScrollPane getRfpIdTabScrollPanel() {
        if (this.rfpIdTabScrollPanel == null) {
            this.rfpIdTabScrollPanel = new AastraScrollPane(null);
            this.rfpIdTabScrollPanel.setViewportView(this.getRfpIdTab());
            this.rfpIdTabScrollPanel.setPreferredSize(new Dimension(100, 200));
        }
        return this.rfpIdTabScrollPanel;
    }

    private ConfiguratorTable getRfpIdTab() {
        if (this.rfpIdTab == null) {
            this.rfpIdTab = new ConfiguratorTable(this.rfpDb);
            this.rfpIdTab.setSelectionMode(0);
            int[] nArray = new int[]{RfpDataRecord.IDX_RFP_ID};
            this.rfpIdTab.setColumnArr(nArray, nArray.length);
            this.rfpIdTab.registerEventListener(this);
            this.rfpIdTab.setColumnFormatString(RfpDataRecord.IDX_RFP_ID, "0x%03X");
            this.disableRfpIdTableAccess();
        }
        return this.rfpIdTab;
    }

    public void initRfpStatisticDetailPanel() {
        if (this.currentRfpId != -1 && RfpStatisticConfigPanel.getCurrentRfpStatGroup() != null && RfpStatisticConfigPanel.getCurrentRfpStatName() != null) {
            this.createRfpStatisticDetailPanel();
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetRFPStatisticConfigResp: {
                this.processGetRfpStatisticConfigResp(omiMessage);
                break;
            }
            case GetRFPStatisticResp: {
                if (!this.processGetRfpStatisticResponse(omiMessage)) break;
                this.setStatisticGroupTableAccess(true);
                break;
            }
            case ResetRFPStatisticResp: {
                this.processResetRFPStatisticResp(omiMessage);
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Link management event: " + omiManagementEventEnum.toString());
            this.rfpStatisticConfigDb.clearAll();
            this.rfpStatisticVectorDb.clearAll();
            this.dataBulkReadyRfp = false;
            this.resetStatisticConfigGroups();
            this.disableRfpIdTableAccess();
            this.rfpDataHandler.sendGetRFPStatisticConfig();
        }
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (dataRecord != null) {
            this.currentRfpId = (Integer)dataRecord.getField(RfpDataRecord.IDX_RFP_ID);
            this.setTabCounterVal();
            if (this.rfpStatisticDetailSplitPanel.getBottomComponent() != null) {
                this.initRfpStatisticDetailPanel();
            }
            this.rfpStatisticTaskPanel.setTaskButtonRefreshRfp(true);
            this.rfpStatisticTaskPanel.setTaskButtonClearRfp(true);
        } else {
            this.currentRfpId = -1;
            this.rfpStatisticTaskPanel.setTaskButtonRefreshRfp(true);
            this.rfpStatisticTaskPanel.setTaskButtonClearRfp(true);
        }
    }

    public void refreshSelectedRfp(int n) {
        this.rfpStatisticVectorDb.deleteRecord(n);
        this.sendReqSingleRfp(n);
    }

    public void refreshCurrentRfp() {
        if (this.currentRfpId != -1) {
            this.rfpStatisticVectorDb.deleteRecord(this.currentRfpId);
            this.sendReqSingleRfp(this.currentRfpId);
        }
    }

    private void sendReqSingleRfp(int n) {
        for (int i = SendRequestType.SINGLE_RFP_TIME_OVERALL.ordinal(); i <= SendRequestType.SINGLE_RFP_TIME_LAST_WEEK.ordinal(); ++i) {
            this.rfpDataHandler.sendGetRFPStatistic(this.sendRequestSeqNb, n, 1, i - SendRequestType.SINGLE_RFP_TIME_OVERALL.ordinal());
            this.sendRequest[this.sendRequestSeqNb] = SendRequestType.values()[i];
            if (++this.sendRequestSeqNb != 256) continue;
            this.sendRequestSeqNb = 0;
        }
    }

    protected void requestAllRfpStatisticData() {
        this.setStatisticGroupTableAccess(false);
        this.rfpStatisticVectorDb.clearAll();
        this.startReqBulkRfpAllSets();
    }

    private void startReqBulkRfpAllSets() {
        this.startReqBulkRfpSingleSet(SendRequestType.BULK_RFP_TIME_OVERALL);
        this.startReqBulkRfpSingleSet(SendRequestType.BULK_RFP_TIME_CURRENT_WEEK);
        this.startReqBulkRfpSingleSet(SendRequestType.BULK_RFP_TIME_LAST_WEEK);
    }

    private void startReqBulkRfpSingleSet(SendRequestType sendRequestType) {
        this.sendReqBulkRfp(0, sendRequestType);
    }

    private void continueReqBulkRfp(int n, SendRequestType sendRequestType) {
        this.sendReqBulkRfp(n, sendRequestType);
    }

    private void sendReqBulkRfp(int n, SendRequestType sendRequestType) {
        this.bulkFinished[sendRequestType.ordinal()] = false;
        this.bulkReceived[sendRequestType.ordinal()] = 0;
        this.rfpDataHandler.sendGetRFPStatistic(this.sendRequestSeqNb, n, 20, sendRequestType.ordinal());
        this.sendRequest[this.sendRequestSeqNb] = sendRequestType;
        if (++this.sendRequestSeqNb == 5000) {
            this.sendRequestSeqNb = 0;
        }
    }

    private void sendResetStatRfp(int n, int n2) {
        this.rfpDataHandler.sendResetRFPStatistic(this.sendResetSeqNb, n, n2);
        this.sendResetRfpId[this.sendResetSeqNb] = n;
        if (++this.sendResetSeqNb == 5000) {
            this.sendResetSeqNb = 0;
        }
    }

    public void resetSingleCounterOnSingleRfp(int n, int n2) {
        this.sendResetStatRfp(n, n2);
    }

    public void resetSingleCounterOnCurrentRfp(int n) {
        if (this.currentRfpId != -1) {
            this.sendResetStatRfp(this.currentRfpId, n);
        }
    }

    public void resetSingleCounterOnAllRfps(int n) {
        this.setStatisticGroupTableAccess(false);
        this.sendResetStatRfp(-1, n);
    }

    public void resetAllCounterOnSelectedRfp(int n) {
        this.sendResetStatRfp(n, -1);
    }

    public void resetAllCounterOnCurrentRfp() {
        if (this.currentRfpId != -1) {
            this.sendResetStatRfp(this.currentRfpId, -1);
        }
    }

    public void resetAllCounterOnAllRfps() {
        this.setStatisticGroupTableAccess(false);
        this.sendResetStatRfp(-1, -1);
    }

    private void processGetRfpStatisticConfigResp(OmiMessage omiMessage) {
        int n = 1;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            OmiMessage.elemIds elemIds2 = this.parseSubElemGetRfpStatisticConfigResp(omiMessage2);
            if (elemIds2 == OmiMessage.elemIds.rfpStatHead || elemIds2 != OmiMessage.elemIds.rfpStatName) continue;
            String string = this.msgGroup.substring(0, 1).toUpperCase() + this.msgGroup.substring(1);
            RfpStatisticConfigRecord rfpStatisticConfigRecord = new RfpStatisticConfigRecord();
            rfpStatisticConfigRecord.setField(0, this.msgElemId);
            rfpStatisticConfigRecord.setField(1, this.msgName);
            rfpStatisticConfigRecord.setField(2, string);
            this.rfpStatisticConfigDb.createRecord(rfpStatisticConfigRecord);
            this.rfpStatConfGroupFieldNames[n] = this.msgName;
            this.buildRfpStatSubTree(string, n);
            ++n;
        }
        this.rfpStatisticDetailSplitPanel.setTopComponent(this.getRfpStatConfigPanel());
        this.cntStatisticGroupPanels = this.addRfpStatisticGroupPanels();
    }

    private OmiMessage.elemIds parseSubElemGetRfpStatisticConfigResp(OmiMessage omiMessage) {
        if (omiMessage.id == OmiMessage.elemIds.rfpStatHead) {
            this.msgNumElemPerRec = omiMessage.getAttribValInt(omiMessage.getFirstAttribName());
            this.msgRecordSets = omiMessage.getAttribValInt(omiMessage.getNextAttribName());
            this.msgResolution = omiMessage.getAttribVal(omiMessage.getNextAttribName());
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "rfpStatHead:" + this.msgNumElemPerRec + "," + this.msgRecordSets + "," + this.msgResolution);
        } else if (omiMessage.id == OmiMessage.elemIds.rfpStatName) {
            this.msgElemId = omiMessage.getAttribValInt(omiMessage.getFirstAttribName());
            this.msgGroup = omiMessage.getAttribVal(omiMessage.getNextAttribName());
            this.msgName = omiMessage.getAttribVal(omiMessage.getNextAttribName());
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "rfpStatName:" + this.msgElemId + "," + this.msgGroup + "," + this.msgName);
        }
        return omiMessage.id;
    }

    private boolean processGetRfpStatisticResponse(OmiMessage omiMessage) {
        OmiMessage.elemIds elemIds2;
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
        if (string == null) {
            return false;
        }
        int n = Integer.parseInt(string);
        if (n >= 5000) {
            return false;
        }
        int n2 = this.sendRequest[n].ordinal();
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        if (n2 <= LAST_BULK_SEND_REQUEST_TYPE) {
            this.bulkFinished[n2] = true;
        }
        while ((elemIds2 = this.parseSubElemGetRfpStatResp(omiMessage2)) != null) {
            if (elemIds2 == OmiMessage.elemIds.rfpStatData) {
                this.setDetailData(this.sendRequest[n]);
                if (n2 <= LAST_BULK_SEND_REQUEST_TYPE) {
                    int n3 = n2;
                    this.bulkReceived[n3] = this.bulkReceived[n3] + 1;
                    if (this.bulkReceived[n3] == 20) {
                        this.continueReqBulkRfp(this.rcvRfpId + 1, this.sendRequest[n]);
                    }
                }
            }
            omiMessage2 = omiMessage2.getNext();
        }
        if (n2 <= LAST_BULK_SEND_REQUEST_TYPE) {
            for (int i = 0; i <= LAST_BULK_SEND_REQUEST_TYPE; ++i) {
                if (this.bulkFinished[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setDetailData(SendRequestType sendRequestType) {
        int n;
        RfpStatisticRecord rfpStatisticRecord = this.rfpStatisticVectorDb.getRecordByRfpId(this.rcvRfpId);
        if (rfpStatisticRecord == null) {
            rfpStatisticRecord = new RfpStatisticRecord(this.rcvRfpId);
        }
        String[] stringArray = this.rcvCounterSet.split(",", 40);
        int[] nArray = new int[40];
        for (n = 0; n < stringArray.length; ++n) {
            nArray[n] = Integer.valueOf(stringArray[n]);
        }
        n = sendRequestType.ordinal() <= LAST_BULK_SEND_REQUEST_TYPE ? sendRequestType.ordinal() : sendRequestType.ordinal() - NUMBER_BULK_SEND_REQUEST_TYPES;
        rfpStatisticRecord.setStatValues(n, nArray);
        this.rfpStatisticVectorDb.createRecord(rfpStatisticRecord);
        if (this.currentRfpId == this.rcvRfpId) {
            this.setTabCounterVal();
            this.updateRfpDetailPanelData();
        }
    }

    private OmiMessage.elemIds parseSubElemGetRfpStatResp(OmiMessage omiMessage) {
        if (omiMessage != null && omiMessage.id == OmiMessage.elemIds.rfpStatData) {
            this.rcvRfpId = omiMessage.getAttribValInt(omiMessage.getFirstAttribName());
            this.rcvCounterSet = omiMessage.getAttribVal(omiMessage.getNextAttribName());
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "parseSubElemGetRfpStatResp:" + this.rcvRfpId + "," + this.rcvCounterSet);
            return omiMessage.id;
        }
        return null;
    }

    private void processResetRFPStatisticResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
        if (string == null) {
            return;
        }
        int n = Integer.parseInt(string);
        if (n >= 5000) {
            return;
        }
        if (this.sendResetRfpId[n] == -1) {
            this.startReqBulkRfpAllSets();
        } else {
            this.sendReqSingleRfp(this.sendResetRfpId[n]);
        }
    }

    public void setMenuTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.nodeRfpStat = defaultMutableTreeNode;
    }

    private void buildRfpStatSubTree(String string, int n) {
        int n2 = 0;
        while (this.groups[n2] != null) {
            if (this.groups[n2].compareTo(string) == 0) {
                this.addCounterCol(n2, n);
                return;
            }
            ++n2;
        }
        this.groups[n2] = string;
        this.numberOfColums[n2] = 1;
        this.arrayColums[n2][0] = 0;
        this.addCounterCol(n2, n);
    }

    private void addCounterCol(int n, int n2) {
        boolean bl = false;
        if (n >= 10) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "addCounterCol: Number of groups=" + n + " out of range");
            bl = true;
        }
        if (this.numberOfColums[n] >= 10) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "addCounterCol: Number of colums=" + this.numberOfColums[n] + " out of range");
            bl = true;
        }
        if (!bl) {
            this.arrayColums[n][this.numberOfColums[n]] = n2;
            int n3 = n;
            this.numberOfColums[n3] = this.numberOfColums[n3] + 1;
        }
    }

    private int addRfpStatisticGroupPanels() {
        int n = 0;
        if (this.nodeRfpStat != null) {
            this.rfpStatConfGroupFieldNames[0] = UtilLocale.getString("TXT_RFP_ID");
            this.rfpStatisticVectorDb.setFieldNames(this.rfpStatConfGroupFieldNames);
            this.nodeRfpStat.removeAllChildren();
            while (this.groups[n] != null) {
                GuiNavigationPanel.addEntry(this.nodeRfpStat, this.groups[n], this.getRfpStatisticSplitGroupPanel(n), this.getRfpStatisticSplitGroupPanel(n));
                ++n;
            }
        }
        return n;
    }

    private RfpStatisticSplitGroupPanel getRfpStatisticSplitGroupPanel(int n) {
        if (this.rfpStatisticSplitGroupPanel[n] == null) {
            this.rfpStatisticSplitGroupPanel[n] = new RfpStatisticSplitGroupPanel(this, this.rfpStatisticVectorDb, this.arrayColums[n], this.numberOfColums[n]);
        }
        return this.rfpStatisticSplitGroupPanel[n];
    }

    private void resetStatisticConfigGroups() {
        for (int i = 0; i < 10; ++i) {
            this.groups[i] = null;
            this.numberOfColums[i] = 0;
            for (int j = 0; j < 10; ++j) {
                this.arrayColums[i][j] = 0;
            }
        }
    }

    @Override
    public void processRfpDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "RFP notification: " + dataNotificationEnum.toString() + ",rfpId=" + n);
        switch (dataNotificationEnum) {
            case DATA_BULK_READY: {
                this.enableRfpIdTableAccess();
                this.dataBulkReadyRfp = true;
                if (!this.anyRfpStatisticPanelActivated) break;
                this.requestAllRfpStatisticData();
                break;
            }
            case DATA_DELETED: {
                if (this.currentRfpId != n) break;
                this.currentRfpId = -1;
                return;
            }
        }
        if (this.rfpIdTab.getRowCount() > 0) {
            this.rfpIdTab.setRowSelectionInterval(0, 0);
        }
        if (this.currentRfpId == -1 && dataNotificationEnum == DataNotificationEnum.NEW_DATA) {
            this.currentRfpId = n;
        }
    }

    @Override
    public void processRfpErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
    }

    @Override
    public void componentActivated(Component component) {
        this.processComponentActivated(component);
    }

    @Override
    public void componentDeactivated() {
        this.processComponentDeactivated();
    }

    protected void processComponentActivated(Component component) {
        if (this.dataBulkReadyRfp && !(component instanceof RfpStatisticPanel) && !(component instanceof RfpStatisticSplitGroupPanel)) {
            this.requestAllRfpStatisticData();
        }
        this.anyRfpStatisticPanelActivated = true;
    }

    protected void processComponentDeactivated() {
        this.anyRfpStatisticPanelActivated = false;
    }

    public void setTabCounterVal() {
        if (this.currentRfpId != -1) {
            RfpStatisticRecord rfpStatisticRecord = this.rfpStatisticVectorDb.getRecordByRfpId(this.currentRfpId);
            int n = this.rfpStatisticConfigDb.getRecordNumber();
            for (int i = 0; i < n; ++i) {
                RfpStatisticConfigRecord rfpStatisticConfigRecord = (RfpStatisticConfigRecord)this.rfpStatisticConfigDb.getRecordByIdx(i);
                if (rfpStatisticRecord != null) {
                    rfpStatisticConfigRecord.setField(3, (Integer)rfpStatisticRecord.getField(i + 1));
                    continue;
                }
                rfpStatisticConfigRecord.setField(3, -1);
            }
            this.rfpStatisticConfigPanel.updateRfpStatisticConfigDb(this.rfpStatisticDetailSplitPanel.getBottomComponent() != null);
        }
    }

    private void updateRfpDetailPanelData() {
        if (this.rfpStatisticDetailSplitPanel.getBottomComponent() != null && this.currentRfpId != -1) {
            RfpStatisticRecord rfpStatisticRecord = this.rfpStatisticVectorDb.getRecordByRfpId(this.currentRfpId);
            if (rfpStatisticRecord != null) {
                this.rfpStatisticDetailPanel.setData(rfpStatisticRecord);
            } else {
                this.rfpStatisticDetailPanel.clearData();
            }
        }
    }

    private void disableRfpIdTableAccess() {
        this.rfpIdTab.setActive(false);
    }

    private void enableRfpIdTableAccess() {
        this.rfpIdTab.setActive(true);
    }

    private void setStatisticGroupTableAccess(boolean bl) {
        for (int i = 0; i < this.cntStatisticGroupPanels; ++i) {
            this.rfpStatisticSplitGroupPanel[i].enableStatisticGroupTableAccess(bl);
        }
        if (bl) {
            this.rfpStatisticTaskPanel.setTaskButtonRefreshAll(true);
            this.rfpStatisticTaskPanel.setTaskButtonClearAll(true);
            if (this.rfpIdTab.getSelectedRowCount() > 0) {
                this.rfpStatisticTaskPanel.setTaskButtonRefreshRfp(true);
                this.rfpStatisticTaskPanel.setTaskButtonClearRfp(true);
            } else {
                this.rfpStatisticTaskPanel.setTaskButtonRefreshRfp(false);
                this.rfpStatisticTaskPanel.setTaskButtonClearRfp(false);
            }
        } else {
            this.rfpStatisticTaskPanel.disableAllTaskButtons();
        }
    }

    private static enum SendRequestType {
        BULK_RFP_TIME_OVERALL,
        BULK_RFP_TIME_CURRENT_WEEK,
        BULK_RFP_TIME_LAST_WEEK,
        SINGLE_RFP_TIME_OVERALL,
        SINGLE_RFP_TIME_CURRENT_WEEK,
        SINGLE_RFP_TIME_LAST_WEEK;

    }
}

