/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.rfpstatistic;

import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.rfpstatistic.RfpStatisticPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.style.AastraLinkButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class RfpStatisticTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private RfpStatisticPanel rfpStatisticPanel = null;
    private AastraLinkButton buttonClearAll = null;
    private AastraLinkButton buttonClearRfp = null;
    private AastraLinkButton buttonRefreshAll = null;
    private AastraLinkButton buttonRefreshRfp = null;

    public RfpStatisticTaskPanel(RfpStatisticPanel rfpStatisticPanel) {
        this.rfpStatisticPanel = rfpStatisticPanel;
        this.initialize();
    }

    private void initialize() {
        this.add(this.getButtonRefreshRfp());
        this.add(this.getButtonRefreshAll());
        this.add(this.getButtonClearRfp());
        this.add(this.getbuttonClearAll());
    }

    private AastraLinkButton getButtonRefreshRfp() {
        if (this.buttonRefreshRfp == null) {
            this.buttonRefreshRfp = this.createTaskButtonEnabled(UtilLocale.getString("TXT_REFRESH_RFP_20"), UtilLocale.getString("TXT_REFRESH_ALL_COUNTERS_FOR_SELECTED_RFP"));
            this.buttonRefreshRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpStatisticTaskPanel.this.rfpStatisticPanel.refreshCurrentRfp();
                }
            });
        }
        return this.buttonRefreshRfp;
    }

    private AastraLinkButton getButtonRefreshAll() {
        if (this.buttonRefreshAll == null) {
            this.buttonRefreshAll = this.createTaskButtonEnabled(UtilLocale.getString("TXT_REFRESH_ALL_20"), UtilLocale.getString("TXT_REFRESH_ALL_COUNTERS_FOR_ALL_RFPS"));
            this.buttonRefreshAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpStatisticTaskPanel.this.rfpStatisticPanel.requestAllRfpStatisticData();
                }
            });
        }
        return this.buttonRefreshAll;
    }

    private AastraLinkButton getButtonClearRfp() {
        if (this.buttonClearRfp == null) {
            this.buttonClearRfp = this.createTaskButtonEnabled(UtilLocale.getString("TXT_CLEAR_RFP_20"), UtilLocale.getString("TXT_CLEAR_ALL_COUNTERS_FOR_SELECTED_RFP"));
            this.buttonClearRfp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpStatisticTaskPanel.this.rfpStatisticPanel.resetAllCounterOnCurrentRfp();
                }
            });
        }
        return this.buttonClearRfp;
    }

    private AastraLinkButton getbuttonClearAll() {
        if (this.buttonClearAll == null) {
            this.buttonClearAll = this.createTaskButtonEnabled(UtilLocale.getString("TXT_CLEAR_ALL_20"), UtilLocale.getString("TXT_CLEAR_ALL_COUNTERS_FOR_ALL_RFPS"));
            this.buttonClearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_CLEAR_ALL_COUNTERS_FOR_ALL_RFPS_?"), true);
                    if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                        RfpStatisticTaskPanel.this.rfpStatisticPanel.resetAllCounterOnAllRfps();
                    }
                }
            });
        }
        return this.buttonClearAll;
    }

    protected void disableAllTaskButtons() {
        this.setTaskButtonRefreshRfp(false);
        this.setTaskButtonRefreshAll(false);
        this.setTaskButtonClearRfp(false);
        this.setTaskButtonClearAll(false);
    }

    protected void setTaskButtonRefreshRfp(boolean bl) {
        this.buttonRefreshRfp.setEnabled(bl);
    }

    protected void setTaskButtonRefreshAll(boolean bl) {
        this.buttonRefreshAll.setEnabled(bl);
    }

    protected void setTaskButtonClearRfp(boolean bl) {
        this.buttonClearRfp.setEnabled(bl);
    }

    protected void setTaskButtonClearAll(boolean bl) {
        this.buttonClearAll.setEnabled(bl);
    }
}

