/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.site;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.site.SiteMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SiteDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private SiteMainPanel siteMainPanel = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelName = null;
    private GuiUtilTextField textFieldName = null;
    private AastraLabel labelId = null;
    private GuiUtilTextField textFieldId = null;
    private AastraLabel labelWideband = null;
    private GuiUtilCheckBox checkBoxWideband = null;
    private AastraLabel labelInfoSiteChange = null;
    private AastraLabel labelSrtp = null;
    private GuiUtilComboBox comboBoxSrtp = null;
    private AastraLabel labelDectSecurity = null;
    private GuiUtilCheckBox checkBoxDectSecurity = null;
    private AastraLabel labelVideoStreaming = null;
    private GuiUtilCheckBox checkBoxVideoStreaming = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private SiteDataHandler.Site site = null;
    private boolean haveSRTP = GuiMain.getOmiManagementObject().getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP);
    private boolean haveVideo = GuiMain.getOmiManagementObject().getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo);
    private boolean haveDECTSecurity = this.haveSRTP;
    private boolean isEditable = true;
    private boolean widebandAndVideoAllowed = false;
    private boolean srtpAllowed = false;
    private boolean dectSecurityAllowed = false;
    private ActionModeEnum actionMode;

    public SiteDetailPanel(SiteMainPanel siteMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(240, 150);
        this.siteMainPanel = siteMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        } else {
            this.isEditable = false;
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(185, 15, 150, 18);
        }
        return this.textFieldName;
    }

    private GuiUtilCheckBox getCheckBoxWideband() {
        if (this.checkBoxWideband == null) {
            this.checkBoxWideband = new GuiUtilCheckBox(this.utilChangeHandler, 180, 45);
            if (this.isEditable) {
                this.checkBoxWideband.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!SiteDetailPanel.this.widebandAndVideoAllowed && !SiteDetailPanel.this.checkBoxWideband.isSelected()) {
                            SiteDetailPanel.this.checkBoxWideband.setEnabled(false);
                            SiteDetailPanel.this.checkBoxWideband.setToolTipText(UtilLocale.getString("TXT_SITE_HI_Q_AUDIO_TECHNOLOGY_TOOL_TIP"));
                        }
                    }
                });
            }
        }
        return this.checkBoxWideband;
    }

    private GuiUtilCheckBox getCheckBoxDectSecurity() {
        if (this.checkBoxDectSecurity == null) {
            this.checkBoxDectSecurity = new GuiUtilCheckBox(this.utilChangeHandler, 180, 75);
            if (this.isEditable) {
                this.checkBoxDectSecurity.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!SiteDetailPanel.this.dectSecurityAllowed && !SiteDetailPanel.this.checkBoxDectSecurity.isSelected()) {
                            SiteDetailPanel.this.checkBoxDectSecurity.setEnabled(false);
                            SiteDetailPanel.this.checkBoxDectSecurity.setToolTipText(UtilLocale.getString("TXT_SITE_DECT_SECURITY_TOOL_TIP"));
                        }
                    }
                });
            }
        }
        return this.checkBoxDectSecurity;
    }

    private GuiUtilCheckBox getCheckBoxVideoStreaming() {
        if (this.checkBoxVideoStreaming == null) {
            this.checkBoxVideoStreaming = new GuiUtilCheckBox(this.utilChangeHandler, 180, 105);
            if (this.isEditable) {
                this.checkBoxVideoStreaming.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!SiteDetailPanel.this.widebandAndVideoAllowed && !SiteDetailPanel.this.checkBoxVideoStreaming.isSelected()) {
                            SiteDetailPanel.this.checkBoxVideoStreaming.setEnabled(false);
                            SiteDetailPanel.this.checkBoxVideoStreaming.setToolTipText(UtilLocale.getString("TXT_SITE_TERMINAL_VIDEO_TOOL_TIP"));
                        }
                    }
                });
            }
        }
        return this.checkBoxVideoStreaming;
    }

    private GuiUtilComboBox getComboBoxSrtp() {
        if (this.comboBoxSrtp == null) {
            this.comboBoxSrtp = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxSrtp.setBounds(185, 140, 150, 20);
            for (int i = 0; i < OmiMessage.SrtpStateType.values().length; ++i) {
                this.comboBoxSrtp.addItem(OmiMessage.SrtpStateType.values()[i].toString());
            }
            if (this.isEditable) {
                this.comboBoxSrtp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SiteDetailPanel.this.srtpAllowed || OmiMessage.SrtpStateType.guiValueToEnum((String)SiteDetailPanel.this.comboBoxSrtp.getSelectedItem()) != OmiMessage.SrtpStateType.Disabled) {
                            SiteDetailPanel.this.comboBoxSrtp.setEnabled(true);
                            SiteDetailPanel.this.comboBoxSrtp.setToolTipText(null);
                        } else {
                            SiteDetailPanel.this.comboBoxSrtp.setEnabled(false);
                            SiteDetailPanel.this.comboBoxSrtp.setToolTipText(UtilLocale.getString("TXT_SITE_SRTP_TOOL_TIP"));
                        }
                    }
                });
            }
            this.comboBoxSrtp.activateActionListener();
        }
        return this.comboBoxSrtp;
    }

    private GuiUtilTextField getTextFieldId() {
        if (this.textFieldId == null) {
            this.textFieldId = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldId.setBounds(185, 180, 50, 18);
            this.textFieldId.setVisible(false);
        }
        return this.textFieldId;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SiteDetailPanel.this.utilChangeHandler.deactivate();
                    SiteDetailPanel.this.utilErrorComp.clearComponents();
                    if (SiteDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SiteDetailPanel.this.siteMainPanel.changeSite();
                    } else {
                        SiteDetailPanel.this.siteMainPanel.createSite();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SiteDetailPanel.this.isEditable) {
                        SiteDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SiteDetailPanel.this.siteMainPanel.removeSiteDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelName = new AastraLabel();
            this.labelName.setBounds(30, 15, 91, 32);
            this.labelName.setText("<html>" + UtilLocale.getString("TXT_NAME") + "</html>");
            this.labelWideband = new AastraLabel();
            this.labelWideband.setBounds(30, 45, 140, 32);
            this.labelWideband.setText("<html>" + UtilLocale.getString("TXT_HI-Q_AUDIO_TECHNOLOGY") + "</html>");
            this.labelInfoSiteChange = new AastraLabel();
            this.labelInfoSiteChange.setBounds(350, 45, 250, 64);
            this.labelInfoSiteChange.setText("<html>" + UtilLocale.getString("TXT_INFO_CHANGING_SITE_PARAMS") + "</html>");
            this.labelInfoSiteChange.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            if (this.haveDECTSecurity) {
                this.labelDectSecurity = new AastraLabel();
                this.labelDectSecurity.setBounds(30, 75, 140, 32);
                this.labelDectSecurity.setText("<html>" + UtilLocale.getString("TXT_ENHANCED_DECT_SECURITY") + "</html>");
            }
            if (this.haveVideo) {
                this.labelVideoStreaming = new AastraLabel();
                this.labelVideoStreaming.setBounds(30, 105, 140, 32);
                this.labelVideoStreaming.setText("<html>" + UtilLocale.getString("TXT_TERMINAL_VIDEO") + "</html>");
            }
            if (this.haveSRTP) {
                this.labelSrtp = new AastraLabel();
                this.labelSrtp.setBounds(30, 140, 140, 16);
                this.labelSrtp.setText("SRTP");
            }
            this.labelId = new AastraLabel();
            this.labelId.setBounds(30, 180, 30, 16);
            this.labelId.setText(UtilLocale.getString("TXT_ID"));
            this.labelId.setVisible(false);
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelName, null);
            this.tabGeneral.add((Component)this.getTextFieldName(), null);
            this.tabGeneral.add((Component)this.labelWideband, null);
            this.tabGeneral.add((Component)this.getCheckBoxWideband(), null);
            this.tabGeneral.add((Component)this.labelInfoSiteChange, null);
            if (this.haveDECTSecurity) {
                this.tabGeneral.add((Component)this.labelDectSecurity, null);
                this.tabGeneral.add((Component)this.getCheckBoxDectSecurity(), null);
            }
            if (this.haveVideo) {
                this.tabGeneral.add((Component)this.labelVideoStreaming, null);
                this.tabGeneral.add((Component)this.getCheckBoxVideoStreaming(), null);
            }
            if (this.haveSRTP) {
                this.tabGeneral.add((Component)this.labelSrtp, null);
                this.tabGeneral.add((Component)this.getComboBoxSrtp(), null);
            }
            this.tabGeneral.add((Component)this.labelId, null);
            this.tabGeneral.add((Component)this.getTextFieldId(), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.SiteType.name.toString(), this.labelName, this.textFieldName);
                this.utilErrorComp.put(OmiMessage.SiteType.id.toString(), this.labelId, this.textFieldId);
                this.utilErrorComp.put(OmiMessage.SiteType.wideband.name(), this.labelWideband, this.checkBoxWideband);
                if (this.haveVideo) {
                    this.utilErrorComp.put(OmiMessage.SiteType.videoStreaming.name(), this.labelVideoStreaming, this.checkBoxVideoStreaming);
                }
                if (this.haveDECTSecurity) {
                    this.utilErrorComp.put(OmiMessage.SiteType.dectSecurity.name(), this.labelDectSecurity, this.checkBoxDectSecurity);
                }
                if (this.haveSRTP) {
                    this.utilErrorComp.put(OmiMessage.SiteType.srtp.name(), this.labelSrtp, this.comboBoxSrtp);
                }
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    public void setSiteDetailData(SiteDataHandler.Site site, boolean bl, boolean bl2, boolean bl3) {
        this.widebandAndVideoAllowed = bl;
        this.srtpAllowed = bl2;
        this.dectSecurityAllowed = bl3;
        this.labelId.setVisible(false);
        this.textFieldId.setVisible(false);
        this.labelInfoSiteChange.setVisible(false);
        if (site != null) {
            this.site = (SiteDataHandler.Site)site.clone();
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_SITE") + " #" + this.site.id);
            this.textFieldName.setText(this.site.name);
            this.checkBoxWideband.setSelected(this.site.wideband);
            if (this.isEditable) {
                this.labelInfoSiteChange.setVisible(true);
            }
            if (this.haveDECTSecurity) {
                this.checkBoxDectSecurity.setSelected(this.site.dectSecurity);
            }
            if (this.haveSRTP) {
                this.comboBoxSrtp.deactivateActionListener();
                this.comboBoxSrtp.setSelectedItem(this.site.srtp.toString());
                this.comboBoxSrtp.activateActionListener();
            }
            if (this.haveVideo) {
                this.checkBoxVideoStreaming.setSelected(this.site.videoStreaming);
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.site = null;
            if (this.isEditable) {
                this.labelId.setVisible(true);
                this.textFieldId.setVisible(true);
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_SITE"));
            } else {
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_RECORD_INVALID"));
            }
            this.textFieldName.setText("");
            this.textFieldId.setText("");
            this.checkBoxWideband.setSelected(false);
            if (this.haveDECTSecurity) {
                this.checkBoxDectSecurity.setSelected(false);
            }
            if (this.haveSRTP) {
                this.comboBoxSrtp.deactivateActionListener();
                this.comboBoxSrtp.setSelectedItem(OmiMessage.SrtpStateType.Disabled.toString());
                this.comboBoxSrtp.activateActionListener();
            }
            if (this.haveVideo) {
                this.checkBoxVideoStreaming.setSelected(false);
            }
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            if (this.widebandAndVideoAllowed || this.site != null && this.site.wideband) {
                this.checkBoxWideband.setEnabled(true);
                this.checkBoxWideband.setToolTipText(null);
            } else {
                this.checkBoxWideband.setEnabled(false);
                this.checkBoxWideband.setToolTipText(UtilLocale.getString("TXT_SITE_HI_Q_AUDIO_TECHNOLOGY_TOOL_TIP"));
            }
            if (this.haveVideo) {
                if (this.widebandAndVideoAllowed || this.site != null && this.site.videoStreaming) {
                    this.checkBoxVideoStreaming.setEnabled(true);
                    this.checkBoxVideoStreaming.setToolTipText(null);
                } else {
                    this.checkBoxVideoStreaming.setEnabled(false);
                    this.checkBoxVideoStreaming.setToolTipText(UtilLocale.getString("TXT_SITE_TERMINAL_VIDEO_TOOL_TIP"));
                }
            }
            if (this.haveDECTSecurity) {
                if (this.dectSecurityAllowed || this.site != null && this.site.dectSecurity) {
                    this.checkBoxDectSecurity.setEnabled(true);
                    this.checkBoxDectSecurity.setToolTipText(null);
                } else {
                    this.checkBoxDectSecurity.setEnabled(false);
                    this.checkBoxDectSecurity.setToolTipText(UtilLocale.getString("TXT_SITE_DECT_SECURITY_TOOL_TIP"));
                }
            }
            this.utilChangeHandler.initRootPane(this.getRootPane());
            this.getTextFieldName().requestFocusInWindow();
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public SiteDataHandler.Site getSiteDetailData() {
        String string;
        if (this.site == null) {
            this.site = new SiteDataHandler.Site();
        }
        if (this.textFieldId.isVisible()) {
            if (this.textFieldId.getText().isEmpty()) {
                this.site.id = 0;
            } else {
                this.site.id = UtilMisc.getIntFromTextField(this.textFieldId, UtilLocale.getString("TXT_ID"), this.utilErrorComp, 10);
                if (this.site.id == -1) {
                    return null;
                }
            }
        }
        if ((string = this.textFieldName.getText()).length() <= 0) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_NAME")));
            this.markErrorComponent(OmiMessage.SiteType.name.toString());
            return null;
        }
        this.site.name = string;
        this.site.wideband = this.checkBoxWideband.isSelected();
        if (this.haveDECTSecurity) {
            this.site.dectSecurity = this.checkBoxDectSecurity.isSelected();
        }
        if (this.haveSRTP) {
            this.site.srtp = OmiMessage.SrtpStateType.guiValueToEnum((String)this.comboBoxSrtp.getSelectedItem());
        }
        if (this.haveVideo) {
            this.site.videoStreaming = this.checkBoxVideoStreaming.isSelected();
        }
        return this.site;
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void markErrorComponent(String string) {
        JComponent jComponent;
        if (string != null && (jComponent = this.utilErrorComp.getField(string)) != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

