/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.statistic;

import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.LinkedList;

public class StatisticChart
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private static int xMax = 300;
    private static int yMax = 200;
    private int highlightPos = -1;
    private int distLeftDown = 30;
    private int distRightUpper = this.distLeftDown / 3;
    private int arrowWidth = 10;
    private int arrowLen = 15;
    private int xlen;
    private int ylen;
    private boolean vectorOrderInvers = false;
    private LinkedList<IntVector> vectors = new LinkedList();
    private int min = 0;
    private int max = 0;
    private int noOfVectors = 0;
    private int maxLen = 0;
    private ChartType type;
    private LinkedList<ChartSelectionInterface> chartListenerList = new LinkedList();

    public void registerChartSelectionListener(ChartSelectionInterface chartSelectionInterface) {
        this.chartListenerList.add(chartSelectionInterface);
    }

    private void GenerateSelectionEvent(int n) {
        for (ChartSelectionInterface chartSelectionInterface : this.chartListenerList) {
            if (chartSelectionInterface == null) continue;
            chartSelectionInterface.valueSelected(n);
        }
    }

    public StatisticChart(ChartType chartType) {
        this.type = chartType;
        this.initialize();
    }

    private int getMin(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            int n2 = nArray[0];
            for (int i = 1; i < n; ++i) {
                if (nArray[i] >= n2) continue;
                n2 = nArray[i];
            }
            return n2;
        }
        return 0;
    }

    private int getMax(int[] nArray) {
        if (nArray != null) {
            int n = nArray.length;
            int n2 = nArray[0];
            for (int i = 1; i < n; ++i) {
                if (nArray[i] <= n2) continue;
                n2 = nArray[i];
            }
            return n2;
        }
        return 0;
    }

    private void addVector(int[] nArray, Color color, String string, boolean bl) {
        IntVector intVector = new IntVector();
        intVector.vector = nArray;
        intVector.min = this.getMin(nArray);
        intVector.max = this.getMax(nArray);
        intVector.color = color;
        intVector.name = string;
        this.vectorOrderInvers = bl;
        this.vectors.add(intVector);
        if (this.noOfVectors == 0) {
            this.min = intVector.min;
            this.max = intVector.max;
            if (this.max == 0) {
                this.max = 1;
            }
        } else {
            if (intVector.min < this.min) {
                this.min = intVector.min;
            }
            if (intVector.max > this.max) {
                this.max = intVector.max;
            }
        }
        if (nArray.length > this.maxLen) {
            this.maxLen = nArray.length;
        }
        ++this.noOfVectors;
        this.repaint();
    }

    public void addVector(int[] nArray, Color color, String string) {
        this.addVector(nArray, color, string, false);
    }

    public void addVector(int[] nArray, String string) {
        this.addVector(nArray, Color.black, string);
    }

    public void addVector(int[] nArray) {
        this.addVector(nArray, Color.black, null);
    }

    public void addVector(int[] nArray, Color color) {
        this.addVector(nArray, color, null);
    }

    public void setVector(int[] nArray, Color color, String string, boolean bl) {
        this.vectors.clear();
        this.noOfVectors = 0;
        this.maxLen = 0;
        this.addVector(nArray, color, string, bl);
    }

    public void setVector(int[] nArray, String string) {
        this.setVector(nArray, Color.black, string, false);
    }

    public void setVector(int[] nArray) {
        this.setVector(nArray, Color.black, null, false);
    }

    public void setVector(int[] nArray, Color color) {
        this.setVector(nArray, color, null, false);
    }

    public void setVectorInverse(int[] nArray, Color color) {
        this.setVector(nArray, color, null, true);
    }

    public void setHighlight(int n) {
        int n2 = this.vectorOrderInvers ? this.maxLen - n - 1 : n;
        if (n2 != this.highlightPos) {
            this.highlightPos = n2;
            this.repaint();
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = (point.x - StatisticChart.this.distLeftDown) * StatisticChart.this.maxLen / (StatisticChart.this.xlen - 10);
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_STAT, this, "mousePressed: x=" + point.x + ",idx=" + n);
                if (n >= 0 && n < StatisticChart.this.maxLen) {
                    if (StatisticChart.this.vectorOrderInvers) {
                        StatisticChart.this.GenerateSelectionEvent(StatisticChart.this.maxLen - n - 1);
                    } else {
                        StatisticChart.this.GenerateSelectionEvent(n);
                    }
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        xMax = (int)dimension.getWidth();
        yMax = (int)dimension.getHeight();
        graphics2D.setColor(Color.black);
        int n = this.distLeftDown;
        int n2 = yMax - this.distLeftDown;
        this.xlen = xMax - this.distLeftDown - this.distRightUpper;
        this.ylen = yMax - this.distLeftDown - this.distRightUpper;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        graphics2D.draw(new Line2D.Double(n, n2, n + this.xlen, n2));
        nArray[0] = n + this.xlen + this.arrowLen / 2;
        nArray2[0] = n2;
        nArray[1] = n + this.xlen - this.arrowLen / 2;
        nArray2[1] = n2 + this.arrowWidth / 2;
        nArray[2] = n + this.xlen - this.arrowLen / 2;
        nArray2[2] = n2 - this.arrowWidth / 2;
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.draw(new Line2D.Double(n, n2, n, n2 - this.ylen));
        nArray[0] = n;
        nArray2[0] = n2 - this.ylen - this.arrowLen / 2;
        nArray[1] = n - this.arrowWidth / 2;
        nArray2[1] = n2 - this.ylen + this.arrowLen / 2;
        nArray[2] = n + this.arrowWidth / 2;
        nArray2[2] = n2 - this.ylen + this.arrowLen / 2;
        graphics2D.fillPolygon(nArray, nArray2, 3);
        int n3 = 0;
        for (IntVector intVector : this.vectors) {
            if (intVector == null) continue;
            graphics2D.setColor(intVector.color);
            switch (this.type) {
                case Line: {
                    int n4;
                    GeneralPath generalPath = new GeneralPath();
                    if (this.vectorOrderInvers) {
                        generalPath.moveTo(n, n2 - intVector.vector[intVector.vector.length - 1] * (this.ylen - 10) / this.max);
                    } else {
                        generalPath.moveTo(n, n2 - intVector.vector[0] * (this.ylen - 10) / this.max);
                    }
                    for (n4 = 1; n4 < intVector.vector.length; ++n4) {
                        int n5 = this.vectorOrderInvers ? intVector.vector.length - n4 - 1 : n4;
                        double d = (double)n + (double)n4 * (double)(this.xlen - 10) / (double)this.maxLen;
                        double d2 = (double)n2 - (double)intVector.vector[n5] * (double)(this.ylen - 10) / (double)this.max;
                        generalPath.lineTo(d, d2);
                    }
                    graphics2D.draw(generalPath);
                    break;
                }
                case BarGraph: {
                    int n4;
                    double d = (double)(this.xlen - 10) / (double)this.maxLen;
                    double d3 = 0.2 * d / 2.0;
                    for (n4 = 0; n4 < intVector.vector.length; ++n4) {
                        int n6 = this.vectorOrderInvers ? intVector.vector.length - n4 - 1 : n4;
                        double d4 = (double)intVector.vector[n6] * (double)(this.ylen - 10) / (double)this.max;
                        double d5 = (double)n + (double)n4 * d;
                        if (this.highlightPos == n4) {
                            graphics2D.setColor(Color.ORANGE);
                        } else {
                            graphics2D.setColor(intVector.color);
                        }
                        graphics2D.fillRect((int)(d5 + d3), n2 - (int)d4, (int)(d - 2.0 * d3), (int)d4);
                    }
                    break;
                }
            }
            graphics2D.setColor(intVector.color);
            if (intVector.name != null) {
                graphics2D.drawString(intVector.name, n + 50, n3 * 10 + 10);
            }
            ++n3;
        }
    }

    private class IntVector {
        public int[] vector = null;
        public String name = null;
        public Color color = Color.black;
        public int min = 0;
        public int max = 0;

        private IntVector() {
        }
    }

    public static enum ChartType {
        Points,
        Line,
        BarGraph;

    }

    public static interface ChartSelectionInterface {
        public void valueSelected(int var1);
    }
}

