/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.statistic;

import com.aastra.oamp.statistic.StatisticChart;
import com.aastra.oamp.statistic.StatisticDataRecord;
import com.aastra.oamp.statistic.SysStatisticPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.GenericDataRecord;
import com.aastra.omilib.GenericDatabase;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SysStatisticHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.omilibgui.ConfiguratorTableModel;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraHeaderBar;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraSplitPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class StatisticDetailPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
StatisticChart.ChartSelectionInterface {
    private static final long serialVersionUID = 1L;
    private SysStatisticPanel sysStatisticPanel = null;
    private AastraHeaderBar headerBarRfp = null;
    private AastraSplitPane splitPane = null;
    private AastraPanel leftPanel = null;
    private JScrollPane rightScrollPane = null;
    private ConfiguratorTable jTable = null;
    private AastraPanel detailData = null;
    private StatisticChart chart = null;
    private AastraLabel title = null;
    private AastraButton resetButton = null;
    private AastraButton refreshButton = null;
    private AastraButton cancelButton = null;
    private AastraLabel sumLabel = null;
    private AastraLabel ageLabel = null;
    private AastraLabel sumValue = null;
    private AastraLabel ageValue = null;
    private AastraLabel ageUnit = null;
    private AastraComboBox selectBox = null;
    private StatisticDataRecord currentRecord = null;
    private CounterDb counterDb = new CounterDb();
    SysStatisticHandler statHandler = null;
    public static int xSize = 600;
    public static int ySize = 400;
    private static int xSizeLeft = 420;
    private static int ySizeDetailData = 130;
    private static final Color[] colors = new Color[]{Color.BLACK, Color.blue, Color.cyan, Color.green, Color.lightGray, Color.orange, Color.pink, Color.red, Color.yellow};
    private Items currentItem = Items.distribution;
    private JLabel jUnitLabel = null;
    private JLabel labelUnit = null;

    public void setMode(ModeEnum modeEnum) {
        if (modeEnum == ModeEnum.SIMPLE) {
            this.counterDb.setMode(Items.occurrence);
            this.selectBox.setVisible(false);
        } else {
            this.selectBox.setVisible(true);
        }
    }

    public StatisticDetailPanel(SysStatisticHandler sysStatisticHandler, SysStatisticPanel sysStatisticPanel) {
        this.statHandler = sysStatisticHandler;
        this.sysStatisticPanel = sysStatisticPanel;
        this.initialize();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(xSize, ySize));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderDetailPanel));
        this.add((Component)this.getHeaderBarRfp(), "North");
        this.add((Component)this.getSplitPane(), "Center");
    }

    private AastraHeaderBar getHeaderBarRfp() {
        if (this.headerBarRfp == null) {
            this.headerBarRfp = new AastraHeaderBar();
            this.headerBarRfp.setPreferredSize(new Dimension(0, 30));
            this.title = new AastraLabel();
            this.title.setFont(AastraCommon.AastraFontHeader);
            this.title.setForeground(AastraCommon.MitelStatusBarForeground);
            this.title.setText(UtilLocale.getString("TXT_TITLE"));
            this.headerBarRfp.add(this.title);
        }
        return this.headerBarRfp;
    }

    private AastraSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new AastraSplitPane();
            this.splitPane.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderDetailPanel));
            this.splitPane.setLeftComponent(this.getLeftPanel());
            this.splitPane.setRightComponent(this.getRightScrollPane());
        }
        return this.splitPane;
    }

    private AastraPanel getLeftPanel() {
        if (this.leftPanel == null) {
            this.leftPanel = new AastraPanel();
            this.leftPanel.setLayout(new BorderLayout());
            this.leftPanel.setMinimumSize(new Dimension(xSizeLeft, 0));
            this.leftPanel.setPreferredSize(new Dimension(xSizeLeft, ySize));
            this.leftPanel.add((Component)this.getDetailData(), "North");
            this.leftPanel.add((Component)this.getChart(), "Center");
        }
        return this.leftPanel;
    }

    private JScrollPane getRightScrollPane() {
        if (this.rightScrollPane == null) {
            this.rightScrollPane = new JScrollPane();
            this.rightScrollPane.setPreferredSize(new Dimension(xSize - xSizeLeft, ySize));
            this.rightScrollPane.setMaximumSize(new Dimension(xSize - xSizeLeft, ySize));
            this.rightScrollPane.setViewportView(this.getJTable());
        }
        return this.rightScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new ConfiguratorTable(this.counterDb);
            this.jTable.setSelectionMode(0);
            int[] nArray = new int[]{1, 2, 3};
            this.jTable.setColumnArr(nArray, nArray.length);
            this.jTable.registerEventListener(this);
        }
        return this.jTable;
    }

    private AastraPanel getDetailData() {
        if (this.detailData == null) {
            this.labelUnit = new AastraLabel();
            this.labelUnit.setBounds(15, 65, 50, 15);
            this.labelUnit.setText(UtilLocale.getString("TXT_UNIT") + ":");
            this.jUnitLabel = new AastraLabel();
            this.jUnitLabel.setBounds(75, 65, 90, 15);
            this.jUnitLabel.setText("");
            this.ageUnit = new AastraLabel();
            this.ageUnit.setBounds(120, 40, 50, 15);
            this.ageUnit.setText("");
            this.ageValue = new AastraLabel();
            this.ageValue.setText("");
            this.ageValue.setBounds(75, 40, 43, 15);
            this.sumValue = new AastraLabel();
            this.sumValue.setBounds(75, 15, 60, 15);
            this.sumValue.setText("");
            this.ageLabel = new AastraLabel();
            this.ageLabel.setBounds(15, 40, 50, 15);
            this.ageLabel.setText(UtilLocale.getString("TXT_AGE") + ":");
            this.sumLabel = new AastraLabel();
            this.sumLabel.setBounds(15, 15, 50, 15);
            this.sumLabel.setText(UtilLocale.getString("TXT_TOTAL") + ":");
            this.detailData = new AastraPanel();
            this.detailData.setLayout(null);
            this.detailData.setPreferredSize(new Dimension(0, ySizeDetailData));
            this.detailData.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTabbedPane));
            this.detailData.add((Component)this.sumLabel, null);
            this.detailData.add((Component)this.ageLabel, null);
            this.detailData.add((Component)this.sumValue, null);
            this.detailData.add((Component)this.ageValue, null);
            this.detailData.add((Component)this.ageUnit, null);
            this.detailData.add((Component)this.getSelectBox(), null);
            this.detailData.add((Component)this.jUnitLabel, null);
            this.detailData.add((Component)this.labelUnit, null);
            this.detailData.add((Component)this.getRefreshButton(), null);
            this.detailData.add((Component)this.getResetButton(), null);
            this.detailData.add((Component)this.getCancelButton(), null);
        }
        return this.detailData;
    }

    private StatisticChart getChart() {
        if (this.chart == null) {
            this.chart = new StatisticChart(StatisticChart.ChartType.BarGraph);
            this.chart.registerChartSelectionListener(this);
        }
        return this.chart;
    }

    private AastraButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new AastraButton();
            this.resetButton.setBounds(315, 15, 90, 25);
            this.resetButton.setToolTipText(UtilLocale.getString("TXT_CLEAR_THIS_COUNTER"));
            this.resetButton.setText(UtilLocale.getString("TXT_CLEAR"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatisticDetailPanel.this.statHandler.sendResetSysStatistic((Integer)StatisticDetailPanel.this.currentRecord.getField(2));
                }
            });
        }
        return this.resetButton;
    }

    private AastraButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new AastraButton();
            this.cancelButton.setBounds(315, 90, 90, 25);
            this.cancelButton.setText(UtilLocale.getString("TXT_CANCEL"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatisticDetailPanel.this.sysStatisticPanel.removeStatisticDetailPanel();
                }
            });
        }
        return this.cancelButton;
    }

    public void setDataRecord(StatisticDataRecord statisticDataRecord) {
        this.currentRecord = statisticDataRecord;
        this.title.setText((String)statisticDataRecord.getField(1));
        this.sumValue.setText("" + (Integer)statisticDataRecord.getField(6));
        this.ageValue.setText("" + (Integer)statisticDataRecord.getField(10));
        if ((OmiMessage.StatisticType)((Object)statisticDataRecord.getField(3)) == OmiMessage.StatisticType.occurrence) {
            this.setMode(ModeEnum.SIMPLE);
            this.jUnitLabel.setText("");
            this.labelUnit.setText("");
            this.counterDb.setValueFieldName(UtilLocale.getString("TXT_NUMBER"));
            this.ageUnit.setText((String)statisticDataRecord.getField(16));
        } else {
            this.setMode(ModeEnum.MINMAX);
            this.jUnitLabel.setText((String)statisticDataRecord.getField(15));
            this.ageUnit.setText((String)statisticDataRecord.getField(16));
            this.labelUnit.setText(UtilLocale.getString("TXT_UNIT") + ":");
        }
        if (statisticDataRecord.occurenceVector != null) {
            this.getChart().setVectorInverse(statisticDataRecord.occurenceVector, colors[1]);
            this.getChart().validate();
        }
        ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
    }

    private AastraComboBox getSelectBox() {
        if (this.selectBox == null) {
            this.selectBox = new AastraComboBox();
            this.selectBox.setBounds(15, 95, 130, 20);
            this.selectBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    Items items = (Items)((Object)itemEvent.getItem());
                    if (items != StatisticDetailPanel.this.currentItem) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "System statistic type=" + items.name() + " selected");
                        StatisticDetailPanel.this.currentItem = items;
                        switch (items) {
                            case distribution: {
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMaxSummary((Integer)StatisticDetailPanel.this.currentRecord.getField(2));
                                StatisticDetailPanel.this.showDistribution();
                                break;
                            }
                            case average: {
                                if (StatisticDetailPanel.this.statHandler == null) break;
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), OmiMessage.StatisticType.sum);
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), OmiMessage.StatisticType.occurrence);
                                break;
                            }
                            case occurrence: 
                            case min: 
                            case max: {
                                if (StatisticDetailPanel.this.statHandler == null) break;
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), items.type);
                            }
                        }
                    }
                }
            });
            this.selectBox.setModel(new DefaultComboBoxModel<Items>(Items.values()));
        }
        return this.selectBox;
    }

    public void showDistribution() {
        this.counterDb.setMode(Items.distribution);
        this.counterDb.setValueFieldName(UtilLocale.getString("TXT_NUMBER"));
        ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
        this.title.setText(this.currentRecord.getField(1) + ", " + Items.distribution.guival);
        this.getChart().setVector(this.currentRecord.distributionValues, colors[1]);
        this.getChart().validate();
        this.getSelectBox().setSelectedItem((Object)Items.distribution);
    }

    public void setVector(OmiMessage.StatisticType statisticType, int[] nArray, int n, int n2) {
        this.currentRecord.setField(7, n);
        this.currentRecord.setField(8, n2);
        this.currentRecord.setField(9, new Date().getTime());
        switch (statisticType) {
            case min: {
                this.currentRecord.minVector = nArray;
                if (this.currentItem != Items.min) break;
                this.counterDb.setMode(Items.min);
                this.counterDb.setValueFieldName((String)this.currentRecord.getField(15));
                ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
                this.title.setText(this.currentRecord.getField(1) + ", " + Items.min.guival);
                this.getChart().setVectorInverse(this.currentRecord.minVector, colors[1]);
                break;
            }
            case max: {
                this.currentRecord.maxVector = nArray;
                if (this.currentItem != Items.max) break;
                this.counterDb.setValueFieldName((String)this.currentRecord.getField(15));
                this.counterDb.setMode(Items.max);
                ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
                this.title.setText(this.currentRecord.getField(1) + ", " + Items.max.guival);
                this.getChart().setVectorInverse(this.currentRecord.maxVector, colors[1]);
                break;
            }
            case sum: {
                this.currentRecord.sumVector = nArray;
                break;
            }
            case occurrence: {
                this.currentRecord.occurenceVector = nArray;
                if (this.currentItem == Items.occurrence) {
                    this.counterDb.setValueFieldName(UtilLocale.getString("TXT_NUMBER"));
                    this.counterDb.setMode(Items.occurrence);
                    ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
                    this.title.setText(this.currentRecord.getField(1) + ", " + Items.occurrence.guival);
                    this.getChart().setVectorInverse(this.currentRecord.occurenceVector, colors[1]);
                }
                if (this.currentItem != Items.average) break;
                this.currentRecord.averageVector = new int[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this.currentRecord.averageVector[i] = this.currentRecord.occurenceVector[i] > 0 ? this.currentRecord.sumVector[i] / this.currentRecord.occurenceVector[i] : 0;
                }
                this.counterDb.setMode(Items.average);
                this.counterDb.setValueFieldName((String)this.currentRecord.getField(15));
                ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableStructureChanged();
                this.title.setText(this.currentRecord.getField(1) + ", " + Items.average.guival);
                this.getChart().setVectorInverse(this.currentRecord.averageVector, colors[1]);
                break;
            }
        }
        this.getChart().repaint();
    }

    private void processTableEvent(DataRecord dataRecord) {
        if (dataRecord != null) {
            GenericDataRecord genericDataRecord = (GenericDataRecord)dataRecord;
            int n = (Integer)genericDataRecord.getField(0);
            this.getChart().setHighlight(n);
            this.getChart().repaint();
        } else {
            this.getChart().setHighlight(-1);
            this.getChart().repaint();
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void valueSelected(int n) {
        this.getChart().setHighlight(n);
        this.getJTable().setRowSelectionInterval(n, n);
    }

    private AastraButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new AastraButton();
            this.refreshButton.setBounds(210, 15, 90, 25);
            this.refreshButton.setText(UtilLocale.getString("TXT_REFRESH"));
            this.refreshButton.setToolTipText(UtilLocale.getString("TXT_REFRESH_THIS_COUNTER"));
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (Integer)StatisticDetailPanel.this.currentRecord.getField(2);
                    if ((OmiMessage.StatisticType)((Object)StatisticDetailPanel.this.currentRecord.getField(3)) == OmiMessage.StatisticType.occurrence) {
                        StatisticDetailPanel.this.statHandler.sendGetSysStatisticOccurrence(n);
                    } else {
                        Items items = (Items)((Object)StatisticDetailPanel.this.getSelectBox().getSelectedItem());
                        switch (items) {
                            case distribution: {
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMaxSummary((Integer)StatisticDetailPanel.this.currentRecord.getField(2));
                                StatisticDetailPanel.this.showDistribution();
                                break;
                            }
                            case average: {
                                if (StatisticDetailPanel.this.statHandler == null) break;
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), OmiMessage.StatisticType.sum);
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), OmiMessage.StatisticType.occurrence);
                                break;
                            }
                            case occurrence: 
                            case min: 
                            case max: {
                                if (StatisticDetailPanel.this.statHandler == null) break;
                                StatisticDetailPanel.this.statHandler.sendGetSysStatisticMinMax((Integer)StatisticDetailPanel.this.currentRecord.getField(2), items.type);
                            }
                        }
                    }
                }
            });
        }
        return this.refreshButton;
    }

    private static enum Items {
        distribution(UtilLocale.getString("TXT_DISTRIBUTION"), null),
        min(UtilLocale.getString("TXT_MINIMUM"), OmiMessage.StatisticType.min),
        max(UtilLocale.getString("TXT_MAXIMUM"), OmiMessage.StatisticType.max),
        average(UtilLocale.getString("TXT_AVERAGE"), OmiMessage.StatisticType.sum),
        occurrence(UtilLocale.getString("TXT_OCCURRENCES"), OmiMessage.StatisticType.occurrence);

        public String guival;
        public OmiMessage.StatisticType type;

        private Items(String string2, OmiMessage.StatisticType statisticType) {
            this.guival = string2;
            this.type = statisticType;
        }

        public String toString() {
            return this.guival;
        }
    }

    class CounterDb
    extends GenericDatabase {
        private Items item = Items.occurrence;

        public CounterDb() {
            this.setFieldName(1, UtilLocale.getString("TXT_FROM_20"));
            this.setFieldName(2, UtilLocale.getString("TXT_TO_20"));
            this.setFieldName(3, UtilLocale.getString("TXT_NUMBER_20"));
        }

        private String getTimeStamp(Calendar calendar) {
            String string = null;
            Formatter formatter = new Formatter();
            formatter.format("%02d.%02d. %02d:%02d", calendar.get(5), calendar.get(2) + 1, calendar.get(11), calendar.get(12));
            string = formatter.toString();
            formatter.close();
            return string;
        }

        public void setValueFieldName(String string) {
            this.setFieldName(3, string);
        }

        @Override
        public GenericDataRecord getRecordByIdx(int n) {
            int[] nArray = null;
            if (StatisticDetailPanel.this.currentRecord != null) {
                switch (this.item) {
                    case occurrence: {
                        nArray = ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.occurenceVector;
                        break;
                    }
                    case average: {
                        nArray = ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.averageVector;
                        break;
                    }
                    case min: {
                        nArray = ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.minVector;
                        break;
                    }
                    case max: {
                        nArray = ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.maxVector;
                        break;
                    }
                    case distribution: {
                        nArray = ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionValues;
                    }
                }
                if (nArray != null && n < nArray.length) {
                    long l;
                    long l2;
                    GenericDataRecord genericDataRecord = new GenericDataRecord(n);
                    genericDataRecord.setField(0, n);
                    if (this.item == Items.distribution) {
                        if (n == 0) {
                            genericDataRecord.setField(1, 0);
                            genericDataRecord.setField(2, ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionUnits[n]);
                        } else if (n < ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionUnits.length) {
                            genericDataRecord.setField(1, ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionUnits[n - 1]);
                            genericDataRecord.setField(2, ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionUnits[n]);
                        } else {
                            genericDataRecord.setField(1, ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionUnits[n - 1]);
                            genericDataRecord.setField(2, "...");
                        }
                        genericDataRecord.setField(3, nArray[n]);
                        return genericDataRecord;
                    }
                    long l3 = (Long)StatisticDetailPanel.this.currentRecord.getField(9);
                    int n2 = 3600;
                    if (n > 0) {
                        if (n == nArray.length - 1) {
                            l2 = l3 - (long)(1000 * n2 * (n - 1)) - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(7)) - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(8));
                            l = l3 - (long)(1000 * n2 * (n - 1)) - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(7));
                        } else {
                            l2 = l3 - (long)(1000 * n2 * n) - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(7));
                            l = l3 - (long)(1000 * n2 * (n - 1)) - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(7));
                        }
                    } else {
                        l2 = l3 - (long)(1000 * (Integer)StatisticDetailPanel.this.currentRecord.getField(7));
                        l = l3;
                    }
                    Date date = new Date();
                    Calendar calendar = Calendar.getInstance();
                    date.setTime(l2);
                    calendar.setTime(date);
                    genericDataRecord.setField(1, this.getTimeStamp(calendar));
                    date.setTime(l);
                    calendar.setTime(date);
                    genericDataRecord.setField(2, this.getTimeStamp(calendar));
                    genericDataRecord.setField(3, nArray[n]);
                    return genericDataRecord;
                }
            }
            return null;
        }

        public void setMode(Items items) {
            this.item = items;
        }

        @Override
        public int getRecordNumber() {
            if (StatisticDetailPanel.this.currentRecord != null) {
                switch (this.item) {
                    case occurrence: {
                        if (((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.occurenceVector == null) break;
                        return ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.occurenceVector.length;
                    }
                    case average: {
                        if (((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.occurenceVector == null || ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.sumVector == null) break;
                        return ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.occurenceVector.length;
                    }
                    case min: {
                        if (((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.minVector == null) break;
                        return ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.minVector.length;
                    }
                    case max: {
                        if (((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.maxVector == null) break;
                        return ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.maxVector.length;
                    }
                    case distribution: {
                        if (((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionValues == null) break;
                        return ((StatisticDetailPanel)StatisticDetailPanel.this).currentRecord.distributionValues.length;
                    }
                }
            }
            return 0;
        }
    }

    public static enum ModeEnum {
        SIMPLE,
        MINMAX;

    }
}

