/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.statistic;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.statistic.StatisticDataRecord;
import com.aastra.oamp.statistic.StatisticDatabase;
import com.aastra.oamp.statistic.StatisticDetailPanel;
import com.aastra.oamp.statistic.StatisticTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.SysStatisticHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.omilibgui.ConfiguratorTableModel;
import com.aastra.style.AastraSplitPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Date;
import java.util.Scanner;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class SysStatisticPanel
extends JPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
OmiMessageInterface,
OmiManagementEventInterface,
GuiComponentActivationInterface,
ComponentListener {
    private static final long serialVersionUID = 1L;
    private AastraSplitPane jSplitPane = null;
    private JScrollPane jScrollPane = null;
    private ConfiguratorTable jTable = null;
    private StatisticDatabase statDb = null;
    private SysStatisticHandler sysStatisticHandler = null;
    private StatisticDetailPanel statisticDetailPanel = null;
    private StatisticDataRecord currentRecord = null;
    private StatisticTaskPanel statTaskPanel = null;
    private int dividerLocation;
    private OmiManagement omiManagement = GuiMain.getOmiManagementObject();
    private int refreshWaitForMinMax = 0;

    public SysStatisticPanel() {
        this.omiManagement.registerManagementEventListener(this);
        this.sysStatisticHandler = new SysStatisticHandler(this.omiManagement);
        this.sysStatisticHandler.registerListener(this);
        this.statDb = new StatisticDatabase();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getStatisticTaskPanel(), "East");
        this.getStatisticTaskPanel().initStatisticMainPanelObject(this);
    }

    private StatisticTaskPanel getStatisticTaskPanel() {
        if (this.statTaskPanel == null) {
            this.statTaskPanel = new StatisticTaskPanel();
        }
        return this.statTaskPanel;
    }

    private StatisticDetailPanel getStatisticDetailPanel() {
        if (this.statisticDetailPanel == null) {
            this.statisticDetailPanel = new StatisticDetailPanel(this.sysStatisticHandler, this);
        }
        return this.statisticDetailPanel;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new AastraSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setTopComponent(this.getJScrollPane());
            this.jSplitPane.setBottomComponent(null);
            this.jSplitPane.addComponentListener(this);
            this.dividerLocation = this.jSplitPane.getHeight() - StatisticDetailPanel.ySize;
        }
        return this.jSplitPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
            this.jScrollPane.setPreferredSize(new Dimension(0, 200));
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new ConfiguratorTable(this.statDb);
            this.jTable.setSelectionMode(0);
            int[] nArray = new int[]{1, 6, 14, 11, 12};
            this.jTable.setColumnArr(nArray, nArray.length);
            this.jTable.registerEventListener(this);
            this.jTable.registerMultiSelectListener(this);
            this.jTable.setNegativeIntAsInvalid(14);
            this.jTable.setNegativeIntAsInvalid(11);
            this.jTable.setNegativeIntAsInvalid(12);
        }
        return this.jTable;
    }

    private void displayCounterDetails(StatisticDataRecord statisticDataRecord, boolean bl) {
        if (statisticDataRecord != null) {
            this.currentRecord = statisticDataRecord;
            OmiMessage.StatisticType statisticType = (OmiMessage.StatisticType)((Object)statisticDataRecord.getField(3));
            if (this.getJSplitPane().getBottomComponent() == null) {
                this.getJSplitPane().setBottomComponent(this.getStatisticDetailPanel());
                this.getJSplitPane().setDividerLocation(this.dividerLocation);
            }
            switch (statisticType) {
                case occurrence: {
                    if (statisticDataRecord.occurenceVector == null) {
                        this.sysStatisticHandler.sendGetSysStatisticOccurrence((Integer)statisticDataRecord.getField(2));
                        break;
                    }
                    this.getStatisticDetailPanel().setDataRecord(statisticDataRecord);
                    break;
                }
                case minmax: {
                    if (bl) {
                        this.sysStatisticHandler.sendGetSysStatisticMinMaxSummary((Integer)statisticDataRecord.getField(2));
                    }
                    this.getStatisticDetailPanel().setDataRecord(statisticDataRecord);
                    this.getStatisticDetailPanel().showDistribution();
                    break;
                }
            }
        }
    }

    public void removeStatisticDetailPanel() {
        this.dividerLocation = this.getJSplitPane().getDividerLocation();
        this.getJSplitPane().setBottomComponent(null);
    }

    public void taskRefreshAll() {
        this.sysStatisticHandler.sendGetSysStatisticConfig();
    }

    public void taskResetAll() {
        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_CLEAR_ALL_COUNTERS_?"), true);
        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            this.sysStatisticHandler.sendResetSysStatistic(-1);
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.displayCounterDetails((StatisticDataRecord)dataRecord, true);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.displayCounterDetails((StatisticDataRecord)dataRecord, true);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.displayCounterDetails((StatisticDataRecord)dataRecord, true);
    }

    private void processGetSysStatisticConfigresp(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        int n = 0;
        while (omiMessage2 != null) {
            if (omiMessage2.id == OmiMessage.elemIds.sysStatName) {
                String string;
                StatisticDataRecord statisticDataRecord = new StatisticDataRecord(n);
                int n2 = omiMessage2.getAttribValInt(OmiMessage.SysStatNameType.elemId.name());
                statisticDataRecord.setField(2, n2);
                String string2 = omiMessage2.getAttribVal(OmiMessage.SysStatNameType.type.name());
                OmiMessage.StatisticType statisticType = null;
                if (string2 != null) {
                    try {
                        statisticType = OmiMessage.StatisticType.valueOf(string2);
                        statisticDataRecord.setField(3, (Object)statisticType);
                        string2 = omiMessage2.getAttribVal(OmiMessage.SysStatNameType.resolution.name());
                        if (string2 != null) {
                            statisticDataRecord.setField(16, string2);
                        }
                        statisticDataRecord.setField(11, -1);
                        statisticDataRecord.setField(12, -1);
                        statisticDataRecord.setField(14, -1);
                        if (statisticType == OmiMessage.StatisticType.minmax) {
                            string2 = omiMessage2.getAttribVal(OmiMessage.SysStatNameType.unit.name());
                            if (string2 != null) {
                                statisticDataRecord.setField(15, string2);
                            }
                            this.sysStatisticHandler.sendGetSysStatisticMinMaxSummary(n2);
                            this.refreshWaitForMinMax = n2;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if ((string = omiMessage2.getAttribVal(OmiMessage.attribIds.name.name())) != null) {
                    statisticDataRecord.setField(1, string);
                }
                n2 = omiMessage2.getAttribValInt(OmiMessage.attribIds.duration.name());
                statisticDataRecord.setField(4, n2);
                n2 = omiMessage2.getAttribValInt(OmiMessage.attribIds.numOfRecords.name());
                statisticDataRecord.setField(5, n2);
                n2 = omiMessage2.getAttribValInt(OmiMessage.attribIds.sum.name());
                statisticDataRecord.setField(6, n2);
                n2 = omiMessage2.getAttribValInt(OmiMessage.attribIds.currMeasuredTime.name());
                statisticDataRecord.setField(7, n2);
                n2 = omiMessage2.getAttribValInt(OmiMessage.attribIds.oldMeasuredTime.name());
                statisticDataRecord.setField(8, n2);
                statisticDataRecord.setField(9, new Date().getTime());
                this.statDb.createRecord(statisticDataRecord);
            }
            omiMessage2 = omiMessage2.getNext();
            ++n;
        }
    }

    private int[] getVector(String string, int n) {
        if (string != null) {
            int n2;
            Object object;
            if (n == 0) {
                object = new Scanner(string);
                ((Scanner)object).useDelimiter(",");
                n2 = 0;
                while (((Scanner)object).hasNext()) {
                    ++n2;
                    ((Scanner)object).next();
                }
                ((Scanner)object).close();
                n = n2;
            }
            object = new int[n];
            Scanner scanner = new Scanner(string);
            scanner.useDelimiter(",");
            n2 = 0;
            while (scanner.hasNext() && n2 < n) {
                object[n2++] = scanner.nextInt();
            }
            scanner.close();
            return object;
        }
        return null;
    }

    private void processGetSysStatisticOccurenceResp(OmiMessage omiMessage) {
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.elemId.name());
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "processGetSysStatisticOccurenceResp: id=" + n);
        if (this.currentRecord != null && (Integer)this.currentRecord.getField(2) == n) {
            int n2 = omiMessage.getAttribValInt(OmiMessage.attribIds.age.name());
            int n3 = omiMessage.getAttribValInt(OmiMessage.attribIds.sum.name());
            int n4 = omiMessage.getAttribValInt(OmiMessage.attribIds.numOfRecords.name());
            this.currentRecord.setField(10, n2);
            this.currentRecord.setField(6, n3);
            this.currentRecord.setField(7, omiMessage.getAttribValInt(OmiMessage.attribIds.currMeasuredTime.name()));
            this.currentRecord.setField(8, omiMessage.getAttribValInt(OmiMessage.attribIds.oldMeasuredTime.name()));
            this.currentRecord.setField(9, new Date().getTime());
            StatisticDataRecord statisticDataRecord = (StatisticDataRecord)this.statDb.getRecordById((Integer)this.currentRecord.getField(0));
            statisticDataRecord.setField(6, n3);
            statisticDataRecord.setField(10, n2);
            if (statisticDataRecord.getFieldChanged(6)) {
                statisticDataRecord.commitChanges();
                int n5 = (Integer)statisticDataRecord.getField(0);
                int n6 = 1;
                ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableCellUpdated(n5, n6);
            }
            String string = omiMessage.getAttribVal(OmiMessage.attribIds.counter.name());
            int[] nArray = this.getVector(string, n4);
            this.currentRecord.occurenceVector = nArray;
            statisticDataRecord.setField(9, this.currentRecord.getField(9));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "processGetSysStatisticOccurenceResp: Current time set");
            this.displayCounterDetails(this.currentRecord, false);
        }
    }

    private void processGetSysStatisticMinMaxSummaryResp(OmiMessage omiMessage) {
        int n = omiMessage.getAttribValInt(OmiMessage.attribIds.elemId.name());
        StatisticDataRecord statisticDataRecord = this.statDb.getRecordByOmiId(n);
        if (statisticDataRecord != null) {
            int n2 = omiMessage.getAttribValInt(OmiMessage.attribIds.age.name());
            int n3 = omiMessage.getAttribValInt(OmiMessage.attribIds.min.name());
            int n4 = omiMessage.getAttribValInt(OmiMessage.attribIds.max.name());
            int n5 = omiMessage.getAttribValInt(OmiMessage.attribIds.sum.name());
            int n6 = omiMessage.getAttribValInt(OmiMessage.attribIds.occurrence.name());
            statisticDataRecord.distributionUnits = this.getVector(omiMessage.getAttribVal(OmiMessage.attribIds.freqDistUnits.name()), 0);
            statisticDataRecord.distributionValues = this.getVector(omiMessage.getAttribVal(OmiMessage.attribIds.freqDistValues.name()), 0);
            statisticDataRecord.setField(13, n5);
            statisticDataRecord.setField(6, n6);
            if (n6 > 0) {
                statisticDataRecord.setField(14, n5 / n6);
            } else {
                statisticDataRecord.setField(14, -1);
            }
            statisticDataRecord.setField(11, n3);
            statisticDataRecord.setField(12, n4);
            statisticDataRecord.setField(10, n2);
            int n7 = (Integer)statisticDataRecord.getField(0);
            if (this.refreshWaitForMinMax != 0) {
                if (this.refreshWaitForMinMax == n) {
                    this.refreshWaitForMinMax = 0;
                    this.statDb.updateIndex();
                }
            } else {
                ((ConfiguratorTableModel)this.getJTable().getModel()).fireTableRowsUpdated(n7, n7);
            }
            if (this.currentRecord != null && n == (Integer)this.currentRecord.getField(2)) {
                this.currentRecord = statisticDataRecord;
                this.displayCounterDetails(statisticDataRecord, false);
            }
        }
    }

    private void processGetSysStatisticMinMaxResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.type.name());
        if (string != null) {
            OmiMessage.StatisticType statisticType = OmiMessage.StatisticType.valueOf(string);
            int n = omiMessage.getAttribValInt(OmiMessage.attribIds.currMeasuredTime.name());
            int n2 = omiMessage.getAttribValInt(OmiMessage.attribIds.oldMeasuredTime.name());
            String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.counter.name());
            int n3 = omiMessage.getAttribValInt(OmiMessage.attribIds.numOfRecords.name());
            int[] nArray = this.getVector(string2, n3);
            this.getStatisticDetailPanel().setVector(statisticType, nArray, n, n2);
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        if (omiMessage.id == OmiMessage.elemIds.GetSysStatisticConfigResp || omiMessage.id == OmiMessage.elemIds.GetSysStatisticOccurrenceResp || omiMessage.id == OmiMessage.elemIds.GetSysStatisticMinMaxResp || omiMessage.id == OmiMessage.elemIds.GetSysStatisticMinMaxSummaryResp || omiMessage.id == OmiMessage.elemIds.ResetSysStatisticResp) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_STAT, this, "System statistic message: " + omiMessage.id.toString());
        }
        block1 : switch (omiMessage.id) {
            case GetSysStatisticConfigResp: {
                this.processGetSysStatisticConfigresp(omiMessage);
                break;
            }
            case GetSysStatisticOccurrenceResp: {
                this.processGetSysStatisticOccurenceResp(omiMessage);
                break;
            }
            case GetSysStatisticMinMaxResp: {
                this.processGetSysStatisticMinMaxResp(omiMessage);
                break;
            }
            case GetSysStatisticMinMaxSummaryResp: {
                this.processGetSysStatisticMinMaxSummaryResp(omiMessage);
                break;
            }
            case ResetSysStatisticResp: {
                int n = 0;
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
                if (string == null) break;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (n == -1) {
                    this.taskRefreshAll();
                    break;
                }
                StatisticDataRecord statisticDataRecord = this.statDb.getRecordByOmiId(n);
                if (statisticDataRecord == null) break;
                OmiMessage.StatisticType statisticType = (OmiMessage.StatisticType)((Object)statisticDataRecord.getField(3));
                switch (statisticType) {
                    case occurrence: {
                        this.sysStatisticHandler.sendGetSysStatisticOccurrence(n);
                        break block1;
                    }
                    case minmax: {
                        this.sysStatisticHandler.sendGetSysStatisticMinMaxSummary(n);
                        break block1;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Link management event: " + omiManagementEventEnum.toString());
            this.statDb.clearAll();
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.taskRefreshAll();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!componentEvent.getComponent().equals(this.jSplitPane)) {
            return;
        }
        int n = this.jSplitPane.getHeight();
        if (n < StatisticDetailPanel.ySize * 2) {
            this.jSplitPane.setDividerLocation(n / 2);
        } else {
            this.jSplitPane.setDividerLocation(n - StatisticDetailPanel.ySize);
        }
        this.getJScrollPane().setMinimumSize(new Dimension(StatisticDetailPanel.xSize, n - StatisticDetailPanel.ySize));
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

