/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordField;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.system.SystemAccountMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.AccountDataHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SystemAccountDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int xPosLabel = 30;
    private static final int xSizeLabel = 170;
    private static final int ySizeLabel = 32;
    private static final int xPosTextField = 210;
    private static final int xSizeTextField = 240;
    private static final int ySizeTextField = 18;
    private SystemAccountMainPanel accountMainPanel = null;
    private OmiManagement omiManagement = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private AccountDataHandler.Account account = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private PermCheckBoxChgHnd permCheckBoxesChangeHandler = null;
    private ActiveCheckBoxChgHnd activeCheckBoxChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedAccount = -1;
    private String dummyPassword = "1234567";
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelUserName = null;
    private GuiUtilTextField textFieldUserName = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordField passwordFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordField passwordFieldPasswordConfirm = null;
    private AastraLabel labelPasswordOld = null;
    private GuiUtilPasswordField passwordFieldPasswordOld = null;
    private AastraLabel labelAging = null;
    private GuiUtilComboBox comboBoxAging = null;
    private AastraPanel tabPermissions = null;
    private AastraLabel[] labelPermArray = null;
    private GuiUtilCheckBox[] checkBoxPermArray = null;
    private boolean[] currPermCheckBoxValues = null;
    private int cntPermissions;
    private boolean haveVideo = false;
    private boolean isEditable = true;
    private static final int TAB_GENERAL = 0;
    private ActionModeEnum actionMode;

    public SystemAccountDetailPanel(SystemAccountMainPanel systemAccountMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(240, 210);
        this.accountMainPanel = systemAccountMainPanel;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.haveVideo = this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo);
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.permCheckBoxesChangeHandler = new PermCheckBoxChgHnd(this.getButtonOK(), this.getButtonCancel(), false);
            this.activeCheckBoxChangeHandler = new ActiveCheckBoxChgHnd(this.getButtonOK(), this.getButtonCancel(), false);
        } else {
            this.isEditable = false;
        }
        this.labelHeaderBar.setText(UtilLocale.getString("TXT_USER_ACCOUNT"));
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_PERMISSIONS"), null, this.getTabPermissions(), null);
        if (this.isEditable) {
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelActive = new AastraLabel();
            this.labelActive.setBounds(30, 15, 170, 32);
            this.labelActive.setText(UtilLocale.getString("TXT_ACTIVE"));
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(30, 50, 170, 32);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPasswordOld = new AastraLabel();
            this.labelPasswordOld.setBounds(30, 85, 170, 32);
            this.labelPasswordOld.setText(UtilLocale.getString("TXT_PASSWORD_OLD"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(30, 120, 170, 32);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setBounds(30, 155, 170, 32);
            this.labelPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelAging = new AastraLabel();
            this.labelAging.setBounds(30, 190, 170, 32);
            this.labelAging.setText(UtilLocale.getString("TXT_PASSWORD_AGING"));
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelActive, null);
            this.tabGeneral.add((Component)this.getCheckBoxActive(), null);
            this.tabGeneral.add((Component)this.labelUserName, null);
            this.tabGeneral.add((Component)this.getTextFieldUserName(), null);
            this.tabGeneral.add((Component)this.labelPasswordOld, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPasswordOld(), null);
            this.tabGeneral.add((Component)this.labelPassword, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPassword(), null);
            this.tabGeneral.add((Component)this.labelPasswordConfirm, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPasswordConfirm(), null);
            this.tabGeneral.add((Component)this.labelAging, null);
            this.tabGeneral.add((Component)this.getComboBoxAging(), null);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.AccountType.username.toString(), this.labelUserName, this.textFieldUserName, 0);
                this.utilErrorComp.putWithTab(OmiMessage.AccountType.oldPassword.toString(), this.labelPasswordOld, this.passwordFieldPasswordOld, 0);
                this.utilErrorComp.putWithTab(OmiMessage.AccountType.password.toString(), this.labelPassword, this.passwordFieldPassword, 0);
                this.utilErrorComp.putWithTab("passwordConfirm", this.labelPasswordConfirm, this.passwordFieldPasswordConfirm, 0);
                this.utilErrorComp.putWithTab(OmiMessage.AccountType.aging.toString(), this.labelAging, this.comboBoxAging, 0);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.activeCheckBoxChangeHandler, 205, 15);
        }
        return this.checkBoxActive;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldUserName.setBounds(210, 50, 240, 18);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordOld() {
        if (this.passwordFieldPasswordOld == null) {
            this.passwordFieldPasswordOld = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPasswordOld.setBounds(210, 85, 240, 18);
        }
        return this.passwordFieldPasswordOld;
    }

    private GuiUtilPasswordField getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPassword.setBounds(210, 120, 240, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPasswordConfirm.setBounds(210, 155, 240, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private GuiUtilComboBox getComboBoxAging() {
        if (this.comboBoxAging == null) {
            this.comboBoxAging = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxAging.setBounds(210, 190, 90, 20);
            this.comboBoxAging.addItem(UtilLocale.getString("TXT_NONE"));
            this.comboBoxAging.addItem("3 " + UtilLocale.getString("TXT_MONTHS"));
            this.comboBoxAging.addItem("6 " + UtilLocale.getString("TXT_MONTHS"));
            this.comboBoxAging.activateActionListener();
        }
        return this.comboBoxAging;
    }

    private AastraPanel getTabPermissions() {
        if (this.tabPermissions == null) {
            this.tabPermissions = new AastraPanel();
            this.tabPermissions.setLayout(null);
            this.cntPermissions = OmiMessage.PermissionType.values().length;
            if (!this.haveVideo) {
                --this.cntPermissions;
            }
            this.labelPermArray = new AastraLabel[this.cntPermissions];
            this.checkBoxPermArray = new GuiUtilCheckBox[this.cntPermissions];
            this.currPermCheckBoxValues = new boolean[this.cntPermissions];
            for (int i = 0; i < this.cntPermissions; ++i) {
                OmiMessage.PermissionType permissionType = OmiMessage.PermissionType.values()[i];
                int n = 15 + i * 30;
                this.labelPermArray[i] = new AastraLabel(permissionType.getTranslatedString(), 30, n, 230, 16);
                this.checkBoxPermArray[i] = new GuiUtilCheckBox(this.permCheckBoxesChangeHandler, 270, n);
                switch (permissionType) {
                    case AllCnfWrite: 
                    case Monitoring: 
                    case Video: {
                        this.checkBoxPermArray[i].setToolTipText(String.format(UtilLocale.getString("TXT_ACTIVATES_PERMISSION_*_AS_WELL"), UtilLocale.getString("TXT_READ")));
                        break;
                    }
                    case Messaging: {
                        this.checkBoxPermArray[i].setToolTipText(String.format(UtilLocale.getString("TXT_ACTIVATES_PERMISSION_*_AS_WELL"), UtilLocale.getString("TXT_MESSAGING_INFO")));
                        break;
                    }
                    case LocatingAlert: 
                    case Alerting: {
                        this.checkBoxPermArray[i].setToolTipText(String.format(UtilLocale.getString("TXT_ACTIVATES_PERMISSION_*_AS_WELL"), UtilLocale.getString("TXT_MESSAGING")));
                        break;
                    }
                }
                this.tabPermissions.add(this.labelPermArray[i]);
                this.tabPermissions.add(this.checkBoxPermArray[i]);
            }
            if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR) {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
                UtilSetPanelEditable.setDisabled(this.tabPermissions);
            }
        }
        return this.tabPermissions;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = GuiUtilButton.ButtonOK(70, 15);
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemAccountDetailPanel.this.utilChangeHandler.deactivate();
                    SystemAccountDetailPanel.this.utilErrorComp.clearComponents();
                    if (SystemAccountDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SystemAccountDetailPanel.this.accountMainPanel.changeAccount();
                    } else {
                        SystemAccountDetailPanel.this.accountMainPanel.createAccount();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = this.isEditable ? GuiUtilButton.ButtonCancel(230, 15) : GuiUtilButton.ButtonCancel(150, 15);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SystemAccountDetailPanel.this.isEditable) {
                        SystemAccountDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SystemAccountDetailPanel.this.accountMainPanel.removeAccountDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setAccountDetailData(AccountDataHandler.Account account) {
        if (account != null) {
            int n;
            this.account = (AccountDataHandler.Account)account.clone();
            this.selectedAccount = this.account.id;
            String string = "";
            if (this.account.getComment().length() > 0) {
                string = String.format(" - %s", this.account.getComment());
            }
            this.labelHeaderBar.setText(String.format("%s #%d%s", UtilLocale.getString("TXT_USER_ACCOUNT"), this.account.id, string));
            this.checkBoxActive.setSelected(this.account.getActive());
            if (this.isEditable && this.account.isBuiltinUserAccount()) {
                this.checkBoxActive.setEnabled(true);
                this.checkBoxActive.setToolTipText("");
            } else {
                this.checkBoxActive.setEnabled(false);
                this.checkBoxActive.setToolTipText(UtilLocale.getString("TXT_ACCOUNT_IS_ALWAYS_ACTIVE"));
            }
            this.textFieldUserName.setText(this.account.getUsername());
            this.passwordFieldPasswordOld.setText("");
            if (this.isEditable) {
                this.passwordFieldPasswordOld.setEditable(this.account.isBuiltinAdminAccount());
            }
            this.comboBoxAging.deactivateActionListener();
            if (this.account.isBuiltinAdminAccount() || this.account.isBuiltinUserAccount()) {
                switch (this.account.getPwAging()) {
                    case time3Months: {
                        this.comboBoxAging.setSelectedIndex(1);
                        break;
                    }
                    case time6Months: {
                        this.comboBoxAging.setSelectedIndex(2);
                        break;
                    }
                    default: {
                        this.comboBoxAging.setSelectedIndex(0);
                    }
                }
                this.comboBoxAging.setEnabled(true);
                this.comboBoxAging.setToolTipText(null);
            } else {
                this.comboBoxAging.setSelectedIndex(0);
                this.comboBoxAging.setEnabled(false);
                this.comboBoxAging.setToolTipText(UtilLocale.getString("TXT_PASSWORD_AGING_NOT_SUPPORTED_FOR_THIS_ACCOUNT"));
            }
            this.comboBoxAging.activateActionListener();
            String string2 = this.account.getPassword();
            if (string2 != null && string2.length() > 0) {
                this.passwordFieldPassword.setText(this.dummyPassword);
                this.passwordFieldPasswordConfirm.setText(this.dummyPassword);
            } else {
                this.passwordFieldPassword.setText("");
                this.passwordFieldPasswordConfirm.setText("");
            }
            if (this.isEditable && this.account.getActive()) {
                this.enableConfigFields(true);
            } else {
                this.enableConfigFields(false);
            }
            for (n = 0; n < this.checkBoxPermArray.length; ++n) {
                this.checkBoxPermArray[n].setSelected(false);
                this.currPermCheckBoxValues[n] = false;
                if (this.isEditable && !this.account.isBuiltinAccount()) {
                    this.checkBoxPermArray[n].setEnabled(true);
                    continue;
                }
                this.checkBoxPermArray[n].setEnabled(false);
            }
            for (n = 0; n < this.account.getPermissions().length; ++n) {
                this.checkBoxPermArray[this.account.getPermissions()[n].ordinal()].setSelected(true);
                this.currPermCheckBoxValues[this.account.getPermissions()[n].ordinal()] = true;
                this.setDependentPermissions(n);
            }
            this.enableLastSelectedPermissionCheckBox(false);
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.account = null;
            this.selectedAccount = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_USER_ACCOUNT"));
            this.checkBoxActive.setSelected(true);
            this.checkBoxActive.setEnabled(false);
            this.checkBoxActive.setToolTipText(UtilLocale.getString("TXT_ACCOUNT_IS_ALWAYS_ACTIVE"));
            this.textFieldUserName.setText("");
            this.textFieldUserName.setEditable(true);
            this.passwordFieldPasswordOld.setText("");
            this.passwordFieldPasswordOld.setEditable(false);
            this.passwordFieldPassword.setText("");
            this.passwordFieldPassword.setEditable(true);
            this.passwordFieldPasswordConfirm.setText("");
            this.passwordFieldPasswordConfirm.setEditable(true);
            this.comboBoxAging.deactivateActionListener();
            this.comboBoxAging.setSelectedIndex(0);
            this.comboBoxAging.setEnabled(false);
            this.comboBoxAging.setToolTipText(UtilLocale.getString("TXT_PASSWORD_AGING_NOT_SUPPORTED_FOR_THIS_ACCOUNT"));
            this.comboBoxAging.activateActionListener();
            for (int i = 0; i < this.checkBoxPermArray.length; ++i) {
                this.checkBoxPermArray[i].setSelected(false);
                this.checkBoxPermArray[i].setEnabled(true);
                this.currPermCheckBoxValues[i] = false;
            }
            this.checkBoxPermArray[OmiMessage.PermissionType.AllCnfRead.ordinal()].setSelected(true);
            this.checkBoxPermArray[OmiMessage.PermissionType.AllCnfRead.ordinal()].setEnabled(false);
            this.currPermCheckBoxValues[OmiMessage.PermissionType.AllCnfRead.ordinal()] = true;
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
            this.checkBoxActive.requestFocusInWindow();
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public AccountDataHandler.Account getAccountDetailData() {
        if (this.account == null) {
            this.account = new AccountDataHandler.Account();
        }
        if (this.account.isBuiltinUserAccount()) {
            this.account.setActive(this.checkBoxActive.isSelected());
        }
        this.account.setUsername(this.textFieldUserName.getText());
        if (this.account.isBuiltinAccount()) {
            switch (this.comboBoxAging.getSelectedIndex()) {
                case 1: {
                    this.account.setPwAging(OmiMessage.PasswordAgingType.time3Months);
                    break;
                }
                case 2: {
                    this.account.setPwAging(OmiMessage.PasswordAgingType.time6Months);
                    break;
                }
                default: {
                    this.account.setPwAging(OmiMessage.PasswordAgingType.none);
                    break;
                }
            }
        } else {
            this.account.setPwAging(OmiMessage.PasswordAgingType.none);
        }
        String string = new String(this.passwordFieldPassword.getPassword());
        if (string.equals(new String(this.passwordFieldPasswordConfirm.getPassword()))) {
            if (!string.equals(this.dummyPassword)) {
                this.account.setPassword(string);
            }
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
            this.markErrorComponent("passwordConfirm");
            return null;
        }
        if (this.account.isBuiltinAdminAccount()) {
            this.account.setPasswordOld(new String(this.passwordFieldPasswordOld.getPassword()));
        }
        if (!this.account.isBuiltinAccount()) {
            this.account.deletePermissions();
            for (int i = 0; i < this.checkBoxPermArray.length; ++i) {
                if (!this.checkBoxPermArray[i].isSelected()) continue;
                this.account.addPermission(OmiMessage.PermissionType.values()[i]);
            }
        }
        return this.account;
    }

    public void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedAccount() {
        return this.selectedAccount;
    }

    private void setPermissionsDependencies() {
        int n;
        this.enableLastSelectedPermissionCheckBox(true);
        for (n = 0; n < this.cntPermissions && this.currPermCheckBoxValues[n] == this.checkBoxPermArray[n].isSelected(); ++n) {
        }
        this.setDependentPermissions(n);
        this.currPermCheckBoxValues[n] = this.checkBoxPermArray[n].isSelected();
        if (!(this.currPermCheckBoxValues[OmiMessage.PermissionType.AllCnfWrite.ordinal()] || this.currPermCheckBoxValues[OmiMessage.PermissionType.Monitoring.ordinal()] || this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && this.currPermCheckBoxValues[OmiMessage.PermissionType.Video.ordinal()])) {
            this.checkBoxPermArray[OmiMessage.PermissionType.AllCnfRead.ordinal()].setEnabled(true);
        }
        if (!(this.currPermCheckBoxValues[OmiMessage.PermissionType.Messaging.ordinal()] || this.currPermCheckBoxValues[OmiMessage.PermissionType.LocatingAlert.ordinal()] || this.currPermCheckBoxValues[OmiMessage.PermissionType.Alerting.ordinal()])) {
            this.checkBoxPermArray[OmiMessage.PermissionType.InfoMessaging.ordinal()].setEnabled(true);
        }
        if (!this.currPermCheckBoxValues[OmiMessage.PermissionType.LocatingAlert.ordinal()] && !this.currPermCheckBoxValues[OmiMessage.PermissionType.Alerting.ordinal()]) {
            this.checkBoxPermArray[OmiMessage.PermissionType.Messaging.ordinal()].setEnabled(true);
        }
        this.enableLastSelectedPermissionCheckBox(false);
    }

    private void setDependentPermissions(int n) {
        if ((n == OmiMessage.PermissionType.AllCnfWrite.ordinal() || n == OmiMessage.PermissionType.Monitoring.ordinal() || this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && n == OmiMessage.PermissionType.Video.ordinal()) && this.checkBoxPermArray[n].isSelected()) {
            this.checkBoxPermArray[OmiMessage.PermissionType.AllCnfRead.ordinal()].setSelected(true);
            this.checkBoxPermArray[OmiMessage.PermissionType.AllCnfRead.ordinal()].setEnabled(false);
            this.currPermCheckBoxValues[OmiMessage.PermissionType.AllCnfRead.ordinal()] = true;
        }
        if (n == OmiMessage.PermissionType.Messaging.ordinal() && this.checkBoxPermArray[n].isSelected()) {
            this.checkBoxPermArray[OmiMessage.PermissionType.InfoMessaging.ordinal()].setSelected(true);
            this.checkBoxPermArray[OmiMessage.PermissionType.InfoMessaging.ordinal()].setEnabled(false);
            this.currPermCheckBoxValues[OmiMessage.PermissionType.InfoMessaging.ordinal()] = true;
        }
        if ((n == OmiMessage.PermissionType.LocatingAlert.ordinal() || n == OmiMessage.PermissionType.Alerting.ordinal()) && this.checkBoxPermArray[n].isSelected()) {
            this.checkBoxPermArray[OmiMessage.PermissionType.InfoMessaging.ordinal()].setSelected(true);
            this.checkBoxPermArray[OmiMessage.PermissionType.InfoMessaging.ordinal()].setEnabled(false);
            this.currPermCheckBoxValues[OmiMessage.PermissionType.InfoMessaging.ordinal()] = true;
            this.checkBoxPermArray[OmiMessage.PermissionType.Messaging.ordinal()].setSelected(true);
            this.checkBoxPermArray[OmiMessage.PermissionType.Messaging.ordinal()].setEnabled(false);
            this.currPermCheckBoxValues[OmiMessage.PermissionType.Messaging.ordinal()] = true;
        }
    }

    private void enableLastSelectedPermissionCheckBox(boolean bl) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.cntPermissions; ++i) {
            if (!this.currPermCheckBoxValues[i]) continue;
            ++n;
            n2 = i;
        }
        if (n == 1) {
            this.checkBoxPermArray[n2].setEnabled(bl);
        }
    }

    private void enableConfigFields(boolean bl) {
        this.textFieldUserName.setEditable(bl);
        this.passwordFieldPassword.setEditable(bl);
        this.passwordFieldPasswordConfirm.setEditable(bl);
        if (this.account.isBuiltinAdminAccount() || this.account.isBuiltinUserAccount()) {
            this.comboBoxAging.setEnabled(bl);
            this.comboBoxAging.setToolTipText(null);
        } else {
            this.comboBoxAging.setEnabled(false);
            this.comboBoxAging.setToolTipText(UtilLocale.getString("TXT_PASSWORD_AGING_NOT_SUPPORTED_FOR_THIS_ACCOUNT"));
        }
    }

    private class PermCheckBoxChgHnd
    extends GuiUtilChangeHandler {
        public PermCheckBoxChgHnd(AastraButton aastraButton, AastraButton aastraButton2, boolean bl) {
            super(aastraButton, aastraButton2, bl);
        }

        @Override
        public void activate() {
            SystemAccountDetailPanel.this.setPermissionsDependencies();
            super.activate();
        }
    }

    private class ActiveCheckBoxChgHnd
    extends GuiUtilChangeHandler {
        public ActiveCheckBoxChgHnd(AastraButton aastraButton, AastraButton aastraButton2, boolean bl) {
            super(aastraButton, aastraButton2, bl);
        }

        @Override
        public void activate() {
            SystemAccountDetailPanel.this.enableConfigFields(SystemAccountDetailPanel.this.checkBoxActive.isSelected());
            super.activate();
        }
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

