/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.system.SystemAccountDetailPanel;
import com.aastra.oamp.system.SystemAccountTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.AccountDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class SystemAccountMainPanel
extends AastraPanel
implements AccountDataHandler.AccountDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 240;
    protected static final int ySizeDetailPanelSurcharge = 210;
    private static final int ySizeDetailPanel = 420;
    private AccountDataHandler accountDataHandler = null;
    private ConfiguratorTable accountTable = null;
    private OmiManagement omiManagement = null;
    private GuiUtilDetailSplitPanel accountDetailSplitPane = null;
    private AastraScrollPane accountTablePane = null;
    private SystemAccountDetailPanel accountDetailPanel = null;
    private SystemAccountTaskPanel accountTaskPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SystemAccountMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, AccountDataHandler accountDataHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.accountDataHandler = accountDataHandler;
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.initialize();
    }

    public void registerAccountDataListener() {
        this.accountDataHandler.registerDataNotificationListener(this);
    }

    public void deregisterAccountDataListener() {
        this.accountDataHandler.deregisterDataNotificationListener(this);
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getAccountDetailSplitPane(), "Center");
        this.add((Component)this.getAccountTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.accountTable.getSelectedRowCount();
        if (this.accountDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                AccountDataHandler.Account account = (AccountDataHandler.Account)dataRecord;
                this.createAccountDetailPanel(account, false);
            } else {
                this.removeAccountDetailPanel();
            }
        } else if (n == 1) {
            this.accountTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.accountTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            boolean bl = false;
            int[] nArray = this.accountTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.accountTable.convertRowIndexToModel(nArray[i]);
                AccountDataHandler.Account account = this.accountDataHandler.getAccountByTableIdx(n2);
                String string = account.getComment();
                if (OmiMessage.BuiltInAccountType.getValFromTxt(string) == null) continue;
                bl = true;
                break;
            }
            if (n >= 1 && !bl) {
                this.accountTaskPanel.setTaskButtonDelete(true);
            } else {
                this.accountTaskPanel.setTaskButtonDelete(false);
            }
        }
    }

    public void configureShowAccount() {
        int n;
        AccountDataHandler.Account account;
        int n2 = this.accountTable.getSelectedRow();
        if (n2 >= 0 && (account = this.accountDataHandler.getAccountByTableIdx(n = this.accountTable.convertRowIndexToModel(n2))) != null) {
            this.createAccountDetailPanel(account, false);
        }
    }

    private GuiUtilDetailSplitPanel getAccountDetailSplitPane() {
        if (this.accountDetailSplitPane == null) {
            this.accountDetailSplitPane = new GuiUtilDetailSplitPanel(420);
            this.accountDetailSplitPane.setTopComponent(this.getAccountTablePane());
            this.accountDetailSplitPane.setBottomComponent(null);
        }
        return this.accountDetailSplitPane;
    }

    private JTable getAccountTable() {
        if (this.accountTable == null) {
            int[] nArray = new int[]{0, 9, 2, 6, 1};
            this.accountTable = this.isEditable ? new GuiUtilConfiguratorTable(this, this.accountDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthSystemUserAccountConfig) : new GuiUtilConfiguratorTable((Object)this, this.accountDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthSystemUserAccountMonitor, 0);
            this.accountTable.setColumnArr(nArray, nArray.length);
            this.accountTable.setIconArray(1, GuiUtilIcon.getIconArrayInactiveActive());
            OmiMessage.BuiltInAccountType.user.setTranslatedString(UtilLocale.getString("TXT_READ_ONLY"));
            OmiMessage.BuiltInAccountType.admin.setTranslatedString(UtilLocale.getString("TXT_FULL_ACCESS"));
            OmiMessage.BuiltInAccountType.root.setTranslatedString(UtilLocale.getString("TXT_ROOT_SSH_ONLY"));
            OmiMessage.PermissionType.AllCnfRead.setTranslatedString(UtilLocale.getString("TXT_READ"));
            OmiMessage.PermissionType.AllCnfWrite.setTranslatedString(UtilLocale.getString("TXT_WRITE"));
            OmiMessage.PermissionType.Messaging.setTranslatedString(UtilLocale.getString("TXT_MESSAGING"));
            OmiMessage.PermissionType.InfoMessaging.setTranslatedString(UtilLocale.getString("TXT_MESSAGING_INFO"));
            OmiMessage.PermissionType.LocatingAlert.setTranslatedString(UtilLocale.getString("TXT_MESSAGING_LOCATING_ALERT"));
            OmiMessage.PermissionType.Alerting.setTranslatedString(UtilLocale.getString("TXT_MESSAGING_INFO_EMERGENCY"));
            OmiMessage.PermissionType.Locating.setTranslatedString(UtilLocale.getString("TXT_LOCATING"));
            OmiMessage.PermissionType.Monitoring.setTranslatedString(UtilLocale.getString("TXT_MONITORING"));
            if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
                OmiMessage.PermissionType.Video.setTranslatedString(UtilLocale.getString("TXT_VIDEO"));
            }
            OmiMessage.PasswordAgingType.none.setTranslatedString(UtilLocale.getString("TXT_NONE"));
            OmiMessage.PasswordAgingType.time3Months.setTranslatedString("3 " + UtilLocale.getString("TXT_MONTHS"));
            OmiMessage.PasswordAgingType.time6Months.setTranslatedString("6 " + UtilLocale.getString("TXT_MONTHS"));
        }
        return this.accountTable;
    }

    private AastraScrollPane getAccountTablePane() {
        if (this.accountTablePane == null) {
            this.accountTablePane = new AastraScrollPane(this.getAccountTable());
            this.dividerLocation = this.accountDetailSplitPane.getHeight() - 420;
            this.accountTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.accountTablePane;
    }

    private void enableTableAccess() {
        this.accountTable.setActive(true);
        if (this.isEditable) {
            this.accountTaskPanel.setTaskButtonCreate(true);
        }
    }

    private void disableTableAccess() {
        this.accountTable.setActive(false);
        this.accountTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.accountTaskPanel.setTaskButtonCreate(false);
            this.accountTaskPanel.setTaskButtonDelete(false);
        }
    }

    private SystemAccountDetailPanel getAccountDetailPanel() {
        if (this.accountDetailPanel == null) {
            this.accountDetailPanel = new SystemAccountDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.accountDetailPanel;
    }

    private AastraPanel getAccountTaskPanel() {
        if (this.accountTaskPanel == null) {
            this.accountTaskPanel = new SystemAccountTaskPanel(this, this.guiNavPanelType);
        }
        return this.accountTaskPanel;
    }

    public void createAccountDetailPanel(AccountDataHandler.Account account, boolean bl) {
        if (bl) {
            this.accountTable.removeRowSelectionAll();
        }
        if (this.accountDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating account config detail panel");
            }
            this.dividerLocation = this.accountDetailSplitPane.getDividerLocation();
            if (account == null) {
                this.accountDetailPanel.setDefaultTab();
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating account config detail panel");
            this.accountDetailSplitPane.setBottomComponent(this.getAccountDetailPanel());
            this.accountDetailPanel.setDefaultTab();
        }
        if (account != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = account.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading account[" + account.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + account.getActive() + ",'" + account.getComment() + "','" + account.getUsername() + "'," + (Object)((Object)account.getPwAging()));
            for (int i = 0; i < account.getPermissions().length; ++i) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)account.getPermissions()[i]));
            }
            if (account.getPasswordChanged()) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + account.getPassword() + "'");
            }
            this.accountDetailPanel.setAccountDetailData(account);
        } else {
            this.accountDetailPanel.setAccountDetailData(null);
        }
        this.accountDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.accountDetailSplitPane.validate();
        this.accountTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeAccountDetailPanel() {
        if (this.accountDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing account config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing account monitor detail panel");
            }
            this.dividerLocation = this.accountDetailSplitPane.getDividerLocation();
            this.accountDetailSplitPane.setBottomComponent(null);
            if (this.accountTable.getSelectedRowCount() == 1) {
                this.accountTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove account detail panel, but there is none");
        }
    }

    public void createAccount() {
        AccountDataHandler.Account account = this.accountDetailPanel.getAccountDetailData();
        if (account == null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating account failed");
            return;
        }
        this.pendingRemoveDetailPanel(-1);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating account:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + account.getActive() + ",'" + account.getUsername() + "'," + (Object)((Object)account.getPwAging()));
        for (int i = 0; i < account.getPermissions().length; ++i) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)account.getPermissions()[i]));
        }
        if (account.getPasswordChanged()) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + account.getPassword() + "'");
        }
        this.accountDataHandler.sendCreateAccount(account);
    }

    public void changeAccount() {
        AccountDataHandler.Account account = this.accountDetailPanel.getAccountDetailData();
        if (account == null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing account failed");
            return;
        }
        this.pendingRemoveDetailPanel(account.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing account[" + account.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + account.getActive() + ",'" + account.getUsername() + "'," + (Object)((Object)account.getPwAging()));
        if (account.getPermissions() != null && account.getPermissions().length > 0) {
            for (int i = 0; i < account.getPermissions().length; ++i) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)account.getPermissions()[i]));
            }
        }
        if (account.getPasswordChanged()) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + account.getPassword() + "'");
        }
        this.accountDataHandler.sendSetAccount(account);
    }

    public void deleteAccount() {
        GuiUtilDialog guiUtilDialog;
        int n = this.accountTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_USER_ACCOUNTS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.accountTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.accountTable.convertRowIndexToModel(nArray[i]);
                AccountDataHandler.Account account = this.accountDataHandler.getAccountByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting account[" + account.id + "]");
                this.accountDataHandler.sendDeleteAccount(account.id);
                if (this.accountDetailSplitPane.getBottomComponent() == null || this.accountDetailPanel.getSelectedAccount() != account.id) continue;
                this.detailPanelPending = true;
                this.idPending = account.id;
            }
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Account data notification: " + dataNotificationEnum.toString() + "," + n);
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: 
                        case DATA_CHANGED: {
                            if (!this.detailPanelPending || dataNotificationEnum != DataNotificationEnum.NEW_DATA && (dataNotificationEnum != DataNotificationEnum.DATA_CHANGED || this.idPending != n)) break block0;
                            this.removeAccountDetailPanel();
                            break;
                        }
                        case DATA_DELETED: {
                            if (!this.detailPanelPending || this.idPending != n) break block0;
                            this.removeAccountDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        AccountDataHandler.Account account = this.accountDataHandler.getAccountByAccountId(n);
                        if (account == null) break block0;
                        this.createAccountDetailPanel(account, false);
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeAccountDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Account error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Account error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string4 = null;
                    if (string2 != null) {
                        string4 = this.getAccountDetailPanel().getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                this.getAccountDetailPanel().markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        AccountDataHandler.Account account = (AccountDataHandler.Account)dataRecord;
        this.createAccountDetailPanel(account, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.accountDetailSplitPane.getBottomComponent() != null && this.accountTable.getSelectedRowCount() > 1) {
            this.removeAccountDetailPanel();
        }
        this.accountTaskPanel.setTaskButtonConfigureShow(false);
    }
}

