/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.system.SystemEventLogMainPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.EventLogMonitoringHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;

public class SystemEventLogDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private SystemEventLogMainPanel eventLogMainPanel = null;
    private AastraPanel tabGeneral = null;
    private AastraButton buttonCancel = null;
    private GuiUtilTextFieldFS textFieldSeverity = null;
    private GuiUtilTextFieldFS textFieldSubsystem = null;
    private GuiUtilTextFieldFS textFieldCount = null;
    private GuiUtilTextFieldFS textFieldTime = null;
    private AastraLabel labelEventValue = null;

    public SystemEventLogDetailPanel(SystemEventLogMainPanel systemEventLogMainPanel) {
        super(230, 150);
        this.eventLogMainPanel = systemEventLogMainPanel;
        this.initialize();
    }

    private void initialize() {
        this.labelHeaderBar.setText(UtilLocale.getString("TXT_EVENT_LOG_20"));
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 15, 170, 32);
            aastraLabel.setText(UtilLocale.getString("TXT_SEVERITY"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 45, 170, 32);
            aastraLabel2.setText(UtilLocale.getString("TXT_SUBSYSTEM"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, 75, 170, 32);
            aastraLabel3.setText(UtilLocale.getString("TXT_COUNT"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(30, 105, 170, 32);
            aastraLabel4.setText(UtilLocale.getString("TXT_TIME"));
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 135, 170, 32);
            aastraLabel5.setText(UtilLocale.getString("TXT_EVENT"));
            this.tabGeneral.add(aastraLabel);
            this.tabGeneral.add(this.getTextFieldSeverity());
            this.tabGeneral.add(aastraLabel2);
            this.tabGeneral.add(this.getTextFieldSubsystem());
            this.tabGeneral.add(aastraLabel3);
            this.tabGeneral.add(this.getTextFieldCount());
            this.tabGeneral.add(aastraLabel4);
            this.tabGeneral.add(this.getTextFieldTime());
            this.tabGeneral.add(aastraLabel5);
            this.tabGeneral.add(this.getLabelEventValue());
            UtilSetPanelEditable.setDisabled(this.tabGeneral);
        }
        return this.tabGeneral;
    }

    private GuiUtilTextFieldFS getTextFieldSeverity() {
        if (this.textFieldSeverity == null) {
            this.textFieldSeverity = new GuiUtilTextFieldFS(210, 15, AastraCommon.TextFieldSizeType.xxs);
        }
        return this.textFieldSeverity;
    }

    private GuiUtilTextFieldFS getTextFieldSubsystem() {
        if (this.textFieldSubsystem == null) {
            this.textFieldSubsystem = new GuiUtilTextFieldFS(210, 45, AastraCommon.TextFieldSizeType.xxs);
        }
        return this.textFieldSubsystem;
    }

    private GuiUtilTextFieldFS getTextFieldCount() {
        if (this.textFieldCount == null) {
            this.textFieldCount = new GuiUtilTextFieldFS(210, 75, AastraCommon.TextFieldSizeType.xxs);
        }
        return this.textFieldCount;
    }

    private GuiUtilTextFieldFS getTextFieldTime() {
        if (this.textFieldTime == null) {
            this.textFieldTime = new GuiUtilTextFieldFS(210, 105, AastraCommon.TextFieldSizeType.m);
        }
        return this.textFieldTime;
    }

    private AastraLabel getLabelEventValue() {
        if (this.labelEventValue == null) {
            this.labelEventValue = new AastraLabel();
            this.labelEventValue.setBounds(30, 155, 500, 48);
            this.labelEventValue.setBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTabbedPane));
        }
        return this.labelEventValue;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = GuiUtilButton.ButtonCancel(150, 15);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemEventLogDetailPanel.this.eventLogMainPanel.removeEventLogDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setDetailData(EventLogMonitoringHandler.EventLogEntry eventLogEntry) {
        if (eventLogEntry != null) {
            this.textFieldSeverity.setText(((OmiMessage.EventLogEntryLevelType)((Object)eventLogEntry.getField(2))).toString());
            this.textFieldSubsystem.setText((String)eventLogEntry.getField(3));
            this.textFieldCount.setText(String.valueOf((Integer)eventLogEntry.getField(4)));
            this.textFieldTime.setText((String)eventLogEntry.getField(1));
            String string = (String)eventLogEntry.getField(5);
            this.labelEventValue.setText("<html>" + string + "</html>");
        }
        this.getButtonCancel().requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }
}

