/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.system.SystemUtil;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiFileTransfer;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpUserSummaryHandler;
import com.aastra.omilib.RfpSummaryHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTabbedPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.BitSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

public class SystemLicensePanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
OmiFileTransfer.FileTransferNotificationInterface,
GuiComponentActivationInterface,
RfpSummaryHandler.RfpSummaryNotificationInterface,
PpUserSummaryHandler.PpUserSummaryNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelHeight = 560;
    private static final int panelWidth = 800;
    private static final int tabbedPaneHeight = 560;
    private static final int tabbedPaneWidth = 800;
    private CommonDataHandler commonDataHandler = null;
    private RfpSummaryHandler rfpSummaryHandler = null;
    private PpUserSummaryHandler ppUserSummaryHandler = null;
    private SystemLicensePanel systemLicensePanel = null;
    private LicenseTabbedPane tabbedPaneLicense = null;
    private static GuiUtilDialog dialog = null;
    private GuiMain guiMain = null;
    private UtilErrorComp utilErrorComp = null;
    private SystemUtil.ToolsSystemSettings toolsSystem = null;
    private boolean isEditable = true;
    private AastraPanel tabStatus = null;
    private AastraPanel panelStatusGeneral = null;
    private AastraLabel labelState = null;
    private AastraLabel labelStateValue = null;
    private AastraLabel labelLicenseType = null;
    private AastraTextField textFieldLicenseType = null;
    private AastraLabel labelLatencyPeriod = null;
    private AastraLabel labelLatencyPeriodTrend = null;
    private AastraTextField textFieldLatencyPeriodHours = null;
    private AastraTextField textFieldLatencyPeriodMinutes = null;
    private AastraLabel labelHours = null;
    private AastraLabel labelMinutes = null;
    private AastraLabel labelPARK = null;
    private AastraTextField textFieldPARK = null;
    private AastraLabel[] labelMACAddressArray = new AastraLabel[3];
    private AastraTextField[] textFieldMACAddressArray = new AastraTextField[3];
    private AastraLabel[] labelConnectedArray = new AastraLabel[3];
    private AastraPanel tabServer = null;
    private AastraPanel panelServerWrapper = null;
    private AastraPanel panelServer = null;
    private AastraPanel panelServerGeneral = null;
    private AastraPanel[] panelServerSystemArray = new AastraPanel[3];
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelInstallationId = null;
    private GuiUtilTextField textFieldInstallationId = null;
    private AastraLabel[] labelServerArray = new AastraLabel[3];
    private GuiUtilTextField[] textFieldServerArray = new GuiUtilTextField[3];
    private AastraLabel[] labelPortArray = new AastraLabel[3];
    private GuiUtilTextField[] textFieldPortArray = new GuiUtilTextField[3];
    private AastraLabel[] labelServerStandbyArray = new AastraLabel[3];
    private GuiUtilTextField[] textFieldServerStandbyArray = new GuiUtilTextField[3];
    private AastraLabel[] labelPortStandbyArray = new AastraLabel[3];
    private GuiUtilTextField[] textFieldPortStandbyArray = new GuiUtilTextField[3];
    private GuiUtilButtonBar panelServerButtonBar = null;
    private AastraPanel panelLicenseImportWrapper = null;
    private AastraPanel panelLicenseImport = null;
    private AastraButton buttonLicenseImport = null;
    private AastraTextField textFieldLicenseImportFile = null;
    private AastraButton buttonLicenseImportFile = null;
    private AastraLabel labelInfo = null;
    private GuiUtilFileChooser licenseImportFileChooser = null;
    private AastraPanel tabSystem = null;
    private AastraLabel labelLicenseDescriptionSystemXXX = null;
    private AastraLabel labelStatusSystemXXXValue = null;
    private AastraLabel labelRfpNumMax = null;
    private AastraTextField textFieldRfpNumMax = null;
    private AastraLabel labelRfpNumCurrent = null;
    private AastraTextField textFieldRfpNumCurrent = null;
    private AastraLabel labelLicenseKeySystem = null;
    private AastraTextField textFieldLicenseKeySystem = null;
    private AastraPanel tabMessaging = null;
    private AastraLabel labelLicenseMessagingAlertingSystem = null;
    private AastraLabel labelLicenseMessagingAlertingSystemStatus = null;
    private AastraLabel labelLicenseMessagingSystemDescription = null;
    private AastraLabel labelLicenseKeyMessaging = null;
    private AastraTextField textFieldLicenseKeyMessaging = null;
    private AastraPanel tabLocating = null;
    private AastraLabel labelLicenseLocatingServer = null;
    private AastraLabel labelLicenseLocatingServerStatus = null;
    private AastraLabel labelLicenseLocatingServerDescription = null;
    private AastraLabel labelLicenseLocatingXXX = null;
    private AastraLabel labelLicenseLocatingXXXStatus = null;
    private AastraLabel labelPpUserNumLocatingMax = null;
    private AastraTextField textFieldPpUserNumLocatingMax = null;
    private AastraLabel labelPpUserNumLocatingCurrent = null;
    private AastraTextField textFieldPpUserNumLocatingCurrent = null;
    private AastraLabel labelLicenseKeyLocating = null;
    private AastraTextField textFieldLicenseKeyLocating = null;
    private String licenseImportFileName = null;
    private static OmiMessage.LicenseStateType lastLicenseState = null;
    private CommonDataHandler.LicenseClass currentLicense = null;
    private CommonDataHandler.LimitsClass currentLimits = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;

    public SystemLicensePanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler, RfpSummaryHandler rfpSummaryHandler, PpUserSummaryHandler ppUserSummaryHandler) {
        this.guiMain = GuiMain.getGuiMainObject();
        this.commonDataHandler = commonDataHandler;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.rfpSummaryHandler = rfpSummaryHandler;
        this.ppUserSummaryHandler = ppUserSummaryHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.License, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.LicenseServer, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.Limits, this);
        this.rfpSummaryHandler.registerRfpSummaryNotificationListener(this);
        this.ppUserSummaryHandler.registerPpUserSummaryNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        this.systemLicensePanel = this;
        this.setSize(new Dimension(740, 325));
        this.setPreferredSize(new Dimension(740, 325));
        this.setLayout(new BoxLayout(this, 1));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
            this.toolsSystem = new SystemUtil.ToolsSystemSettings(this.utilErrorComp);
        } else {
            this.isEditable = false;
        }
        this.add(this.getTabbedPaneLicense());
    }

    protected GuiUtilButtonBar getPanelServerButtonBar() {
        if (this.panelServerButtonBar == null) {
            this.panelServerButtonBar = new GuiUtilButtonBar(800, false, false, this.tabbedPaneLicense);
            this.panelServerButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemLicensePanel)SystemLicensePanel.this).panelServerButtonBar.utilChangeHandler.deactivate();
                    SystemLicensePanel.this.utilErrorComp.clearComponents();
                    SystemLicensePanel.this.changeServer();
                }
            });
            this.panelServerButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemLicensePanel)SystemLicensePanel.this).panelServerButtonBar.utilChangeHandler.deactivate();
                    SystemLicensePanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.LicenseServer);
                    SystemLicensePanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelServerButtonBar;
    }

    private AastraTabbedPane getTabbedPaneLicense() {
        if (this.tabbedPaneLicense == null) {
            this.tabbedPaneLicense = new LicenseTabbedPane();
            this.tabbedPaneLicense.setPreferredSize(new Dimension(800, 560));
            this.tabbedPaneLicense.setMaximumSize(new Dimension(800, 560));
            this.tabbedPaneLicense.setAlignmentX(0.0f);
            this.tabbedPaneLicense.addTab(UtilLocale.getString("TXT_STATUS"), null, this.getTabStatus(), null);
            String string = UtilLocale.getString("TXT_LICENSE_FILE");
            this.tabbedPaneLicense.addTab(string, null, this.getTabServer(), null);
            this.tabbedPaneLicense.addTab(UtilLocale.getString("TXT_SYSTEM_20"), null, this.getTabSystem(), null);
            this.tabbedPaneLicense.addTab(UtilLocale.getString("TXT_MESSAGING"), null, this.getTabMessaging(), null);
            this.tabbedPaneLicense.addTab(UtilLocale.getString("TXT_LOCATING"), null, this.getTabLocating(), null);
        }
        return this.tabbedPaneLicense;
    }

    private AastraPanel getTabStatus() {
        if (this.tabStatus == null) {
            this.tabStatus = new AastraPanel();
            this.tabStatus.setLayout(new BoxLayout(this.tabStatus, 1));
            this.tabStatus.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabStatus.add(this.getPanelStatusGeneral());
            this.tabStatus.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        return this.tabStatus;
    }

    private AastraPanel getPanelStatusGeneral() {
        if (this.panelStatusGeneral == null) {
            int n;
            this.panelStatusGeneral = new GuiUtilBorderPanel(280, UtilLocale.getString("TXT_GENERAL"));
            this.labelState = new AastraLabel();
            this.labelState.setBounds(30, 30, 120, 16);
            this.labelState.setText(UtilLocale.getString("TXT_STATE"));
            this.labelStateValue = new AastraLabel();
            this.labelStateValue.setBounds(170, 30, 510, 74);
            this.labelStateValue.setIconTextGap(13);
            this.labelLicenseType = new AastraLabel();
            this.labelLicenseType.setBounds(30, 90, 120, 16);
            this.labelLicenseType.setText(UtilLocale.getString("TXT_LICENSE_TYPE"));
            this.labelLatencyPeriod = new AastraLabel();
            this.labelLatencyPeriod.setBounds(30, 120, 120, 16);
            this.labelLatencyPeriodTrend = new AastraLabel();
            this.labelLatencyPeriodTrend.setBounds(170, 120, 16, 16);
            this.labelLatencyPeriod.setText(UtilLocale.getString("TXT_GRACE_PERIOD"));
            this.labelHours = new AastraLabel();
            this.labelHours.setBounds(240, 121, 25, 16);
            this.labelHours.setText(UtilLocale.getString("TXT_UNIT_HOUR"));
            this.labelMinutes = new AastraLabel();
            this.labelMinutes.setBounds(295, 121, 25, 16);
            this.labelMinutes.setText(UtilLocale.getString("TXT_UNIT_MINUTE"));
            this.labelPARK = new AastraLabel();
            this.labelPARK.setBounds(30, 150, 120, 16);
            this.labelPARK.setText("PARK");
            for (n = 0; n < 3; ++n) {
                this.labelMACAddressArray[n] = new AastraLabel();
                this.labelMACAddressArray[n].setBounds(30, 180 + n * 30, 120, 16);
                this.labelMACAddressArray[n].setText(UtilLocale.getString("TXT_MAC_ADDRESS") + " " + (n + 1));
                this.labelConnectedArray[n] = new AastraLabel();
                this.labelConnectedArray[n].setBounds(170, 180 + n * 31, 16, 16);
            }
            this.panelStatusGeneral.add((Component)this.labelState, null);
            this.panelStatusGeneral.add((Component)this.labelStateValue, null);
            this.panelStatusGeneral.add((Component)this.labelLicenseType, null);
            this.panelStatusGeneral.add((Component)this.getTextFieldLicenseType(), null);
            this.panelStatusGeneral.add((Component)this.labelLatencyPeriod, null);
            this.panelStatusGeneral.add((Component)this.labelLatencyPeriodTrend, null);
            this.panelStatusGeneral.add((Component)this.getTextFieldLatencyPeriodHours(), null);
            this.panelStatusGeneral.add((Component)this.labelHours, null);
            this.panelStatusGeneral.add((Component)this.getTextFieldLatencyPeriodMinutes(), null);
            this.panelStatusGeneral.add((Component)this.labelMinutes, null);
            this.panelStatusGeneral.add((Component)this.labelPARK, null);
            this.panelStatusGeneral.add((Component)this.getTextFieldPARK(), null);
            for (n = 0; n < 3; ++n) {
                this.panelStatusGeneral.add((Component)this.labelMACAddressArray[n], null);
                this.panelStatusGeneral.add((Component)this.getTextFieldMACAddressArray(n), null);
                this.panelStatusGeneral.add((Component)this.labelConnectedArray[n], null);
            }
        }
        return this.panelStatusGeneral;
    }

    private AastraTextField getTextFieldLicenseType() {
        if (this.textFieldLicenseType == null) {
            this.textFieldLicenseType = new AastraTextField();
            this.textFieldLicenseType.setBounds(200, 90, 300, 18);
            this.textFieldLicenseType.setEditable(false);
        }
        return this.textFieldLicenseType;
    }

    private AastraTextField getTextFieldLatencyPeriodHours() {
        if (this.textFieldLatencyPeriodHours == null) {
            this.textFieldLatencyPeriodHours = new AastraTextField();
            this.textFieldLatencyPeriodHours.setBounds(200, 120, 35, 18);
            this.textFieldLatencyPeriodHours.setHorizontalAlignment(4);
            this.textFieldLatencyPeriodHours.setEditable(false);
        }
        return this.textFieldLatencyPeriodHours;
    }

    private AastraTextField getTextFieldLatencyPeriodMinutes() {
        if (this.textFieldLatencyPeriodMinutes == null) {
            this.textFieldLatencyPeriodMinutes = new AastraTextField();
            this.textFieldLatencyPeriodMinutes.setBounds(265, 120, 25, 18);
            this.textFieldLatencyPeriodMinutes.setHorizontalAlignment(4);
            this.textFieldLatencyPeriodMinutes.setEditable(false);
        }
        return this.textFieldLatencyPeriodMinutes;
    }

    private AastraTextField getTextFieldPARK() {
        if (this.textFieldPARK == null) {
            this.textFieldPARK = new AastraTextField();
            this.textFieldPARK.setBounds(200, 150, 110, 18);
            this.textFieldPARK.setEditable(false);
        }
        return this.textFieldPARK;
    }

    private AastraTextField getTextFieldMACAddressArray(int n) {
        if (this.textFieldMACAddressArray[n] == null) {
            this.textFieldMACAddressArray[n] = new AastraTextField();
            this.textFieldMACAddressArray[n].setBounds(200, 180 + n * 30, 110, 18);
            this.textFieldMACAddressArray[n].setEditable(false);
        }
        return this.textFieldMACAddressArray[n];
    }

    private AastraButton getButtonLicenseImportFile() {
        if (this.buttonLicenseImportFile == null) {
            this.buttonLicenseImportFile = new AastraButton(GuiUtilIcon.getIconDocumentAdd());
            this.buttonLicenseImportFile.setText(UtilLocale.getString("TXT_FILE"));
            this.buttonLicenseImportFile.setBounds(30, 30, 106, 25);
            this.buttonLicenseImportFile.setToolTipText(UtilLocale.getString("TXT_SELECT_LICENSE_FILE_TO_IMPORT"));
            this.buttonLicenseImportFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = SystemLicensePanel.this.getLicenseImportFileChooser(SystemLicensePanel.this.panelLicenseImport).fileChooser();
                    if (file != null) {
                        SystemLicensePanel.this.licenseImportFileName = file.getAbsolutePath();
                        SystemLicensePanel.this.buttonLicenseImport.setEnabled(true);
                    } else {
                        SystemLicensePanel.this.licenseImportFileName = null;
                        SystemLicensePanel.this.buttonLicenseImport.setEnabled(false);
                    }
                    SystemLicensePanel.this.textFieldLicenseImportFile.setText(SystemLicensePanel.this.licenseImportFileName);
                }
            });
        }
        return this.buttonLicenseImportFile;
    }

    private AastraButton getButtonLicenseImport() {
        if (this.buttonLicenseImport == null) {
            this.buttonLicenseImport = new AastraButton();
            this.buttonLicenseImport.setBounds(30, 75, 106, 25);
            this.buttonLicenseImport.setText(UtilLocale.getString("TXT_IMPORT_20"));
            this.buttonLicenseImport.setEnabled(false);
            this.buttonLicenseImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OmiFileTransfer.StartFileTransferReturnEnum startFileTransferReturnEnum = OmiFileTransfer.startFileTransfer(OmiMessage.elemIds.PutFile, ":license", SystemLicensePanel.this.licenseImportFileName, SystemLicensePanel.this.systemLicensePanel);
                    switch (startFileTransferReturnEnum) {
                        case FILETRANSFER_START_OK: {
                            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import started successfully");
                            GuiInfoConsole.showInfo(UtilLocale.getString("TXT_LICENSE_IMPORT_STARTED"));
                            SystemLicensePanel.this.buttonLicenseImport.setEnabled(false);
                            break;
                        }
                        case FILETRANSFER_ACTIVE: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: Another file transfer is still active");
                            break;
                        }
                        case WRONG_PARAM: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: Wrong parameters");
                            break;
                        }
                        case FILE_TRANSFER_NOT_INITIALIZED: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: File transfer not initialized");
                            break;
                        }
                        case LOCAL_FILE_ERROR: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: Local file access failed");
                            break;
                        }
                        case NO_LINK_TO_OMM: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: OMM link failed");
                            break;
                        }
                        default: {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "License import error: Unknown");
                        }
                    }
                }
            });
        }
        return this.buttonLicenseImport;
    }

    private AastraTextField getTextFieldLicenseImportFile() {
        if (this.textFieldLicenseImportFile == null) {
            this.textFieldLicenseImportFile = new AastraTextField();
            this.textFieldLicenseImportFile.setBounds(150, 34, 600, 18);
            this.textFieldLicenseImportFile.setText(this.licenseImportFileName);
            this.textFieldLicenseImportFile.setEditable(false);
        }
        return this.textFieldLicenseImportFile;
    }

    private GuiUtilFileChooser getLicenseImportFileChooser(AastraPanel aastraPanel) {
        if (this.licenseImportFileChooser == null) {
            this.licenseImportFileChooser = new GuiUtilFileChooser(aastraPanel);
        }
        return this.licenseImportFileChooser;
    }

    private AastraPanel getTabServer() {
        if (this.tabServer == null) {
            this.tabServer = new AastraPanel();
            this.tabServer.setLayout(new BoxLayout(this.tabServer, 1));
            this.tabServer.add(Box.createRigidArea(new Dimension(0, 5)));
            this.tabServer.add(this.getPanelServerWrapper());
            if (this.isEditable) {
                this.tabServer.add(Box.createRigidArea(new Dimension(0, 5)));
                this.tabServer.add(this.getPanelLicenseImportWrapper());
            }
        }
        return this.tabServer;
    }

    private AastraPanel getPanelServerWrapper() {
        if (this.panelServerWrapper == null) {
            this.panelServerWrapper = new AastraPanel();
            this.panelServerWrapper.setLayout(new BoxLayout(this.panelServerWrapper, 0));
            this.panelServerWrapper.add(this.getPanelServer());
        }
        return this.panelServerWrapper;
    }

    private AastraPanel getPanelServer() {
        if (this.panelServer == null) {
            this.panelServer = new AastraPanel();
            this.panelServer.setLayout(new BoxLayout(this.panelServer, 1));
            Dimension dimension = new Dimension(780, 150);
            this.panelServer.setPreferredSize(dimension);
            this.panelServer.setMaximumSize(dimension);
            this.panelServer.setMinimumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_SERVER"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelServer.setBorder(BorderFactory.createTitledBorder(titledBorder));
            this.getPanelServerButtonBar();
            this.panelServer.add(Box.createRigidArea(new Dimension(0, 5)));
            this.panelServer.add(this.getPanelServerGeneral());
            if (this.isEditable) {
                this.panelServer.add(Box.createRigidArea(new Dimension(0, 5)));
                this.panelServer.add(this.panelServerButtonBar);
            }
        }
        return this.panelServer;
    }

    private AastraPanel getPanelLicenseImportWrapper() {
        if (this.panelLicenseImportWrapper == null) {
            this.panelLicenseImportWrapper = new AastraPanel();
            this.panelLicenseImportWrapper.add(this.getPanelLicenseImport());
        }
        return this.panelLicenseImportWrapper;
    }

    private AastraPanel getPanelLicenseImport() {
        if (this.panelLicenseImport == null) {
            this.panelLicenseImport = new GuiUtilBorderPanel(120, UtilLocale.getString("TXT_LICENSE_FILE_IMPORT"));
            this.labelInfo = new AastraLabel();
            this.labelInfo.setBounds(150, 80, 550, 31);
            this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_INFO_OMM_RESET_IMPORT_LICENSE") + "</html>");
            this.labelInfo.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.panelLicenseImport.add((Component)this.getTextFieldLicenseImportFile(), null);
            this.panelLicenseImport.add((Component)this.getButtonLicenseImportFile(), null);
            this.panelLicenseImport.add((Component)this.getButtonLicenseImport(), null);
            this.panelLicenseImport.add((Component)this.labelInfo, null);
        }
        return this.panelLicenseImport;
    }

    private AastraPanel getPanelServerGeneral() {
        if (this.panelServerGeneral == null) {
            this.panelServerGeneral = new GuiUtilBorderPanel(760, 50, UtilLocale.getString("TXT_GENERAL"));
            this.labelInstallationId = new AastraLabel();
            this.labelInstallationId.setBounds(30, 20, 120, 16);
            this.labelInstallationId.setText(UtilLocale.getString("TXT_INSTALLATION_ID"));
            this.panelServerGeneral.add((Component)this.labelInstallationId, null);
            this.panelServerGeneral.add((Component)this.getTextFieldInstallationId(), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.installationId.toString(), this.labelInstallationId, this.getTextFieldInstallationId(), this.panelServerButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelServerGeneral);
            }
        }
        return this.panelServerGeneral;
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.panelServerButtonBar.utilChangeHandler, 160, 20);
        }
        return this.checkBoxActive;
    }

    private GuiUtilTextField getTextFieldInstallationId() {
        if (this.textFieldInstallationId == null) {
            this.textFieldInstallationId = new GuiUtilTextField(this.panelServerButtonBar.utilChangeHandler);
            this.textFieldInstallationId.setBounds(160, 20, 110, 18);
        }
        return this.textFieldInstallationId;
    }

    private AastraPanel getPanelServerSystem(int n) {
        if (this.panelServerSystemArray[n] == null) {
            this.panelServerSystemArray[n] = new GuiUtilBorderPanel(760, 75, UtilLocale.getString("TXT_LICENSE_SYSTEM") + " " + (n + 1));
            this.panelServerSystemArray[n].add((Component)this.getLabelServer(n), null);
            this.panelServerSystemArray[n].add((Component)this.getTextFieldServer(n), null);
            this.panelServerSystemArray[n].add((Component)this.getLabelPort(n), null);
            this.panelServerSystemArray[n].add((Component)this.getTextFieldPort(n), null);
            this.panelServerSystemArray[n].add((Component)this.getLabelServerStandby(n), null);
            this.panelServerSystemArray[n].add((Component)this.getTextFieldServerStandby(n), null);
            this.panelServerSystemArray[n].add((Component)this.getLabelPortStandby(n), null);
            this.panelServerSystemArray[n].add((Component)this.getTextFieldPortStandby(n), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.server.toString() + String.valueOf(n + 1), this.getLabelServer(n), this.getTextFieldServer(n), this.panelServerButtonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.port.toString() + String.valueOf(n + 1), this.getLabelPort(n), this.getTextFieldPort(n), this.panelServerButtonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.serverStandby.toString() + String.valueOf(n + 1), this.getLabelServerStandby(n), this.getTextFieldServerStandby(n), this.panelServerButtonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.portStandby.toString() + String.valueOf(n + 1), this.getLabelPortStandby(n), this.getTextFieldPortStandby(n), this.panelServerButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelServerSystemArray[n]);
            }
        }
        return this.panelServerSystemArray[n];
    }

    private AastraLabel getLabelServer(int n) {
        if (this.labelServerArray[n] == null) {
            this.labelServerArray[n] = new AastraLabel(UtilLocale.getString("TXT_SERVER"));
            this.labelServerArray[n].setBounds(30, 18, 230, 16);
        }
        return this.labelServerArray[n];
    }

    private GuiUtilTextField getTextFieldServer(int n) {
        if (this.textFieldServerArray[n] == null) {
            this.textFieldServerArray[n] = new GuiUtilTextField(this.panelServerButtonBar.utilChangeHandler);
            this.textFieldServerArray[n].setBounds(160, 18, 150, 18);
        }
        return this.textFieldServerArray[n];
    }

    private AastraLabel getLabelPort(int n) {
        if (this.labelPortArray[n] == null) {
            this.labelPortArray[n] = new AastraLabel(UtilLocale.getString("TXT_PORT"));
            this.labelPortArray[n].setBounds(30, 48, 230, 16);
        }
        return this.labelPortArray[n];
    }

    private GuiUtilTextField getTextFieldPort(int n) {
        if (this.textFieldPortArray[n] == null) {
            this.textFieldPortArray[n] = new GuiUtilTextField(this.panelServerButtonBar.utilChangeHandler);
            this.textFieldPortArray[n].setBounds(160, 48, 50, 18);
        }
        return this.textFieldPortArray[n];
    }

    private AastraLabel getLabelServerStandby(int n) {
        if (this.labelServerStandbyArray[n] == null) {
            this.labelServerStandbyArray[n] = new AastraLabel(UtilLocale.getString("TXT_STANDBY_SERVER"));
            this.labelServerStandbyArray[n].setBounds(400, 18, 230, 16);
        }
        return this.labelServerStandbyArray[n];
    }

    private GuiUtilTextField getTextFieldServerStandby(int n) {
        if (this.textFieldServerStandbyArray[n] == null) {
            this.textFieldServerStandbyArray[n] = new GuiUtilTextField(this.panelServerButtonBar.utilChangeHandler);
            this.textFieldServerStandbyArray[n].setBounds(530, 18, 150, 18);
        }
        return this.textFieldServerStandbyArray[n];
    }

    private AastraLabel getLabelPortStandby(int n) {
        if (this.labelPortStandbyArray[n] == null) {
            this.labelPortStandbyArray[n] = new AastraLabel(UtilLocale.getString("TXT_STANDBY_PORT"));
            this.labelPortStandbyArray[n].setBounds(400, 48, 230, 16);
        }
        return this.labelPortStandbyArray[n];
    }

    private GuiUtilTextField getTextFieldPortStandby(int n) {
        if (this.textFieldPortStandbyArray[n] == null) {
            this.textFieldPortStandbyArray[n] = new GuiUtilTextField(this.panelServerButtonBar.utilChangeHandler);
            this.textFieldPortStandbyArray[n].setBounds(530, 48, 50, 18);
        }
        return this.textFieldPortStandbyArray[n];
    }

    private AastraPanel getTabSystem() {
        if (this.tabSystem == null) {
            this.tabSystem = new AastraPanel();
            this.tabSystem.setLayout(null);
            this.tabSystem.setPreferredSize(new Dimension(0, 280));
            this.labelLicenseDescriptionSystemXXX = new AastraLabel();
            this.labelLicenseDescriptionSystemXXX.setBounds(30, 30, 180, 16);
            this.labelLicenseDescriptionSystemXXX.setText("OM System License XXX");
            this.labelStatusSystemXXXValue = new AastraLabel();
            this.labelStatusSystemXXXValue.setBounds(270, 30, 16, 16);
            this.labelRfpNumMax = new AastraLabel();
            this.labelRfpNumMax.setBounds(30, 60, 230, 16);
            this.labelRfpNumMax.setText(UtilLocale.getString("TXT_MAXIMUM_NUMBER_OF_RFPS"));
            this.labelRfpNumCurrent = new AastraLabel();
            this.labelRfpNumCurrent.setBounds(30, 90, 230, 16);
            this.labelRfpNumCurrent.setText(UtilLocale.getString("TXT_CURRENT_NUMBER_OF_RFPS"));
            this.labelLicenseKeySystem = new AastraLabel();
            this.labelLicenseKeySystem.setBounds(30, 120, 230, 16);
            this.labelLicenseKeySystem.setText(UtilLocale.getString("TXT_LICENSE_KEY"));
            this.tabSystem.add((Component)this.labelLicenseDescriptionSystemXXX, null);
            this.tabSystem.add((Component)this.labelStatusSystemXXXValue, null);
            this.tabSystem.add((Component)this.labelRfpNumMax, null);
            this.tabSystem.add((Component)this.getTextFieldRfpNumMax(), null);
            this.tabSystem.add((Component)this.labelRfpNumCurrent, null);
            this.tabSystem.add((Component)this.getTextFieldRfpNumCurrent(), null);
            this.tabSystem.add((Component)this.labelLicenseKeySystem, null);
            this.tabSystem.add((Component)this.getTextFieldLicenseKeySystem(), null);
        }
        return this.tabSystem;
    }

    private AastraTextField getTextFieldRfpNumMax() {
        if (this.textFieldRfpNumMax == null) {
            this.textFieldRfpNumMax = new AastraTextField();
            this.textFieldRfpNumMax.setBounds(270, 60, 75, 18);
            this.textFieldRfpNumMax.setEditable(false);
        }
        return this.textFieldRfpNumMax;
    }

    private AastraTextField getTextFieldRfpNumCurrent() {
        if (this.textFieldRfpNumCurrent == null) {
            this.textFieldRfpNumCurrent = new AastraTextField();
            this.textFieldRfpNumCurrent.setBounds(270, 90, 75, 18);
            this.textFieldRfpNumCurrent.setEditable(false);
        }
        return this.textFieldRfpNumCurrent;
    }

    private AastraTextField getTextFieldLicenseKeySystem() {
        if (this.textFieldLicenseKeySystem == null) {
            this.textFieldLicenseKeySystem = new AastraTextField();
            this.textFieldLicenseKeySystem.setBounds(270, 120, 225, 18);
            this.textFieldLicenseKeySystem.setEditable(false);
        }
        return this.textFieldLicenseKeySystem;
    }

    private AastraPanel getTabMessaging() {
        if (this.tabMessaging == null) {
            this.tabMessaging = new AastraPanel();
            this.tabMessaging.setLayout(null);
            this.tabMessaging.setPreferredSize(new Dimension(0, 280));
            this.labelLicenseMessagingAlertingSystem = new AastraLabel();
            this.labelLicenseMessagingAlertingSystem.setBounds(30, 30, 230, 32);
            this.labelLicenseMessagingAlertingSystem.setText("<html>OM Messaging & Alerting System License</html>");
            this.labelLicenseMessagingAlertingSystemStatus = new AastraLabel();
            this.labelLicenseMessagingAlertingSystemStatus.setBounds(270, 30, 16, 16);
            this.labelLicenseMessagingSystemDescription = new AastraLabel();
            this.labelLicenseMessagingSystemDescription.setBounds(350, 30, 330, 32);
            this.labelLicenseMessagingSystemDescription.setText("<html>" + UtilLocale.getString("TXT_RECEIVING_TEXT_MESSAGES") + "</html>");
            this.labelLicenseKeyMessaging = new AastraLabel();
            this.labelLicenseKeyMessaging.setBounds(30, 90, 230, 16);
            this.labelLicenseKeyMessaging.setText(UtilLocale.getString("TXT_LICENSE_KEY"));
            this.tabMessaging.add((Component)this.labelLicenseMessagingAlertingSystem, null);
            this.tabMessaging.add((Component)this.labelLicenseMessagingAlertingSystemStatus, null);
            this.tabMessaging.add((Component)this.labelLicenseMessagingSystemDescription, null);
            this.tabMessaging.add((Component)this.labelLicenseKeyMessaging, null);
            this.tabMessaging.add((Component)this.getTextFieldLicenseKeyMessaging(), null);
        }
        return this.tabMessaging;
    }

    private AastraTextField getTextFieldLicenseKeyMessaging() {
        if (this.textFieldLicenseKeyMessaging == null) {
            this.textFieldLicenseKeyMessaging = new AastraTextField();
            this.textFieldLicenseKeyMessaging.setBounds(270, 90, 225, 18);
            this.textFieldLicenseKeyMessaging.setEditable(false);
        }
        return this.textFieldLicenseKeyMessaging;
    }

    private AastraPanel getTabLocating() {
        if (this.tabLocating == null) {
            this.labelLicenseLocatingServer = new AastraLabel();
            this.labelLicenseLocatingServer.setBounds(30, 30, 230, 16);
            this.labelLicenseLocatingServer.setText("OM Locating Server License");
            this.labelLicenseLocatingServerStatus = new AastraLabel();
            this.labelLicenseLocatingServerStatus.setBounds(270, 30, 16, 16);
            this.labelLicenseLocatingServerDescription = new AastraLabel();
            this.labelLicenseLocatingServerDescription.setBounds(350, 30, 330, 32);
            this.labelLicenseLocatingServerDescription.setText("<html>" + UtilLocale.getString("TXT_OM_LOCATING_APPLICATION") + "</html>");
            this.labelLicenseLocatingXXX = new AastraLabel();
            this.labelLicenseLocatingXXX.setBounds(30, 90, 180, 16);
            this.labelLicenseLocatingXXX.setText("OM Locating License XXX");
            this.labelLicenseLocatingXXXStatus = new AastraLabel();
            this.labelLicenseLocatingXXXStatus.setBounds(270, 90, 16, 16);
            this.labelPpUserNumLocatingMax = new AastraLabel();
            this.labelPpUserNumLocatingMax.setBounds(30, 120, 230, 32);
            this.labelPpUserNumLocatingMax.setText("<html>" + UtilLocale.getString("TXT_MAXIMUM_NUMBER_OF_USERS_ALLOWED_TO_BE_LOCATED") + "</html>");
            this.labelPpUserNumLocatingCurrent = new AastraLabel();
            this.labelPpUserNumLocatingCurrent.setBounds(30, 165, 230, 32);
            this.labelPpUserNumLocatingCurrent.setText("<html>" + UtilLocale.getString("TXT_CURRENT_NUMBER_OF_USERS_ALLOWED_TO_BE_LOCATED") + "</html>");
            this.labelLicenseKeyLocating = new AastraLabel();
            this.labelLicenseKeyLocating.setBounds(30, 240, 230, 16);
            this.labelLicenseKeyLocating.setText(UtilLocale.getString("TXT_LICENSE_KEY"));
            this.tabLocating = new AastraPanel();
            this.tabLocating.setLayout(null);
            this.tabLocating.setPreferredSize(new Dimension(0, 280));
            this.tabLocating.add((Component)this.labelLicenseLocatingServer, null);
            this.tabLocating.add((Component)this.labelLicenseLocatingServerStatus, null);
            this.tabLocating.add((Component)this.labelLicenseLocatingServerDescription, null);
            this.tabLocating.add((Component)this.labelLicenseLocatingXXX, null);
            this.tabLocating.add((Component)this.labelLicenseLocatingXXXStatus, null);
            this.tabLocating.add((Component)this.labelPpUserNumLocatingMax, null);
            this.tabLocating.add((Component)this.getTextFieldPpUserNumLocatingMax(), null);
            this.tabLocating.add((Component)this.labelPpUserNumLocatingCurrent, null);
            this.tabLocating.add((Component)this.getTextFieldPpUserNumLocatingCurrent(), null);
            this.tabLocating.add((Component)this.labelLicenseKeyLocating, null);
            this.tabLocating.add((Component)this.getTextFieldLicenseKeyLocating(), null);
        }
        return this.tabLocating;
    }

    private AastraTextField getTextFieldPpUserNumLocatingMax() {
        if (this.textFieldPpUserNumLocatingMax == null) {
            this.textFieldPpUserNumLocatingMax = new AastraTextField();
            this.textFieldPpUserNumLocatingMax.setBounds(270, 120, 75, 18);
            this.textFieldPpUserNumLocatingMax.setEditable(false);
        }
        return this.textFieldPpUserNumLocatingMax;
    }

    private AastraTextField getTextFieldPpUserNumLocatingCurrent() {
        if (this.textFieldPpUserNumLocatingCurrent == null) {
            this.textFieldPpUserNumLocatingCurrent = new AastraTextField();
            this.textFieldPpUserNumLocatingCurrent.setBounds(270, 165, 75, 18);
            this.textFieldPpUserNumLocatingCurrent.setEditable(false);
        }
        return this.textFieldPpUserNumLocatingCurrent;
    }

    private AastraTextField getTextFieldLicenseKeyLocating() {
        if (this.textFieldLicenseKeyLocating == null) {
            this.textFieldLicenseKeyLocating = new AastraTextField();
            this.textFieldLicenseKeyLocating.setBounds(270, 240, 225, 18);
            this.textFieldLicenseKeyLocating.setEditable(false);
        }
        return this.textFieldLicenseKeyLocating;
    }

    public void changeServer() {
        boolean bl = true;
        CommonDataHandler.LicenseServerClass licenseServerClass = new CommonDataHandler.LicenseServerClass();
        licenseServerClass.installationId = this.toolsSystem.getUnsignedDecimalIntFromTextField(this.textFieldInstallationId, UtilLocale.getString("TXT_INSTALLATION_ID"));
        if (licenseServerClass.installationId == -1) {
            bl = false;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.LicenseServer.toString() + "='" + licenseServerClass.serverActive + "', " + licenseServerClass.installationId);
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.LicenseServer, licenseServerClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.LicenseServer);
        } else {
            this.panelServerButtonBar.buttonCancel.setEnabled(true);
        }
    }

    private void setLatencyPeriodTrend() {
        if (this.currentLicense != null && this.currentLimits != null) {
            if (this.currentLicense.type != OmiMessage.LicenseTypeType.small) {
                if (this.currentLicense.state == OmiMessage.LicenseStateType.noRedundancyLicense || this.currentLicense.state == OmiMessage.LicenseStateType.activeLicense) {
                    if (this.currentLicense.latency < this.currentLimits.licLatency) {
                        this.labelLatencyPeriodTrend.setIcon(GuiUtilIcon.getIconUp());
                    } else {
                        this.labelLatencyPeriodTrend.setIcon(null);
                    }
                } else if (this.currentLicense.latency > 0) {
                    this.labelLatencyPeriodTrend.setIcon(GuiUtilIcon.getIconDown());
                } else {
                    this.labelLatencyPeriodTrend.setIcon(null);
                }
            } else {
                this.labelLatencyPeriodTrend.setIcon(null);
            }
        }
    }

    @Override
    public void omiFileTransferNotification(String string, OmiFileTransfer.OmiFileTransferEvents omiFileTransferEvents, OmiMessage omiMessage, int n) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "File transfer event: " + omiFileTransferEvents.toString());
        switch (omiFileTransferEvents) {
            case TRANSFER_COMPLETED: {
                GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_LICENSE_FILE_*_IMPORTED_SUCCESSFULLY"), this.licenseImportFileName));
                break;
            }
            case TRANSFER_ERROR: {
                if (omiMessage != null) {
                    String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                    try {
                        OmiMessage.errorCodes errorCodes2 = OmiMessage.errorCodes.valueOf(string2);
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_LICENSE_IMPORT_FAILED") + ": " + UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "OMI file transfer notification: Unknown errorCode=" + string2);
                    }
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_LICENSE_IMPORT_FAILED") + ": " + UtilLocale.getString("TXT_TRANSFER_ERROR"));
                break;
            }
            case ERROR_NAME_CONFLICT: {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_LICENSE_IMPORT_FAILED") + ": " + UtilLocale.getString("TXT_FILE_NAME_CONFLICT"));
                break;
            }
            case ERROR_OFFSET_MISMATCH: {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_LICENSE_IMPORT_FAILED") + ": " + UtilLocale.getString("TXT_FILE_OFFSET_MISMATCH"));
                break;
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.rfpSummaryHandler.activateRequest();
        this.ppUserSummaryHandler.activateRequest();
        this.panelServerButtonBar.utilChangeHandler.initRootPane(this.getRootPane());
        this.getRootPane().setDefaultButton(this.panelServerButtonBar.buttonCancel);
    }

    @Override
    public void componentDeactivated() {
        this.rfpSummaryHandler.deactivateRequest();
        this.ppUserSummaryHandler.deactivateRequest();
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        Object object;
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        String string4 = null;
        if (string2 != null) {
            if (!string2.equals(OmiMessage.attribIds.installationId.toString()) && (object = omiMessage.getAttribVal(OmiMessage.attribIds.info.name())) != null) {
                if (((String)object).contains(OmiMessage.elemIds.licenseServer1.name())) {
                    string2 = string2.concat("1");
                } else if (((String)object).contains(OmiMessage.elemIds.licenseServer2.name())) {
                    string2 = string2.concat("2");
                } else if (((String)object).contains(OmiMessage.elemIds.licenseServer3.name())) {
                    string2 = string2.concat("3");
                }
            }
            string4 = this.utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        object = null;
        GuiUtilButtonBar guiUtilButtonBar = null;
        if (string2 != null) {
            object = this.utilErrorComp.getField(string2);
            if (object != null) {
                this.utilErrorComp.markComponent((JComponent)object);
            }
            if ((guiUtilButtonBar = this.utilErrorComp.getButtonBar(string2)) != null) {
                guiUtilButtonBar.utilChangeHandler.activateOnError();
            }
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        BitSet bitSet = new BitSet();
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        switch (commonDataItemEnum) {
            case License: {
                int n;
                int n2;
                CommonDataHandler.LicenseClass licenseClass = null;
                try {
                    licenseClass = (CommonDataHandler.LicenseClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.License);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.License.toString() + " failed");
                    return;
                }
                this.currentLicense = licenseClass;
                if (licenseClass.type == null || licenseClass.state == null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.License.toString() + ":");
                    if (licenseClass.type == null) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "   license.type = null");
                    }
                    if (licenseClass.state != null) break;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "   license.state = null");
                    break;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.License.toString() + ":");
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + (Object)((Object)licenseClass.type) + ", " + (Object)((Object)licenseClass.state) + "," + licenseClass.latency + "," + licenseClass.park);
                for (n2 = 0; n2 < licenseClass.numRfps; ++n2) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseClass.licenseRfpType[n2].id);
                }
                if (licenseClass.sysLicense != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseClass.sysLicense.systemLicenseVersion + "," + licenseClass.sysLicense.number + "," + licenseClass.sysLicense.key);
                }
                if (licenseClass.msgLicense != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseClass.msgLicense.messagingLicenseRcvMsgs + "," + licenseClass.msgLicense.number + "," + licenseClass.msgLicense.key);
                }
                if (licenseClass.locLicense != null) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseClass.locLicense.locatingLicense + "," + licenseClass.locLicense.number + "," + licenseClass.locLicense.key);
                }
                switch (licenseClass.state) {
                    case activeLicense: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStateValue.setText("");
                        break;
                    }
                    case noLicense: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStateValue.setText("<html>" + UtilLocale.getString("TXT_LICENSE_MISSING_ERROR") + "</html>");
                        break;
                    }
                    case inactiveLicense: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStateValue.setText("<html>" + UtilLocale.getString("TXT_LICENSE_INACTIVE_ERROR") + "</html>");
                        break;
                    }
                    case inactiveLicenseBlocked: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStateValue.setText("<html>" + UtilLocale.getString("TXT_LICENSE_INACTIVE_ERROR") + "</html>");
                        for (n2 = 0; n2 < licenseClass.numViolations; ++n2) {
                            bitSet.set(licenseClass.violations[n2].ordinal());
                        }
                        break;
                    }
                    case noRedundancyLicense: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStateValue.setText("<html>" + UtilLocale.getString("TXT_LICENSE_WITH_NO_REDUNDANCY_WARNING") + "</html>");
                        break;
                    }
                    default: {
                        this.labelStateValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        String string = "<html>" + UtilLocale.getString("TXT_LICENSE_IS_VIOLATED_BY_CONFIGURATION") + "</html>";
                        for (int i = 0; i < licenseClass.numViolations; ++i) {
                            if (licenseClass.violations[i] == OmiMessage.LicenseViolationType.swRelease) {
                                bitSet.set(OmiMessage.LicenseViolationType.swRelease.ordinal());
                                string = "<html>" + UtilLocale.getString("TXT_LICENSE_BLOCKED_SOFTWARE_VERSION") + " " + UtilLocale.getString("TXT_LICENSE_PLEASE_UPDATE") + "</html>";
                                break;
                            }
                            if (licenseClass.violations[i] == OmiMessage.LicenseViolationType.numRFPs) {
                                bitSet.set(OmiMessage.LicenseViolationType.numRFPs.ordinal());
                                if (!bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal())) {
                                    string = "<html>" + UtilLocale.getString("TXT_LICENSE_BLOCKED_NUM_RFPS_ERROR") + "</html>";
                                }
                            }
                            if (licenseClass.violations[i] == OmiMessage.LicenseViolationType.numSendMsgs) {
                                bitSet.set(OmiMessage.LicenseViolationType.numSendMsgs.ordinal());
                                if (!bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal()) && !bitSet.get(OmiMessage.LicenseViolationType.numRFPs.ordinal())) {
                                    string = "<html>" + UtilLocale.getString("TXT_LICENSE_BLOCKED_NUM_PPS_MESSAGING_ERROR") + "</html>";
                                }
                            }
                            if (licenseClass.violations[i] == OmiMessage.LicenseViolationType.numLocatables) {
                                bitSet.set(OmiMessage.LicenseViolationType.numLocatables.ordinal());
                                if (!(bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal()) || bitSet.get(OmiMessage.LicenseViolationType.numRFPs.ordinal()) || bitSet.get(OmiMessage.LicenseViolationType.numSendMsgs.ordinal()))) {
                                    string = "<html>" + UtilLocale.getString("TXT_LICENSE_BLOCKED_NUM_PPS_LOCATING_ERROR") + "</html>";
                                }
                            }
                            if (licenseClass.violations[i] != OmiMessage.LicenseViolationType.noLicense) continue;
                            bitSet.set(OmiMessage.LicenseViolationType.noLicense.ordinal());
                            if (bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal()) || bitSet.get(OmiMessage.LicenseViolationType.numRFPs.ordinal()) || bitSet.get(OmiMessage.LicenseViolationType.numSendMsgs.ordinal()) || bitSet.get(OmiMessage.LicenseViolationType.numLocatables.ordinal())) continue;
                            string = "<html>" + UtilLocale.getString("TXT_LICENSE_MISSING_ERROR") + "</html>";
                        }
                        this.labelStateValue.setText(string);
                    }
                }
                switch (licenseClass.type) {
                    default: {
                        this.getTextFieldLicenseType().setText(UtilLocale.getString("TXT_UNKNOWN"));
                        break;
                    }
                    case small: {
                        this.getTextFieldLicenseType().setText(UtilLocale.getString("TXT_BUILT_IN_LICENSE_FOR_UP_TO_5_RFPS"));
                        break;
                    }
                    case standard: {
                        this.getTextFieldLicenseType().setText(UtilLocale.getString("TXT_STANDARD_LICENSE"));
                    }
                }
                if (licenseClass.type != OmiMessage.LicenseTypeType.small) {
                    this.getTextFieldLatencyPeriodHours().setText(String.format("%02d", licenseClass.latency / 60));
                    this.getTextFieldLatencyPeriodMinutes().setText(String.format("%02d", licenseClass.latency % 60));
                } else {
                    this.getTextFieldLatencyPeriodHours().setText("-");
                    this.getTextFieldLatencyPeriodMinutes().setText("-");
                }
                if (!licenseClass.park.isEmpty()) {
                    this.getTextFieldPARK().setText(licenseClass.park);
                } else {
                    this.getTextFieldPARK().setText("-");
                }
                for (n = 0; n < licenseClass.numRfps && n < 3; ++n) {
                    this.getTextFieldMACAddressArray(n).setText(licenseClass.licenseRfpType[n].ethAddr);
                    if (licenseClass.licenseRfpType[n].connected) {
                        this.labelConnectedArray[n].setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        continue;
                    }
                    this.labelConnectedArray[n].setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                }
                for (n = 2; n >= licenseClass.numRfps; --n) {
                    this.labelConnectedArray[n].setIcon(null);
                    this.getTextFieldMACAddressArray(n).setText("-");
                }
                this.setLatencyPeriodTrend();
                if (licenseClass.sysLicense != null) {
                    this.getTextFieldRfpNumMax().setText(Integer.toString(licenseClass.sysLicense.number));
                    if (!licenseClass.sysLicense.key.isEmpty()) {
                        this.getTextFieldLicenseKeySystem().setText(licenseClass.sysLicense.key);
                    } else {
                        this.getTextFieldLicenseKeySystem().setText("-");
                    }
                    if (bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal())) {
                        this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStatusSystemXXXValue.setToolTipText(UtilLocale.getString("TXT_LICENSE_BLOCKED_SOFTWARE_VERSION"));
                    } else if (bitSet.get(OmiMessage.LicenseViolationType.numRFPs.ordinal())) {
                        this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStatusSystemXXXValue.setToolTipText(UtilLocale.getString("TXT_LICENSE_BLOCKED_NUM_RFPS_ERROR"));
                    } else if (licenseClass.sysLicense.number > 0) {
                        if (licenseClass.state == OmiMessage.LicenseStateType.inactiveLicense || licenseClass.state == OmiMessage.LicenseStateType.inactiveLicenseBlocked) {
                            this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                            this.labelStatusSystemXXXValue.setToolTipText("<html>" + UtilLocale.getString("TXT_LICENSE_INACTIVE_ERROR") + "</html>");
                        } else {
                            this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                            this.labelStatusSystemXXXValue.setToolTipText(null);
                        }
                    } else {
                        this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelStatusSystemXXXValue.setToolTipText(null);
                    }
                } else {
                    this.getTextFieldRfpNumMax().setText("0");
                    this.getTextFieldLicenseKeySystem().setText("-");
                    this.labelStatusSystemXXXValue.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.labelStatusSystemXXXValue.setToolTipText(null);
                }
                if (licenseClass.msgLicense != null) {
                    if (licenseClass.msgLicense.messagingLicenseRcvMsgs) {
                        if (licenseClass.state == OmiMessage.LicenseStateType.inactiveLicense || licenseClass.state == OmiMessage.LicenseStateType.inactiveLicenseBlocked) {
                            this.labelLicenseMessagingAlertingSystemStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        } else {
                            this.labelLicenseMessagingAlertingSystemStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        }
                    } else {
                        this.labelLicenseMessagingAlertingSystemStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    }
                    if (!licenseClass.msgLicense.key.isEmpty()) {
                        this.getTextFieldLicenseKeyMessaging().setText(licenseClass.msgLicense.key);
                    } else {
                        this.getTextFieldLicenseKeyMessaging().setText("-");
                    }
                } else {
                    this.labelLicenseMessagingAlertingSystemStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.getTextFieldLicenseKeyMessaging().setText("-");
                }
                if (licenseClass.locLicense != null) {
                    if (licenseClass.locLicense.locatingLicense) {
                        if (licenseClass.state == OmiMessage.LicenseStateType.inactiveLicense || licenseClass.state == OmiMessage.LicenseStateType.inactiveLicenseBlocked) {
                            this.labelLicenseLocatingServerStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        } else {
                            this.labelLicenseLocatingServerStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        }
                    } else {
                        this.labelLicenseLocatingServerStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    }
                    if (licenseClass.locLicense.number > 0) {
                        this.getTextFieldPpUserNumLocatingMax().setText(Integer.toString(licenseClass.locLicense.number));
                    } else {
                        this.getTextFieldPpUserNumLocatingMax().setText("0");
                    }
                    if (!licenseClass.locLicense.key.isEmpty()) {
                        this.getTextFieldLicenseKeyLocating().setText(licenseClass.locLicense.key);
                    } else {
                        this.getTextFieldLicenseKeyLocating().setText("-");
                    }
                    if (bitSet.get(OmiMessage.LicenseViolationType.numLocatables.ordinal())) {
                        this.labelLicenseLocatingXXXStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelLicenseLocatingXXXStatus.setToolTipText("<html>" + UtilLocale.getString("TXT_LICENSE_BLOCKED_NUM_PPS_LOCATING_ERROR") + "</html>");
                    } else if (licenseClass.locLicense.number > 0) {
                        if (licenseClass.state == OmiMessage.LicenseStateType.inactiveLicense || licenseClass.state == OmiMessage.LicenseStateType.inactiveLicenseBlocked) {
                            this.labelLicenseLocatingXXXStatus.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                            this.labelLicenseLocatingXXXStatus.setToolTipText("<html>" + UtilLocale.getString("TXT_LICENSE_INACTIVE_ERROR") + "</html>");
                        } else {
                            this.labelLicenseLocatingXXXStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                            this.labelLicenseLocatingXXXStatus.setToolTipText(null);
                        }
                    } else {
                        this.labelLicenseLocatingXXXStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                        this.labelLicenseLocatingXXXStatus.setToolTipText(null);
                    }
                } else {
                    this.labelLicenseLocatingServerStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.labelLicenseLocatingXXXStatus.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
                    this.labelLicenseLocatingXXXStatus.setToolTipText(null);
                    this.getTextFieldPpUserNumLocatingMax().setText("0");
                    this.getTextFieldLicenseKeyLocating().setText("-");
                }
                GuiUtilDialog.GuiUtilDialogMessageTypeEnum guiUtilDialogMessageTypeEnum = null;
                String string = "";
                switch (licenseClass.state) {
                    case noLicense: {
                        guiUtilDialogMessageTypeEnum = GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageError;
                        string = UtilLocale.getString("TXT_LICENSE_IS_MISSING");
                        break;
                    }
                    case inactiveLicense: {
                        guiUtilDialogMessageTypeEnum = GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageError;
                        string = UtilLocale.getString("TXT_INSUFFICIENT_NUMBER_OF_LICENSE_RFPS_CONNECTED");
                        break;
                    }
                    case inactiveLicenseBlocked: 
                    case activeLicenseBlocked: 
                    case noRedundancyLicenseBlocked: {
                        guiUtilDialogMessageTypeEnum = GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageError;
                        if (bitSet.get(OmiMessage.LicenseViolationType.swRelease.ordinal())) {
                            string = UtilLocale.getString("TXT_LICENSE_BLOCKED_SOFTWARE_VERSION");
                            break;
                        }
                        string = UtilLocale.getString("TXT_LICENSE_IS_VIOLATED_BY_CONFIGURATION");
                        break;
                    }
                    case noRedundancyLicense: {
                        guiUtilDialogMessageTypeEnum = GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning;
                        string = UtilLocale.getString("TXT_ONE_LICENSE_RFP_IS_NOT_CONNECTED");
                        break;
                    }
                }
                if (licenseClass.state != OmiMessage.LicenseStateType.activeLicense && lastLicenseState != licenseClass.state) {
                    if (dialog != null && dialog.isVisible()) {
                        dialog.setVisible(false);
                    }
                    if (!this.guiMain.getExceptionStatus()) {
                        dialog = new GuiUtilDialog(guiUtilDialogMessageTypeEnum, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, GuiUtilDialog.GuiUtilDialogModalityEnum.Modeless, string, null, null, true);
                    }
                }
                lastLicenseState = licenseClass.state;
                break;
            }
            case LicenseServer: {
                CommonDataHandler.LicenseServerClass licenseServerClass = null;
                try {
                    licenseServerClass = (CommonDataHandler.LicenseServerClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.LicenseServer);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.LicenseServer.toString() + " failed");
                    return;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.LicenseServer.toString() + ":");
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseServerClass.serverActive + ", " + licenseServerClass.installationId);
                for (int i = 0; i < 3; ++i) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  " + licenseServerClass.licenseServerList[i].server + ", " + licenseServerClass.licenseServerList[i].port + ", " + licenseServerClass.licenseServerList[i].serverStandby + ", " + licenseServerClass.licenseServerList[i].portStandby);
                }
                this.getTextFieldInstallationId().setText(String.valueOf(licenseServerClass.installationId));
                break;
            }
            case Limits: {
                CommonDataHandler.LimitsClass limitsClass = null;
                try {
                    limitsClass = (CommonDataHandler.LimitsClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.Limits);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.name());
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.Limits.name() + " failed");
                    return;
                }
                this.currentLimits = limitsClass;
                this.setLatencyPeriodTrend();
                break;
            }
        }
    }

    @Override
    public void processRfpSummaryNotification(RfpSummaryHandler.RfpSummaryClass rfpSummaryClass) {
        this.getTextFieldRfpNumCurrent().setText(String.valueOf(rfpSummaryClass.nRFPs));
    }

    @Override
    public void processRfpSummaryErrorNotification(OmiMessage omiMessage) {
    }

    @Override
    public void processPpUserSummaryNotification(PpUserSummaryHandler.PpUserSummaryClass ppUserSummaryClass) {
        this.getTextFieldPpUserNumLocatingCurrent().setText(String.valueOf(ppUserSummaryClass.nLocatable));
    }

    @Override
    public void processPpUserSummaryErrorNotification(OmiMessage omiMessage) {
    }

    private final class LicenseTabbedPane
    extends GuiUtilTabbedPane {
        private static final long serialVersionUID = 1L;

        private LicenseTabbedPane() {
        }

        @Override
        public void showChangeDialog() {
            new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, UtilLocale.getString("TXT_PLEASE_SAVE_OR_CANCEL_YOUR_CHANGES"), true);
        }
    }
}

