/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilElementCollection;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;

public class SystemPemFileImportPanel
extends AastraPanel {
    private static final long serialVersionUID = 5905600244051141145L;
    private SystemPemFileImportPanel panel = this;
    private GuiUtilComboBox comboBoxCertType = null;
    private String pemImportFileName = "";
    private AastraButton buttonCertImportFile = null;
    private AastraButton buttonCertImport = null;
    private GuiUtilTextField textFieldCertImportFile = null;
    private AastraLabel labelCertImportInfo = null;
    private GuiUtilFileChooser certImportFileChooser = null;
    PemFileStringHandlerInterface certHandler = null;

    public SystemPemFileImportPanel(int n, boolean bl, PemFileStringHandlerInterface pemFileStringHandlerInterface, String string) {
        this.certHandler = pemFileStringHandlerInterface;
        this.setLayout(null);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_PEM_FILE_IMPORT"));
        titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
        this.setBorder(titledBorder);
        this.setPreferredSize(new Dimension(n - 20, 150));
        this.setMaximumSize(new Dimension(n - 20, 150));
        this.setMinimumSize(new Dimension(n - 20, 150));
        this.setAlignmentX(0.0f);
        GuiUtilElementCollection.setChangeHandler(null);
        GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_IMPORT_PEM_FILE_WITH"), 30, 170, GuiUtilComboBox.class, 210, 220);
        OmiMessage.PEMCertificateListType.trustedCertificates.setTranslatedString(UtilLocale.getString("TXT_TRUSTED_CERTIFICATES"));
        OmiMessage.PEMCertificateListType.localCertificates.setTranslatedString(UtilLocale.getString("TXT_LOCAL_CERTIFICATE_CHAIN"));
        OmiMessage.PEMCertificateListType.privateKey.setTranslatedString(UtilLocale.getString("TXT_PRIVATE_KEY"));
        this.comboBoxCertType = guiElement.getComboBox();
        for (int i = 0; i < OmiMessage.PEMCertificateListType.values().length; ++i) {
            if (bl) {
                if (OmiMessage.PEMCertificateListType.values()[i] == OmiMessage.PEMCertificateListType.trustedCertificates) continue;
                this.comboBoxCertType.addItem(OmiMessage.PEMCertificateListType.values()[i].getTranslatedString());
                continue;
            }
            this.comboBoxCertType.addItem(OmiMessage.PEMCertificateListType.values()[i].getTranslatedString());
        }
        this.comboBoxCertType.activateActionListener();
        this.comboBoxCertType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SystemPemFileImportPanel.this.textFieldCertImportFile.getText().length() > 0) {
                    SystemPemFileImportPanel.this.buttonCertImport.setEnabled(true);
                } else {
                    SystemPemFileImportPanel.this.buttonCertImport.setEnabled(false);
                }
            }
        });
        GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(null, 0, 0, GuiUtilTextField.class, 210, 400);
        this.textFieldCertImportFile = guiElement2.getTextField();
        this.textFieldCertImportFile.setText(this.pemImportFileName);
        this.textFieldCertImportFile.setEditable(false);
        GuiUtilElementCollection.GuiElement guiElement3 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_FILE"), 0, 0, AastraButton.class, 30, 106);
        this.buttonCertImportFile = guiElement3.getButton();
        this.buttonCertImportFile.setToolTipText(UtilLocale.getString("TXT_SELECT_PEM_FILE_TO_IMPORT"));
        this.buttonCertImportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                if (SystemPemFileImportPanel.this.certImportFileChooser == null) {
                    SystemPemFileImportPanel.this.certImportFileChooser = new GuiUtilFileChooser(SystemPemFileImportPanel.this.panel);
                }
                if ((file = SystemPemFileImportPanel.this.certImportFileChooser.fileChooser()) != null) {
                    SystemPemFileImportPanel.this.pemImportFileName = file.getAbsolutePath();
                    SystemPemFileImportPanel.this.buttonCertImport.setEnabled(true);
                } else {
                    SystemPemFileImportPanel.this.pemImportFileName = null;
                    SystemPemFileImportPanel.this.buttonCertImport.setEnabled(false);
                }
                SystemPemFileImportPanel.this.textFieldCertImportFile.setText(SystemPemFileImportPanel.this.pemImportFileName);
            }
        });
        GuiUtilElementCollection.GuiElement guiElement4 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_IMPORT_20"), 0, 0, AastraButton.class, 210, 106);
        guiElement4.newLine = true;
        this.buttonCertImport = guiElement4.getButton();
        this.buttonCertImport.setEnabled(false);
        this.buttonCertImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemPemFileImportPanel.this.buttonCertImport.setEnabled(false);
                String string = (String)SystemPemFileImportPanel.this.comboBoxCertType.getSelectedItem();
                SystemPemFileImportPanel.this.readPemFile(SystemPemFileImportPanel.this.textFieldCertImportFile.getText(), OmiMessage.PEMCertificateListType.getValFromTxt(string));
            }
        });
        GuiUtilElementCollection.GuiElement guiElement5 = new GuiUtilElementCollection.GuiElement("<html>" + String.format(UtilLocale.getString("TXT_CERTIFICATE_IMPORT_INFO_*"), string) + "</html>", 340, 420, null, 0, 0);
        guiElement5.labelYSize = 46;
        this.labelCertImportInfo = guiElement5.getLabel();
        this.labelCertImportInfo.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
        GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
        guiUtilElementCollection.addElement(guiElement);
        guiUtilElementCollection.addElement(guiElement3);
        guiUtilElementCollection.addElement(guiElement2);
        guiUtilElementCollection.addElement(guiElement4);
        guiUtilElementCollection.addElement(guiElement5);
        guiUtilElementCollection.addToPanel(this);
    }

    private boolean readPemFile(String string, OmiMessage.PEMCertificateListType pEMCertificateListType) {
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            String string2 = "";
            String string3 = bufferedReader.readLine();
            byte[] byArray = new byte[]{10};
            String string4 = new String(byArray);
            boolean bl = false;
            boolean bl2 = false;
            this.certHandler.certInit();
            while (string3 != null && !bl2) {
                switch (n) {
                    case 0: {
                        if (!string3.startsWith("-----BEGIN")) break;
                        if (string3.contains("PRIVATE KEY")) {
                            bl = true;
                        }
                        n = 1;
                        string2 = string2 + string3 + string4;
                        break;
                    }
                    case 1: {
                        string2 = string2 + string3 + string4;
                        if (!string3.startsWith("-----END")) break;
                        n = 0;
                        if (bl && pEMCertificateListType == OmiMessage.PEMCertificateListType.privateKey) {
                            if (this.certHandler != null) {
                                this.certHandler.addCertifcate(OmiMessage.PEMCertificateListType.privateKey, string2);
                            }
                            bl2 = true;
                        } else if (this.certHandler != null) {
                            this.certHandler.addCertifcate(pEMCertificateListType, string2);
                        }
                        bl = false;
                        string2 = "";
                    }
                }
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (this.certHandler != null) {
                this.certHandler.sendCertificates();
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return false;
    }

    public void setActive(boolean bl) {
        this.comboBoxCertType.setEnabled(bl);
        this.buttonCertImportFile.setEnabled(bl);
        if (bl && this.pemImportFileName != null) {
            this.buttonCertImport.setEnabled(true);
        } else {
            this.buttonCertImport.setEnabled(false);
        }
        this.labelCertImportInfo.setVisible(!bl);
    }

    public static interface PemFileStringHandlerInterface {
        public void certInit();

        public void addCertifcate(OmiMessage.PEMCertificateListType var1, String var2);

        public void sendCertificates();
    }
}

