/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilElementCollection;
import com.aastra.oamp.guiutil.GuiUtilPasswordFieldNew;
import com.aastra.oamp.guiutil.GuiUtilTabbedPane;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.system.SystemCertificateNumberPanel;
import com.aastra.oamp.system.SystemPemFileImportPanel;
import com.aastra.oamp.system.SystemUtil;
import com.aastra.oamp.system.SystemUtilCertificateServer;
import com.aastra.oamp.system.SystemUtilUrlBorderPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

public class SystemProvisioningPanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelWidth = 800;
    private static final int panelHeight = 470;
    private static final int tabbedPaneWidth = 800;
    private static final int tabbedPaneHeight = 535;
    private CommonDataHandler commonDataHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private UtilErrorComp utilErrorComp = null;
    private SystemUtil.ToolsSystemSettings toolsSystem = null;
    private SysSetTabbedPane tabbedPaneSysSet = null;
    private boolean isEditable = true;
    private boolean changeHandlerEnable = true;
    private AastraPanel tabProvisioning = null;
    private GuiUtilButtonBar panelProvisioningButtonBar = null;
    private SystemUtilUrlBorderPanel panelConfigUrl = null;
    private GuiUtilCheckBox checkboxValidateCerts = null;
    private GuiUtilCheckBox checkboxValidateExpires = null;
    private GuiUtilCheckBox checkboxValidateHostName = null;
    private GuiUtilCheckBox checkboxAllowNonConfTrustCerts = null;
    private GuiUtilCheckBox checkboxImportCerts = null;
    private GuiUtilBorderPanel panelSSLSettings = null;
    private GuiUtilBorderPanel panelProvUpdateTrigger = null;
    private GuiUtilCheckBox checkBoxProvUpdateTriggerActive = null;
    private GuiUtilTextField textFieldProvUpdateTriggerHour = null;
    private GuiUtilTextField textFieldProvUpdateTriggerMinute = null;
    private GuiUtilComboBox comboBoxUrlSslType = null;
    private AastraPanel tabUsedConfigSettings = null;
    private SystemUtilUrlBorderPanel panelUsedConfigUrl = null;
    private GuiUtilBorderPanel panelUsedConfigSSLSettings = null;
    private GuiUtilCheckBox checkboxUsedConfigValidateCerts = null;
    private GuiUtilCheckBox checkboxUsedConfigValidateExpires = null;
    private GuiUtilCheckBox checkboxUsedConfigValidateHostName = null;
    private GuiUtilCheckBox checkboxUsedConfigAllowNonConfTrustCerts = null;
    private GuiUtilCheckBox checkboxUsedConfigImportCerts = null;
    private GuiUtilComboBox comboBoxUsedConfigUrlSslType = null;
    private AastraPanel tabSystemCredentials = null;
    private GuiUtilButtonBar panelSystemCredentialsButtonBar = null;
    private UtilErrorComp utilErrorCompSystemCredentials = null;
    private GuiUtilBorderPanel panelSystemCredentials = null;
    private GuiUtilTextField textFieldSysCredUserName = null;
    private GuiUtilPasswordFieldNew passwordFieldSysCredPassword = null;
    private GuiUtilPasswordFieldNew passwordFieldSysCredPasswordConfirm = null;
    private AastraPanel tabProvisioningCertificates = null;
    private SystemCertificateNumberPanel panelCertsKey = null;
    private PrivateKeyInputPanel panelProvKeyPassword = null;
    private SystemPemFileImportPanel systemPemFileImportPanel = null;
    private SystemUtilCertificateServer tabCertificateServer = null;

    public SystemProvisioningPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.ConfigUrl, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig, this);
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.UsedConfigUrl, this);
        if (this.isEditable) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer, this);
        }
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.initialize();
        if (this.isEditable) {
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.ParkServerResult, this);
        }
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(800, 470));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
            this.toolsSystem = new SystemUtil.ToolsSystemSettings(this.utilErrorComp);
        } else {
            this.isEditable = false;
        }
        this.add(this.getTabbedPaneSysSet());
    }

    private GuiUtilButtonBar getPanelProvisioningButtonBar() {
        if (this.panelProvisioningButtonBar == null) {
            this.panelProvisioningButtonBar = new GuiUtilButtonBar(800, false, false, this.tabbedPaneSysSet);
            this.panelProvisioningButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemProvisioningPanel)SystemProvisioningPanel.this).panelProvisioningButtonBar.utilChangeHandler.deactivate();
                    SystemProvisioningPanel.this.utilErrorComp.clearComponents();
                    SystemProvisioningPanel.this.changeProvisioning();
                }
            });
            this.panelProvisioningButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemProvisioningPanel)SystemProvisioningPanel.this).panelProvisioningButtonBar.utilChangeHandler.deactivate();
                    SystemProvisioningPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.ConfigUrl);
                    SystemProvisioningPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig);
                    SystemProvisioningPanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelProvisioningButtonBar;
    }

    private SysSetTabbedPane getTabbedPaneSysSet() {
        if (this.tabbedPaneSysSet == null) {
            this.tabbedPaneSysSet = new SysSetTabbedPane();
            this.tabbedPaneSysSet.setPreferredSize(new Dimension(800, 535));
            this.tabbedPaneSysSet.setMaximumSize(new Dimension(800, 535));
            this.tabbedPaneSysSet.setAlignmentX(0.0f);
            this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_PROVISIONING"), null, this.getTabProvisioning(), null);
            if (!this.isEditable) {
                this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_CURRENT_CONFIGURATION_FILES_SETTINGS"), null, this.getTabUsedConfigSettings(), null);
            }
            this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_PROVISIONING_CERTIFICATES"), null, this.getTabProvisioningCertificates(), null);
            this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_CERTIFICATE_SERVER"), null, this.getTabCertificateServer(), null);
            if (this.isEditable) {
                this.tabbedPaneSysSet.addTab(UtilLocale.getString("TXT_SYSTEM_CREDENTIALS"), null, this.getTabSystemCredentials(), null);
            }
        }
        return this.tabbedPaneSysSet;
    }

    private AastraPanel getTabProvisioning() {
        if (this.tabProvisioning == null) {
            this.tabProvisioning = new AastraPanel();
            this.tabProvisioning.setLayout(new BoxLayout(this.tabProvisioning, 1));
            this.getPanelProvisioningButtonBar();
            this.tabProvisioning.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabProvisioning.add(this.getPanelConfigUrl());
            this.tabProvisioning.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabProvisioning.add(this.getPanelSSLSettings());
            this.tabProvisioning.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabProvisioning.add(this.getPanelProvUpdateTrigger());
            if (this.isEditable) {
                this.tabProvisioning.add(this.panelProvisioningButtonBar);
            }
        }
        return this.tabProvisioning;
    }

    private AastraPanel getTabProvisioningCertificates() {
        if (this.tabProvisioningCertificates == null) {
            this.tabProvisioningCertificates = new AastraPanel();
            this.tabProvisioningCertificates.setLayout(new BoxLayout(this.tabProvisioningCertificates, 1));
            this.tabProvisioningCertificates.add(Box.createRigidArea(new Dimension(0, 10)));
            this.panelCertsKey = new SystemCertificateNumberPanel(800, false, this.isEditable);
            if (this.isEditable) {
                this.panelCertsKey.buttonSecurityDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_CERTIFICATES_AND_PRIVATE_KEY_?"), true);
                        if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                            CommonDataHandler.UrlClass urlClass = new CommonDataHandler.UrlClass();
                            urlClass.addCertificate(OmiMessage.PEMCertificateListType.localCertificates, "");
                            urlClass.addCertificate(OmiMessage.PEMCertificateListType.trustedCertificates, "");
                            urlClass.addCertificate(OmiMessage.PEMCertificateListType.privateKey, "");
                            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetConfigURL);
                            urlClass.addUrlToMsg(omiMessage);
                            GuiMain.getOmiManagementObject().getOmiHandler().sendOmiMessage(omiMessage);
                        }
                    }
                });
            }
            this.tabProvisioningCertificates.add(this.panelCertsKey);
            if (this.isEditable) {
                this.tabProvisioningCertificates.add(Box.createRigidArea(new Dimension(0, 10)));
                class PemFileDataHandler
                implements SystemPemFileImportPanel.PemFileStringHandlerInterface {
                    CommonDataHandler.UrlClass url = null;

                    PemFileDataHandler() {
                    }

                    @Override
                    public void certInit() {
                        this.url = null;
                    }

                    @Override
                    public void addCertifcate(OmiMessage.PEMCertificateListType pEMCertificateListType, String string) {
                        if (this.url == null) {
                            this.url = new CommonDataHandler.UrlClass();
                        }
                        this.url.addCertificate(pEMCertificateListType, string);
                    }

                    @Override
                    public void sendCertificates() {
                        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetConfigURL);
                        this.url.addUrlToMsg(omiMessage);
                        GuiMain.getOmiManagementObject().getOmiHandler().sendOmiMessage(omiMessage);
                    }
                }
                this.systemPemFileImportPanel = new SystemPemFileImportPanel(800, false, new PemFileDataHandler(), UtilLocale.getString("TXT_CERTIFICATE_SERVER"));
                this.tabProvisioningCertificates.add(this.systemPemFileImportPanel);
                this.tabProvisioningCertificates.add(Box.createRigidArea(new Dimension(0, 10)));
                class PasswordChangeHandler
                implements ChangePrivateKeyInterface {
                    PasswordChangeHandler() {
                    }

                    @Override
                    public void changePrivateKey(String string) {
                        CommonDataHandler.UrlClass urlClass = new CommonDataHandler.UrlClass();
                        urlClass.setAndEncryptPrivateKeyPassword(string);
                        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetConfigURL);
                        urlClass.addUrlToMsg(omiMessage);
                        GuiMain.getOmiManagementObject().getOmiHandler().sendOmiMessage(omiMessage);
                    }
                }
                this.panelProvKeyPassword = new PrivateKeyInputPanel(new PasswordChangeHandler(), this.utilErrorComp);
                this.tabProvisioningCertificates.add(this.panelProvKeyPassword);
            }
        }
        return this.tabProvisioningCertificates;
    }

    private void updateProvCertificatePanel(boolean bl) {
        this.panelCertsKey.buttonSecurityDelete.setEnabled(!bl);
        if (this.systemPemFileImportPanel != null) {
            this.systemPemFileImportPanel.setActive(!bl);
        }
    }

    private SystemUtilUrlBorderPanel getPanelConfigUrl() {
        if (this.panelConfigUrl == null) {
            int n = 8295;
            if (this.isEditable) {
                n |= 0x200;
            }
            this.panelConfigUrl = new SystemUtilUrlBorderPanel(UtilLocale.getString("TXT_CONFIGURATION_FILES_URL"), this.panelProvisioningButtonBar, this.utilErrorComp, this.isEditable, n, null, null, true, null, 235);
            this.panelConfigUrl.setFileName("/ipdect.cfg, /<MAC>.cfg, /<PARK>.cfg ...");
            this.panelConfigUrl.setFileNameWidth(300);
            this.panelConfigUrl.setActiveHintText("<html>" + UtilLocale.getString("TXT_HINT_USER_LOGOUT") + "</html>");
        }
        return this.panelConfigUrl;
    }

    private GuiUtilBorderPanel getPanelSSLSettings() {
        if (this.panelSSLSettings == null) {
            this.panelSSLSettings = new GuiUtilBorderPanel(65, UtilLocale.getString("TXT_SSL_SETTINGS"));
            GuiUtilElementCollection.setChangeHandler(this.panelProvisioningButtonBar.utilChangeHandler);
            int n = 230;
            int n2 = 300;
            GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_CERTIFICATES"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxValidateCerts = guiElement.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_ALLOW_UNCONF_TRUSTED_CERTS"), n + 100, n2, GuiUtilCheckBox.class, n + 100 + n2 + 5, 45);
            this.checkboxAllowNonConfTrustCerts = guiElement2.getCheckBox();
            if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
                this.checkboxAllowNonConfTrustCerts.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SystemProvisioningPanel.this.checkboxAllowNonConfTrustCerts.isSelected()) {
                            SystemProvisioningPanel.this.checkboxImportCerts.setEnabled(true);
                        } else {
                            SystemProvisioningPanel.this.checkboxImportCerts.setEnabled(false);
                            SystemProvisioningPanel.this.checkboxImportCerts.setSelected(false);
                        }
                    }
                });
            }
            GuiUtilElementCollection.GuiElement guiElement3 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_EXPIRES"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxValidateExpires = guiElement3.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement4 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_IMPORT_CERTIFICATES"), n + 100, n2, GuiUtilCheckBox.class, n + 100 + n2 + 5, 45);
            this.checkboxImportCerts = guiElement4.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement5 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_HOST_NAME"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxValidateHostName = guiElement5.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement6 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_SSL_METHOD"), n + 100, n2, GuiUtilComboBox.class, n + 100 + n2 + 10, 90);
            this.comboBoxUrlSslType = guiElement6.getComboBox();
            for (OmiMessage.SslMethodType sslMethodType : OmiMessage.SslMethodType.values()) {
                this.comboBoxUrlSslType.addItem(sslMethodType);
            }
            if (this.isEditable) {
                this.comboBoxUrlSslType.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (SystemProvisioningPanel.this.changeHandlerEnable) {
                            ((SystemProvisioningPanel)SystemProvisioningPanel.this).panelProvisioningButtonBar.utilChangeHandler.activate();
                        }
                    }
                });
                this.utilErrorComp.put(OmiMessage.URLType.sslMethod.name(), guiElement6.label, guiElement6.elem, this.panelProvisioningButtonBar);
            }
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement);
            guiUtilElementCollection.addElement(guiElement2);
            guiUtilElementCollection.addElement(guiElement3);
            guiUtilElementCollection.addElement(guiElement4);
            guiUtilElementCollection.addElement(guiElement5);
            guiUtilElementCollection.addElement(guiElement6);
            int n3 = guiUtilElementCollection.addToPanel(this.panelSSLSettings);
            this.panelSSLSettings.setYSize(n3 + 30);
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.panelSSLSettings);
            }
        }
        return this.panelSSLSettings;
    }

    private AastraPanel getTabUsedConfigSettings() {
        if (this.tabUsedConfigSettings == null) {
            this.tabUsedConfigSettings = new AastraPanel();
            this.tabUsedConfigSettings.setLayout(new BoxLayout(this.tabUsedConfigSettings, 1));
            this.tabUsedConfigSettings.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabUsedConfigSettings.add(this.getPanelUsedConfigUrl());
            this.tabUsedConfigSettings.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabUsedConfigSettings.add(this.getPanelUsedConfigSSLSettings());
        }
        return this.tabUsedConfigSettings;
    }

    private SystemUtilUrlBorderPanel getPanelUsedConfigUrl() {
        if (this.panelUsedConfigUrl == null) {
            this.panelUsedConfigUrl = new SystemUtilUrlBorderPanel(UtilLocale.getString("TXT_CONFIGURATION_FILES_URL"), 110);
        }
        return this.panelUsedConfigUrl;
    }

    private GuiUtilBorderPanel getPanelUsedConfigSSLSettings() {
        if (this.panelUsedConfigSSLSettings == null) {
            this.panelUsedConfigSSLSettings = new GuiUtilBorderPanel(65, UtilLocale.getString("TXT_SSL_SETTINGS"));
            int n = 230;
            int n2 = 300;
            GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_CERTIFICATES"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxUsedConfigValidateCerts = guiElement.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_ALLOW_UNCONF_TRUSTED_CERTS"), n + 100, n2, GuiUtilCheckBox.class, n + 100 + n2 + 5, 45);
            this.checkboxUsedConfigAllowNonConfTrustCerts = guiElement2.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement3 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_EXPIRES"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxUsedConfigValidateExpires = guiElement3.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement4 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_IMPORT_CERTIFICATES"), n + 100, n2, GuiUtilCheckBox.class, n + 100 + n2 + 5, 45);
            this.checkboxUsedConfigImportCerts = guiElement4.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement5 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_VALIDATE_HOST_NAME"), SystemUtilUrlBorderPanel.DEF_XPOS, 150, GuiUtilCheckBox.class, n, 45);
            this.checkboxUsedConfigValidateHostName = guiElement5.getCheckBox();
            GuiUtilElementCollection.GuiElement guiElement6 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_SSL_METHOD"), n + 100, n2, GuiUtilComboBox.class, n + 100 + n2 + 10, 90);
            this.comboBoxUsedConfigUrlSslType = guiElement6.getComboBox();
            for (OmiMessage.SslMethodType sslMethodType : OmiMessage.SslMethodType.values()) {
                this.comboBoxUsedConfigUrlSslType.addItem(sslMethodType);
            }
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement);
            guiUtilElementCollection.addElement(guiElement2);
            guiUtilElementCollection.addElement(guiElement3);
            guiUtilElementCollection.addElement(guiElement4);
            guiUtilElementCollection.addElement(guiElement5);
            guiUtilElementCollection.addElement(guiElement6);
            int n3 = guiUtilElementCollection.addToPanel(this.panelUsedConfigSSLSettings);
            this.panelUsedConfigSSLSettings.setYSize(n3 + 30);
            UtilSetPanelEditable.setDisabled(this.panelUsedConfigSSLSettings);
        }
        return this.panelUsedConfigSSLSettings;
    }

    private AastraPanel getTabSystemCredentials() {
        if (this.tabSystemCredentials == null) {
            this.tabSystemCredentials = new AastraPanel();
            this.tabSystemCredentials.setLayout(new BoxLayout(this.tabSystemCredentials, 1));
            this.tabSystemCredentials.add(Box.createRigidArea(new Dimension(0, 10)));
            if (this.isEditable) {
                this.utilErrorCompSystemCredentials = new UtilErrorComp();
                this.getPanelSystemCredentialsButtonBar();
                this.tabSystemCredentials.add(Box.createRigidArea(new Dimension(0, 10)));
                this.tabSystemCredentials.add(this.getPanelSystemCredentials());
                this.tabSystemCredentials.add(this.panelSystemCredentialsButtonBar);
            }
        }
        return this.tabSystemCredentials;
    }

    private GuiUtilButtonBar getPanelSystemCredentialsButtonBar() {
        if (this.panelSystemCredentialsButtonBar == null) {
            this.panelSystemCredentialsButtonBar = new GuiUtilButtonBar(800, false, false, this.tabbedPaneSysSet);
            this.panelSystemCredentialsButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemProvisioningPanel)SystemProvisioningPanel.this).panelSystemCredentialsButtonBar.utilChangeHandler.deactivate();
                    SystemProvisioningPanel.this.utilErrorCompSystemCredentials.clearComponents();
                    SystemProvisioningPanel.this.changeSystemCredentials();
                }
            });
            this.panelSystemCredentialsButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemProvisioningPanel)SystemProvisioningPanel.this).panelSystemCredentialsButtonBar.utilChangeHandler.deactivate();
                    SystemProvisioningPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SystemCredentials);
                    SystemProvisioningPanel.this.utilErrorCompSystemCredentials.clearComponents();
                }
            });
        }
        return this.panelSystemCredentialsButtonBar;
    }

    private GuiUtilBorderPanel getPanelSystemCredentials() {
        if (this.panelSystemCredentials == null) {
            AastraLabel aastraLabel = null;
            AastraLabel aastraLabel2 = null;
            int n = 30;
            int n2 = this.isEditable ? 125 : 65;
            class CDNotificationHandlerSC
            implements CommonDataHandler.CommonDataNotificationInterface {
                CDNotificationHandlerSC() {
                }

                @Override
                public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
                    try {
                        CommonDataHandler.SystemCredentialsClass systemCredentialsClass = (CommonDataHandler.SystemCredentialsClass)SystemProvisioningPanel.this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SystemCredentials);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemCredentials.name());
                        if (SystemProvisioningPanel.this.panelSystemCredentials != null) {
                            SystemProvisioningPanel.this.textFieldSysCredUserName.setText(systemCredentialsClass.username);
                            SystemProvisioningPanel.this.passwordFieldSysCredPassword.setInitial();
                            SystemProvisioningPanel.this.passwordFieldSysCredPasswordConfirm.setInitial();
                        }
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemCredentials.name() + " failed");
                    }
                }

                @Override
                public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
                    String string = SystemProvisioningPanel.this.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, SystemProvisioningPanel.this.utilErrorCompSystemCredentials);
                    if (string != null && string.equals(OmiMessage.URLType.password.name())) {
                        SystemProvisioningPanel.this.utilErrorCompSystemCredentials.markComponent(SystemProvisioningPanel.this.passwordFieldSysCredPasswordConfirm);
                    }
                }
            }
            this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SystemCredentials, new CDNotificationHandlerSC());
            this.panelSystemCredentials = new GuiUtilBorderPanel(n2, UtilLocale.getString("TXT_SYSTEM_CREDENTIALS"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, n, 150, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.panelSystemCredentials.add(aastraLabel3);
            this.panelSystemCredentials.add(this.getTextFieldSysCredUserName(n));
            if (this.isEditable) {
                aastraLabel = new AastraLabel();
                aastraLabel.setBounds(30, n += 30, 150, 16);
                aastraLabel.setText(UtilLocale.getString("TXT_PASSWORD"));
                this.panelSystemCredentials.add(aastraLabel);
                this.panelSystemCredentials.add(this.getPasswordFieldSysCredPassword(n));
                aastraLabel2 = new AastraLabel();
                aastraLabel2.setBounds(30, n += 30, 150, 36);
                aastraLabel2.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
                this.panelSystemCredentials.add(aastraLabel2);
                this.panelSystemCredentials.add(this.getPasswordFieldSysCredPasswordConfirm(n));
            }
            if (this.isEditable) {
                this.utilErrorCompSystemCredentials.put(OmiMessage.attribIds.username.name(), aastraLabel3, this.textFieldSysCredUserName, this.panelSystemCredentialsButtonBar);
                this.utilErrorCompSystemCredentials.put(OmiMessage.attribIds.password.name(), aastraLabel, this.passwordFieldSysCredPassword, this.panelSystemCredentialsButtonBar);
                this.utilErrorCompSystemCredentials.put("PwConfirm", aastraLabel2, this.passwordFieldSysCredPasswordConfirm, this.panelSystemCredentialsButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelSystemCredentials);
            }
        }
        return this.panelSystemCredentials;
    }

    private GuiUtilTextField getTextFieldSysCredUserName(int n) {
        if (this.textFieldSysCredUserName == null) {
            this.textFieldSysCredUserName = new GuiUtilTextField(this.panelSystemCredentialsButtonBar.utilChangeHandler);
            this.textFieldSysCredUserName.setBounds(185, 30, 400, 18);
        }
        return this.textFieldSysCredUserName;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldSysCredPassword(int n) {
        if (this.passwordFieldSysCredPassword == null) {
            this.passwordFieldSysCredPassword = new GuiUtilPasswordFieldNew(this.panelSystemCredentialsButtonBar.utilChangeHandler);
            this.passwordFieldSysCredPassword.setBounds(185, 60, 240, 18);
        }
        return this.passwordFieldSysCredPassword;
    }

    private GuiUtilPasswordFieldNew getPasswordFieldSysCredPasswordConfirm(int n) {
        if (this.passwordFieldSysCredPasswordConfirm == null) {
            this.passwordFieldSysCredPasswordConfirm = new GuiUtilPasswordFieldNew(this.panelSystemCredentialsButtonBar.utilChangeHandler);
            this.passwordFieldSysCredPasswordConfirm.setBounds(185, 90, 240, 18);
        }
        return this.passwordFieldSysCredPasswordConfirm;
    }

    private GuiUtilBorderPanel getPanelProvUpdateTrigger() {
        if (this.panelProvUpdateTrigger == null) {
            this.panelProvUpdateTrigger = new GuiUtilBorderPanel(95, UtilLocale.getString("TXT_UPDATE_TRIGGER"));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 150, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_ACTIVE"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 60, 150, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_UPDATE_TIME"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setText(":");
            aastraLabel3.setBounds(263, 60, 10, 16);
            this.panelProvUpdateTrigger.add(aastraLabel);
            this.panelProvUpdateTrigger.add(this.getCheckBoxProvUpdateTriggerActive());
            this.panelProvUpdateTrigger.add(aastraLabel2);
            this.panelProvUpdateTrigger.add(this.getTextFieldProvUpdateTriggerHour());
            this.panelProvUpdateTrigger.add(aastraLabel3);
            this.panelProvUpdateTrigger.add(this.getTextFieldProvUpdateTriggerMinute());
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.hour.name(), aastraLabel2, this.textFieldProvUpdateTriggerHour, this.panelProvisioningButtonBar);
                this.utilErrorComp.put(OmiMessage.attribIds.min.name(), aastraLabel2, this.textFieldProvUpdateTriggerMinute, this.panelProvisioningButtonBar);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelProvUpdateTrigger);
            }
        }
        return this.panelProvUpdateTrigger;
    }

    private GuiUtilCheckBox getCheckBoxProvUpdateTriggerActive() {
        if (this.checkBoxProvUpdateTriggerActive == null) {
            this.checkBoxProvUpdateTriggerActive = new GuiUtilCheckBox(this.panelProvisioningButtonBar.utilChangeHandler, 230, 30);
        }
        return this.checkBoxProvUpdateTriggerActive;
    }

    private GuiUtilTextField getTextFieldProvUpdateTriggerHour() {
        if (this.textFieldProvUpdateTriggerHour == null) {
            this.textFieldProvUpdateTriggerHour = new GuiUtilTextField(this.panelProvisioningButtonBar.utilChangeHandler);
            this.textFieldProvUpdateTriggerHour.setBounds(235, 60, 25, 18);
            this.textFieldProvUpdateTriggerHour.setHorizontalAlignment(4);
            this.textFieldProvUpdateTriggerHour.setToolTipText(UtilLocale.getString("TXT_HOUR_HELP"));
        }
        return this.textFieldProvUpdateTriggerHour;
    }

    private GuiUtilTextField getTextFieldProvUpdateTriggerMinute() {
        if (this.textFieldProvUpdateTriggerMinute == null) {
            this.textFieldProvUpdateTriggerMinute = new GuiUtilTextField(this.panelProvisioningButtonBar.utilChangeHandler);
            this.textFieldProvUpdateTriggerMinute.setBounds(270, 60, 25, 18);
            this.textFieldProvUpdateTriggerMinute.setHorizontalAlignment(4);
            this.textFieldProvUpdateTriggerMinute.setToolTipText(UtilLocale.getString("TXT_MINUTE"));
        }
        return this.textFieldProvUpdateTriggerMinute;
    }

    private SystemUtilCertificateServer getTabCertificateServer() {
        if (this.tabCertificateServer == null) {
            this.tabCertificateServer = new SystemUtilCertificateServer(CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer, this.commonDataHandler, this.tabbedPaneSysSet, this.isEditable);
        }
        return this.tabCertificateServer;
    }

    private void changeProvisioning() {
        boolean bl = true;
        CommonDataHandler.UrlClass urlClass = this.panelConfigUrl.getUrl();
        if (urlClass == null) {
            bl = false;
        } else {
            urlClass.sslMethod = (OmiMessage.SslMethodType)((Object)this.comboBoxUrlSslType.getSelectedItem());
            urlClass.validateCert = this.checkboxValidateCerts.isSelected();
            urlClass.validateExpires = this.checkboxValidateExpires.isSelected();
            urlClass.validateHostName = this.checkboxValidateHostName.isSelected();
            urlClass.allowNonConfTrustCerts = this.checkboxAllowNonConfTrustCerts.isSelected();
            urlClass.importCerts = this.checkboxImportCerts.isSelected();
        }
        CommonDataHandler.SystemProvUpdTrigClass systemProvUpdTrigClass = new CommonDataHandler.SystemProvUpdTrigClass();
        systemProvUpdTrigClass.enable = this.checkBoxProvUpdateTriggerActive.isSelected();
        systemProvUpdTrigClass.hour = this.toolsSystem.getHourFromTextField(this.textFieldProvUpdateTriggerHour, UtilLocale.getString("TXT_HOUR"));
        if (systemProvUpdTrigClass.hour == -1) {
            bl = false;
        }
        if ((systemProvUpdTrigClass.min = this.toolsSystem.getMinuteFromTextField(this.textFieldProvUpdateTriggerMinute, UtilLocale.getString("TXT_MINUTE"))) == -1) {
            bl = false;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.ConfigUrl));
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.ConfigUrl, urlClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.ConfigUrl);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig));
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig, systemProvUpdTrigClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig);
        } else {
            this.panelProvisioningButtonBar.utilChangeHandler.activateOnError();
        }
    }

    private void changeSystemCredentials() {
        boolean bl = true;
        CommonDataHandler.SystemCredentialsClass systemCredentialsClass = new CommonDataHandler.SystemCredentialsClass();
        systemCredentialsClass.username = this.textFieldSysCredUserName.getText();
        if (this.passwordFieldSysCredPassword.isChanged() || this.passwordFieldSysCredPasswordConfirm.isChanged()) {
            String string = new String(this.passwordFieldSysCredPassword.getPassword());
            String string2 = new String(this.passwordFieldSysCredPasswordConfirm.getPassword());
            if (this.passwordFieldSysCredPassword.isChanged() && this.passwordFieldSysCredPasswordConfirm.isChanged() && string.equals(string2)) {
                systemCredentialsClass.password = string;
            } else {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                this.utilErrorCompSystemCredentials.markComponent(this.passwordFieldSysCredPassword);
                this.utilErrorCompSystemCredentials.markComponent(this.passwordFieldSysCredPasswordConfirm);
                this.passwordFieldSysCredPassword.setInitial();
                this.passwordFieldSysCredPasswordConfirm.setInitial();
                bl = false;
            }
        } else {
            systemCredentialsClass.password = null;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + (Object)((Object)CommonDataHandler.CommonDataItemEnum.SystemCredentials));
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SystemCredentials, systemCredentialsClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SystemCredentials);
        } else {
            this.panelSystemCredentialsButtonBar.utilChangeHandler.activateOnError();
        }
    }

    private String commonDataErrorNotificationHandler(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage, UtilErrorComp utilErrorComp) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.info.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return null;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        if (string4 != null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "   info=" + string4);
        }
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        if (string4 != null && string2.equals(OmiMessage.attribIds.text.name())) {
            if (string4.contains(OmiMessage.elemIds.bootTextHeadline.name())) {
                string2 = OmiMessage.elemIds.bootTextHeadline.name();
            } else if (string4.contains(OmiMessage.elemIds.bootTextStartup.name())) {
                string2 = OmiMessage.elemIds.bootTextStartup.name();
            }
        }
        String string5 = null;
        if (string2 != null) {
            string5 = utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        GuiUtilButtonBar guiUtilButtonBar = null;
        if (string2 != null) {
            if (string2.equals(OmiMessage.attribIds.timeout.name())) {
                return null;
            }
            jComponent = utilErrorComp.getField(string2);
            if (jComponent != null) {
                utilErrorComp.markComponent(jComponent);
            }
            if ((guiUtilButtonBar = utilErrorComp.getButtonBar(string2)) != null) {
                guiUtilButtonBar.utilChangeHandler.activateOnError();
            }
        }
        return string2;
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer) {
            return;
        }
        String string = this.commonDataErrorNotificationHandler(dataNotificationEnum, commonDataItemEnum, omiMessage, this.utilErrorComp);
        if (string != null) {
            if (string.equals(OmiMessage.elemIds.url.name() + OmiMessage.URLType.password.name())) {
                this.utilErrorComp.markComponent(this.panelConfigUrl.passwordFieldUrlPasswordConfirm);
            }
            if (string.equals(OmiMessage.URLType.privateKeyPassword.name()) && this.panelProvKeyPassword != null) {
                this.utilErrorComp.markComponent(this.panelProvKeyPassword.passwordFieldConfirm);
                this.panelProvKeyPassword.activateOnError();
            }
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        switch (commonDataItemEnum) {
            case ConfigUrl: {
                try {
                    CommonDataHandler.UrlClass urlClass = (CommonDataHandler.UrlClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.ConfigUrl);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ConfigUrl.name());
                    if (urlClass == null) break;
                    if (this.panelConfigUrl != null) {
                        this.panelConfigUrl.setUrl(urlClass);
                        if (urlClass.sslMethod != null) {
                            this.changeHandlerEnable = false;
                            this.comboBoxUrlSslType.setSelectedItem((Object)urlClass.sslMethod);
                            this.changeHandlerEnable = true;
                        }
                        if (urlClass.validateCert != null) {
                            this.checkboxValidateCerts.setSelected(urlClass.validateCert);
                        }
                        if (urlClass.validateExpires != null) {
                            this.checkboxValidateExpires.setSelected(urlClass.validateExpires);
                        }
                        if (urlClass.validateHostName != null) {
                            this.checkboxValidateHostName.setSelected(urlClass.validateHostName);
                        }
                        if (urlClass.allowNonConfTrustCerts != null) {
                            this.checkboxAllowNonConfTrustCerts.setSelected(urlClass.allowNonConfTrustCerts);
                        }
                        if (urlClass.importCerts != null) {
                            if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG && urlClass.allowNonConfTrustCerts != null && urlClass.allowNonConfTrustCerts.booleanValue()) {
                                this.checkboxImportCerts.setEnabled(true);
                                this.checkboxImportCerts.setSelected(urlClass.importCerts);
                            } else {
                                this.checkboxImportCerts.setEnabled(false);
                                this.checkboxImportCerts.setSelected(false);
                            }
                        }
                        if (this.isEditable && this.panelProvKeyPassword != null) {
                            this.panelProvKeyPassword.passwordField.setInitial();
                            this.panelProvKeyPassword.passwordFieldConfirm.setInitial();
                        }
                    }
                    if (this.panelCertsKey == null) break;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    if (urlClass.nTrustedCertificates != null) {
                        n = urlClass.nTrustedCertificates;
                    }
                    if (urlClass.nLocalCertificates != null) {
                        n2 = urlClass.nLocalCertificates;
                    }
                    if (urlClass.nPrivateKeys != null) {
                        n3 = urlClass.nPrivateKeys;
                    }
                    this.panelCertsKey.setCertValues(n, n2, n3);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.ConfigUrl.name() + " failed");
                }
                break;
            }
            case UsedConfigUrl: {
                try {
                    CommonDataHandler.UrlClass urlClass = (CommonDataHandler.UrlClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.UsedConfigUrl);
                    if (urlClass == null) break;
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.UsedConfigUrl.name());
                    if (this.panelUsedConfigUrl != null) {
                        this.panelUsedConfigUrl.setUrl(urlClass);
                    }
                    if (this.panelUsedConfigSSLSettings == null) break;
                    if (urlClass.sslMethod != null) {
                        this.comboBoxUsedConfigUrlSslType.setSelectedItem((Object)urlClass.sslMethod);
                    }
                    if (urlClass.validateCert != null) {
                        this.checkboxUsedConfigValidateCerts.setSelected(urlClass.validateCert);
                    }
                    if (urlClass.validateExpires != null) {
                        this.checkboxUsedConfigValidateExpires.setSelected(urlClass.validateExpires);
                    }
                    if (urlClass.validateHostName != null) {
                        this.checkboxUsedConfigValidateHostName.setSelected(urlClass.validateHostName);
                    }
                    if (urlClass.allowNonConfTrustCerts != null) {
                        this.checkboxUsedConfigAllowNonConfTrustCerts.setSelected(urlClass.allowNonConfTrustCerts);
                    }
                    if (urlClass.importCerts == null) break;
                    this.checkboxUsedConfigImportCerts.setSelected(urlClass.importCerts);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.UsedConfigUrl.name() + " failed");
                }
                break;
            }
            case SystemCredentials: {
                break;
            }
            case SystemProvUpdTrig: {
                try {
                    CommonDataHandler.SystemProvUpdTrigClass systemProvUpdTrigClass = (CommonDataHandler.SystemProvUpdTrigClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig);
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig.name());
                    this.getCheckBoxProvUpdateTriggerActive().setSelected(systemProvUpdTrigClass.enable);
                    this.getTextFieldProvUpdateTriggerHour().setText(String.format("%02d", systemProvUpdTrigClass.hour));
                    this.getTextFieldProvUpdateTriggerMinute().setText(String.format("%02d", systemProvUpdTrigClass.min));
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SystemProvUpdTrig.name() + " failed");
                }
                break;
            }
            case SecurePROVCertificateServer: {
                if (!this.isEditable) break;
                try {
                    CommonDataHandler.CertificateServer certificateServer = (CommonDataHandler.CertificateServer)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer);
                    this.updateProvCertificatePanel(certificateServer.url.enable);
                }
                catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SecurePROVCertificateServer.name() + " failed");
                }
                break;
            }
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (this.isEditable) {
            // empty if block
        }
    }

    @Override
    public void componentDeactivated() {
    }

    class PrivateKeyInputPanel
    extends AastraPanel {
        private static final long serialVersionUID = 1L;
        private ChangePrivateKeyInterface changeHandler;
        private GuiUtilButtonBar buttonBar = null;
        public GuiUtilPasswordFieldNew passwordField = null;
        public GuiUtilPasswordFieldNew passwordFieldConfirm = null;
        private UtilErrorComp errorComp = null;

        public PrivateKeyInputPanel(ChangePrivateKeyInterface changePrivateKeyInterface, UtilErrorComp utilErrorComp) {
            this.changeHandler = changePrivateKeyInterface;
            this.errorComp = utilErrorComp;
            this.setLayout(new BoxLayout(this, 1));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_PRIVATE_KEY_PASSWORD"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.setBorder(titledBorder);
            this.setPreferredSize(new Dimension(780, 150));
            this.setMaximumSize(new Dimension(780, 150));
            this.setMinimumSize(new Dimension(780, 150));
            this.setAlignmentX(0.0f);
            AastraPanel aastraPanel = new AastraPanel();
            aastraPanel.setLayout(null);
            aastraPanel.setPreferredSize(new Dimension(760, 70));
            aastraPanel.setMaximumSize(new Dimension(760, 70));
            aastraPanel.setMinimumSize(new Dimension(760, 70));
            aastraPanel.setAlignmentX(0.0f);
            this.buttonBar = new GuiUtilButtonBar(800, false, false, SystemProvisioningPanel.this.tabbedPaneSysSet);
            this.buttonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.deactivate();
                    PrivateKeyInputPanel.this.errorComp.clearComponents();
                    String string = new String(PrivateKeyInputPanel.this.passwordField.getPassword());
                    String string2 = new String(PrivateKeyInputPanel.this.passwordFieldConfirm.getPassword());
                    if (PrivateKeyInputPanel.this.passwordField.isChanged() && PrivateKeyInputPanel.this.passwordFieldConfirm.isChanged() && string.equals(string2)) {
                        if (PrivateKeyInputPanel.this.changeHandler != null) {
                            PrivateKeyInputPanel.this.changeHandler.changePrivateKey(string);
                        }
                    } else {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
                        PrivateKeyInputPanel.this.errorComp.markComponent(PrivateKeyInputPanel.this.passwordField);
                        PrivateKeyInputPanel.this.errorComp.markComponent(PrivateKeyInputPanel.this.passwordFieldConfirm);
                        PrivateKeyInputPanel.this.passwordField.setInitial();
                        PrivateKeyInputPanel.this.passwordFieldConfirm.setInitial();
                        ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.activateOnError();
                    }
                }
            });
            this.buttonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((PrivateKeyInputPanel)PrivateKeyInputPanel.this).buttonBar.utilChangeHandler.deactivate();
                    PrivateKeyInputPanel.this.passwordField.setInitial();
                    PrivateKeyInputPanel.this.passwordFieldConfirm.setInitial();
                    PrivateKeyInputPanel.this.errorComp.clearComponents();
                }
            });
            GuiUtilElementCollection.setChangeHandler(this.buttonBar.utilChangeHandler);
            GuiUtilElementCollection.GuiElement guiElement = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PRIVATE_KEY_PASSWORD"), 20, 180, GuiUtilPasswordFieldNew.class, 205, 240);
            guiElement.yDist = 15;
            this.passwordField = guiElement.getPasswordField();
            GuiUtilElementCollection.GuiElement guiElement2 = new GuiUtilElementCollection.GuiElement(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION"), 20, 180, GuiUtilPasswordFieldNew.class, 205, 240);
            this.passwordFieldConfirm = guiElement2.getPasswordField();
            GuiUtilElementCollection guiUtilElementCollection = new GuiUtilElementCollection();
            guiUtilElementCollection.addElement(guiElement);
            guiUtilElementCollection.addElement(guiElement2);
            guiUtilElementCollection.addToPanel(aastraPanel);
            this.errorComp.put(OmiMessage.URLType.privateKeyPassword.name(), guiElement.label, guiElement.elem);
            this.errorComp.put("pkwc", guiElement2.label, guiElement2.elem);
            this.add(aastraPanel);
            this.add(this.buttonBar);
        }

        public void activateOnError() {
            if (this.buttonBar != null && this.buttonBar.utilChangeHandler != null) {
                this.buttonBar.utilChangeHandler.activateOnError();
            }
        }
    }

    static interface ChangePrivateKeyInterface {
        public void changePrivateKey(String var1);
    }

    private final class SysSetTabbedPane
    extends GuiUtilTabbedPane {
        private static final long serialVersionUID = 1L;

        private SysSetTabbedPane() {
        }

        @Override
        public void showChangeDialog() {
            new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, UtilLocale.getString("TXT_PLEASE_SAVE_OR_CANCEL_YOUR_CHANGES"), true);
        }
    }
}

