/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.system;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilBorderPanel;
import com.aastra.oamp.guiutil.GuiUtilButtonBar;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class SystemSNMPPanel
extends AastraPanel
implements CommonDataHandler.CommonDataNotificationInterface,
GuiComponentActivationInterface {
    private static final long serialVersionUID = 1L;
    private static final int panelHeight = 330;
    private static final int panelWidth = 800;
    private static final int tabbedPaneWidth = 800;
    private CommonDataHandler commonDataHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private UtilErrorComp utilErrorComp = null;
    private GuiUtilButtonBar panelButtonBar = null;
    private boolean isEditable = true;
    private AastraPanel tabGeneral = null;
    private AastraPanel panelGeneral = null;
    private AastraLabel labelReadOnlyCommunity = null;
    private GuiUtilTextField textFieldReadOnlyCommunity = null;
    private AastraLabel labelSystemContact = null;
    private GuiUtilTextField textFieldSystemContact = null;
    private AastraPanel panelTrapHandling = null;
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelTrapCommunity = null;
    private GuiUtilTextField textFieldTrapCommunity = null;
    private AastraLabel labelTrapHostIPAddress = null;
    private GuiUtilTextField textFieldTrapHostIPAddress = null;

    public SystemSNMPPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, CommonDataHandler commonDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.SNMP, this);
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(new Dimension(800, 330));
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.add(this.getTabGeneral());
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(new BoxLayout(this.tabGeneral, 1));
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.getPanelButtonBar();
            this.tabGeneral.add(this.getPanelGeneral());
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelTrapHandling());
            if (this.isEditable) {
                this.tabGeneral.add(this.panelButtonBar);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilButtonBar getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new GuiUtilButtonBar(800, false, false);
            this.panelButtonBar.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSNMPPanel)SystemSNMPPanel.this).panelButtonBar.utilChangeHandler.deactivate();
                    SystemSNMPPanel.this.utilErrorComp.clearComponents();
                    SystemSNMPPanel.this.changeSNMP();
                }
            });
            this.panelButtonBar.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((SystemSNMPPanel)SystemSNMPPanel.this).panelButtonBar.utilChangeHandler.deactivate();
                    SystemSNMPPanel.this.commonDataHandler.sendGetReq(CommonDataHandler.CommonDataItemEnum.SNMP);
                    SystemSNMPPanel.this.utilErrorComp.clearComponents();
                }
            });
        }
        return this.panelButtonBar;
    }

    private AastraPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new GuiUtilBorderPanel(95, UtilLocale.getString("TXT_GENERAL"));
            this.labelReadOnlyCommunity = new AastraLabel();
            this.labelReadOnlyCommunity.setBounds(30, 30, 120, 16);
            this.labelReadOnlyCommunity.setText(UtilLocale.getString("TXT_READ_ONLY_COMMUNITY"));
            this.labelSystemContact = new AastraLabel();
            this.labelSystemContact.setBounds(30, 60, 120, 16);
            this.labelSystemContact.setText(UtilLocale.getString("TXT_SYSTEM_CONTACT"));
            this.panelGeneral.add((Component)this.labelReadOnlyCommunity, null);
            this.panelGeneral.add((Component)this.getTextFieldReadOnlyCommunity(), null);
            this.panelGeneral.add((Component)this.labelSystemContact, null);
            this.panelGeneral.add((Component)this.getTextFieldSystemContact(), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.readCommunity.toString(), this.labelReadOnlyCommunity, this.textFieldReadOnlyCommunity);
                this.utilErrorComp.put(OmiMessage.attribIds.contact.toString(), this.labelSystemContact, this.textFieldSystemContact);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelGeneral);
            }
        }
        return this.panelGeneral;
    }

    private AastraPanel getPanelTrapHandling() {
        if (this.panelTrapHandling == null) {
            this.panelTrapHandling = new GuiUtilBorderPanel(125, UtilLocale.getString("TXT_TRAP_HANDLING"));
            this.labelActive = new AastraLabel();
            this.labelActive.setBounds(30, 30, 130, 16);
            this.labelActive.setText(UtilLocale.getString("TXT_ACTIVE"));
            this.labelTrapCommunity = new AastraLabel();
            this.labelTrapCommunity.setBounds(30, 60, 130, 16);
            this.labelTrapCommunity.setText(UtilLocale.getString("TXT_TRAP_COMMUNITY"));
            this.labelTrapHostIPAddress = new AastraLabel();
            this.labelTrapHostIPAddress.setBounds(30, 90, 130, 31);
            this.labelTrapHostIPAddress.setText("<html>" + UtilLocale.getString("TXT_TRAP_HOST_IP_ADDRESS") + "</html>");
            this.panelTrapHandling.add((Component)this.labelActive, null);
            this.panelTrapHandling.add((Component)this.getCheckBoxActive(), null);
            this.panelTrapHandling.add((Component)this.labelTrapCommunity, null);
            this.panelTrapHandling.add((Component)this.getTextFieldTrapCommunity(), null);
            this.panelTrapHandling.add((Component)this.labelTrapHostIPAddress, null);
            this.panelTrapHandling.add((Component)this.getTextFieldTrapHostIPAddress(), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.attribIds.trapCommunity.toString(), this.labelTrapCommunity, this.textFieldTrapCommunity);
                this.utilErrorComp.put(OmiMessage.attribIds.trapHostAddr.toString(), this.labelTrapHostIPAddress, this.textFieldTrapHostIPAddress);
            } else {
                UtilSetPanelEditable.setDisabled(this.panelTrapHandling);
            }
        }
        return this.panelTrapHandling;
    }

    private GuiUtilTextField getTextFieldReadOnlyCommunity() {
        if (this.textFieldReadOnlyCommunity == null) {
            this.textFieldReadOnlyCommunity = new GuiUtilTextField(this.panelButtonBar.utilChangeHandler);
            this.textFieldReadOnlyCommunity.setBounds(210, 30, 150, 18);
        }
        return this.textFieldReadOnlyCommunity;
    }

    private GuiUtilTextField getTextFieldSystemContact() {
        if (this.textFieldSystemContact == null) {
            this.textFieldSystemContact = new GuiUtilTextField(this.panelButtonBar.utilChangeHandler);
            this.textFieldSystemContact.setBounds(210, 60, 150, 18);
        }
        return this.textFieldSystemContact;
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.panelButtonBar.utilChangeHandler, 205, 30);
        }
        return this.checkBoxActive;
    }

    private GuiUtilTextField getTextFieldTrapCommunity() {
        if (this.textFieldTrapCommunity == null) {
            this.textFieldTrapCommunity = new GuiUtilTextField(this.panelButtonBar.utilChangeHandler);
            this.textFieldTrapCommunity.setBounds(210, 60, 150, 18);
        }
        return this.textFieldTrapCommunity;
    }

    private GuiUtilTextField getTextFieldTrapHostIPAddress() {
        if (this.textFieldTrapHostIPAddress == null) {
            this.textFieldTrapHostIPAddress = new GuiUtilTextField(this.panelButtonBar.utilChangeHandler);
            this.textFieldTrapHostIPAddress.setBounds(210, 90, 150, 18);
        }
        return this.textFieldTrapHostIPAddress;
    }

    public void changeSNMP() {
        boolean bl = true;
        CommonDataHandler.SNMPClass sNMPClass = new CommonDataHandler.SNMPClass();
        sNMPClass.readCommunity = this.textFieldReadOnlyCommunity.getText();
        sNMPClass.contact = this.textFieldSystemContact.getText();
        sNMPClass.enableTraps = this.checkBoxActive.isSelected();
        sNMPClass.trapCommunity = this.textFieldTrapCommunity.getText();
        String string = this.textFieldTrapHostIPAddress.getText();
        if (UtilMisc.validateIPAddress(string)) {
            sNMPClass.trapHostAddr = string;
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_IP_ADDRESS_FORMAT_INVALID"));
            this.utilErrorComp.markComponent(this.textFieldTrapHostIPAddress);
            bl = false;
        }
        if (bl) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.SNMP.toString() + "='" + sNMPClass.readCommunity + "','" + sNMPClass.contact + "'," + sNMPClass.enableTraps + "','" + sNMPClass.trapCommunity + "','" + sNMPClass.trapHostAddr + "'");
            this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.SNMP, sNMPClass);
            this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.SNMP);
        } else {
            this.panelButtonBar.buttonCancel.setEnabled(true);
        }
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (!this.isEditable || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: " + dataNotificationEnum.toString() + ",item=" + String.valueOf((Object)commonDataItemEnum) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data error notification: Unknown errorCode=" + string);
        }
        String string4 = null;
        if (string2 != null) {
            string4 = this.utilErrorComp.getLabelText(string2);
        }
        if (errorCodes2 != null) {
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        JComponent jComponent = null;
        if (string2 != null) {
            jComponent = this.utilErrorComp.getField(string2);
        }
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
            this.panelButtonBar.buttonCancel.setEnabled(true);
        }
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.SNMP) {
            CommonDataHandler.SNMPClass sNMPClass = null;
            try {
                sNMPClass = (CommonDataHandler.SNMPClass)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.SNMP);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SNMP.toString() + "='" + sNMPClass.readCommunity + "','" + sNMPClass.contact + "," + sNMPClass.enableTraps + ",'" + sNMPClass.trapCommunity + "','" + sNMPClass.trapHostAddr + "' received");
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.SNMP.toString() + " failed");
                return;
            }
            this.getTextFieldReadOnlyCommunity().setText(sNMPClass.readCommunity);
            this.getTextFieldSystemContact().setText(sNMPClass.contact);
            this.getCheckBoxActive().setSelected(sNMPClass.enableTraps);
            this.getTextFieldTrapCommunity().setText(sNMPClass.trapCommunity);
            this.getTextFieldTrapHostIPAddress().setText(sNMPClass.trapHostAddr);
        }
    }

    @Override
    public void componentActivated(Component component) {
        if (this.isEditable) {
            this.getTextFieldReadOnlyCommunity().requestFocusInWindow();
            this.panelButtonBar.utilChangeHandler.initRootPane(this.getRootPane());
            this.getRootPane().setDefaultButton(this.panelButtonBar.buttonCancel);
        }
    }

    @Override
    public void componentDeactivated() {
    }
}

