/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.systemfeatures.SysFeatAlarmTriggerDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatAlarmTriggerTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.AlarmTriggerHandler;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class SysFeatAlarmTriggerMainPanel
extends AastraPanel
implements AlarmTriggerHandler.AlarmTriggerCnfDataNotificationInterface,
ConfiguratorTableEventInterface,
CommonDataHandler.CommonDataNotificationInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 200;
    protected static final int ySizeDetailPanelSurcharge = 100;
    private static final int ySizeDetailPanel = 310;
    private AlarmTriggerHandler alarmTriggerHandler = null;
    private CommonDataHandler commonDataHandler = null;
    private GuiUtilConfiguratorTable alarmTriggerTable = null;
    private GuiUtilDetailSplitPanel alarmTriggerDetailSplitPane = null;
    private AastraScrollPane alarmTriggerTablePane = null;
    private SysFeatAlarmTriggerDetailPanel alarmTriggerDetailPanel = null;
    private SysFeatAlarmTriggerTaskPanel alarmTriggerTaskPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private String prefix = null;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatAlarmTriggerMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, AlarmTriggerHandler alarmTriggerHandler, CommonDataHandler commonDataHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.commonDataHandler = commonDataHandler;
        this.alarmTriggerHandler = alarmTriggerHandler;
        this.commonDataHandler.registerDataNotificationListener(CommonDataHandler.CommonDataItemEnum.FACPrefix, this);
        this.alarmTriggerHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getAlarmTriggerDetailSplitPane(), "Center");
        this.add((Component)this.getAlarmTriggerTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.alarmTriggerTable.getSelectedRowCount();
        if (this.alarmTriggerDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                AlarmTriggerHandler.AlarmTrigger alarmTrigger = (AlarmTriggerHandler.AlarmTrigger)dataRecord;
                this.createAlarmTriggerDetailPanel(alarmTrigger, false);
            } else {
                this.removeAlarmTriggerDetailPanel();
            }
        } else if (n == 1) {
            this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            boolean bl = false;
            int[] nArray = this.alarmTriggerTable.getSelectedRows();
            for (int i = 0; i < n; ++i) {
                int n2 = this.alarmTriggerTable.convertRowIndexToModel(nArray[i]);
                AlarmTriggerHandler.AlarmTrigger alarmTrigger = this.alarmTriggerHandler.getTriggerByTableIdx(n2);
                String string = alarmTrigger.triggerId;
                if (string.compareTo(OmiMessage.SpecialAlarmTriggerType.SOS.name()) != 0 && string.compareTo(OmiMessage.SpecialAlarmTriggerType.MANDOWN.name()) != 0) continue;
                bl = true;
                break;
            }
            if (n >= 1 && !bl) {
                this.alarmTriggerTaskPanel.setTaskButtonDelete(true);
            } else {
                this.alarmTriggerTaskPanel.setTaskButtonDelete(false);
            }
        }
    }

    public void configureShowAlarmTrigger() {
        int n;
        AlarmTriggerHandler.AlarmTrigger alarmTrigger;
        int n2 = this.alarmTriggerTable.getSelectedRow();
        if (n2 >= 0 && (alarmTrigger = this.alarmTriggerHandler.getTriggerByTableIdx(n = this.alarmTriggerTable.convertRowIndexToModel(n2))) != null) {
            this.createAlarmTriggerDetailPanel(alarmTrigger, false);
        }
    }

    private GuiUtilDetailSplitPanel getAlarmTriggerDetailSplitPane() {
        if (this.alarmTriggerDetailSplitPane == null) {
            this.alarmTriggerDetailSplitPane = new GuiUtilDetailSplitPanel(310);
            this.alarmTriggerDetailSplitPane.setTopComponent(this.getAlarmTriggerTablePane());
            this.alarmTriggerDetailSplitPane.setBottomComponent(null);
        }
        return this.alarmTriggerDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getAlarmTriggerTable() {
        if (this.alarmTriggerTable == null) {
            int[] nArray = new int[]{0, 1, 2, 3, 4};
            this.alarmTriggerTable = this.isEditable ? new GuiUtilConfiguratorTable((Object)this, this.alarmTriggerHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthAlarmTriggerConfig, true) : new GuiUtilConfiguratorTable((Object)this, this.alarmTriggerHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthAlarmTriggerMonitor, 0, true);
        }
        return this.alarmTriggerTable;
    }

    private AastraScrollPane getAlarmTriggerTablePane() {
        if (this.alarmTriggerTablePane == null) {
            this.alarmTriggerTablePane = new AastraScrollPane(this.getAlarmTriggerTable());
            this.dividerLocation = this.alarmTriggerDetailSplitPane.getHeight() - 310;
            this.alarmTriggerTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.alarmTriggerTablePane;
    }

    private void enableTableAccess() {
        this.alarmTriggerTable.setActive(true);
        if (this.isEditable) {
            this.alarmTriggerTaskPanel.setTaskButtonCreate(true);
        }
    }

    private void disableTableAccess() {
        this.alarmTriggerTable.setActive(false);
        this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.alarmTriggerTaskPanel.setTaskButtonCreate(false);
            this.alarmTriggerTaskPanel.setTaskButtonDelete(false);
        }
    }

    private AastraPanel getAlarmTriggerDetailPanel() {
        if (this.alarmTriggerDetailPanel == null) {
            this.alarmTriggerDetailPanel = new SysFeatAlarmTriggerDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.alarmTriggerDetailPanel;
    }

    private AastraPanel getAlarmTriggerTaskPanel() {
        if (this.alarmTriggerTaskPanel == null) {
            this.alarmTriggerTaskPanel = new SysFeatAlarmTriggerTaskPanel(this, this.guiNavPanelType);
        }
        return this.alarmTriggerTaskPanel;
    }

    public void createAlarmTriggerDetailPanel(AlarmTriggerHandler.AlarmTrigger alarmTrigger, boolean bl) {
        if (bl) {
            this.alarmTriggerTable.removeRowSelectionAll();
        }
        if (this.alarmTriggerDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating alarm trigger config detail panel");
            }
            this.dividerLocation = this.alarmTriggerDetailSplitPane.getDividerLocation();
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating alarm trigger config detail panel");
            this.alarmTriggerDetailSplitPane.setBottomComponent(this.getAlarmTriggerDetailPanel());
        }
        if (alarmTrigger != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = alarmTrigger.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading alarm trigger[" + alarmTrigger.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + alarmTrigger.triggerId + "','" + alarmTrigger.fac + "','" + alarmTrigger.num + "'");
            this.alarmTriggerDetailPanel.setAlarmTriggerDetailData(alarmTrigger, this.prefix);
        } else {
            this.alarmTriggerDetailPanel.setAlarmTriggerDetailData(null, this.prefix);
        }
        this.alarmTriggerDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.alarmTriggerDetailSplitPane.validate();
        this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeAlarmTriggerDetailPanel() {
        if (this.alarmTriggerDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing alarm trigger config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing alarm trigger monitor detail panel");
            }
            this.dividerLocation = this.alarmTriggerDetailSplitPane.getDividerLocation();
            this.alarmTriggerDetailSplitPane.setBottomComponent(null);
            if (this.alarmTriggerTable.getSelectedRowCount() == 1) {
                this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove alarm trigger detail panel, but there is none");
        }
    }

    public void createAlarmTrigger() {
        AlarmTriggerHandler.AlarmTrigger alarmTrigger = this.alarmTriggerDetailPanel.getAlarmTriggerDetailData();
        this.pendingRemoveDetailPanel(-1);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating alarm trigger:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + alarmTrigger.triggerId + "','" + alarmTrigger.fac + "','" + alarmTrigger.num + "'");
        this.alarmTriggerHandler.sendCreateAlarmTrigger(alarmTrigger);
    }

    public void changeAlarmTrigger() {
        AlarmTriggerHandler.AlarmTrigger alarmTrigger = this.alarmTriggerDetailPanel.getAlarmTriggerDetailData();
        this.pendingRemoveDetailPanel(alarmTrigger.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing alarm trigger[" + alarmTrigger.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + alarmTrigger.triggerId + "','" + alarmTrigger.fac + "','" + alarmTrigger.num + "'");
        this.alarmTriggerHandler.sendSetAlarmTrigger(alarmTrigger);
    }

    public void deleteAlarmTrigger() {
        GuiUtilDialog guiUtilDialog;
        int n = this.alarmTriggerTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_ALARM_TRIGGERS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.alarmTriggerTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.alarmTriggerTable.convertRowIndexToModel(nArray[i]);
                AlarmTriggerHandler.AlarmTrigger alarmTrigger = this.alarmTriggerHandler.getTriggerByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting alarm trigger[" + alarmTrigger.id + "]");
                this.alarmTriggerHandler.sendDeleteAlarmTrigger(alarmTrigger.id);
                if (this.alarmTriggerDetailSplitPane.getBottomComponent() == null || this.alarmTriggerDetailPanel.getSelectedAlarmTrigger() != alarmTrigger.id) continue;
                this.detailPanelPending = true;
                this.idPending = alarmTrigger.id;
            }
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    @Override
    public void processCommonDataErrorNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum, OmiMessage omiMessage) {
    }

    @Override
    public void processCommonDataNotification(DataNotificationEnum dataNotificationEnum, CommonDataHandler.CommonDataItemEnum commonDataItemEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Common data notification: " + dataNotificationEnum.toString() + "," + commonDataItemEnum.toString());
        if (commonDataItemEnum == CommonDataHandler.CommonDataItemEnum.FACPrefix) {
            try {
                this.prefix = (String)this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.FACPrefix);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.FACPrefix.toString() + "='" + this.prefix + "'");
            }
            catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.FACPrefix.toString() + "='" + this.prefix + "'");
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        AlarmTriggerHandler.AlarmTrigger alarmTrigger = (AlarmTriggerHandler.AlarmTrigger)dataRecord;
        this.createAlarmTriggerDetailPanel(alarmTrigger, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.alarmTriggerDetailSplitPane.getBottomComponent() != null && this.alarmTriggerTable.getSelectedRowCount() > 1) {
            this.removeAlarmTriggerDetailPanel();
        }
        this.alarmTriggerTaskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Alarm trigger data notification: " + dataNotificationEnum.toString() + "," + n);
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: 
                        case DATA_CHANGED: {
                            if (!this.detailPanelPending || dataNotificationEnum != DataNotificationEnum.NEW_DATA && (dataNotificationEnum != DataNotificationEnum.DATA_CHANGED || this.idPending != n)) break block0;
                            this.removeAlarmTriggerDetailPanel();
                            break;
                        }
                        case DATA_DELETED: {
                            if (!this.detailPanelPending || this.idPending != n) break block0;
                            this.removeAlarmTriggerDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        AlarmTriggerHandler.AlarmTrigger alarmTrigger = this.alarmTriggerHandler.getTriggerById(n);
                        if (alarmTrigger != null) {
                            this.createAlarmTriggerDetailPanel(alarmTrigger, false);
                            break block0;
                        }
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading alarm trigger[" + n + "] failed");
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeAlarmTriggerDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Alarm trigger error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Alarm trigger error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string4 = null;
                    if (string2 != null) {
                        string4 = this.alarmTriggerDetailPanel.getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                this.alarmTriggerDetailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }
}

