/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatDigitTreatmentMainPanel;
import com.aastra.oamp.systemfeatures.SysFeatDigitTreatmentSitePanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.DigitTreatmentHandlerExpanded;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SysFeatDigitTreatmentDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private SiteDataHandler siteDataHandler = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private SysFeatDigitTreatmentMainPanel mainPanel = null;
    private SysFeatDigitTreatmentSitePanel siteSelectionDialog = null;
    private UtilErrorComp utilErrorComp = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private GuiUtilTextField textFieldExtPattern = null;
    private GuiUtilTextField textFieldIntPattern = null;
    private AastraLabel labelExtPattern = null;
    private AastraLabel labelIntPattern = null;
    private AastraLabel labelDirectory = null;
    private GuiUtilCheckBox checkBoxDirectory = null;
    private AastraLabel labelDirection = null;
    private GuiUtilComboBox comboBoxDirection = null;
    private AastraLabel labelSites = null;
    private AastraTextField textFieldSites = null;
    private AastraButton buttonSelectSites = null;
    private DigitTreatmentHandlerExpanded.DigitTreatment dT = null;
    private int selectedDT = -1;
    private boolean isEditable = true;
    private ActionModeEnum actionMode;

    public SysFeatDigitTreatmentDetailPanel(SysFeatDigitTreatmentMainPanel sysFeatDigitTreatmentMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, SiteDataHandler siteDataHandler, UtilErrorComp utilErrorComp) {
        super(240, 120);
        this.mainPanel = sysFeatDigitTreatmentMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.siteDataHandler = siteDataHandler;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelExtPattern = new AastraLabel();
            this.labelExtPattern.setBounds(30, 15, 160, 16);
            this.labelExtPattern.setText(UtilLocale.getString("TXT_EXTERNAL_PATTERN"));
            this.labelIntPattern = new AastraLabel();
            this.labelIntPattern.setBounds(30, 45, 160, 16);
            this.labelIntPattern.setText(UtilLocale.getString("TXT_INTERNAL_PATTERN"));
            this.labelDirection = new AastraLabel();
            this.labelDirection.setBounds(30, 75, 160, 16);
            this.labelDirection.setText(UtilLocale.getString("TXT_DIRECTION"));
            this.labelDirectory = new AastraLabel();
            this.labelDirectory.setBounds(30, 105, 160, 31);
            this.labelDirectory.setText("<html>" + UtilLocale.getString("TXT_APPLY_TO_CENTRAL_DIRECTORY") + "</html>");
            this.labelSites = new AastraLabel();
            this.labelSites.setBounds(30, 150, 150, 16);
            this.labelSites.setText(UtilLocale.getString("TXT_SITES"));
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelExtPattern, null);
            this.tabGeneral.add((Component)this.getTextFieldExtPattern(), null);
            this.tabGeneral.add((Component)this.labelIntPattern, null);
            this.tabGeneral.add((Component)this.getTextFieldIntPattern(), null);
            this.tabGeneral.add((Component)this.labelDirection, null);
            this.tabGeneral.add((Component)this.getComboBoxDirection(), null);
            this.tabGeneral.add((Component)this.labelDirectory, null);
            this.tabGeneral.add((Component)this.getCheckBoxDirectory(), null);
            this.tabGeneral.add((Component)this.labelSites, null);
            this.tabGeneral.add((Component)this.getTextFieldSites(), null);
            if (this.isEditable) {
                this.tabGeneral.add((Component)this.getButtonSelectSites(), null);
                this.utilErrorComp.put(OmiMessage.DigitTreatmentExpandedType.externalPattern.toString(), this.labelExtPattern, this.textFieldExtPattern);
                this.utilErrorComp.put(OmiMessage.DigitTreatmentExpandedType.internalPattern.toString(), this.labelIntPattern, this.textFieldIntPattern);
                this.utilErrorComp.put(OmiMessage.DigitTreatmentExpandedType.sites.toString(), this.labelSites, this.textFieldSites);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilTextField getTextFieldExtPattern() {
        if (this.textFieldExtPattern == null) {
            this.textFieldExtPattern = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldExtPattern.setBounds(210, 15, 230, 18);
        }
        return this.textFieldExtPattern;
    }

    private GuiUtilTextField getTextFieldIntPattern() {
        if (this.textFieldIntPattern == null) {
            this.textFieldIntPattern = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldIntPattern.setBounds(210, 45, 230, 18);
        }
        return this.textFieldIntPattern;
    }

    private GuiUtilComboBox getComboBoxDirection() {
        if (this.comboBoxDirection == null) {
            this.comboBoxDirection = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxDirection.setBounds(210, 75, 190, 20);
            this.comboBoxDirection.addItem(UtilLocale.getString("TXT_INCOMING_AND_OUTGOING_CALLS"));
            this.comboBoxDirection.addItem(UtilLocale.getString("TXT_INCOMING_CALLS"));
            this.comboBoxDirection.addItem(UtilLocale.getString("TXT_OUTGOING_CALLS"));
            this.comboBoxDirection.addItem(UtilLocale.getString("TXT_CENTRAL_DIRECTORY_ONLY"));
            this.comboBoxDirection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatDigitTreatmentDetailPanel.this.isEditable) {
                        if (SysFeatDigitTreatmentDetailPanel.this.comboBoxDirection.getSelectedIndex() == 3) {
                            SysFeatDigitTreatmentDetailPanel.this.getCheckBoxDirectory().setEnabled(false);
                            SysFeatDigitTreatmentDetailPanel.this.getCheckBoxDirectory().setSelected(true);
                        } else {
                            SysFeatDigitTreatmentDetailPanel.this.getCheckBoxDirectory().setEnabled(true);
                        }
                    }
                }
            });
            this.comboBoxDirection.activateActionListener();
        }
        return this.comboBoxDirection;
    }

    private GuiUtilCheckBox getCheckBoxDirectory() {
        if (this.checkBoxDirectory == null) {
            this.checkBoxDirectory = new GuiUtilCheckBox(this.utilChangeHandler, 205, 105);
        }
        return this.checkBoxDirectory;
    }

    private AastraTextField getTextFieldSites() {
        if (this.textFieldSites == null) {
            this.textFieldSites = new AastraTextField();
            this.textFieldSites.setEditable(false);
            this.textFieldSites.setBounds(210, 150, 230, 18);
        }
        return this.textFieldSites;
    }

    private AastraButton getButtonSelectSites() {
        if (this.buttonSelectSites == null) {
            this.buttonSelectSites = new AastraButton();
            this.buttonSelectSites.setBounds(460, 150, 90, 25);
            this.buttonSelectSites.setText(UtilLocale.getString("TXT_SELECT"));
            this.buttonSelectSites.setToolTipText(UtilLocale.getString("TXT_SELECT_SITES_FOR_DIGIT_TREATMENT_ENTRY"));
            this.buttonSelectSites.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatDigitTreatmentDetailPanel.this.siteSelectionDialog = new SysFeatDigitTreatmentSitePanel(SysFeatDigitTreatmentDetailPanel.this.siteDataHandler, SysFeatDigitTreatmentDetailPanel.this.utilChangeHandler, SysFeatDigitTreatmentDetailPanel.this.textFieldSites);
                    SysFeatDigitTreatmentDetailPanel.this.siteSelectionDialog.setVisible(true);
                }
            });
        }
        return this.buttonSelectSites;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatDigitTreatmentDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatDigitTreatmentDetailPanel.this.utilErrorComp.clearComponents();
                    if (SysFeatDigitTreatmentDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SysFeatDigitTreatmentDetailPanel.this.mainPanel.changeDigitTreatment();
                    } else {
                        SysFeatDigitTreatmentDetailPanel.this.mainPanel.createDigitTreatment();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatDigitTreatmentDetailPanel.this.isEditable) {
                        SysFeatDigitTreatmentDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatDigitTreatmentDetailPanel.this.mainPanel.removeDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    public void setDetailData(DigitTreatmentHandlerExpanded.DigitTreatment digitTreatment) {
        if (digitTreatment != null) {
            this.dT = (DigitTreatmentHandlerExpanded.DigitTreatment)digitTreatment.clone();
            this.selectedDT = this.dT.id;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_DIGIT_TREATMENT_ENTRY") + " #" + this.dT.id);
            this.textFieldExtPattern.setText(this.dT.extPattern);
            this.textFieldIntPattern.setText(this.dT.intPattern);
            this.checkBoxDirectory.setSelected(this.dT.directory);
            this.comboBoxDirection.deactivateActionListener();
            this.comboBoxDirection.setSelectedIndex(this.dT.direction.ordinal());
            this.comboBoxDirection.activateActionListener();
            this.textFieldSites.setText(this.dT.sites);
            if (this.isEditable) {
                this.textFieldExtPattern.setEditable(true);
                this.textFieldIntPattern.setEditable(true);
                this.comboBoxDirection.setEnabled(true);
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.dT = null;
            this.selectedDT = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_DIGIT_TREATMENT_ENTRY"));
            this.textFieldExtPattern.setText("");
            this.textFieldIntPattern.setText("");
            this.checkBoxDirectory.setSelected(false);
            this.comboBoxDirection.deactivateActionListener();
            this.comboBoxDirection.setSelectedIndex(0);
            this.comboBoxDirection.activateActionListener();
            this.textFieldSites.setText(DigitTreatmentHandlerExpanded.getStrAllSites());
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public DigitTreatmentHandlerExpanded.DigitTreatment getDetailData() {
        if (this.dT == null) {
            this.dT = new DigitTreatmentHandlerExpanded.DigitTreatment();
        }
        this.dT.extPattern = this.textFieldExtPattern.getText();
        this.dT.intPattern = this.textFieldIntPattern.getText();
        this.dT.directory = this.checkBoxDirectory.isSelected();
        this.dT.direction = DigitTreatmentHandlerExpanded.DirectionType.values()[this.comboBoxDirection.getSelectedIndex()];
        this.dT.sites = this.textFieldSites.getText();
        return this.dT;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedDigitTreatment() {
        return this.selectedDT;
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

