/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.DigitTreatmentHandlerExpanded;
import com.aastra.omilib.SiteDataHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SysFeatDigitTreatmentSitePanel
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel siteSelectionPanel = null;
    private SiteDataHandler siteDataHandler = null;
    private GuiUtilChangeHandler utilChangeHandlerDetailPanel = null;
    private String strSitesInput = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraScrollPane itemlistScrollPanel = null;
    private AastraPanel itemListPanel = null;
    private AastraCheckBox checkBoxNoSiteSelection = null;
    private AastraCheckBox[] checkBoxActiveArray = null;
    private AastraTextField textFieldSites;
    private int[] siteIdArray = null;

    public SysFeatDigitTreatmentSitePanel(SiteDataHandler siteDataHandler, GuiUtilChangeHandler guiUtilChangeHandler, AastraTextField aastraTextField) {
        super(GuiMain.getGuiMainObject());
        this.siteDataHandler = siteDataHandler;
        this.utilChangeHandlerDetailPanel = guiUtilChangeHandler;
        this.textFieldSites = aastraTextField;
        this.strSitesInput = this.textFieldSites.getText();
        this.initialize();
    }

    private void initialize() {
        this.setSize(290, 445);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_SELECT_SITES"));
        this.setContentPane(this.getSiteSelectionPanel());
        this.getRootPane().setDefaultButton(this.getButtonOK());
    }

    private AastraPanel getSiteSelectionPanel() {
        if (this.siteSelectionPanel == null) {
            this.siteSelectionPanel = new AastraPanel();
            this.siteSelectionPanel.setLayout(null);
            this.siteSelectionPanel.add((Component)this.getItemListScrollPanel(), null);
            this.siteSelectionPanel.add(this.getCheckNoSiteSelection());
            this.siteSelectionPanel.add((Component)this.getButtonOK(), null);
            this.siteSelectionPanel.add((Component)this.getButtonCancel(), null);
        }
        return this.siteSelectionPanel;
    }

    private AastraScrollPane getItemListScrollPanel() {
        if (this.itemlistScrollPanel == null) {
            this.itemlistScrollPanel = new AastraScrollPane(this.getItemListPanel());
            this.itemlistScrollPanel.setBounds(9, 9, 268, 300);
        }
        return this.itemlistScrollPanel;
    }

    private AastraPanel getItemListPanel() {
        if (this.itemListPanel == null) {
            this.itemListPanel = new AastraPanel();
            this.itemListPanel.setLayout(null);
            this.buildSitesCheckBoxList();
        }
        return this.itemListPanel;
    }

    private void buildSitesCheckBoxList() {
        int n;
        Object object;
        int[] nArray;
        int n2 = this.siteDataHandler.getNumberOfSites();
        if (this.strSitesInput.length() > 0) {
            if (this.strSitesInput.equals(DigitTreatmentHandlerExpanded.getStrAllSites())) {
                nArray = null;
            } else {
                object = this.strSitesInput.split(",");
                nArray = new int[((String[])object).length];
                for (n = 0; n < ((String[])object).length; ++n) {
                    nArray[n] = new Integer(object[n]);
                }
            }
        } else {
            nArray = null;
        }
        this.itemListPanel.setPreferredSize(new Dimension(1, n2 * 27));
        this.siteIdArray = new int[n2];
        this.checkBoxActiveArray = new AastraCheckBox[n2];
        for (n = 0; n < n2; ++n) {
            object = this.siteDataHandler.getSiteByTableIdx(n);
            this.siteIdArray[n] = object.id;
            this.checkBoxActiveArray[n] = new AastraCheckBox();
            this.checkBoxActiveArray[n].setBounds(30, 20 + n * 25, 230, 22);
            this.checkBoxActiveArray[n].setText(String.format(" %3d - \"%s\"", object.id, object.name));
            this.checkBoxActiveArray[n].setEnabled(false);
            this.checkBoxActiveArray[n].setSelected(false);
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.checkBoxActiveArray[n].setEnabled(true);
                    if (nArray[i] != object.id) continue;
                    this.checkBoxActiveArray[n].setSelected(true);
                    break;
                }
            }
            this.checkBoxActiveArray[n].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                }
            });
            this.itemListPanel.add(this.checkBoxActiveArray[n]);
        }
    }

    private AastraCheckBox getCheckNoSiteSelection() {
        if (this.checkBoxNoSiteSelection == null) {
            this.checkBoxNoSiteSelection = new AastraCheckBox();
            this.checkBoxNoSiteSelection.setBounds(40, 320, 150, 22);
            this.checkBoxNoSiteSelection.setText("  " + UtilLocale.getString("TXT_ALL_SITES"));
            this.checkBoxNoSiteSelection.setToolTipText(UtilLocale.getString("TXT_APPLY_ENTRY_TO_ALL_SITES"));
            this.checkBoxNoSiteSelection.setSelected(false);
            if (this.strSitesInput.length() > 0 && this.strSitesInput.equals(DigitTreatmentHandlerExpanded.getStrAllSites())) {
                this.checkBoxNoSiteSelection.setSelected(true);
            }
            this.checkBoxNoSiteSelection.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = SysFeatDigitTreatmentSitePanel.this.checkBoxNoSiteSelection.isSelected();
                    for (int i = 0; i < SysFeatDigitTreatmentSitePanel.this.checkBoxActiveArray.length; ++i) {
                        if (bl) {
                            SysFeatDigitTreatmentSitePanel.this.checkBoxActiveArray[i].setEnabled(false);
                            SysFeatDigitTreatmentSitePanel.this.checkBoxActiveArray[i].setSelected(false);
                            continue;
                        }
                        SysFeatDigitTreatmentSitePanel.this.checkBoxActiveArray[i].setEnabled(true);
                    }
                }
            });
        }
        return this.checkBoxNoSiteSelection;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(43, 365, 76, 26);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatDigitTreatmentSitePanel.this.setTextFieldSites();
                    SysFeatDigitTreatmentSitePanel.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(162, 365, 76, 26);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatDigitTreatmentSitePanel.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    private void setTextFieldSites() {
        String string = "";
        int n = this.checkBoxActiveArray.length;
        if (this.checkBoxNoSiteSelection.isSelected()) {
            string = DigitTreatmentHandlerExpanded.getStrAllSites();
        } else {
            for (int i = 0; i < n; ++i) {
                if (!this.checkBoxActiveArray[i].isSelected()) continue;
                if (string.length() > 0) {
                    string = string + ",";
                }
                string = string + this.siteIdArray[i];
            }
        }
        this.textFieldSites.setText(string);
        if (!string.equals(this.strSitesInput)) {
            this.utilChangeHandlerDetailPanel.activate();
        }
    }
}

