/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordField;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatLDAPMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.LDAPDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class SysFeatLDAPDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_SERVER = 1;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private LDAPDataHandler ldapDataHandler = null;
    private SysFeatLDAPMainPanel ldapMainPanel = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedLDAPRecord = -1;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraPanel tabServer = null;
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelOrder = null;
    private GuiUtilComboBox comboBoxOrder = null;
    private AastraLabel labelName = null;
    private GuiUtilTextField textFieldName = null;
    private AastraLabel labelSearchBase = null;
    private GuiUtilTextField textFieldSearchBase = null;
    private AastraLabel labelSearchType = null;
    private GuiUtilComboBox comboBoxSearchType = null;
    private AastraLabel labelDisplayType = null;
    private GuiUtilComboBox comboBoxDisplayType = null;
    private AastraLabel labelServer = null;
    private GuiUtilTextField textFieldServer = null;
    private AastraLabel labelPort = null;
    private GuiUtilTextField textFieldPort = null;
    private AastraLabel labelUserName = null;
    private GuiUtilTextField textFieldUserName = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordField passwordFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordField passwordFieldPasswordConfirm = null;
    private AastraLabel labelTimeout = null;
    private AastraLabel labelUnitSecond = null;
    private GuiUtilTextField textFieldTimeout = null;
    private LDAPDataHandler.LDAPRecord ldapRecord;
    private String dummyPassword = "1234567";
    private boolean isEditable = true;
    private ActionModeEnum actionMode;

    public SysFeatLDAPDetailPanel(SysFeatLDAPMainPanel sysFeatLDAPMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, LDAPDataHandler lDAPDataHandler, UtilErrorComp utilErrorComp) {
        super(100, 160);
        this.ldapMainPanel = sysFeatLDAPMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.ldapDataHandler = lDAPDataHandler;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        } else {
            this.isEditable = false;
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_SERVER"), null, this.getTabServer(), null);
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.utilChangeHandler, 190, 15);
        }
        return this.checkBoxActive;
    }

    private GuiUtilComboBox getComboBoxOrder() {
        if (this.comboBoxOrder == null) {
            this.comboBoxOrder = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxOrder.setBounds(195, 45, 50, 20);
        }
        return this.comboBoxOrder;
    }

    private void rebuiltComboBoxOrder(int n) {
        if (this.comboBoxOrder != null && this.comboBoxOrder.getItemCount() != n) {
            this.comboBoxOrder.removeAllItems();
            for (int i = 1; i <= n; ++i) {
                this.comboBoxOrder.addItem(Integer.toString(i));
            }
        }
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(195, 75, 150, 18);
        }
        return this.textFieldName;
    }

    private GuiUtilTextField getTextFieldSearchBase() {
        if (this.textFieldSearchBase == null) {
            this.textFieldSearchBase = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldSearchBase.setBounds(195, 105, 250, 18);
        }
        return this.textFieldSearchBase;
    }

    private GuiUtilComboBox getComboBoxSearchType() {
        if (this.comboBoxSearchType == null) {
            this.comboBoxSearchType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxSearchType.setBounds(195, 135, 170, 20);
            this.comboBoxSearchType.addItem(UtilLocale.getString("TXT_SURNAME"));
            this.comboBoxSearchType.addItem(UtilLocale.getString("TXT_GIVEN_NAME"));
            this.comboBoxSearchType.activateActionListener();
        }
        return this.comboBoxSearchType;
    }

    private GuiUtilComboBox getComboBoxDisplayType() {
        if (this.comboBoxDisplayType == null) {
            this.comboBoxDisplayType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxDisplayType.setBounds(195, 165, 170, 20);
            this.comboBoxDisplayType.addItem(UtilLocale.getString("TXT_SURNAME_GIVEN_NAME"));
            this.comboBoxDisplayType.addItem(UtilLocale.getString("TXT_GIVEN_NAME_AND_SURNAME"));
            this.comboBoxDisplayType.activateActionListener();
        }
        return this.comboBoxDisplayType;
    }

    private GuiUtilTextField getTextFieldServer() {
        if (this.textFieldServer == null) {
            this.textFieldServer = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldServer.setBounds(195, 15, 150, 18);
        }
        return this.textFieldServer;
    }

    private GuiUtilTextField getTextFieldPort() {
        if (this.textFieldPort == null) {
            this.textFieldPort = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldPort.setBounds(195, 45, 60, 18);
        }
        return this.textFieldPort;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldUserName.setBounds(195, 75, 150, 18);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordField getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPassword.setBounds(195, 105, 150, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPasswordConfirm.setBounds(195, 135, 150, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldTimeout() {
        if (this.textFieldTimeout == null) {
            this.textFieldTimeout = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldTimeout.setBounds(195, 180, 60, 18);
        }
        return this.textFieldTimeout;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatLDAPDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatLDAPDetailPanel.this.utilErrorComp.clearComponents();
                    if (SysFeatLDAPDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SysFeatLDAPDetailPanel.this.ldapMainPanel.changeLDAPRecord();
                    } else {
                        SysFeatLDAPDetailPanel.this.ldapMainPanel.createLDAPRecord();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatLDAPDetailPanel.this.isEditable) {
                        SysFeatLDAPDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatLDAPDetailPanel.this.ldapMainPanel.removeLDAPDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelActive = new AastraLabel();
            this.labelActive.setBounds(30, 15, 120, 16);
            this.labelActive.setText(UtilLocale.getString("TXT_ACTIVE"));
            this.labelOrder = new AastraLabel();
            this.labelOrder.setBounds(30, 45, 120, 16);
            this.labelOrder.setText(UtilLocale.getString("TXT_ORDER"));
            this.labelName = new AastraLabel();
            this.labelName.setBounds(30, 75, 120, 16);
            this.labelName.setText(UtilLocale.getString("TXT_NAME"));
            this.labelSearchBase = new AastraLabel();
            this.labelSearchBase.setBounds(30, 105, 150, 16);
            this.labelSearchBase.setText(UtilLocale.getString("TXT_SEARCH_BASE"));
            this.labelSearchType = new AastraLabel();
            this.labelSearchType.setBounds(30, 135, 120, 16);
            this.labelSearchType.setText(UtilLocale.getString("TXT_SEARCH_TYPE"));
            this.labelDisplayType = new AastraLabel();
            this.labelDisplayType.setBounds(30, 165, 120, 16);
            this.labelDisplayType.setText(UtilLocale.getString("TXT_DISPLAY_TYPE"));
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelActive, null);
            this.tabGeneral.add((Component)this.getCheckBoxActive(), null);
            this.tabGeneral.add((Component)this.labelOrder, null);
            this.tabGeneral.add((Component)this.getComboBoxOrder(), null);
            this.tabGeneral.add((Component)this.labelName, null);
            this.tabGeneral.add((Component)this.getTextFieldName(), null);
            this.tabGeneral.add((Component)this.labelSearchBase, null);
            this.tabGeneral.add((Component)this.getTextFieldSearchBase(), null);
            this.tabGeneral.add((Component)this.labelSearchType, null);
            this.tabGeneral.add((Component)this.getComboBoxSearchType(), null);
            this.tabGeneral.add((Component)this.labelDisplayType, null);
            this.tabGeneral.add((Component)this.getComboBoxDisplayType(), null);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.name.toString(), this.labelName, this.textFieldName, 0);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.searchBase.toString(), this.labelSearchBase, this.textFieldSearchBase, 0);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private AastraPanel getTabServer() {
        if (this.tabServer == null) {
            this.labelServer = new AastraLabel();
            this.labelServer.setBounds(30, 15, 120, 16);
            this.labelServer.setText(UtilLocale.getString("TXT_SERVER"));
            this.labelPort = new AastraLabel();
            this.labelPort.setBounds(30, 45, 120, 16);
            this.labelPort.setText(UtilLocale.getString("TXT_PORT"));
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(30, 75, 120, 16);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(30, 105, 120, 16);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setBounds(30, 135, 150, 31);
            this.labelPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelTimeout = new AastraLabel();
            this.labelTimeout.setBounds(30, 180, 150, 31);
            this.labelTimeout.setText("<html>" + UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT") + "</html>");
            this.labelUnitSecond = new AastraLabel();
            this.labelUnitSecond.setBounds(265, 180, 45, 16);
            this.labelUnitSecond.setText(UtilLocale.getString("TXT_UNIT_SECOND"));
            this.tabServer = new AastraPanel();
            this.tabServer.setLayout(null);
            this.tabServer.add((Component)this.labelServer, null);
            this.tabServer.add((Component)this.getTextFieldServer(), null);
            this.tabServer.add((Component)this.labelPort, null);
            this.tabServer.add((Component)this.getTextFieldPort(), null);
            this.tabServer.add((Component)this.labelUserName, null);
            this.tabServer.add((Component)this.getTextFieldUserName(), null);
            this.tabServer.add((Component)this.labelPassword, null);
            this.tabServer.add((Component)this.getPasswordFieldPassword(), null);
            this.tabServer.add((Component)this.labelPasswordConfirm, null);
            this.tabServer.add((Component)this.getPasswordFieldPasswordConfirm(), null);
            this.tabServer.add((Component)this.labelTimeout, null);
            this.tabServer.add((Component)this.getTextFieldTimeout(), null);
            this.tabServer.add((Component)this.labelUnitSecond, null);
            if (this.isEditable) {
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.server.toString(), this.labelServer, this.textFieldServer, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.port.toString(), this.labelPort, this.textFieldPort, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.username.toString(), this.labelUserName, this.textFieldUserName, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.password.toString(), this.labelPassword, this.passwordFieldPassword, 1);
                this.utilErrorComp.putWithTab("passwordConfirm", this.labelPassword, this.passwordFieldPasswordConfirm, 1);
                this.utilErrorComp.putWithTab(OmiMessage.LDAPNewType.timeout.toString(), this.labelTimeout, this.textFieldTimeout, 1);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabServer);
            }
        }
        return this.tabServer;
    }

    public void setLDAPRecordDetailData(LDAPDataHandler.LDAPRecord lDAPRecord) {
        if (lDAPRecord != null) {
            this.ldapRecord = (LDAPDataHandler.LDAPRecord)lDAPRecord.clone();
            this.selectedLDAPRecord = this.ldapRecord.id;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_LDAP_ENTRY"));
            this.checkBoxActive.setSelected(this.ldapRecord.active);
            this.comboBoxOrder.deactivateActionListener();
            this.rebuiltComboBoxOrder(this.ldapDataHandler.getNumberOfLDAP());
            this.comboBoxOrder.setSelectedItem(Integer.toString(this.ldapRecord.order));
            this.comboBoxOrder.activateActionListener();
            this.textFieldName.setText(this.ldapRecord.name);
            this.textFieldSearchBase.setText(this.ldapRecord.searchBase);
            this.comboBoxSearchType.deactivateActionListener();
            if (this.ldapRecord.searchType == OmiMessage.SearchNewType.SN) {
                this.comboBoxSearchType.setSelectedIndex(0);
            } else {
                this.comboBoxSearchType.setSelectedIndex(1);
            }
            this.comboBoxSearchType.activateActionListener();
            this.comboBoxDisplayType.deactivateActionListener();
            if (this.ldapRecord.displayType == OmiMessage.DisplayNewType.SN_GN) {
                this.comboBoxDisplayType.setSelectedIndex(0);
            } else {
                this.comboBoxDisplayType.setSelectedIndex(1);
            }
            this.comboBoxDisplayType.activateActionListener();
            this.textFieldServer.setText(this.ldapRecord.server);
            this.textFieldPort.setText(String.valueOf(this.ldapRecord.port));
            this.textFieldUserName.setText(this.ldapRecord.username);
            if (this.ldapRecord.password != null && this.ldapRecord.password.length() > 0) {
                this.passwordFieldPassword.setText(this.dummyPassword);
                this.passwordFieldPasswordConfirm.setText(this.dummyPassword);
            } else {
                this.passwordFieldPassword.setText("");
                this.passwordFieldPasswordConfirm.setText("");
            }
            this.textFieldTimeout.setText(String.valueOf(this.ldapRecord.timeout));
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.selectedLDAPRecord = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_LDAP_ENTRY"));
            this.checkBoxActive.setSelected(false);
            this.comboBoxOrder.deactivateActionListener();
            this.rebuiltComboBoxOrder(this.ldapDataHandler.getNumberOfLDAP() + 1);
            this.comboBoxOrder.setSelectedItem("1");
            this.comboBoxOrder.activateActionListener();
            this.textFieldName.setText("");
            this.textFieldSearchBase.setText("");
            this.comboBoxSearchType.deactivateActionListener();
            this.comboBoxSearchType.setSelectedIndex(0);
            this.comboBoxSearchType.activateActionListener();
            this.comboBoxDisplayType.deactivateActionListener();
            this.comboBoxDisplayType.setSelectedIndex(0);
            this.comboBoxDisplayType.activateActionListener();
            this.textFieldServer.setText("");
            this.textFieldPort.setText("389");
            this.textFieldUserName.setText("");
            this.passwordFieldPassword.setText("");
            this.passwordFieldPasswordConfirm.setText("");
            this.textFieldTimeout.setText("10");
            this.checkBoxActive.requestFocusInWindow();
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public LDAPDataHandler.LDAPRecord getLDAPRecordDetailData() {
        if (this.ldapRecord == null) {
            this.ldapRecord = new LDAPDataHandler.LDAPRecord();
        }
        this.ldapRecord.active = this.checkBoxActive.isSelected();
        this.ldapRecord.order = new Integer(this.comboBoxOrder.getSelectedItem().toString());
        this.ldapRecord.name = this.textFieldName.getText();
        this.ldapRecord.searchBase = this.textFieldSearchBase.getText();
        this.ldapRecord.searchType = this.comboBoxSearchType.getSelectedIndex() == 0 ? OmiMessage.SearchNewType.SN : OmiMessage.SearchNewType.GN;
        this.ldapRecord.displayType = this.comboBoxDisplayType.getSelectedIndex() == 0 ? OmiMessage.DisplayNewType.SN_GN : OmiMessage.DisplayNewType.CN;
        this.ldapRecord.server = this.textFieldServer.getText();
        if (this.textFieldPort.getText().length() > 0) {
            try {
                this.ldapRecord.port = Integer.parseInt(this.textFieldPort.getText());
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                this.markErrorComponent(OmiMessage.LDAPNewType.port.toString());
                return null;
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_PORT")));
            this.markErrorComponent(OmiMessage.LDAPNewType.port.toString());
            return null;
        }
        this.ldapRecord.username = this.textFieldUserName.getText();
        String string = new String(this.passwordFieldPassword.getPassword());
        if (string.equals(new String(this.passwordFieldPasswordConfirm.getPassword()))) {
            this.ldapRecord.password = string.equals(this.dummyPassword) ? null : string;
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
            this.markErrorComponent("passwordConfirm");
            return null;
        }
        if (this.textFieldTimeout.getText().length() > 0) {
            try {
                this.ldapRecord.timeout = Integer.parseInt(this.textFieldTimeout.getText());
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_INPUT_FORMAT_INVALID"));
                this.markErrorComponent(OmiMessage.LDAPNewType.timeout.toString());
                return null;
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_SERVER_SEARCH_TIMEOUT")));
            this.markErrorComponent(OmiMessage.LDAPNewType.timeout.toString());
            return null;
        }
        return this.ldapRecord;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
            this.panelTabbed.setSelectedIndex(this.utilErrorComp.getTab(string));
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedLDAPRecord() {
        return this.selectedLDAPRecord;
    }

    public void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

