/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.systemfeatures.SysFeatLDAPDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatLDAPTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.LDAPDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;

public class SysFeatLDAPMainPanel
extends AastraPanel
implements LDAPDataHandler.LDAPCnfDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 100;
    protected static final int ySizeDetailPanelSurcharge = 160;
    private static final int ySizeDetailPanel = 370;
    private LDAPDataHandler ldapDataHandler = null;
    private ConfiguratorTable ldapTable = null;
    private GuiUtilDetailSplitPanel ldapDetailSplitPane = null;
    private AastraScrollPane ldapTablePane = null;
    private SysFeatLDAPDetailPanel ldapDetailPanel = null;
    private SysFeatLDAPTaskPanel ldapTaskPanel = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private boolean detailPanelPending = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatLDAPMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, LDAPDataHandler lDAPDataHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.ldapDataHandler = lDAPDataHandler;
        this.ldapDataHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLDAPDetailSplitPane(), "Center");
        this.add((Component)this.getLDAPTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        boolean bl = false;
        int n = this.ldapTable.getSelectedRowCount();
        if (this.ldapDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                LDAPDataHandler.LDAPRecord lDAPRecord = (LDAPDataHandler.LDAPRecord)dataRecord;
                this.createLDAPDetailPanel(lDAPRecord, false);
            } else {
                this.removeLDAPDetailPanel();
            }
        } else if (n == 1) {
            this.ldapTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.ldapTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n >= 1 && !bl) {
                this.ldapTaskPanel.setTaskButtonDelete(true);
            } else {
                this.ldapTaskPanel.setTaskButtonDelete(false);
            }
        }
    }

    public void configureShowLDAPRecord() {
        int n;
        LDAPDataHandler.LDAPRecord lDAPRecord;
        int n2 = this.ldapTable.getSelectedRow();
        if (n2 >= 0 && (lDAPRecord = this.ldapDataHandler.getLDAPRecordByTableIdx(n = this.ldapTable.convertRowIndexToModel(n2))) != null) {
            this.createLDAPDetailPanel(lDAPRecord, false);
        }
    }

    private GuiUtilDetailSplitPanel getLDAPDetailSplitPane() {
        if (this.ldapDetailSplitPane == null) {
            this.ldapDetailSplitPane = new GuiUtilDetailSplitPanel(370);
            this.ldapDetailSplitPane.setTopComponent(this.getLDAPTablePane());
            this.ldapDetailSplitPane.setBottomComponent(null);
        }
        return this.ldapDetailSplitPane;
    }

    private JTable getLDAPTable() {
        if (this.ldapTable == null) {
            int[] nArray = new int[]{3, 1, 4, 6, 2};
            this.ldapTable = this.isEditable ? new GuiUtilConfiguratorTable((Object)this, this.ldapDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthLdapConfig, true) : new GuiUtilConfiguratorTable((Object)this, this.ldapDataHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthLdapMonitor, 0, true);
            this.ldapTable.setIconArray(2, GuiUtilIcon.getIconArrayInactiveActive());
        }
        return this.ldapTable;
    }

    private AastraScrollPane getLDAPTablePane() {
        if (this.ldapTablePane == null) {
            this.ldapTablePane = new AastraScrollPane(this.getLDAPTable());
            this.dividerLocation = this.ldapDetailSplitPane.getHeight() - 370;
            this.ldapTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.ldapTablePane;
    }

    private AastraPanel getLDAPDetailPanel() {
        if (this.ldapDetailPanel == null) {
            this.ldapDetailPanel = new SysFeatLDAPDetailPanel(this, this.guiNavPanelType, this.ldapDataHandler, this.utilErrorComp);
        }
        return this.ldapDetailPanel;
    }

    private AastraPanel getLDAPTaskPanel() {
        if (this.ldapTaskPanel == null) {
            this.ldapTaskPanel = new SysFeatLDAPTaskPanel(this, this.guiNavPanelType);
        }
        return this.ldapTaskPanel;
    }

    public void createLDAPDetailPanel(LDAPDataHandler.LDAPRecord lDAPRecord, boolean bl) {
        if (bl) {
            this.ldapTable.removeRowSelectionAll();
        }
        if (this.ldapDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating LDAP config detail panel");
            }
            this.dividerLocation = this.ldapDetailSplitPane.getDividerLocation();
            if (lDAPRecord == null) {
                this.ldapDetailPanel.setDefaultTab();
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating LDAP config detail panel");
            this.ldapDetailSplitPane.setBottomComponent(this.getLDAPDetailPanel());
            this.ldapDetailPanel.setDefaultTab();
        }
        if (lDAPRecord != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = lDAPRecord.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading LDAP entry[" + lDAPRecord.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.order + "','" + lDAPRecord.name + "','" + lDAPRecord.server + "'" + "','" + lDAPRecord.port + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.username + "','" + lDAPRecord.searchBase + "','" + (Object)((Object)lDAPRecord.searchType) + "'");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + (Object)((Object)lDAPRecord.displayType) + "','" + lDAPRecord.timeout + "','" + lDAPRecord.active + "'");
            this.ldapDetailPanel.setLDAPRecordDetailData(lDAPRecord);
        } else {
            this.ldapDetailPanel.setLDAPRecordDetailData(null);
        }
        this.ldapDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.ldapDetailSplitPane.validate();
        this.ldapTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeLDAPDetailPanel() {
        if (this.ldapDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing LDAP config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing LDAP monitor detail panel");
            }
            this.dividerLocation = this.ldapDetailSplitPane.getDividerLocation();
            this.ldapDetailSplitPane.setBottomComponent(null);
            if (this.ldapTable.getSelectedRowCount() == 1) {
                this.ldapTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove LDAP detail panel, but there is none");
        }
    }

    public void createLDAPRecord() {
        LDAPDataHandler.LDAPRecord lDAPRecord = this.ldapDetailPanel.getLDAPRecordDetailData();
        if (lDAPRecord == null) {
            return;
        }
        this.pendingRemoveDetailPanel(-1);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating LDAP record:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.order + "','" + lDAPRecord.name + "','" + lDAPRecord.server + "'" + "','" + lDAPRecord + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.username + "','" + lDAPRecord.searchBase + "','" + (Object)((Object)lDAPRecord.searchType) + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + (Object)((Object)lDAPRecord.displayType) + "','" + lDAPRecord.timeout + "','" + lDAPRecord.active + "'");
        this.ldapDataHandler.sendCreateLDAP(lDAPRecord);
    }

    public void changeLDAPRecord() {
        LDAPDataHandler.LDAPRecord lDAPRecord = this.ldapDetailPanel.getLDAPRecordDetailData();
        if (lDAPRecord == null) {
            return;
        }
        this.pendingRemoveDetailPanel(lDAPRecord.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing LDAP record[" + lDAPRecord.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.order + "','" + lDAPRecord.name + "','" + lDAPRecord.server + "'" + "','" + lDAPRecord.port + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + lDAPRecord.username + "','" + lDAPRecord.searchBase + "','" + (Object)((Object)lDAPRecord.searchType) + "'");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + (Object)((Object)lDAPRecord.displayType) + "','" + lDAPRecord.timeout + "','" + lDAPRecord.active + "'");
        this.ldapDataHandler.sendSetLDAP(lDAPRecord);
    }

    public void deleteLDAPRecords() {
        GuiUtilDialog guiUtilDialog;
        int n = this.ldapTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_LDAP_ENTRIES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.ldapTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.ldapTable.convertRowIndexToModel(nArray[i]);
                LDAPDataHandler.LDAPRecord lDAPRecord = this.ldapDataHandler.getLDAPRecordByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting LDAP record[" + lDAPRecord.id + "]");
                this.ldapDataHandler.sendDeleteLDAP(lDAPRecord.id);
                if (this.ldapDetailSplitPane.getBottomComponent() == null || this.ldapDetailPanel.getSelectedLDAPRecord() != lDAPRecord.id) continue;
                this.detailPanelPending = true;
                this.idPending = lDAPRecord.id;
            }
        }
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        LDAPDataHandler.LDAPRecord lDAPRecord = (LDAPDataHandler.LDAPRecord)dataRecord;
        this.createLDAPDetailPanel(lDAPRecord, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.ldapDetailSplitPane.getBottomComponent() != null && this.ldapTable.getSelectedRowCount() > 1) {
            this.removeLDAPDetailPanel();
        }
        this.ldapTaskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processLDAPDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        block18: {
            block17: {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "LDAP notification: " + dataNotificationEnum.toString() + "," + n);
                if (!this.isEditable) break block17;
                switch (dataNotificationEnum) {
                    case NEW_DATA: {
                        if (this.ldapTable.getRowCount() < 5) {
                            this.ldapTaskPanel.setTaskButtonCreate(true);
                        } else {
                            this.ldapTaskPanel.setTaskButtonCreate(false);
                        }
                        if (this.detailPanelPending && (dataNotificationEnum == DataNotificationEnum.NEW_DATA || dataNotificationEnum == DataNotificationEnum.DATA_CHANGED && this.idPending == n)) {
                            this.removeLDAPDetailPanel();
                            break;
                        }
                        break block18;
                    }
                    case DATA_CHANGED: {
                        if (this.detailPanelPending && (dataNotificationEnum == DataNotificationEnum.NEW_DATA || dataNotificationEnum == DataNotificationEnum.DATA_CHANGED && this.idPending == n)) {
                            this.removeLDAPDetailPanel();
                            break;
                        }
                        break block18;
                    }
                    case DATA_DELETED: {
                        if (this.ldapTable.getRowCount() < 5) {
                            this.ldapTaskPanel.setTaskButtonCreate(true);
                        } else {
                            this.ldapTaskPanel.setTaskButtonCreate(false);
                        }
                        if (this.detailPanelPending && this.idPending == n) {
                            this.removeLDAPDetailPanel();
                            break;
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (n == this.idCurrentMonitorPanel) {
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        LDAPDataHandler.LDAPRecord lDAPRecord = this.ldapDataHandler.getLDAPRecordById(n);
                        if (lDAPRecord == null) break;
                        this.createLDAPDetailPanel(lDAPRecord, false);
                        break;
                    }
                    case DATA_DELETED: {
                        this.removeLDAPDetailPanel();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void processLDAPErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "LDAP error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "LDAP error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string4 = null;
                    if (string2 != null) {
                        string4 = this.ldapDetailPanel.getErrorLabelText(string2);
                    }
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null) break;
                this.ldapDetailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }
}

