/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatPpProfilesMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpProfilesHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextArea;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JComponent;

public class SysFeatPpProfilesDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private SysFeatPpProfilesMainPanel ppProfilesMainPanel = null;
    private PpProfilesHandler.PpProfileRec ppProfile = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedPpProfile = -1;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraButton buttonImportFile = null;
    private AastraPanel tabGeneral = null;
    private GuiUtilTextField textFieldTimeStamp = null;
    private GuiUtilTextField textFieldName = null;
    private AastraTextArea textAreaData = null;
    private AastraLabel labelDefault = null;
    private GuiUtilCheckBox checkboxDefault = null;
    private AastraLabel labelId = null;
    private GuiUtilComboBox comboBoxId = null;
    private boolean isEditable = true;
    private GuiUtilFileChooser ppDataFileChooser = null;
    private AastraPanel detailPanel;
    private String nameBackup = null;
    private ActionModeEnum actionMode;

    public SysFeatPpProfilesDetailPanel(SysFeatPpProfilesMainPanel sysFeatPpProfilesMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(240, 120);
        this.ppProfilesMainPanel = sysFeatPpProfilesMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.detailPanel = this;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add(this.getButtonOK());
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelButtonBar.add(this.getButtonCancel());
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatPpProfilesDetailPanel.this.utilChangeHandler.deactivate();
                    String string = SysFeatPpProfilesDetailPanel.this.textAreaData.getText();
                    if (string.isEmpty()) {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_NO_PROFILE_DATA"));
                        SysFeatPpProfilesDetailPanel.this.utilErrorComp.markComponent(SysFeatPpProfilesDetailPanel.this.textAreaData);
                        SysFeatPpProfilesDetailPanel.this.utilChangeHandler.activateOnError();
                    } else {
                        SysFeatPpProfilesDetailPanel.this.utilErrorComp.clearComponents();
                        if (SysFeatPpProfilesDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                            SysFeatPpProfilesDetailPanel.this.ppProfilesMainPanel.changePpProfile();
                        } else {
                            SysFeatPpProfilesDetailPanel.this.ppProfilesMainPanel.createPpProfile();
                        }
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatPpProfilesDetailPanel.this.isEditable) {
                        SysFeatPpProfilesDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatPpProfilesDetailPanel.this.ppProfilesMainPanel.removeDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 15, 70, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_NAME"));
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(105, 15, 150, 18);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 45, 70, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_TIME_STAMP"));
            this.textFieldTimeStamp = new GuiUtilTextField();
            this.textFieldTimeStamp.setBounds(105, 45, 150, 18);
            this.textAreaData = new AastraTextArea();
            this.textAreaData.setEditable(false);
            AastraScrollPane aastraScrollPane = new AastraScrollPane(this.textAreaData);
            aastraScrollPane.setBounds(270, 15, 320, 170);
            this.labelDefault = new AastraLabel();
            this.labelDefault.setBounds(30, 45, 70, 16);
            this.labelDefault.setText(UtilLocale.getString("TXT_DEFAULT_20"));
            this.checkboxDefault = new GuiUtilCheckBox(this.utilChangeHandler);
            this.checkboxDefault.setBounds(100, 45, 45, 20);
            this.checkboxDefault.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (SysFeatPpProfilesDetailPanel.this.checkboxDefault.isSelected()) {
                        SysFeatPpProfilesDetailPanel.this.nameBackup = SysFeatPpProfilesDetailPanel.this.textFieldName.getText();
                        SysFeatPpProfilesDetailPanel.this.textFieldName.setText(UtilLocale.getString("TXT_DEFAULT_20"));
                        SysFeatPpProfilesDetailPanel.this.textFieldName.setEnabled(false);
                        SysFeatPpProfilesDetailPanel.this.disableComboBoxId();
                    } else {
                        SysFeatPpProfilesDetailPanel.this.textFieldName.setEnabled(true);
                        if (SysFeatPpProfilesDetailPanel.this.nameBackup != null) {
                            SysFeatPpProfilesDetailPanel.this.textFieldName.setText(SysFeatPpProfilesDetailPanel.this.nameBackup);
                        } else if (SysFeatPpProfilesDetailPanel.this.ppProfile != null) {
                            SysFeatPpProfilesDetailPanel.this.textFieldName.setText(((SysFeatPpProfilesDetailPanel)SysFeatPpProfilesDetailPanel.this).ppProfile.name);
                        } else {
                            SysFeatPpProfilesDetailPanel.this.textFieldName.setText("");
                        }
                        SysFeatPpProfilesDetailPanel.this.enableComboBoxId();
                    }
                }
            });
            this.labelId = new AastraLabel();
            this.labelId.setBounds(30, 75, 70, 16);
            this.labelId.setText(UtilLocale.getString("TXT_ID"));
            this.comboBoxId = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxId.setBounds(105, 75, 50, 20);
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setText(UtilLocale.getString("TXT_PROFILE_DATA"));
            this.tabGeneral.add((Component)aastraLabel, null);
            this.tabGeneral.add((Component)this.textFieldName, null);
            if (this.isEditable) {
                this.tabGeneral.add(this.labelDefault);
                this.tabGeneral.add(this.checkboxDefault);
                this.tabGeneral.add(this.labelId);
                this.tabGeneral.add(this.comboBoxId);
            } else {
                this.tabGeneral.add(aastraLabel2);
                this.tabGeneral.add(this.textFieldTimeStamp);
            }
            this.tabGeneral.add((Component)aastraScrollPane, null);
            if (this.isEditable) {
                this.buttonImportFile = new AastraButton();
                this.buttonImportFile.setBounds(30, 130, 120, 25);
                this.buttonImportFile.setText(UtilLocale.getString("TXT_IMPORT_FILE"));
                this.buttonImportFile.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string;
                        String string2;
                        File file;
                        if (SysFeatPpProfilesDetailPanel.this.ppDataFileChooser == null) {
                            SysFeatPpProfilesDetailPanel.this.ppDataFileChooser = new GuiUtilFileChooser(SysFeatPpProfilesDetailPanel.this.detailPanel);
                        }
                        if ((file = SysFeatPpProfilesDetailPanel.this.ppDataFileChooser.fileChooser()) != null && (string2 = SysFeatPpProfilesDetailPanel.this.readPpProfileDataFile(string = file.getAbsolutePath())) != null) {
                            SysFeatPpProfilesDetailPanel.this.textAreaData.setText(string2);
                            SysFeatPpProfilesDetailPanel.this.utilChangeHandler.activate();
                        }
                    }
                });
                this.tabGeneral.add(this.buttonImportFile);
                this.utilErrorComp.put(OmiMessage.PpProfileDataSetType.name.name(), aastraLabel, this.textFieldName);
                this.utilErrorComp.put(OmiMessage.PpProfileDataSetType.ppData.name(), aastraLabel3, aastraScrollPane);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private void setConfigureMode() {
        if (this.labelDefault != null) {
            this.labelDefault.setVisible(false);
        }
        if (this.checkboxDefault != null) {
            this.checkboxDefault.setVisible(false);
        }
        if (this.labelId != null) {
            this.labelId.setVisible(false);
        }
        if (this.comboBoxId != null) {
            this.comboBoxId.setVisible(false);
            this.comboBoxId.removeAllItems();
        }
    }

    private void setCreateMode() {
        if (this.labelDefault != null) {
            this.labelDefault.setVisible(true);
        }
        if (this.checkboxDefault != null) {
            this.checkboxDefault.setVisible(true);
            this.checkboxDefault.setEnabled(true);
        }
        if (this.labelId != null) {
            this.labelId.setVisible(true);
        }
        if (this.comboBoxId != null) {
            this.comboBoxId.setVisible(true);
            this.enableComboBoxId();
        }
    }

    private void enableComboBoxId() {
        this.comboBoxId.setEnabled(true);
        this.comboBoxId.removeAllItems();
        for (int i = 1; i < 21; ++i) {
            if (this.ppProfilesMainPanel.isProfileSet(i)) continue;
            this.comboBoxId.addItem(i);
        }
    }

    private void disableComboBoxId() {
        this.comboBoxId.removeAllItems();
        this.comboBoxId.setEnabled(false);
    }

    private String readPpProfileDataFile(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            String string2 = "";
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = string2 + string3 + "\n";
                string3 = bufferedReader.readLine();
                if (string2.length() <= 4096) continue;
                bufferedReader.close();
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_ERROR_FILE_*_TO_LONG"), string));
                return null;
            }
            bufferedReader.close();
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return null;
    }

    public void setppProfileDetailData(PpProfilesHandler.PpProfileRec ppProfileRec) {
        this.nameBackup = null;
        if (ppProfileRec != null) {
            this.ppProfile = (PpProfilesHandler.PpProfileRec)ppProfileRec.clone();
            this.selectedPpProfile = this.ppProfile.id;
            if (this.ppProfile.id == 0) {
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_COA_DEFAULT_PROFILE"));
            } else {
                this.labelHeaderBar.setText(UtilLocale.getString("TXT_COA_PROFILE_20") + " #" + this.ppProfile.id);
            }
            this.textFieldName.setText(this.ppProfile.name);
            this.textAreaData.setText(this.ppProfile.data);
            if (this.isEditable) {
                this.setConfigureMode();
                this.checkboxDefault.setEnabled(false);
                if (ppProfileRec.id == 0) {
                    this.checkboxDefault.setSelected(true);
                } else {
                    this.checkboxDefault.setSelected(false);
                }
            } else {
                this.textFieldTimeStamp.setText(this.ppProfile.timeStamp);
            }
        } else {
            this.ppProfile = null;
            this.selectedPpProfile = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_COA_PROFILE"));
            this.textFieldName.setText("");
            this.textAreaData.setText("");
            this.setCreateMode();
            this.checkboxDefault.setSelected(false);
            this.checkboxDefault.setEnabled(!this.ppProfilesMainPanel.isProfileSet(0));
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public PpProfilesHandler.PpProfileRec getPpProfileDetailData() {
        if (this.ppProfile == null) {
            this.ppProfile = new PpProfilesHandler.PpProfileRec();
        }
        if (this.checkboxDefault.isSelected()) {
            this.ppProfile.name = "Default";
            this.ppProfile.id = 0;
        } else {
            this.ppProfile.name = this.textFieldName.getText();
            Object object = this.comboBoxId.getSelectedItem();
            if (object != null) {
                this.ppProfile.id = Integer.valueOf(object.toString());
            }
        }
        this.ppProfile.data = this.textAreaData.getText();
        return this.ppProfile;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedPpProfile() {
        return this.selectedPpProfile;
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

