/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.systemfeatures.SysFeatPpProfilesDetailPanel;
import com.aastra.oamp.systemfeatures.SysFeatPpProfilesTaskPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpProfilesHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.table.TableColumn;

public class SysFeatPpProfilesMainPanel
extends AastraPanel
implements PpProfilesHandler.PpProfilesDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 240;
    protected static final int ySizeDetailPanelSurcharge = 120;
    private static final int ySizeDetailPanel = 330;
    private SysFeatPpProfilesTaskPanel taskPanel = null;
    private SysFeatPpProfilesDetailPanel detailPanel = null;
    private PpProfilesHandler ppProfilesHandler;
    private GuiUtilDetailSplitPanel detailSplitPane = null;
    private AastraScrollPane tablePane = null;
    private GuiUtilConfiguratorTable table = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType;
    private int dividerLocation = 0;
    private int idCurrentMonitorPanel = -1;
    private int idPending = -1;
    private boolean detailPanelPending = false;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public SysFeatPpProfilesMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, PpProfilesHandler ppProfilesHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.ppProfilesHandler = ppProfilesHandler;
        this.ppProfilesHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDetailSplitPane(), "Center");
        this.add((Component)this.getTaskPanel(), "East");
        if (this.isEditable) {
            this.taskPanel.setTaskButtonCreate(true);
        }
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new SysFeatPpProfilesTaskPanel(this, this.guiNavPanelType);
        }
        return this.taskPanel;
    }

    private GuiUtilDetailSplitPanel getDetailSplitPane() {
        if (this.detailSplitPane == null) {
            this.detailSplitPane = new GuiUtilDetailSplitPanel(330);
            this.detailSplitPane.setTopComponent(this.getTablePane());
            this.detailSplitPane.setBottomComponent(null);
            this.detailSplitPane.setPreferredSize(new Dimension(0, 500));
        }
        return this.detailSplitPane;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new AastraScrollPane(this.getTable());
            this.dividerLocation = this.detailSplitPane.getHeight() - 330;
            this.tablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.tablePane;
    }

    private AastraPanel getDetailPanel() {
        if (this.detailPanel == null) {
            this.detailPanel = new SysFeatPpProfilesDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.detailPanel;
    }

    private GuiUtilConfiguratorTable getTable() {
        if (this.table == null) {
            TableColumn tableColumn;
            int[] nArray = new int[]{0, 1, 2, 4};
            if (this.isEditable) {
                this.table = new GuiUtilConfiguratorTable((Object)this, this.ppProfilesHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpProfilesConfig, true);
                tableColumn = this.table.getColumnModel().getColumn(1);
            } else {
                this.table = new GuiUtilConfiguratorTable((Object)this, this.ppProfilesHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthPpProfilesMonitor, 0, true);
                tableColumn = this.table.getColumnModel().getColumn(0);
            }
            this.table.setIconArray(4, GuiUtilIcon.getIconArrayInactiveActive());
            tableColumn.setMinWidth(30);
            tableColumn.setMaxWidth(45);
        }
        return this.table;
    }

    public void removeDetailPanel() {
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing pp profile config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing pp profile monitor detail panel");
            }
            this.dividerLocation = this.detailSplitPane.getDividerLocation();
            this.detailSplitPane.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.taskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove pp profile detail panel, but there is none");
        }
    }

    public void createPpProfile() {
        PpProfilesHandler.PpProfileRec ppProfileRec = this.detailPanel.getPpProfileDetailData();
        this.pendingRemoveDetailPanel(ppProfileRec.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating PpProfile:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + ppProfileRec.id + "','" + ppProfileRec.name + "'");
        this.ppProfilesHandler.sendSetPpProfile(ppProfileRec);
    }

    public void changePpProfile() {
        PpProfilesHandler.PpProfileRec ppProfileRec = this.detailPanel.getPpProfileDetailData();
        this.pendingRemoveDetailPanel(ppProfileRec.id);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing PpProfile [" + ppProfileRec.id + "]:");
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + ppProfileRec.name + "'");
        this.ppProfilesHandler.sendSetPpProfile(ppProfileRec);
    }

    public void deletePpProfile() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, "Delete selected PP Profiles?", true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                PpProfilesHandler.PpProfileRec ppProfileRec = (PpProfilesHandler.PpProfileRec)this.ppProfilesHandler.getDb().getRecordByIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting pp profile[" + ppProfileRec.id + "]");
                ppProfileRec.data = "";
                this.ppProfilesHandler.sendSetPpProfile(ppProfileRec);
                if (this.detailSplitPane.getBottomComponent() == null || this.detailPanel.getSelectedPpProfile() != ppProfileRec.id) continue;
                this.detailPanelPending = true;
                this.idPending = ppProfileRec.id;
            }
        }
    }

    boolean isProfileSet(int n) {
        PpProfilesHandler.PpProfileRec ppProfileRec = ((PpProfilesHandler.PpProfilesDatabase)this.ppProfilesHandler.getDb()).getRecordById(n);
        return ppProfileRec != null;
    }

    public void pendingRemoveDetailPanel(int n) {
        this.detailPanelPending = true;
        this.idPending = n;
    }

    public void createDetailPanel(PpProfilesHandler.PpProfileRec ppProfileRec, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.detailPanelPending = false;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating PP profile config detail panel");
            }
            this.dividerLocation = this.detailSplitPane.getDividerLocation();
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating PP profile config detail panel");
            this.detailSplitPane.setBottomComponent(this.getDetailPanel());
        }
        if (ppProfileRec != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = ppProfileRec.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading PP Profile[" + ppProfileRec.id + "]:");
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "  '" + ppProfileRec.id + "','" + ppProfileRec.name + "'");
            this.detailPanel.setppProfileDetailData(ppProfileRec);
        } else {
            this.detailPanel.setppProfileDetailData(null);
        }
        this.detailSplitPane.setDividerLocation(this.dividerLocation);
        this.detailSplitPane.validate();
        this.taskPanel.setTaskButtonConfigureShow(false);
    }

    public void taskPanelActionConfigure() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            int n2 = this.table.convertRowIndexToModel(n);
            PpProfilesHandler.PpProfileRec ppProfileRec = ((PpProfilesHandler.PpProfilesDatabase)this.ppProfilesHandler.getDb()).getRecordByIdx(n2);
            if (ppProfileRec != null) {
                this.createDetailPanel(ppProfileRec, false);
            }
        }
    }

    public void taskPanelActionDelete() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, "Delete selected PP Profiles?", true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                PpProfilesHandler.PpProfileRec ppProfileRec = ((PpProfilesHandler.PpProfilesDatabase)this.ppProfilesHandler.getDb()).getRecordByIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting PP profile[" + ppProfileRec.id + "]");
                ppProfileRec.data = "";
                this.ppProfilesHandler.sendSetPpProfile(ppProfileRec);
                if (this.detailSplitPane.getBottomComponent() == null) continue;
                PpProfilesHandler.PpProfileRec ppProfileRec2 = this.detailPanel.getPpProfileDetailData();
                if (ppProfileRec2.id != ppProfileRec.id) continue;
                this.detailPanelPending = true;
                this.idPending = ppProfileRec.id;
            }
        }
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        if (this.isEditable) {
            if (this.ppProfilesHandler.getDb().getRecordNumber() == 21) {
                this.taskPanel.setTaskButtonCreate(false);
            } else {
                this.taskPanel.setTaskButtonCreate(true);
            }
        }
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.taskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.taskPanel.setTaskButtonCreate(false);
            this.taskPanel.setTaskButtonDelete(false);
        }
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP profile data notification: " + dataNotificationEnum.toString() + "," + n);
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: 
                        case DATA_CHANGED: {
                            if (!this.detailPanelPending || dataNotificationEnum != DataNotificationEnum.NEW_DATA && (dataNotificationEnum != DataNotificationEnum.DATA_CHANGED || this.idPending != n)) break;
                            this.removeDetailPanel();
                            break;
                        }
                        case DATA_DELETED: {
                            if (!this.detailPanelPending || this.idPending != n) break;
                            this.removeDetailPanel();
                            break;
                        }
                    }
                    if (this.ppProfilesHandler.getDb().getRecordNumber() == 21) {
                        this.taskPanel.setTaskButtonCreate(false);
                        break;
                    }
                    this.taskPanel.setTaskButtonCreate(true);
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        PpProfilesHandler.PpProfileRec ppProfileRec = ((PpProfilesHandler.PpProfilesDatabase)this.ppProfilesHandler.getDb()).getRecordById(n);
                        if (ppProfileRec != null) {
                            this.createDetailPanel(ppProfileRec, false);
                            break block0;
                        }
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading pp Profile[" + n + "] failed");
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP profile error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "PP profile error notification: Unknown errorCode=" + string);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string4 = null;
                    if (string2 != null && this.detailPanel != null) {
                        string4 = this.detailPanel.getErrorLabelText(string2);
                        GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
                    }
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string2 == null || this.detailPanel == null) break;
                this.detailPanel.markErrorComponent(string2);
                break;
            }
            case DATA_DELETED: {
                if (errorCodes2 != null) {
                    GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, null, null));
                    break;
                }
                GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                break;
            }
        }
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.detailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                PpProfilesHandler.PpProfileRec ppProfileRec = (PpProfilesHandler.PpProfileRec)dataRecord;
                this.createDetailPanel(ppProfileRec, false);
            } else {
                this.removeDetailPanel();
            }
        } else if (n == 1) {
            this.taskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.taskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n >= 1) {
                this.taskPanel.setTaskButtonDelete(true);
            } else {
                this.taskPanel.setTaskButtonDelete(false);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.detailSplitPane.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeDetailPanel();
        }
        this.taskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        PpProfilesHandler.PpProfileRec ppProfileRec = (PpProfilesHandler.PpProfileRec)dataRecord;
        this.createDetailPanel(ppProfileRec, false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }
}

