/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.systemfeatures;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilPasswordField;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.systemfeatures.SysFeatXMLApplicationMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.XMLApplicationHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SysFeatXMLApplicationDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private SysFeatXMLApplicationMainPanel xmlApplicationMainPanel = null;
    private XMLApplicationHandler.XMLApplRec xmlApplRec = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int selectedXMLApplication = -1;
    private String dummyPassword = "1234567";
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraLabel labelActive = null;
    private GuiUtilCheckBox checkBoxActive = null;
    private AastraLabel labelName = null;
    private GuiUtilTextField textFieldName = null;
    private AastraLabel labelProtocol = null;
    private GuiUtilComboBox comboBoxProtocol = null;
    private AastraLabel labelServer = null;
    private GuiUtilTextField textFieldServer = null;
    private AastraLabel labelUserName = null;
    private GuiUtilTextField textFieldUserName = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordField passwordFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordField passwordFieldPasswordConfirm = null;
    private AastraLabel labelPath = null;
    private GuiUtilTextField textFieldPath = null;
    private boolean isEditable = true;
    private GuiUtilTextField textFieldUrlPort = null;
    private GuiUtilCheckBox checkBoxDefaultPort = null;
    private ActionModeEnum actionMode;

    public SysFeatXMLApplicationDetailPanel(SysFeatXMLApplicationMainPanel sysFeatXMLApplicationMainPanel, GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, UtilErrorComp utilErrorComp) {
        super(285, 210);
        this.xmlApplicationMainPanel = sysFeatXMLApplicationMainPanel;
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private GuiUtilCheckBox getCheckBoxActive() {
        if (this.checkBoxActive == null) {
            this.checkBoxActive = new GuiUtilCheckBox(this.utilChangeHandler, 165, 15);
        }
        return this.checkBoxActive;
    }

    private GuiUtilTextField getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldName.setBounds(170, 45, 240, 18);
        }
        return this.textFieldName;
    }

    private GuiUtilComboBox getComboBoxProtocol() {
        if (this.comboBoxProtocol == null) {
            this.comboBoxProtocol = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxProtocol.setBounds(170, 75, 90, 20);
            if (OmiMessage.ProtType.HTTP.isValid().booleanValue()) {
                this.comboBoxProtocol.addItem(OmiMessage.ProtType.HTTP);
            }
            if (OmiMessage.ProtType.HTTPS.isValid().booleanValue()) {
                this.comboBoxProtocol.addItem(OmiMessage.ProtType.HTTPS);
            }
            this.comboBoxProtocol.activateActionListener();
        }
        return this.comboBoxProtocol;
    }

    private GuiUtilTextField getTextFieldServer() {
        if (this.textFieldServer == null) {
            this.textFieldServer = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldServer.setBounds(170, 135, 400, 18);
        }
        return this.textFieldServer;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldUserName.setBounds(170, 165, 240, 18);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordField getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPassword.setBounds(170, 195, 240, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordField(this.utilChangeHandler);
            this.passwordFieldPasswordConfirm.setBounds(170, 225, 240, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private GuiUtilTextField getTextFieldPath() {
        if (this.textFieldPath == null) {
            this.textFieldPath = new GuiUtilTextField(this.utilChangeHandler);
            this.textFieldPath.setBounds(170, 255, 400, 18);
        }
        return this.textFieldPath;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SysFeatXMLApplicationDetailPanel.this.utilChangeHandler.deactivate();
                    SysFeatXMLApplicationDetailPanel.this.utilErrorComp.clearComponents();
                    if (SysFeatXMLApplicationDetailPanel.this.actionMode == ActionModeEnum.CHANGE) {
                        SysFeatXMLApplicationDetailPanel.this.xmlApplicationMainPanel.changeXMLApplication();
                    } else {
                        SysFeatXMLApplicationDetailPanel.this.xmlApplicationMainPanel.createXMLApplication();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            if (this.isEditable) {
                this.buttonCancel.setBounds(230, 15, 90, 25);
            } else {
                this.buttonCancel.setBounds(150, 15, 90, 25);
            }
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SysFeatXMLApplicationDetailPanel.this.isEditable) {
                        SysFeatXMLApplicationDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    SysFeatXMLApplicationDetailPanel.this.xmlApplicationMainPanel.removeXMLApplicationDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.labelActive = new AastraLabel();
            this.labelActive.setBounds(30, 15, 120, 16);
            this.labelActive.setText(UtilLocale.getString("TXT_ACTIVE"));
            this.labelName = new AastraLabel();
            this.labelName.setBounds(30, 45, 120, 16);
            this.labelName.setText(UtilLocale.getString("TXT_NAME"));
            this.labelProtocol = new AastraLabel();
            this.labelProtocol.setBounds(30, 75, 120, 16);
            this.labelProtocol.setText(UtilLocale.getString("TXT_PROTOCOL"));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 105, 120, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_PORT"));
            this.textFieldUrlPort = this.isEditable ? new GuiUtilTextField(this.utilChangeHandler) : new GuiUtilTextField();
            this.textFieldUrlPort.setBounds(170, 105, 70, 18);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(250, 105, 145, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_USE_DEFAULT_PORT"));
            aastraLabel2.setHorizontalAlignment(4);
            this.checkBoxDefaultPort = new GuiUtilCheckBox(this.utilChangeHandler, 395, 102);
            if (this.isEditable) {
                this.checkBoxDefaultPort.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SysFeatXMLApplicationDetailPanel.this.checkBoxDefaultPort.isSelected()) {
                            SysFeatXMLApplicationDetailPanel.this.textFieldUrlPort.setText("");
                            SysFeatXMLApplicationDetailPanel.this.textFieldUrlPort.setEnabled(false);
                        } else {
                            SysFeatXMLApplicationDetailPanel.this.textFieldUrlPort.setEnabled(true);
                        }
                    }
                });
            }
            this.labelServer = new AastraLabel();
            this.labelServer.setBounds(30, 135, 120, 16);
            this.labelServer.setText(UtilLocale.getString("TXT_SERVER"));
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(30, 165, 120, 16);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(30, 195, 120, 16);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setBounds(30, 225, 120, 32);
            this.labelPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.labelPath = new AastraLabel();
            this.labelPath.setBounds(30, 255, 120, 32);
            this.labelPath.setText("<html>" + UtilLocale.getString("TXT_PATH_AND_PARAMETERS") + "</html>");
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            this.tabGeneral.add((Component)this.labelActive, null);
            this.tabGeneral.add((Component)this.getCheckBoxActive(), null);
            this.tabGeneral.add((Component)this.labelName, null);
            this.tabGeneral.add((Component)this.getTextFieldName(), null);
            this.tabGeneral.add((Component)this.labelProtocol, null);
            this.tabGeneral.add((Component)this.getComboBoxProtocol(), null);
            this.tabGeneral.add(aastraLabel);
            this.tabGeneral.add(aastraLabel2);
            this.tabGeneral.add(this.checkBoxDefaultPort);
            this.tabGeneral.add(this.textFieldUrlPort);
            this.tabGeneral.add((Component)this.labelServer, null);
            this.tabGeneral.add((Component)this.getTextFieldServer(), null);
            this.tabGeneral.add((Component)this.labelUserName, null);
            this.tabGeneral.add((Component)this.getTextFieldUserName(), null);
            this.tabGeneral.add((Component)this.labelPassword, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPassword(), null);
            this.tabGeneral.add((Component)this.labelPasswordConfirm, null);
            this.tabGeneral.add((Component)this.getPasswordFieldPasswordConfirm(), null);
            this.tabGeneral.add((Component)this.labelPath, null);
            this.tabGeneral.add((Component)this.getTextFieldPath(), null);
            if (this.isEditable) {
                this.utilErrorComp.put(OmiMessage.XMLApplicationType.name.toString(), this.labelName, this.textFieldName);
                this.utilErrorComp.put(OmiMessage.URLType.port.toString(), aastraLabel, this.textFieldUrlPort);
                this.utilErrorComp.put(OmiMessage.URLType.host.toString(), this.labelServer, this.textFieldServer);
                this.utilErrorComp.put(OmiMessage.URLType.username.toString(), this.labelUserName, this.textFieldUserName);
                this.utilErrorComp.put(OmiMessage.URLType.password.toString(), this.labelPassword, this.passwordFieldPassword);
                this.utilErrorComp.put("passwordConfirm", this.labelPasswordConfirm, this.passwordFieldPasswordConfirm);
                this.utilErrorComp.put(OmiMessage.URLType.path.toString(), this.labelPath, this.textFieldPath);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    public void setXMLApplicationDetailData(XMLApplicationHandler.XMLApplRec xMLApplRec) {
        if (xMLApplRec != null) {
            this.xmlApplRec = xMLApplRec.clone();
            this.selectedXMLApplication = this.xmlApplRec.id;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_XML_APPLICATION") + " #" + this.xmlApplRec.id);
            this.checkBoxActive.setSelected(this.xmlApplRec.enable);
            this.textFieldName.setText(this.xmlApplRec.name);
            if (this.isEditable) {
                this.checkBoxActive.requestFocusInWindow();
            }
            this.comboBoxProtocol.deactivateActionListener();
            this.comboBoxProtocol.setSelectedItem((Object)this.xmlApplRec.url.protocol);
            this.comboBoxProtocol.activateActionListener();
            this.textFieldServer.setText(this.xmlApplRec.url.host);
            this.textFieldUserName.setText(this.xmlApplRec.url.username);
            this.textFieldPath.setText(this.xmlApplRec.url.path);
            if (this.xmlApplRec.url.port != null) {
                if (this.xmlApplRec.url.port == 0) {
                    this.textFieldUrlPort.setText("");
                    this.checkBoxDefaultPort.setSelected(true);
                } else {
                    this.textFieldUrlPort.setText("" + this.xmlApplRec.url.port);
                    this.checkBoxDefaultPort.setSelected(false);
                }
            } else {
                this.textFieldUrlPort.setText("");
                this.checkBoxDefaultPort.setSelected(true);
            }
            String string = this.xmlApplRec.url.password;
            if (string != null && string.length() > 0) {
                this.passwordFieldPassword.setText(this.dummyPassword);
                this.passwordFieldPasswordConfirm.setText(this.dummyPassword);
            } else {
                this.passwordFieldPassword.setText("");
                this.passwordFieldPasswordConfirm.setText("");
            }
            if (this.isEditable) {
                boolean bl = this.xmlApplRec.type == OmiMessage.XMLApplicationTypeType.Dynamic;
                this.textFieldName.setEditable(bl);
                bl = this.xmlApplRec.type == OmiMessage.XMLApplicationTypeType.Dynamic || this.xmlApplRec.type == OmiMessage.XMLApplicationTypeType.BuiltIn;
                this.checkBoxActive.setEnabled(bl);
                this.comboBoxProtocol.setEnabled(bl);
                this.textFieldServer.setEditable(bl);
                this.textFieldUrlPort.setEditable(bl);
                this.checkBoxDefaultPort.setEnabled(bl);
                this.textFieldUserName.setEditable(bl);
                this.textFieldPath.setEditable(bl);
                this.passwordFieldPassword.setEditable(bl);
                this.passwordFieldPasswordConfirm.setEditable(bl);
            }
            this.actionMode = ActionModeEnum.CHANGE;
        } else {
            this.xmlApplRec = null;
            this.selectedXMLApplication = -1;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_XML_APPLICATION"));
            this.checkBoxActive.setSelected(true);
            this.textFieldName.setText("");
            this.comboBoxProtocol.setSelectedIndex(0);
            this.textFieldServer.setText("");
            this.textFieldUserName.setText("");
            this.passwordFieldPassword.setText("");
            this.passwordFieldPasswordConfirm.setText("");
            this.textFieldPath.setText("");
            this.textFieldUrlPort.setText("");
            this.checkBoxDefaultPort.setSelected(true);
            this.textFieldName.setEditable(true);
            this.checkBoxActive.setEnabled(true);
            this.comboBoxProtocol.setEnabled(true);
            this.textFieldServer.setEditable(true);
            this.textFieldUserName.setEditable(true);
            this.textFieldPath.setEditable(true);
            this.textFieldUrlPort.setEditable(true);
            this.checkBoxDefaultPort.setEnabled(true);
            this.passwordFieldPassword.setEditable(true);
            this.passwordFieldPasswordConfirm.setEditable(true);
            this.textFieldName.requestFocusInWindow();
            this.actionMode = ActionModeEnum.CREATE;
        }
        if (this.isEditable) {
            this.utilChangeHandler.initRootPane(this.getRootPane());
        } else {
            this.getButtonCancel().requestFocusInWindow();
        }
        this.getRootPane().setDefaultButton(this.getButtonCancel());
    }

    public XMLApplicationHandler.XMLApplRec getXMLApplicationDetailData() {
        if (this.xmlApplRec == null) {
            this.xmlApplRec = new XMLApplicationHandler.XMLApplRec();
            this.xmlApplRec.type = OmiMessage.XMLApplicationTypeType.Dynamic;
            this.xmlApplRec.url = new CommonDataHandler.UrlClass();
        }
        this.xmlApplRec.enable = this.checkBoxActive.isSelected();
        this.xmlApplRec.name = this.textFieldName.getText();
        this.xmlApplRec.url.protocol = (OmiMessage.ProtType)((Object)this.comboBoxProtocol.getSelectedItem());
        this.xmlApplRec.url.host = this.textFieldServer.getText();
        this.xmlApplRec.url.username = this.textFieldUserName.getText();
        this.xmlApplRec.url.path = this.textFieldPath.getText();
        if (this.checkBoxDefaultPort.isSelected()) {
            this.xmlApplRec.url.port = 0;
        } else {
            int n = 0;
            n = UtilMisc.getIntFromTextField(this.textFieldUrlPort, UtilLocale.getString("TXT_PORT"), this.utilErrorComp, 10);
            if (n == -1) {
                this.markErrorComponent(UtilLocale.getString("TXT_PORT"));
                return null;
            }
            this.xmlApplRec.url.port = n;
        }
        String string = new String(this.passwordFieldPassword.getPassword());
        if (string.equals(new String(this.passwordFieldPasswordConfirm.getPassword()))) {
            if (string.equals(this.dummyPassword)) {
                this.xmlApplRec.url.password = null;
                this.xmlApplRec.url.passwordChanged = false;
            } else {
                this.xmlApplRec.url.password = string;
                this.xmlApplRec.url.passwordChanged = true;
            }
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
            this.markErrorComponent("passwordConfirm");
            return null;
        }
        return this.xmlApplRec;
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public int getSelectedXMLApplication() {
        return this.selectedXMLApplication;
    }

    private static enum ActionModeEnum {
        CREATE,
        CHANGE;

    }
}

