/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.util;

import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.OmiMessage;

public class UtilErrorHandling {
    public static String getErrorMessage(OmiMessage.errorCodes errorCodes2, String string, String string2) {
        String string3;
        switch (errorCodes2) {
            case EInval: {
                if (string != null) {
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_INVALID"), string);
                    if (string2 == null) break;
                    string3 = string3 + " " + String.format(UtilLocale.getString("TXT_LENGTH_MUST_BE_EXACT_*_CHARACTERS"), string2);
                    break;
                }
                string3 = UtilLocale.getString("TXT_UNKNOWN_PARAMETER_INVALID");
                break;
            }
            case EInvalidChars: {
                if (string != null) {
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_CONTAINS_INVALID_CHARS"), string);
                    break;
                }
                string3 = UtilLocale.getString("TXT_UNKNOWN_PARAMETER_CONTAINS_INVALID_CHARS");
                break;
            }
            case ETooLong: {
                if (string != null && string2 != null) {
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_TOO_LONG") + " ", string);
                    string3 = string3 + String.format(UtilLocale.getString("TXT_ONLY_*_CHARACTERS_ALLOWED"), string2);
                    break;
                }
                if (string != null) {
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_TOO_LONG"), string);
                    break;
                }
                string3 = UtilLocale.getString("TXT_UNKNOWN_PARAMETER_TOO_LONG");
                break;
            }
            case EMissing: {
                if (string != null) {
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), string);
                    break;
                }
                string3 = UtilLocale.getString("TXT_UNKNOWN_PARAMETER_MISSING");
                break;
            }
            case EPerm: {
                string3 = UtilLocale.getString("TXT_NO_SUFFICIENT_PERMISSION");
                break;
            }
            case EFailed: {
                string3 = UtilLocale.getString("TXT_FAILED");
                break;
            }
            case EExist: 
            case InternalEExistNotUnique: {
                if (string != null) {
                    if (errorCodes2 == OmiMessage.errorCodes.InternalEExistNotUnique) {
                        string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_VALUE_ALREADY_IN_USE_OR_NOT_UNIQUE"), string);
                        break;
                    }
                    string3 = String.format(UtilLocale.getString("TXT_PARAMETER_*_VALUE_ALREADY_IN_USE"), string);
                    break;
                }
                string3 = String.format(UtilLocale.getString("TXT_UNKNOWN_PARAMETER_ALREADY_EXISTS"), new Object[0]);
                break;
            }
            case EAreaFull: {
                string3 = UtilLocale.getString("TXT_PAGING_AREA_COMPLETELY_CONFIGURED");
                break;
            }
            case ENoMem: {
                string3 = UtilLocale.getString("TXT_SYSTEM_IS_COMPLETELY_CONFIGURED");
                break;
            }
            case EVersion: {
                if (string != null && string2 != null) {
                    string3 = String.format(UtilLocale.getString("TXT_APPLICATION_*_INCOMPATIBLE_WITH_OMM_*"), string, string2);
                    break;
                }
                string3 = UtilLocale.getString("TXT_REQUESTED_VERSION_NOT_SUPPORTED");
                break;
            }
            case ENoEnt: {
                string3 = UtilLocale.getString("TXT_NO_RECORD_FOUND_FOR_GIVEN_KEY");
                break;
            }
            case EAuth: {
                string3 = UtilLocale.getString("TXT_AUTHENTICATION_INVALID");
                break;
            }
            case EWouldBlock: {
                string3 = UtilLocale.getString("TXT_REQUEST_CANNOT_BE_FULFILLED_CURRENTLY");
                break;
            }
            case EForbidden: {
                if (string != null) {
                    if (string.equals(OmiMessage.PPUserType.relType.toString())) {
                        string3 = UtilLocale.getString("TXT_CHANGING_RELATION_TYPE_NOT_ALLOWED");
                        break;
                    }
                    if (string.equals(OmiMessage.attribIds.installationId.toString())) {
                        string3 = String.format(UtilLocale.getString("TXT_LICENSE_IMPORT_NOT_ALLOWED"), new Object[0]);
                        break;
                    }
                    string3 = String.format(UtilLocale.getString("TXT_OPERATION_NOT_ALLOWED_FOR_PARAMETER_*"), string);
                    break;
                }
                string3 = UtilLocale.getString("TXT_OPERATION_NOT_ALLOWED");
                break;
            }
            case EInProgress: {
                string3 = UtilLocale.getString("TXT_ANOTHER_OPERATION_IN_PROGRESS");
                break;
            }
            case ELicense: {
                string3 = UtilLocale.getString("TXT_OPERATION_NOT_ALLOWED_DUE_TO_LICENSE_RESTRICTIONS");
                break;
            }
            case ELicenseFile: {
                string3 = UtilLocale.getString("TXT_LICENSE_FILE_INVALID");
                break;
            }
            case EEncryptNotAllowed: {
                string3 = UtilLocale.getString("TXT_ENCRYPTION_NOT_ALLOWED");
                break;
            }
            case EPwEmpty: {
                string3 = UtilLocale.getString("TXT_PASSWORD_NOT_SET");
                break;
            }
            case EPwUnchanged: {
                string3 = UtilLocale.getString("TXT_PASSWORD_EQUAL_TO_OLD_ONE");
                break;
            }
            case EPwTooSimilar: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_SIMILAR_TO_OLD_ONE");
                break;
            }
            case EPwTooShort: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_SHORT");
                break;
            }
            case EPwSimilarToName: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_SIMILAR_TO_USER_NAME");
                break;
            }
            case EPwSimilarToHost: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_SIMILAR_TO_HOST_NAME");
                break;
            }
            case EPwTooManySimilarChars: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_MANY_SIMILAR_CHARS");
                break;
            }
            case EPwTooWeak: {
                string3 = UtilLocale.getString("TXT_PASSWORD_TOO_WEAK");
                break;
            }
            case EDectRegDomainInvalid: {
                string3 = UtilLocale.getString("TXT_DECT_REGULATORY_DOMAIN_NOT_CONFIGURED");
                break;
            }
            case EWlanRegDomainInvalid: {
                string3 = UtilLocale.getString("TXT_WLAN_REGULATORY_DOMAIN_NOT_CONFIGURED");
                break;
            }
            case ELicenseWrongInstallId: {
                string3 = UtilLocale.getString("TXT_CONFIGURED_INSTALLATION_ID_DOES_NOT_FIT_TO_THE_LICENSE_FILE");
                break;
            }
            default: {
                string3 = UtilLocale.getString("TXT_UNKNOWN_ERROR");
            }
        }
        return string3;
    }
}

