/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.util;

import com.aastra.oamp.util.UtilPreferences;
import com.aastra.util.UtilSpy;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UtilLocale {
    private static final String BUNDLE_NAME = "com.aastra.oamp.txt.messages";
    private static ResourceBundle resourceBundle;
    public static int English;
    public static int German;
    public static int French;
    public static int Spanish;
    public static Languages[] languages;

    public static void initLocale() {
        Locale locale = UtilPreferences.getLocale();
        Locale locale2 = null;
        resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        locale2 = resourceBundle.getLocale();
        if (locale.equals(locale2)) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Locale initialized to '" + locale2.toString() + "'");
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Locale '" + locale.toString() + "' not found and set to '" + locale2.toString() + "'");
            UtilPreferences.setLocale(locale2);
        }
    }

    public static void setLocale(Locale locale) {
        resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        Locale locale2 = resourceBundle.getLocale();
        if (locale2 == locale) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Locale set to '" + locale2.toString() + "'");
            UtilPreferences.setLocale(locale2);
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Locale not found and set to '" + locale2.toString() + "'");
            UtilPreferences.setLocale(locale2);
        }
    }

    public static String getString(String string) {
        try {
            String string2 = resourceBundle.getString(string);
            String string3 = null;
            if (string2.length() > 2 && string2.charAt(0) == '!' && string2.charAt(1) == '!') {
                string3 = string2.substring(2);
                return string3;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }

    public static String getStringLanguage(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        if (resourceBundle != null) {
            try {
                String string2 = resourceBundle.getString(string);
                String string3 = null;
                if (string2.length() > 2 && string2.charAt(0) == '!' && string2.charAt(1) == '!') {
                    string3 = string2.substring(2);
                    return string3;
                }
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                return '!' + string + '!';
            }
        }
        return '!' + string + '!';
    }

    static {
        English = 0;
        German = 1;
        French = 2;
        Spanish = 3;
        languages = new Languages[]{new Languages("English", new Locale("en", "US")), new Languages("Deutsch", new Locale("de", "DE")), new Languages("Fran\u00e7ais", new Locale("fr", "FR")), new Languages("Espa\u00f1ol", new Locale("es", "ES"))};
    }

    public static enum RegionType {
        US,
        DE,
        FR,
        ES;

    }

    public static enum LanguageType {
        en,
        de,
        fr,
        es;

    }

    public static class Languages {
        private String strLanguage;
        private Locale locale;

        public Languages(String string, Locale locale) {
            this.strLanguage = string;
            this.locale = locale;
        }

        public String getStrLanguage() {
            return this.strLanguage;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

