/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.videodev;

import com.aastra.oamp.gui.GuiComponentActivationInterface;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.gui.GuiProgressDlgCancel;
import com.aastra.oamp.gui.GuiStatusBar;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilFilterTable;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilPrint;
import com.aastra.oamp.videodev.VideoDevConfigDetailPanel;
import com.aastra.oamp.videodev.VideoDevConfigTaskPanel;
import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.VideoDevHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.BitSet;
import java.util.HashMap;

public class VideoDevConfigMainPanel
extends AastraPanel
implements VideoDevHandler.VideoDevNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
GuiComponentActivationInterface,
DataHandler.DataHandlerSendBulkInterface,
GuiProgressDlgCancel.GuiProgressDlgCancelInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 150;
    protected static final int ySizeDetailPanel = 360;
    private VideoDevHandler videoDevHandler = null;
    private VideoDevHandler.VideoDevDatabase videoDevDatabase = null;
    private GuiStatusBar guiStatusBar = null;
    private GuiUtilDetailSplitPanel videoDevDetailSplitPane = null;
    private AastraScrollPane videoDevTablePane = null;
    private VideoDevConfigDetailPanel videoDevDetailPanel = null;
    private VideoDevConfigTaskPanel videoDevTaskPanel = null;
    private GuiUtilConfiguratorTable videoDevTable = null;
    private boolean detailPanelPending = false;
    private HashMap<Integer, Boolean> videoDevIdsPending = new HashMap();
    private int dividerLocation = 0;
    private GuiProgressDlgCancel guiProgressDlg = null;
    private int cntNotificationsToReceive = 0;
    private VideoDevHandler.VideoDevRec[] videoDevRecordsChange = null;
    private int cntVideoDevsSendBulkTotal;
    private DataHandler.SendBulkActionType sendBulkAction = null;
    private UtilErrorComp utilErrorComp = null;
    public static int[] videoDevTableConfigIdxArray = new int[]{0, 1, 2, 3, 6, 8, 9, 10, 11, 4, 5, 15};
    public static int[] videoDevTableConfigIdxArrayDefault = new int[]{0, 6, 2, 9, 10, 11, 4, 5};

    public VideoDevConfigMainPanel(VideoDevHandler videoDevHandler) {
        this.videoDevHandler = videoDevHandler;
        this.guiStatusBar = GuiMain.getGuiStatusBarObject();
        this.videoDevHandler.registerDataNotificationListener(this);
        this.videoDevDatabase = this.videoDevHandler.getDb();
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getVideoDevDetailSplitPane(), "Center");
        this.add((Component)this.getVideoDevTaskPanel(), "East");
        this.utilErrorComp = new UtilErrorComp();
    }

    public void setDetailPanelPending() {
        this.detailPanelPending = true;
    }

    public void clearDetailPanelPending() {
        this.detailPanelPending = false;
        this.videoDevIdsPending.clear();
    }

    private void processTableEvent() {
        boolean bl;
        boolean bl2;
        int n = this.videoDevTable.getSelectedRowCount();
        int[] nArray = this.videoDevTable.getSelectedRows();
        if (n > 0) {
            bl2 = true;
            DataRecord[] dataRecordArray = new DataRecord[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.videoDevTable.convertRowIndexToModel(nArray[i]);
                dataRecordArray[i] = this.videoDevDatabase.getRecordByIdx(n2);
                OmiMessage.VideoDevStateType videoDevStateType = (OmiMessage.VideoDevStateType)((Object)((VideoDevHandler.VideoDevRec)dataRecordArray[i]).getField(5));
                if (videoDevStateType == null || videoDevStateType == OmiMessage.VideoDevStateType.unplugged) continue;
                bl2 = false;
            }
            if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
                this.createVideoDevDetailPanel(dataRecordArray);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            bl = false;
            bl2 = false;
            if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
                this.removeVideoDevDetailPanel();
            }
        }
        this.videoDevTaskPanel.setTaskButtonConfigure(bl);
        this.videoDevTaskPanel.setTaskButtonDelete(bl2);
    }

    public void configureVideoDev() {
        int n = this.videoDevTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.videoDevTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.videoDevTable.convertRowIndexToModel(nArray[i]);
            VideoDevHandler.VideoDevRec videoDevRec = this.videoDevDatabase.getRecordByIdx(n2);
            dataRecordArray[i] = videoDevRec;
        }
        this.createVideoDevDetailPanel(dataRecordArray);
    }

    private GuiUtilDetailSplitPanel getVideoDevDetailSplitPane() {
        if (this.videoDevDetailSplitPane == null) {
            this.videoDevDetailSplitPane = new GuiUtilDetailSplitPanel(360);
            this.videoDevDetailSplitPane.setTopComponent(this.getVideoDevTablePane());
            this.videoDevDetailSplitPane.setBottomComponent(null);
        }
        return this.videoDevDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getVideoDevTable() {
        if (this.videoDevTable == null) {
            this.videoDevTable = new GuiUtilConfiguratorTable((Object)this, (Database)this.videoDevDatabase, videoDevTableConfigIdxArray, this.getActiveVideoDevConfigColumns(), UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthVideoDevConfig);
            this.videoDevTable.setColumnFormatString(0, "0x%03X");
            this.videoDevTable.setColumnFormatString(2, "0x%03X");
            this.videoDevTable.setIconArray(4, GuiUtilIcon.getIconArrayInactiveActive());
            this.videoDevTable.setIconArray(5, GuiUtilIcon.getIconArray_Disconnect_OK_Eye_Error());
            this.videoDevTable.setPreferredColumnWidth(2, 30);
            this.videoDevTable.setPreferredColumnWidth(4, 35);
            this.videoDevTable.setPreferredColumnWidth(5, 25);
            this.videoDevTable.applyPreferredColumnWidthSettings();
        }
        return this.videoDevTable;
    }

    private AastraScrollPane getVideoDevTablePane() {
        if (this.videoDevTablePane == null) {
            this.videoDevTablePane = new AastraScrollPane(this.getVideoDevTable());
            this.dividerLocation = this.videoDevDetailSplitPane.getHeight() - 360;
            this.videoDevTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.videoDevTablePane;
    }

    private int[] getActiveVideoDevConfigColumns() {
        int n = 0;
        int[] nArray = null;
        int[] nArray2 = videoDevTableConfigIdxArray;
        BitSet bitSet = UtilPreferences.getTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectVideoDevConfig);
        if (bitSet != null) {
            nArray = new int[bitSet.cardinality()];
            for (int i = 0; i < nArray2.length; ++i) {
                if (!bitSet.get(i)) continue;
                nArray[n++] = nArray2[i];
            }
        } else {
            nArray = videoDevTableConfigIdxArrayDefault;
            if (bitSet == null) {
                bitSet = new BitSet();
            }
            block1: for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    if (nArray[i] != nArray2[j]) continue;
                    bitSet.set(j);
                    continue block1;
                }
            }
            UtilPreferences.setTableColumnsSelection(UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectVideoDevConfig, bitSet);
        }
        return nArray;
    }

    private void enableTableAccess() {
        this.videoDevTable.setActive(true);
        this.videoDevTaskPanel.setTaskButtonCreate(true);
        this.videoDevTaskPanel.setTaskButtonFilter(true);
        this.videoDevTaskPanel.setTaskButtonConfigureTable(true);
    }

    private void disableTableAccess() {
        this.videoDevTable.setActive(false);
        this.videoDevTaskPanel.setTaskButtonCreate(false);
        this.videoDevTaskPanel.setTaskButtonConfigure(false);
        this.videoDevTaskPanel.setTaskButtonDelete(false);
        this.videoDevTaskPanel.setTaskButtonFilter(false);
        this.videoDevTaskPanel.setTaskButtonConfigureTable(false);
    }

    protected void configureTableFilter() {
        boolean bl = UtilFilterTable.setFilterItems(this.videoDevTable, videoDevTableConfigIdxArray, UtilPreferences.getTableFilterValues(UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesVideoDevConfig));
        this.videoDevTaskPanel.setTaskButtonFilterState(bl, null);
    }

    private AastraPanel getVideoDevDetailPanel() {
        if (this.videoDevDetailPanel == null) {
            this.videoDevDetailPanel = new VideoDevConfigDetailPanel(this, this.utilErrorComp);
        }
        return this.videoDevDetailPanel;
    }

    private AastraPanel getVideoDevTaskPanel() {
        if (this.videoDevTaskPanel == null) {
            this.videoDevTaskPanel = new VideoDevConfigTaskPanel(this, this.getVideoDevTable());
        }
        return this.videoDevTaskPanel;
    }

    public void startVideoDevCreation() {
        this.videoDevTable.removeRowSelectionAll();
        this.createVideoDevDetailPanel(null);
    }

    private void createVideoDevDetailPanel(DataRecord[] dataRecordArray) {
        if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
            this.clearDetailPanelPending();
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            this.utilErrorComp.clearComponents();
            this.dividerLocation = this.videoDevDetailSplitPane.getDividerLocation();
            if (dataRecordArray == null) {
                this.videoDevDetailPanel.setDefaultTab();
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating video device config detail panel");
        } else {
            this.videoDevDetailSplitPane.setBottomComponent(this.getVideoDevDetailPanel());
            this.videoDevDetailPanel.setDefaultTab();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating video device config detail panel");
        }
        if (dataRecordArray != null) {
            for (int i = 0; i < dataRecordArray.length; ++i) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading video device[" + (Integer)dataRecordArray[i].getField(0) + "]:");
                UtilPrint.printVideoDevRecordString((VideoDevHandler.VideoDevRec)dataRecordArray[i], this);
            }
            this.videoDevDetailPanel.setVideoDevDetailData(dataRecordArray);
        } else {
            this.videoDevDetailPanel.setVideoDevDetailData(null);
        }
        this.videoDevDetailPanel.requestDefaultFocusInWindow();
        this.videoDevDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.videoDevDetailSplitPane.validate();
        this.videoDevTaskPanel.setTaskButtonConfigure(false);
    }

    public void removeVideoDevDetailPanel() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing video device config detail panel");
        this.clearDetailPanelPending();
        this.dividerLocation = this.videoDevDetailSplitPane.getDividerLocation();
        this.videoDevDetailSplitPane.setBottomComponent(null);
        this.utilErrorComp.clearComponents();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.videoDevTable.getSelectedRow() >= 0) {
            this.videoDevTaskPanel.setTaskButtonConfigure(true);
        } else {
            this.videoDevTaskPanel.setTaskButtonConfigure(false);
        }
    }

    public boolean createVideoDev() {
        DataRecord[] dataRecordArray = this.videoDevDetailPanel.getVideoDevDetailData();
        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
        VideoDevHandler.VideoDevRec videoDevRec = (VideoDevHandler.VideoDevRec)dataRecordArray[0];
        if (videoDevRec != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating video device:");
            UtilPrint.printVideoDevRecordString(videoDevRec, this);
            this.videoDevHandler.sendCreateVideoDev(videoDevRec);
            this.setDetailPanelPending();
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating video device failed: No video device data record");
            this.removeVideoDevDetailPanel();
        }
        return true;
    }

    public boolean changeVideoDev() {
        int n;
        DataRecord[] dataRecordArray = this.videoDevDetailPanel.getVideoDevDetailData();
        this.cntVideoDevsSendBulkTotal = 0;
        for (n = 0; n < dataRecordArray.length; ++n) {
            if (!((VideoDevHandler.VideoDevRec)dataRecordArray[n]).getRecordChanged()) continue;
            ++this.cntVideoDevsSendBulkTotal;
            ++this.cntNotificationsToReceive;
            this.videoDevIdsPending.put((Integer)dataRecordArray[n].getField(0), false);
        }
        if (this.cntVideoDevsSendBulkTotal > 0) {
            n = 0;
            this.videoDevRecordsChange = new VideoDevHandler.VideoDevRec[this.cntVideoDevsSendBulkTotal];
            for (int i = 0; i < dataRecordArray.length; ++i) {
                if (!((VideoDevHandler.VideoDevRec)dataRecordArray[i]).getRecordChanged()) continue;
                this.videoDevRecordsChange[n++] = (VideoDevHandler.VideoDevRec)dataRecordArray[i];
            }
            if (this.cntVideoDevsSendBulkTotal == 1) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing videodev[%d]\n", this.videoDevRecordsChange[0].getField(0)));
            } else {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Changing %d video devices\n", this.cntVideoDevsSendBulkTotal));
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Change;
            this.videoDevHandler.sendChangeDeleteDevs(this.sendBulkAction, this.videoDevRecordsChange, this);
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_BUSY, null);
            this.setDetailPanelPending();
            if (this.cntVideoDevsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_CHANGING_VIDEO_DEVICES_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing video device(s): OMILIB told us there is nothing to do (all attributes are unchanged)");
            this.removeVideoDevDetailPanel();
        }
        return true;
    }

    public void deleteVideoDev() {
        GuiUtilDialog guiUtilDialog;
        int n = this.videoDevTable.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_VIDEO_DEVICES_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.videoDevTable.getSelectedRows();
            this.cntVideoDevsSendBulkTotal = nArray.length;
            this.cntNotificationsToReceive = nArray.length;
            this.videoDevRecordsChange = new VideoDevHandler.VideoDevRec[this.cntVideoDevsSendBulkTotal];
            for (int i = 0; i < this.cntVideoDevsSendBulkTotal; ++i) {
                int n2 = this.videoDevTable.convertRowIndexToModel(nArray[i]);
                this.videoDevRecordsChange[i] = this.videoDevDatabase.getRecordByIdx(n2);
                if (this.videoDevDetailSplitPane.getBottomComponent() == null) continue;
                int n3 = (Integer)this.videoDevRecordsChange[i].getField(0);
                if (this.videoDevDetailPanel.getSelectedVideoDev() != n3) continue;
                this.videoDevIdsPending.put(n3, false);
                this.setDetailPanelPending();
            }
            this.sendBulkAction = DataHandler.SendBulkActionType.Delete;
            this.videoDevHandler.sendChangeDeleteDevs(this.sendBulkAction, this.videoDevRecordsChange, this);
            if (this.cntVideoDevsSendBulkTotal > 1) {
                this.guiProgressDlg = new GuiProgressDlgCancel(UtilLocale.getString("TXT_DELETING_VIDEO_DEVICES_IN_PROGRESS"), false, true, this);
                this.guiProgressDlg.setValue(0);
                this.guiProgressDlg.setVisible(true);
            }
        }
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.videoDevDetailSplitPane.getBottomComponent() != null) {
            this.createVideoDevDetailPanel(dataRecordArray);
        }
    }

    @Override
    public void componentActivated(Component component) {
        this.videoDevHandler.start();
        this.configureTableFilter();
    }

    @Override
    public void componentDeactivated() {
    }

    @Override
    public void processVideoDevDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Video device notification: " + dataNotificationEnum.toString() + ",videoDevId=" + n);
        if (this.videoDevTable.getSelectedRowCount() == 0) {
            this.videoDevTaskPanel.setTaskButtonConfigure(false);
            this.videoDevTaskPanel.setTaskButtonDelete(false);
        }
        switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                this.guiStatusBar.showAppStateResetOverride(GuiStatusBar.AppStateEnum.APP_STATE_OK, "");
                break;
            }
            case NEW_DATA: {
                if (this.detailPanelPending) {
                    this.videoDevIdsPending.remove(n);
                    this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                    this.removeVideoDevDetailPanel();
                    this.videoDevHandler.sendGetVideoDev(n);
                }
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_CHANGED_CNF: {
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_CHANGED_RESP: {
                if (this.detailPanelPending) {
                    if (this.videoDevIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                        --this.cntNotificationsToReceive;
                    }
                    this.videoDevIdsPending.remove(n);
                    if (this.videoDevIdsPending.isEmpty()) {
                        this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
                        this.removeVideoDevDetailPanel();
                        this.cntNotificationsToReceive = 0;
                    }
                }
                this.configureTaskButtonDelete();
                break;
            }
            case DATA_DELETED: {
                if (!this.detailPanelPending) break;
                if (this.videoDevIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                    --this.cntNotificationsToReceive;
                }
                this.videoDevIdsPending.remove(n);
                if (!this.videoDevIdsPending.isEmpty()) break;
                this.removeVideoDevDetailPanel();
                this.cntNotificationsToReceive = 0;
                break;
            }
        }
    }

    @Override
    public void processVideoDevErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Video device error notification: " + dataNotificationEnum.toString() + ",videoDevId=" + String.valueOf(n) + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Video device error notification: Unknown errorCode=" + string);
        }
        if (this.detailPanelPending) {
            String string5 = null;
            if (errorCodes2 != null) {
                this.videoDevDetailPanel.markErrorComponent(string2);
                string5 = this.videoDevDetailPanel.getErrorLabelText(string2);
                string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string3);
            }
            if (this.videoDevIdsPending.containsKey(n) && this.cntNotificationsToReceive > 0) {
                --this.cntNotificationsToReceive;
            }
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                if (!this.videoDevIdsPending.containsKey(n)) {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "videoDevId=" + n + " does not exist in send map anymore");
                    return;
                }
                this.videoDevIdsPending.put(n, true);
                int n2 = 0;
                for (Integer object2 : this.videoDevIdsPending.keySet()) {
                    if (!this.videoDevIdsPending.get(object2).booleanValue()) continue;
                    ++n2;
                }
                VideoDevHandler.VideoDevRec[] videoDevRecArray = new VideoDevHandler.VideoDevRec[n2];
                n2 = 0;
                for (Integer n3 : this.videoDevIdsPending.keySet()) {
                    if (!this.videoDevIdsPending.get(n3).booleanValue()) continue;
                    videoDevRecArray[n2] = this.videoDevDatabase.getRecordById(n3);
                    ++n2;
                }
                this.videoDevDetailPanel.setVideoDevDetailData(videoDevRecArray);
            }
        } else if (errorCodes2 != null) {
            string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string2, string3);
        }
        if (string4 != null) {
            GuiInfoConsole.showError(string4);
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        if (this.cntNotificationsToReceive == 0) {
            this.guiStatusBar.showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        }
    }

    private void configureTaskButtonDelete() {
        boolean bl;
        int n = this.videoDevTable.getSelectedRowCount();
        int[] nArray = this.videoDevTable.getSelectedRows();
        if (n > 0) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.videoDevTable.convertRowIndexToModel(nArray[i]);
                if (this.videoDevDatabase.getRecordByIdx(n2).getField(5) == OmiMessage.VideoDevStateType.unplugged) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        this.videoDevTaskPanel.setTaskButtonDelete(bl);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int n = this.videoDevTable.getSelectedRowCount();
        DataRecord[] dataRecordArray = new DataRecord[n];
        if (n < 1) {
            return;
        }
        int[] nArray = this.videoDevTable.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.videoDevTable.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.videoDevDatabase.getRecordByIdx(n2);
        }
        this.createVideoDevDetailPanel(dataRecordArray);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent();
    }

    @Override
    public void notifyProgress(int n, boolean bl) {
        if (bl || n == this.cntVideoDevsSendBulkTotal) {
            if (this.guiProgressDlg != null) {
                this.guiProgressDlg.dispose();
            }
            GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
            if (bl) {
                if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_AFTER_*_OF_*_VIDEO_DEVICES"), n, this.cntVideoDevsSendBulkTotal));
                } else {
                    GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_AFTER_*_OF_*_VIDEO_DEVICES"), n, this.cntVideoDevsSendBulkTotal));
                }
            }
        } else {
            this.guiProgressDlg.setValue(100 * n / this.cntVideoDevsSendBulkTotal);
        }
    }

    @Override
    public void timeout(int n) {
        if (this.guiProgressDlg != null) {
            this.guiProgressDlg.dispose();
        }
        GuiMain.getGuiStatusBarObject().showAppState(GuiStatusBar.AppStateEnum.APP_STATE_OK, null);
        if (this.sendBulkAction == DataHandler.SendBulkActionType.Change) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_CHANGING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_VIDEO_DEVICES"), n, this.cntVideoDevsSendBulkTotal));
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_DELETING_CANCELED_BY_TIMEOUT_AFTER_*_OF_*_VIDEO_DEVICES"), n, this.cntVideoDevsSendBulkTotal));
        }
    }

    @Override
    public void canceled() {
        this.videoDevHandler.cancelChangeDeleteDevs();
    }

    public static enum VideoDevTableConfigTypeEnum {
        VIDEO_DEV_TABLE_CONFIG,
        VIDEO_DEV_TABLE_MONITOR;

    }
}

